/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.project.support;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.spi.project.LookupMerger;
import org.netbeans.spi.project.LookupProvider;
import org.openide.ErrorManager;
import org.openide.util.ChangeSupport;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LookupProviderSupport {
    private LookupProviderSupport() {
    }

    public static Lookup createCompositeLookup(Lookup baseLookup, String folderPath) {
        return new DelegatingLookupImpl(baseLookup, folderPath);
    }

    public static LookupMerger<Sources> createSourcesMerger() {
        return new SourcesMerger();
    }

    private static class SourcesImpl
    implements Sources,
    ChangeListener,
    LookupListener {
        private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
        private Lookup.Result<Sources> delegates;
        private Collection<Sources> currentDelegates = new ArrayList<Sources>();

        private void setLookup(Lookup lookup) {
            if (this.currentDelegates.size() > 0) {
                for (Sources old : this.currentDelegates) {
                    old.removeChangeListener(this);
                }
                this.currentDelegates.clear();
            }
            if (this.delegates != null) {
                this.delegates.removeLookupListener((LookupListener)this);
            }
            Lookup.Result srcs = lookup.lookupResult(Sources.class);
            for (Sources ns : srcs.allInstances()) {
                ns.addChangeListener(this);
                this.currentDelegates.add(ns);
            }
            srcs.addLookupListener((LookupListener)this);
            this.delegates = srcs;
            this.changeSupport.fireChange();
        }

        public SourceGroup[] getSourceGroups(String type) {
            assert (this.delegates != null);
            ArrayList<SourceGroup> result = new ArrayList<SourceGroup>();
            for (Sources ns : this.delegates.allInstances()) {
                SourceGroup[] grps = ns.getSourceGroups(type);
                if (grps == null) continue;
                result.addAll(Arrays.asList(grps));
            }
            return result.toArray(new SourceGroup[result.size()]);
        }

        public void addChangeListener(ChangeListener listener) {
            this.changeSupport.addChangeListener(listener);
        }

        public void removeChangeListener(ChangeListener listener) {
            this.changeSupport.removeChangeListener(listener);
        }

        public void stateChanged(ChangeEvent e) {
            this.changeSupport.fireChange();
        }

        public void resultChanged(LookupEvent ev) {
            if (this.currentDelegates.size() > 0) {
                for (Sources old : this.currentDelegates) {
                    old.removeChangeListener(this);
                }
                this.currentDelegates.clear();
            }
            for (Sources ns : this.delegates.allInstances()) {
                ns.addChangeListener(this);
                this.currentDelegates.add(ns);
            }
            this.changeSupport.fireChange();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SourcesMerger
    implements LookupMerger<Sources> {
        private SourcesImpl merger;

        private SourcesMerger() {
        }

        @Override
        public Class<Sources> getMergeableClass() {
            return Sources.class;
        }

        @Override
        public Sources merge(Lookup lookup) {
            if (this.merger == null) {
                this.merger = new SourcesImpl();
            }
            this.merger.setLookup(lookup);
            return this.merger;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DelegatingLookupImpl
    extends ProxyLookup
    implements LookupListener {
        private final Lookup baseLookup;
        private Lookup.Result<LookupProvider> providerResult;
        private LookupListener providerListener;
        private List<LookupProvider> old = Collections.emptyList();
        private List<Lookup> currentLookups;
        private Lookup.Result<LookupMerger> mergers;
        private Reference<LookupListener> listenerRef;
        private final List<Lookup.Result<?>> results = new ArrayList();

        public DelegatingLookupImpl(Lookup base, String path) {
            this(base, Lookups.forPath((String)path), path);
        }

        public DelegatingLookupImpl(Lookup base, Lookup providerLookup, String path) {
            assert (base != null);
            this.baseLookup = base;
            this.providerResult = providerLookup.lookup(new Lookup.Template(LookupProvider.class));
            assert (this.isAllJustLookupProviders(providerLookup)) : "Layer content at " + path + " contains other than LookupProvider instances! See messages.log file for more details.";
            this.doDelegate(this.providerResult.allInstances());
            this.providerListener = new LookupListener(){

                public void resultChanged(LookupEvent ev) {
                    DelegatingLookupImpl.this.doDelegate(DelegatingLookupImpl.this.providerResult.allInstances());
                }
            };
            this.providerResult.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this.providerListener, this.providerResult));
        }

        private boolean isAllJustLookupProviders(Lookup lkp) {
            Lookup.Result res = lkp.lookupResult(Object.class);
            Set set = res.allClasses();
            for (Class clzz : set) {
                if (LookupProvider.class.isAssignableFrom(clzz)) continue;
                Logger.getLogger(LookupProviderSupport.class.getName()).warning("" + clzz.getName() + " is not instance of LookupProvider.");
                return false;
            }
            return true;
        }

        public void resultChanged(LookupEvent ev) {
            this.doDelegate(this.providerResult.allInstances());
        }

        private synchronized void doDelegate(Collection<? extends LookupProvider> providers) {
            LookupListener l;
            for (Lookup.Result<?> r : this.results) {
                r.removeLookupListener((LookupListener)this);
            }
            ArrayList<Lookup> newLookups = new ArrayList<Lookup>();
            for (LookupProvider lookupProvider : providers) {
                if (this.old.contains(lookupProvider)) {
                    int index = this.old.indexOf(lookupProvider);
                    newLookups.add(this.currentLookups.get(index));
                    continue;
                }
                Lookup newone = lookupProvider.createAdditionalLookup(this.baseLookup);
                assert (newone != null);
                newLookups.add(newone);
            }
            this.old = new ArrayList<LookupProvider>(providers);
            this.currentLookups = newLookups;
            newLookups.add(this.baseLookup);
            ProxyLookup lkp = new ProxyLookup(newLookups.toArray(new Lookup[newLookups.size()]));
            ArrayList arrayList = new ArrayList();
            ArrayList mergedInstances = new ArrayList();
            LookupListener lookupListener = l = this.listenerRef != null ? this.listenerRef.get() : null;
            if (l != null) {
                this.mergers.removeLookupListener(l);
            }
            this.mergers = lkp.lookupResult(LookupMerger.class);
            l = (LookupListener)WeakListeners.create(LookupListener.class, (EventListener)((Object)this), this.mergers);
            this.listenerRef = new WeakReference<LookupListener>(l);
            this.mergers.addLookupListener(l);
            for (LookupMerger lm : this.mergers.allInstances()) {
                Class c = lm.getMergeableClass();
                if (arrayList.contains(c)) {
                    ErrorManager.getDefault().log(16, "Two LookupMerger registered for class " + c + ". Only first one will be used");
                    continue;
                }
                arrayList.add(c);
                mergedInstances.add(lm.merge((Lookup)lkp));
                Lookup.Result result = lkp.lookupResult(c);
                result.addLookupListener((LookupListener)this);
                this.results.add(result);
            }
            lkp = Lookups.exclude((Lookup)lkp, (Class[])arrayList.toArray(new Class[arrayList.size()]));
            Lookup fixed = Lookups.fixed((Object[])mergedInstances.toArray(new Object[mergedInstances.size()]));
            this.setLookups(new Lookup[]{fixed, lkp});
        }
    }
}

