/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.lexer.util;

import java.util.Collections;
import java.util.List;
import org.netbeans.modules.lexer.util.ObjectArrayList;
import org.netbeans.modules.lexer.util.UnmodifiableArrayList;
import org.netbeans.spi.lexer.util.ObjectArray;
import org.netbeans.spi.lexer.util.ProxyList;

public class LexerUtilities {
    private static final char[] HEX_DIGIT = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private LexerUtilities() {
    }

    public static ProxyList objectArrayList(ObjectArray objectArray) {
        return new ObjectArrayList(objectArray);
    }

    public static List unmodifiableList(Object[] objectArray) {
        return new UnmodifiableArrayList(objectArray);
    }

    public static List singletonList(Object object) {
        return Collections.singletonList(object);
    }

    public static int charSequenceHashCode(CharSequence charSequence) {
        int n = charSequence.length();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 = 31 * n2 + charSequence.charAt(i);
        }
        return n2;
    }

    public static boolean charSequenceEquals(CharSequence charSequence, Object object) {
        if (charSequence == object) {
            return true;
        }
        if (object instanceof CharSequence) {
            CharSequence charSequence2 = (CharSequence)object;
            int n = charSequence.length();
            if (n == charSequence2.length()) {
                for (int i = n - 1; i >= 0; --i) {
                    if (charSequence.charAt(i) == charSequence2.charAt(i)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public static void appendToSource(StringBuffer stringBuffer, char c) {
        switch (c) {
            case '\n': {
                stringBuffer.append("\\n");
                break;
            }
            case '\r': {
                stringBuffer.append("\\r");
                break;
            }
            case '\t': {
                stringBuffer.append("\\t");
                break;
            }
            case '\b': {
                stringBuffer.append("\\b");
                break;
            }
            case '\f': {
                stringBuffer.append("\\f");
                break;
            }
            case '\\': {
                stringBuffer.append("\\\\");
                break;
            }
            case '\"': {
                stringBuffer.append("\\\"");
                break;
            }
            case '\'': {
                stringBuffer.append("'");
                break;
            }
            default: {
                if (c < ' ' || c > '~') {
                    stringBuffer.append("\\u");
                    stringBuffer.append(HEX_DIGIT[(c & 0xF000) >> 12]);
                    stringBuffer.append(HEX_DIGIT[(c & 0xF00) >> 8]);
                    stringBuffer.append(HEX_DIGIT[(c & 0xF0) >> 4]);
                    stringBuffer.append(HEX_DIGIT[c & 0xF]);
                    break;
                }
                stringBuffer.append(c);
            }
        }
    }

    public static void appendToSource(StringBuffer stringBuffer, String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            LexerUtilities.appendToSource(stringBuffer, string.charAt(i));
        }
    }

    public static void appendToSource(StringBuffer stringBuffer, CharSequence charSequence) {
        int n = charSequence.length();
        for (int i = 0; i < n; ++i) {
            LexerUtilities.appendToSource(stringBuffer, charSequence.charAt(i));
        }
    }

    public static void appendToSource(StringBuffer stringBuffer, char[] cArray, int n, int n2) {
        n2 += n;
        while (n < n2) {
            LexerUtilities.appendToSource(stringBuffer, cArray[n++]);
        }
    }

    public static String toSource(char c) {
        StringBuffer stringBuffer = new StringBuffer();
        LexerUtilities.appendToSource(stringBuffer, c);
        return stringBuffer.toString();
    }

    public static String toSource(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        LexerUtilities.appendToSource(stringBuffer, string);
        return stringBuffer.toString();
    }

    public static String toSource(CharSequence charSequence) {
        StringBuffer stringBuffer = new StringBuffer();
        LexerUtilities.appendToSource(stringBuffer, charSequence);
        return stringBuffer.toString();
    }

    public static String toSource(char[] cArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        LexerUtilities.appendToSource(stringBuffer, cArray, n, n2);
        return stringBuffer.toString();
    }
}

