/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remotefs.ftpfs.ftpclient;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;

public class FTPResponse {
    private int code;
    private String response;
    public static final int POSITIVE_PRELIMINARY = 1;
    public static final int POSITIVE_COMPLETION = 2;
    public static final int POSITIVE_INTERMEDIATE = 3;
    public static final int TRANSIENT_NEGATIVE_COMPLETION = 4;
    public static final int PERMANENT_NEGATIVE_COMPLETION = 5;

    public FTPResponse(BufferedReader in) throws IOException {
        String line = in.readLine();
        String stringcode = line.substring(0, 3);
        try {
            this.code = Integer.parseInt(stringcode);
        }
        catch (NumberFormatException e) {
            this.code = 0;
        }
        if (line.length() >= 4 && line.charAt(3) == '-') {
            StringBuffer multiline = new StringBuffer();
            multiline.append(line);
            do {
                line = in.readLine();
                multiline.append("\n");
                multiline.append(line);
            } while (!line.startsWith(stringcode) || line.startsWith(stringcode + "-"));
            this.response = multiline.toString();
        } else {
            this.response = line;
        }
    }

    protected void writeLog(PrintWriter log) {
        if (log != null) {
            log.println(this.response);
            log.flush();
        }
    }

    public String getResponse() {
        return this.response;
    }

    public String toString() {
        return this.response;
    }

    public int getCode() {
        return this.code;
    }

    public int getFirstDigit() {
        return this.getCode() / 100;
    }

    public int getSecondDigit() {
        return this.getCode() % 100 / 10;
    }

    public int getThirdDigit() {
        return this.getCode() % 10;
    }

    public boolean isPositivePreliminary() {
        return this.getFirstDigit() == 1;
    }

    public boolean isPositiveCompletion() {
        return this.getFirstDigit() == 2;
    }

    public boolean isPositiveIntermediate() {
        return this.getFirstDigit() == 3;
    }

    public boolean isTransientNegativeCompletion() {
        return this.getFirstDigit() == 4;
    }

    public boolean isPermanentNegativeCompletion() {
        return this.getFirstDigit() == 5;
    }
}

