/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remotefs.ftpfs.actions;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Set;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.distributed.common.cookies.RemoteCompileCookie;
import org.netbeans.modules.distributed.common.util.RemoteProjectSettings;
import org.netbeans.modules.distributed.ideserverclient.settings.DistributedSettings;
import org.netbeans.modules.distributed.remotefs.ftpfs.FTPFileSystem;
import org.netbeans.modules.distributed.remotefs.smb.NetworkFileSystem;
import org.openide.LifecycleManager;
import org.openide.actions.AbstractCompileAction;
import org.openide.awt.StatusDisplayer;
import org.openide.compiler.Compiler;
import org.openide.compiler.CompilerJob;
import org.openide.cookies.CompilerCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.NodeAction;
import patchsources.OpenProjectList_Dist;

public class RemoteCompileAction
extends NodeAction {
    public String getName() {
        return "Remote Compile";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected Class[] cookieClasses() {
        return new Class[]{CompilerCookie.class};
    }

    protected final Class cookie() {
        return DataObject.class;
    }

    protected String iconResource() {
        return "org/netbeans/modules/distributed/resources/remcompile.gif";
    }

    private static void refreshFS() {
        Set fss = OpenProjectList_Dist.getFsSet();
        for (FileSystem fs : fss) {
            fs.refresh(false);
        }
    }

    private static void refreshRemoteProjectSettings(FileObject fobj) {
        Project project = FileOwnerQuery.getOwner((FileObject)fobj);
        RemoteProjectSettings rs = (RemoteProjectSettings)project.getLookup().lookup(RemoteProjectSettings.class);
        if (rs != null) {
            rs.refreshAll();
        }
    }

    protected void performAction(Node[] activatedNodes) {
        final Node[] anodes = activatedNodes;
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                RemoteCompileAction.refreshFS();
                RemoteCompileAction.this.compile3GL(anodes);
                RemoteCompileAction.refreshFS();
            }
        });
    }

    static String findName(Node[] nodes) {
        String name = "";
        if (nodes.length > 0) {
            Node n = nodes[0];
            Node.Cookie ck = null;
            do {
                if ((ck = n.getCookie(DataObject.class)) == null) continue;
                DataObject d = (DataObject)ck;
                name = d.isValid() ? d.getNodeDelegate().getDisplayName() : "";
                break;
            } while ((n = n.getParentNode()) != null);
        }
        return NbBundle.getMessage(Compiler.class, (String)"FMT_Compile", (Object)new Integer(nodes.length), (Object)name);
    }

    public void actionPerformed(ActionEvent ev) {
        Object s = ev == null ? null : ev.getSource();
        Node[] nodes = null;
        if (s instanceof Node) {
            Node node = (Node)s;
            nodes = new Node[]{node};
        } else {
            nodes = s instanceof Node[] ? (Node[])s : super.getActivatedNodes();
        }
        final Node[] anodes = nodes;
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                RemoteCompileAction.refreshFS();
                RemoteCompileAction.this.compile3GL(anodes);
                RemoteCompileAction.refreshFS();
            }
        });
    }

    public static CompilerJob createJob(Enumeration en, Compiler.Depth depth) {
        CompilerJob job = new CompilerJob(depth);
        AbstractCompileAction.prepareJobFor(job, en, RemoteCompileCookie.class, depth);
        return job;
    }

    private void compile3GL(Node[] nodes) {
        if (DistributedSettings.getDefault().getSaveAll()) {
            LifecycleManager.getDefault().saveAll();
        }
        for (int i = 0; i < nodes.length; ++i) {
            RemoteCompileCookie comp = (RemoteCompileCookie)nodes[i].getCookie(RemoteCompileCookie.class);
            if (comp == null) continue;
            try {
                DataObject dobj = (DataObject)nodes[i].getCookie(DataObject.class);
                RemoteCompileAction.refreshRemoteProjectSettings(dobj.getPrimaryFile());
                comp.compile();
                continue;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        this.compileNodes2(nodes);
    }

    protected String message() {
        return NbBundle.getMessage(Compiler.class, (String)"CTL_CompilationStarted");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void compileNodes2(Node[] nodes) {
        StatusDisplayer.getDefault().setStatusText(this.message());
        StatusDisplayer.getDefault().setStatusText("");
    }

    protected boolean enable(Node[] node) {
        int nodeCnt = 0;
        if (node.length == 0) {
            return false;
        }
        for (int i = 0; i < node.length; ++i) {
            DataObject dobj = (DataObject)node[i].getCookie(DataObject.class);
            if (dobj == null) {
                return false;
            }
            if (dobj.getPrimaryFile().isFolder() || dobj.getPrimaryFile().isRoot()) {
                return false;
            }
            try {
                if (!(dobj.getPrimaryFile().getFileSystem() instanceof NetworkFileSystem) && !(dobj.getPrimaryFile().getFileSystem() instanceof FTPFileSystem)) {
                    return false;
                }
            }
            catch (FileStateInvalidException e) {
                return false;
            }
            if (dobj.getCookie(RemoteCompileCookie.class) == null) continue;
            ++nodeCnt;
        }
        return nodeCnt == node.length;
    }

    protected boolean asynchronous() {
        return false;
    }
}

