/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.ideserverclient.explorer;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.HashSet;
import org.netbeans.modules.distributed.ideserverclient.RemoteRuntimeType;
import org.netbeans.modules.distributed.ideserverclient.actions.RemoteDiagnosticAction;
import org.netbeans.modules.distributed.ideserverclient.actions.RemoteServerStatusAction;
import org.netbeans.modules.distributed.ideserverclient.explorer.LookupPanel;
import org.netbeans.modules.distributed.ideserverclient.explorer.SvcBrowserChildren;
import org.netbeans.modules.distributed.ideserverclient.settings.DistributedSettings;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.actions.NewAction;
import org.openide.actions.OpenLocalExplorerAction;
import org.openide.actions.PropertiesAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.NewType;

public class SvcBrowserNode
extends AbstractNode {
    public SvcBrowserNode() {
        super((Children)new SvcBrowserChildren());
        this.setIconBase("org/netbeans/modules/distributed/ideserverclient/resources/remoteServers");
        this.setDefaultAction(SystemAction.get(PropertiesAction.class));
        this.setName(this.toString());
        this.setDisplayName(NbBundle.getMessage(SvcBrowserNode.class, (String)"ROOT_node"));
        this.setShortDescription(NbBundle.getMessage(SvcBrowserNode.class, (String)"HINT_node"));
    }

    public void refresh() {
    }

    protected SystemAction[] createActions() {
        return new SystemAction[]{SystemAction.get(OpenLocalExplorerAction.class), null, SystemAction.get(NewAction.class), SystemAction.get(RemoteServerStatusAction.class), null, SystemAction.get(RemoteDiagnosticAction.class)};
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected SvcBrowserChildren getSvcBrowserChildren() {
        return (SvcBrowserChildren)this.getChildren();
    }

    public NewType[] getNewTypes() {
        return new NewType[]{new LookupType()};
    }

    class LookupType
    extends NewType
    implements ActionListener {
        private Dialog myDialog = null;
        private LookupPanel rpanel = null;

        public void create() throws IOException {
            this.rpanel = new LookupPanel();
            DialogDescriptor dd = new DialogDescriptor((Object)this.rpanel, NbBundle.getMessage(SvcBrowserNode.class, (String)"TITLE_NEW_TYPE"), false, (ActionListener)this);
            dd.setValid(false);
            this.rpanel.setDialogDescriptor(dd);
            this.myDialog = DialogDisplayer.getDefault().createDialog(dd);
            this.myDialog.show();
        }

        private boolean checkIfAlreadyExist(int port, String hostName, String userName) {
            HashSet set = DistributedSettings.getDefault().getRemoteRuntimes();
            for (RemoteRuntimeType type : set) {
                if (!type.getHostName().trim().equalsIgnoreCase(hostName.trim()) || !type.getUserName().trim().equalsIgnoreCase(userName.trim()) || type.getPort() != port) continue;
                return true;
            }
            return false;
        }

        public void actionPerformed(ActionEvent ae) {
            if (ae.getSource() == DialogDescriptor.OK_OPTION) {
                try {
                    int port = Integer.parseInt(this.rpanel.getPort().trim());
                    int svrTimeOut = Integer.parseInt(this.rpanel.getSvrTimeOut().trim());
                    String hostName = this.rpanel.getHostName().trim();
                    String userName = this.rpanel.getUserName().trim();
                    char[] password = this.rpanel.getPassword();
                    String setupCommand = this.rpanel.getSetupCommand().trim();
                    boolean storepass = this.rpanel.getStorePass();
                    DistributedSettings.getDefault().setUserName(userName);
                    DistributedSettings.getDefault().setHostName(hostName);
                    DistributedSettings.getDefault().setPort(this.rpanel.getPort());
                    DistributedSettings.getDefault().setSetupCommand(this.rpanel.getSetupCommand());
                    String jdkVersion = this.rpanel.getJDKVersion();
                    if (hostName.length() > 0 && password.length > 0 && userName.length() > 0) {
                        if (!this.checkIfAlreadyExist(port, hostName, userName)) {
                            RemoteRuntimeType rtt = new RemoteRuntimeType(userName, password, hostName, port, jdkVersion, setupCommand, svrTimeOut, true, storepass);
                            ((SvcBrowserChildren)SvcBrowserNode.this.getChildren()).addRemoteRuntimeType(rtt);
                        } else {
                            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)NbBundle.getMessage(SvcBrowserNode.class, (String)"ERROR_duplicate_rem_server", (Object)(hostName + ":" + userName)), 1);
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                        }
                    } else {
                        NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)NbBundle.getMessage(SvcBrowserNode.class, (String)"ERROR_invalid_login_info"), 0);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                    }
                }
                catch (NumberFormatException ex) {
                    NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)NbBundle.getMessage(SvcBrowserNode.class, (String)"ERROR_invalid_port"), 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                }
            }
            if (this.myDialog != null) {
                this.myDialog.dispose();
                this.myDialog = null;
            }
        }

        public String getName() {
            return "Remote IDE Server";
        }
    }
}

