/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.common.propertyeditors;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyEditor;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import org.openide.explorer.propertysheet.InplaceEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.propertysheet.PropertyModel;

public class PasswordInplaceEditor
extends JPasswordField
implements InplaceEditor,
InplaceEditor.Factory {
    private String password;
    protected PropertyEditor editor = null;
    protected PropertyEnv env = null;
    private boolean added = false;
    KeyStroke[] strokes = new KeyStroke[]{KeyStroke.getKeyStroke(36, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 0x40), KeyStroke.getKeyStroke(35, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 0x40), KeyStroke.getKeyStroke(38, 0, false), KeyStroke.getKeyStroke(40, 0, false)};
    private PropertyModel pm = null;

    public void removeNotify() {
        super.removeNotify();
    }

    public void clear() {
        this.editor = null;
        this.setEditable(true);
        this.setEnabled(true);
        this.setText("");
        this.pm = null;
        this.env = null;
    }

    public void connect(PropertyEditor p, PropertyEnv env) {
        this.setActionCommand("success");
        this.env = env;
        if (this.editor == p) {
            return;
        }
        this.editor = p;
        boolean editable = true;
        this.setEnabled(editable);
        this.setEditable(editable);
        this.reset();
        this.added = false;
    }

    public void addNotify() {
        super.addNotify();
        this.added = true;
    }

    public JComponent getComponent() {
        return this;
    }

    public Object getValue() {
        return this.getText();
    }

    public void reset() {
        String initialEditValue;
        String txt = this.editor.getAsText();
        if (this.getClass() == PasswordInplaceEditor.class && this.env != null && this.env.getFeatureDescriptor() != null && (initialEditValue = (String)this.env.getFeatureDescriptor().getValue("initialEditValue")) != null) {
            txt = initialEditValue;
        }
        if (txt == null) {
            txt = "";
        }
        this.setText(txt);
        this.setSelectionStart(0);
        this.setSelectionEnd(txt.length());
    }

    public KeyStroke[] getKeyStrokes() {
        return this.strokes;
    }

    public PropertyEditor getPropertyEditor() {
        return this.editor;
    }

    private void handleInitialInputEvent(InputEvent e) {
        String txt = this.getText();
        if (txt.length() > 0) {
            this.setSelectionStart(0);
            this.setSelectionEnd(this.getText().length());
        }
    }

    public void setValue(Object o) {
        this.setText(o != null ? o.toString() : "");
    }

    public boolean supportsTextEntry() {
        return true;
    }

    public PropertyModel getPropertyModel() {
        return this.pm;
    }

    public void setPropertyModel(PropertyModel pm) {
        this.pm = pm;
    }

    public boolean isKnownComponent(Component c) {
        return false;
    }

    private Graphics getScratchGraphics(Component c) {
        Graphics result = null;
        BufferedImage scratch = null;
        if (result == null) {
            if (scratch == null) {
                scratch = new BufferedImage(1, 1, 2);
            }
            result = scratch.getGraphics();
        }
        return result;
    }

    private int getMinimumPropPanelWidth() {
        int base = 50;
        int minW = Math.round((float)base * this.getFontSizeFactor());
        return minW;
    }

    private float getFontSizeFactor() {
        Font f = UIManager.getFont("controlFont");
        if (f == null) {
            JLabel jl = new JLabel();
            f = jl.getFont();
        }
        int baseSize = 12;
        float fsfactor = baseSize / f.getSize();
        return fsfactor;
    }

    private int getMinimumPropPanelHeight() {
        int base = 18;
        int minH = Math.round((float)base * this.getFontSizeFactor());
        return minH;
    }

    public Dimension getPreferredSize() {
        Graphics g = this.getScratchGraphics(this);
        String s = "***";
        FontMetrics fm = g.getFontMetrics(this.getFont());
        Dimension result = new Dimension(fm.stringWidth(s), fm.getHeight());
        result.width = Math.max(result.width, this.getMinimumPropPanelWidth());
        result.height = Math.max(result.height, this.getMinimumPropPanelHeight());
        if (this.getBorder() != null) {
            Insets i = this.getBorder().getBorderInsets(this);
            result.width += i.right + i.left;
            result.height += i.top + i.bottom;
        }
        return result;
    }

    private int getTextMargin() {
        if ("apple.laf.AquaLookAndFeel".equals(UIManager.getLookAndFeel().getClass().getName())) {
            return 0;
        }
        Object o = UIManager.get("netbeans.ps.textMargin");
        int textMargin = o instanceof Integer ? (Integer)o : 2;
        return textMargin;
    }

    public void processMouseEvent(MouseEvent me) {
        super.processMouseEvent(me);
        if (this.added) {
            this.handleInitialInputEvent(me);
        }
        this.added = false;
    }

    protected void processFocusEvent(FocusEvent fe) {
        super.processFocusEvent(fe);
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintComponent(Graphics g) {
        if (this.editor != null && !this.hasFocus() && this.editor.isPaintable()) {
            Insets ins = this.getInsets();
            Color c = g.getColor();
            try {
                g.setColor(this.getBackground());
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            finally {
                g.setColor(c);
            }
            ins.left += this.getTextMargin();
            this.editor.paintValue(g, new Rectangle(ins.left, ins.top, this.getWidth() - (ins.right + ins.left), this.getHeight() - (ins.top + ins.bottom)));
        } else {
            super.paintComponent(g);
        }
    }

    public InplaceEditor getInplaceEditor() {
        return new PasswordInplaceEditor();
    }
}

