/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.pascalsupport.pascal;

import com.hp.openvms.netbeans.baseclasses.compiler.AlphaVMSCompiler;
import com.hp.openvms.netbeans.baseclasses.compiler.AlphaVMSCompilerType;
import com.hp.openvms.netbeans.baseclasses.dataloaders.AlphaVMSDataLoader;
import com.hp.openvms.netbeans.pascalsupport.pascal.PascalCompilerGroup;
import com.hp.openvms.netbeans.pascalsupport.pascal.PascalCompilerType;
import com.hp.openvms.netbeans.pascalsupport.pascal.datasys.PascalCompilerSupport;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import org.netbeans.modules.distributed.remotefs.propertyeditor.RemoteFSFile;
import org.openide.compiler.ExternalCompiler;
import org.openide.cookies.CompilerCookie;
import org.openide.execution.NbProcessDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataLoader;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

public class PascalCompiler
extends AlphaVMSCompiler {
    private PascalCompilerType compilerSvcType;
    private static final String COMPILER_NAME = "HP PASCAL compiler";
    private boolean isRemote = false;

    public PascalCompiler(Class type, FileObject primFile, NbProcessDescriptor compiler, ExternalCompiler.ErrorExpression errExpr, PascalCompilerType compilerSvcType) {
        super(type.equals(BUILD) || type.equals(AlphaVMSCompilerType.REMOTE_BUILD), primFile, compiler, errExpr);
        if (type.equals(AlphaVMSCompilerType.REMOTE_COMPILE) || type.equals(AlphaVMSCompilerType.REMOTE_BUILD)) {
            this.isRemote = true;
        }
        this.compilerSvcType = compilerSvcType;
    }

    public Class compilerGroupClass() {
        return PascalCompilerGroup.class;
    }

    public Object compilerGroupKey() {
        ArrayList<Object> l = new ArrayList<Object>(3);
        l.add(0, super.compilerGroupKey());
        l.add(1, PascalCompiler.class);
        l.add(2, (Object)this.compilerSvcType);
        return l;
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof PascalCompiler)) {
            return false;
        }
        PascalCompiler other = (PascalCompiler)o;
        return other.compilerSvcType == this.compilerSvcType && this.getBuilding() == other.getBuilding();
    }

    public int hashCode() {
        return 0x4D2 ^ this.getFileObject().getPackageNameExt('/', '.').hashCode();
    }

    public String getCompilerName() {
        return COMPILER_NAME;
    }

    public PascalCompilerType getCompilerSvcType() {
        return this.compilerSvcType;
    }

    public final FileObject getFileObject0() {
        return this.getFileObject();
    }

    public boolean isUpToDate() {
        try {
            boolean b = super.isUpToDate();
            if (!b) {
                return false;
            }
            DataObject mdo = DataObject.find((FileObject)this.getFileObject());
            RemoteFSFile searchDir = null;
            PascalCompilerSupport supp = (PascalCompilerSupport)mdo.getCookie(CompilerCookie.class);
            NbProcessDescriptor descr = supp.getExternalCompiler();
            searchDir = supp.getBuildDirectory();
            FileObject primary = mdo.getPrimaryFile();
            FileObject folder = primary.getParent();
            AlphaVMSDataLoader loader = (AlphaVMSDataLoader)DataLoader.getLoader(AlphaVMSDataLoader.class);
            Enumeration itr = loader.getObjExtensions().extensions();
            File secondaryFile = null;
            while (itr.hasMoreElements()) {
                String ext = (String)itr.nextElement();
                String secondary = primary.getName().toUpperCase() + "." + ext.toUpperCase();
                secondaryFile = new File(((File)searchDir).getAbsolutePath() + File.separatorChar + secondary);
                if (secondaryFile.exists()) break;
                secondaryFile = null;
            }
            if (secondaryFile != null && secondaryFile.length() > 0L && secondaryFile.lastModified() > primary.lastModified().getTime()) {
                return true;
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            // empty catch block
        }
        return false;
    }

    public boolean isRemote() {
        return this.isRemote;
    }
}

