/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.pascalsupport.editor.pascal;

import com.hp.openvms.netbeans.pascalsupport.editor.lang.PascalLanguage;
import com.hp.openvms.netbeans.pascalsupport.editor.pascal.PascalFormatter;
import com.hp.openvms.netbeans.pascalsupport.editor.pascal.PascalOptions;
import com.hp.openvms.netbeans.pascalsupport.editor.pascal.PascalPrintOptions;
import com.hp.openvms.netbeans.pascalsupport.editor.pascal.PascalSettingsInitializer;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.TextAction;
import org.netbeans.api.lexer.Language;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.Formatter;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsDefaults;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.Completion;
import org.netbeans.editor.ext.ExtKit;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.netbeans.editor.ext.ExtUtilities;
import org.netbeans.editor.ext.plain.PlainSyntax;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.editor.NbEditorKit;
import org.netbeans.modules.editor.options.AllOptions;
import org.netbeans.modules.lexer.editorbridge.LanguageDescriptor;
import org.netbeans.modules.lexer.editorbridge.LexerLayerInitializer;
import org.openide.options.SystemOption;
import org.openide.text.PrintSettings;

public class PascalKit
extends NbEditorKit {
    private static ArrayList actionClasses;

    private static Map createTokenId2ColoringMap() {
        HashMap<String, Coloring> m = new HashMap<String, Coloring>();
        Font boldFont = SettingsDefaults.defaultFont.deriveFont(1);
        Font italicFont = SettingsDefaults.defaultFont.deriveFont(2);
        m.put("Literals", new Coloring(null, new Color(153, 0, 107), null));
        m.put("Reserved Words", new Coloring(boldFont, new Color(0, 0, 153), null));
        m.put("User Defined Words", new Coloring(null, null, null));
        m.put("Comments", new Coloring(italicFont, new Color(115, 115, 115), null));
        m.put("Identifiers", new Coloring(boldFont, null, null));
        return m;
    }

    public String getContentType() {
        return "text/x-hp+openvms+pas";
    }

    public Syntax createSyntax(Document doc) {
        return new PlainSyntax();
    }

    public SyntaxSupport createSyntaxSupport(BaseDocument doc) {
        return new ExtSyntaxSupport(doc);
    }

    public Document createDefaultDocument() {
        NbEditorDocument doc = new NbEditorDocument(((Object)((Object)this)).getClass());
        doc.putProperty((Object)"write-line-separator", (Object)"\n");
        return doc;
    }

    public Formatter createFormatter() {
        return new PascalFormatter(((Object)((Object)this)).getClass());
    }

    protected Action[] createActions() {
        int arraySize = 2;
        int numAddClasses = 0;
        if (actionClasses != null) {
            numAddClasses = actionClasses.size();
            arraySize += numAddClasses;
        }
        Action[] pascalActions = new Action[arraySize];
        int index = 0;
        if (actionClasses != null) {
            for (int i = 0; i < numAddClasses; ++i) {
                Class c = (Class)actionClasses.get(i);
                try {
                    pascalActions[index] = (Action)c.newInstance();
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                ++index;
            }
        }
        pascalActions[index++] = new FDefaultKeyTypedAction();
        pascalActions[index++] = new PascalFormatAction();
        return TextAction.augmentList(super.createActions(), pascalActions);
    }

    public static void addActionClass(Class action) {
        if (actionClasses == null) {
            actionClasses = new ArrayList(2);
        }
        actionClasses.add(action);
    }

    protected void updateActions() {
        super.updateActions();
        this.addSystemActionMapping("format", PascalFormatAction.class);
    }

    static {
        Settings.addInitializer((Settings.Initializer)new LexerLayerInitializer(new LanguageDescriptor((Language)PascalLanguage.get(), PascalKit.class, "", PascalKit.createTokenId2ColoringMap())));
        PascalSettingsInitializer cci = new PascalSettingsInitializer(PascalKit.class);
        Settings.addInitializer((Settings.Initializer)cci);
        Settings.reset();
        AllOptions ao = (AllOptions)AllOptions.findObject(AllOptions.class, (boolean)true);
        ao.addOption((SystemOption)((PascalOptions)SystemOption.findObject(PascalOptions.class, (boolean)true)));
        PrintSettings ps = (PrintSettings)PrintSettings.findObject(PrintSettings.class, (boolean)true);
        ps.addOption((SystemOption)((PascalPrintOptions)SystemOption.findObject(PascalPrintOptions.class, (boolean)true)));
        actionClasses = null;
    }

    public static class FDefaultKeyTypedAction
    extends ExtKit.ExtDefaultKeyTypedAction {
        protected void checkCompletion(JTextComponent target, String typedText) {
            Completion completion = ExtUtilities.getCompletion((JTextComponent)target);
            if (completion != null && typedText.length() > 0) {
                if (!completion.isPaneVisible()) {
                    if (completion.isAutoPopupEnabled()) {
                        boolean pop = false;
                        switch (typedText.charAt(0)) {
                            case ' ': {
                                int dotPos = target.getCaret().getDot();
                                BaseDocument doc = (BaseDocument)target.getDocument();
                                if (dotPos < 2) break;
                                int pos = Math.max(dotPos - 5, 0);
                                try {
                                    String txtBeforeSpace = doc.getText(pos, dotPos - pos);
                                    if (txtBeforeSpace.endsWith("new ")) {
                                        pop = true;
                                        break;
                                    }
                                    if (!txtBeforeSpace.endsWith(", ")) break;
                                    pop = true;
                                }
                                catch (BadLocationException e) {}
                                break;
                            }
                            case ',': 
                            case '.': {
                                pop = true;
                            }
                        }
                        if (pop) {
                            completion.popup(true);
                        } else {
                            completion.cancelRequest();
                        }
                    }
                } else {
                    switch (typedText.charAt(0)) {
                        case ';': 
                        case '=': 
                        case '{': {
                            completion.setPaneVisible(false);
                            break;
                        }
                        default: {
                            completion.refresh(true);
                        }
                    }
                }
            }
        }
    }

    public static class PascalFormatAction
    extends BaseAction {
        public PascalFormatAction() {
            super("format", 14);
            this.putValue("helpID", PascalFormatAction.class.getName());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                if (!target.isEditable() || !target.isEnabled()) {
                    target.getToolkit().beep();
                    return;
                }
                Caret caret = target.getCaret();
                BaseDocument doc = (BaseDocument)target.getDocument();
                doc.atomicLock();
                try {
                    int pos;
                    String out;
                    Position endPosition;
                    int startPos;
                    int caretLine = Utilities.getLineOffset((BaseDocument)doc, (int)caret.getDot());
                    if (caret.isSelectionVisible()) {
                        startPos = target.getSelectionStart();
                        endPosition = doc.createPosition(target.getSelectionEnd());
                    } else {
                        startPos = 0;
                        endPosition = doc.createPosition(doc.getLength());
                    }
                    for (pos = startPos; pos < endPosition.getOffset(); pos += out.length()) {
                        int stopPos = endPosition.getOffset();
                        CharArrayWriter cw = new CharArrayWriter();
                        Writer w = doc.getFormatter().createWriter((Document)doc, pos, (Writer)cw);
                        w.write(doc.getChars(pos, stopPos - pos));
                        w.close();
                        out = new String(cw.toCharArray());
                        doc.remove(pos, stopPos - pos);
                        doc.insertString(pos, out, null);
                    }
                    pos = Utilities.getRowStartFromLineOffset((BaseDocument)doc, (int)caretLine);
                    if (pos >= 0) {
                        caret.setDot(pos);
                    }
                }
                catch (BadLocationException e) {
                    if (System.getProperty("netbeans.debug.exceptions") != null) {
                        e.printStackTrace();
                    }
                }
                catch (IOException e) {
                    if (System.getProperty("netbeans.debug.exceptions") != null) {
                        e.printStackTrace();
                    }
                }
                finally {
                    doc.atomicUnlock();
                }
            }
        }
    }
}

