/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.debugsupport.model;

import com.hp.openvms.netbeans.debugsupport.breakpoints.FunctionBreakpoint;
import com.hp.openvms.netbeans.debugsupport.breakpoints.LineBreakpoint;
import com.hp.openvms.netbeans.debugsupport.breakpoints.RemoteBreakpoint;
import com.hp.openvms.netbeans.debugsupport.debugger.EditorContextBridge;
import com.hp.openvms.netbeans.debugsupport.model.BoldVariablesTableModelFilterFirst;
import com.hp.openvms.netbeans.debugsupport.model.BreakpointsTreeModelFilter;
import java.util.Vector;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;

public class BreakpointsNodeModel
implements NodeModel {
    public static final String BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/NonLineBreakpoint";
    public static final String LINE_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/Breakpoint";
    private Vector listeners = new Vector();
    private static final String ZEROS = "            ";
    private RemoteBreakpoint currentBreakpoint;

    static int log10(int n) {
        int l = 1;
        while ((n /= 10) > 0) {
            ++l;
        }
        return l;
    }

    static String zeros(int n) {
        if (n < ZEROS.length()) {
            return ZEROS.substring(0, n);
        }
        String z = ZEROS;
        while (z.length() < n) {
            z = z + " ";
        }
        return z;
    }

    public String getDisplayName(Object o) throws UnknownTypeException {
        if (o instanceof LineBreakpoint) {
            int max;
            int num0;
            LineBreakpoint b = (LineBreakpoint)((Object)o);
            int lineNum = b.getLineNumber();
            String line = Integer.toString(lineNum);
            Integer maxInt = (Integer)BreakpointsTreeModelFilter.MAX_LINES.get((Object)b);
            if (maxInt != null && (num0 = BreakpointsNodeModel.log10(max = maxInt.intValue()) - BreakpointsNodeModel.log10(lineNum)) > 0) {
                line = BreakpointsNodeModel.zeros(num0) + line;
            }
            return this.bold(b, NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Line_Breakpoint", (Object)EditorContextBridge.getFileName(b), (Object)line));
        }
        if (o instanceof FunctionBreakpoint) {
            FunctionBreakpoint b = (FunctionBreakpoint)((Object)o);
            String className = "";
            if (b.getFunctionName().equals("")) {
                return this.bold(b, NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_All_Functions_Breakpoint", (Object)BreakpointsNodeModel.getShort(className)));
            }
            String clazz = BreakpointsNodeModel.getShort(className);
            if (clazz != null && clazz.length() > 0) {
                return this.bold(b, NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Function_Breakpoint_With_Class", (Object)BreakpointsNodeModel.getShort(className), (Object)b.getFunctionName()));
            }
            return this.bold(b, NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Function_Breakpoint", (Object)b.getFunctionName()));
        }
        throw new UnknownTypeException(o);
    }

    public String getShortDescription(Object o) throws UnknownTypeException {
        if (o instanceof LineBreakpoint) {
            return NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Line_Breakpoint", (Object)EditorContextBridge.getFileName((LineBreakpoint)((Object)o)), (Object)("" + ((LineBreakpoint)((Object)o)).getLineNumber()));
        }
        if (o instanceof FunctionBreakpoint) {
            FunctionBreakpoint b = (FunctionBreakpoint)((Object)o);
            String className = "";
            if (b.getFunctionName().equals("")) {
                return NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_All_Functions_Breakpoint", (Object)className);
            }
            return NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Function_Breakpoint", (Object)className, (Object)b.getFunctionName());
        }
        throw new UnknownTypeException(o);
    }

    public String getIconBase(Object o) throws UnknownTypeException {
        if (o instanceof LineBreakpoint) {
            return LINE_BREAKPOINT;
        }
        if (o instanceof FunctionBreakpoint) {
            return BREAKPOINT;
        }
        throw new UnknownTypeException(o);
    }

    public void addModelListener(ModelListener l) {
        this.listeners.add(l);
    }

    public void removeModelListener(ModelListener l) {
        this.listeners.remove(l);
    }

    void fireNodeChanged(RemoteBreakpoint b) {
        Vector v = (Vector)this.listeners.clone();
        int k = v.size();
        for (int i = 0; i < k; ++i) {
            ((ModelListener)v.get(i)).modelChanged((ModelEvent)new ModelEvent.NodeChanged((Object)this, (Object)b));
        }
    }

    static String getShort(String s) {
        if (s.indexOf(42) >= 0) {
            return s;
        }
        int i = s.lastIndexOf(46);
        if (i < 0) {
            return s;
        }
        return s.substring(i + 1);
    }

    private String bold(RemoteBreakpoint b, String name) {
        return b == this.currentBreakpoint ? BoldVariablesTableModelFilterFirst.toHTML(name, true, false, null) : name;
    }

    public void setCurrentBreakpoint(RemoteBreakpoint currentBreakpoint) {
        if (this.currentBreakpoint != null) {
            this.fireNodeChanged(this.currentBreakpoint);
        }
        this.currentBreakpoint = currentBreakpoint;
        if (currentBreakpoint != null) {
            this.fireNodeChanged(currentBreakpoint);
        }
    }
}

