/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.debugsupport.breakpoints;

import com.hp.openvms.netbeans.debugsupport.breakpoints.BreakpointsReader;
import com.hp.openvms.netbeans.debugsupport.breakpoints.RemoteBreakpoint;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.LazyDebuggerManagerListener;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.Watch;

public class PersistenceManager
implements LazyDebuggerManagerListener {
    public Breakpoint[] initBreakpoints() {
        Properties p = Properties.getDefault().getProperties("debugger").getProperties("breakpoints");
        return (Breakpoint[])p.getArray("gdb", (Object[])new Breakpoint[0]);
    }

    public void initWatches() {
    }

    public String[] getProperties() {
        return new String[]{"breakpointsInit", "breakpoints"};
    }

    public void breakpointAdded(Breakpoint breakpoint) {
        Properties p = Properties.getDefault().getProperties("debugger").getProperties("breakpoints");
        p.setArray("gdb", (Object[])PersistenceManager.getBreakpoints());
        breakpoint.addPropertyChangeListener((PropertyChangeListener)((Object)this));
    }

    public void breakpointRemoved(Breakpoint breakpoint) {
        Properties p = Properties.getDefault().getProperties("debugger").getProperties("breakpoints");
        p.setArray("gdb", (Object[])PersistenceManager.getBreakpoints());
        breakpoint.removePropertyChangeListener((PropertyChangeListener)((Object)this));
    }

    public void watchAdded(Watch watch) {
    }

    public void watchRemoved(Watch watch) {
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof RemoteBreakpoint) {
            PersistenceManager.storeBreakpoints();
        }
    }

    static BreakpointsReader findBreakpointsReader() {
        BreakpointsReader breakpointsReader = null;
        for (Properties.Reader r : DebuggerManager.getDebuggerManager().lookup(null, Properties.Reader.class)) {
            String[] ns = r.getSupportedClassNames();
            if (ns.length != 1 || !RemoteBreakpoint.class.getName().equals(ns[0])) continue;
            breakpointsReader = (BreakpointsReader)r;
            break;
        }
        return breakpointsReader;
    }

    static void storeBreakpoints() {
        Properties.getDefault().getProperties("debugger").getProperties("breakpoints").setArray("gdb", (Object[])PersistenceManager.getBreakpoints());
    }

    public void sessionAdded(Session session) {
    }

    public void sessionRemoved(Session session) {
    }

    public void engineAdded(DebuggerEngine engine) {
    }

    public void engineRemoved(DebuggerEngine engine) {
    }

    private static Breakpoint[] getBreakpoints() {
        Breakpoint[] bs = DebuggerManager.getDebuggerManager().getBreakpoints();
        int k = bs.length;
        ArrayList<Breakpoint> bb = new ArrayList<Breakpoint>();
        for (int i = 0; i < k; ++i) {
            if (!(bs[i] instanceof RemoteBreakpoint) || ((RemoteBreakpoint)bs[i]).isHidden()) continue;
            bb.add(bs[i]);
        }
        bs = new Breakpoint[bb.size()];
        return bb.toArray(bs);
    }
}

