/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.cobolsupport.editor.cobol;

import com.hp.openvms.netbeans.cobolsupport.cobol.datasys.CobolCompilerSupport;
import com.hp.openvms.netbeans.cobolsupport.cobol.datasys.CobolDataObject;
import com.hp.openvms.netbeans.cobolsupport.editor.cobol.IndentInfo;
import com.hp.openvms.netbeans.cobolsupport.editor.cobol.StringLexerInput;
import com.hp.openvms.netbeans.cobolsupport.editor.lang.CobolLanguage;
import javax.swing.text.JTextComponent;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Lexer;
import org.netbeans.api.lexer.LexerInput;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenCategory;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtFormatSupport;
import org.netbeans.editor.ext.FormatTokenPosition;
import org.netbeans.editor.ext.FormatWriter;

public class CobolFormatSupport
extends ExtFormatSupport {
    private TokenContextPath tokenContextPath;
    private Language language;
    private LexerInput input;
    private Lexer lex;
    private boolean ansiformat;

    public CobolFormatSupport(FormatWriter formatWriter) {
        super(formatWriter);
        CobolCompilerSupport cookie;
        BaseDocument doc = Utilities.getDocument((JTextComponent)Utilities.getLastActiveComponent());
        CobolDataObject cobd = (CobolDataObject)((Object)doc.getProperty((Object)"stream"));
        CobolCompilerSupport cobolSupport = cookie = cobd.getCookie(CobolCompilerSupport.class);
        this.ansiformat = cobolSupport.getAnsiFormatting().equals(Boolean.TRUE);
    }

    private int getNumericId(String image) {
        CobolLanguage language = CobolLanguage.get();
        StringLexerInput input = new StringLexerInput(image);
        Lexer lex = language.createLexer();
        lex.restart((LexerInput)input, null);
        Token tok = lex.nextToken();
        return tok.getId().getIntId();
    }

    private TokenId getLexerTokenId(TokenID tokenid) {
        CobolLanguage language = CobolLanguage.get();
        StringLexerInput input = new StringLexerInput(tokenid.getName());
        Lexer lex = language.createLexer();
        lex.restart((LexerInput)input, null);
        Token tok = lex.nextToken();
        return tok.getId();
    }

    public boolean isFreeFormatComment(TokenItem token) {
        return token != null && token.getImage().startsWith("*");
    }

    public int getCommentPosition() {
        if (this.isAnsiFormat()) {
            return 7;
        }
        return 1;
    }

    public int getFormattedIndentPosition() {
        if (this.isAnsiFormat()) {
            return 7;
        }
        return 0;
    }

    public int getTokenIndent(TokenItem token) {
        FormatTokenPosition tp = this.getPosition(token, 0);
        FormatTokenPosition fnw = this.findLineFirstNonWhitespace(tp);
        if (fnw != null) {
            TokenItem t = fnw.getToken();
            Object object = fnw = t == null && t.getImage().length() > 0 ? null : this.getPosition(t, 0);
            if (fnw != null) {
                tp = fnw;
            }
        }
        return this.getVisualColumnOffset(tp);
    }

    public boolean isPreviousLineBlank(FormatTokenPosition current) {
        FormatTokenPosition lstartnw = null;
        FormatTokenPosition prev = null;
        FormatTokenPosition lstart = null;
        prev = this.findPreviousEOL(current);
        lstart = this.findLineStart(prev);
        lstartnw = this.getInitialPosition(lstart);
        return lstartnw == null;
    }

    public FormatTokenPosition GetPreviousLinePosition(FormatTokenPosition current) {
        FormatTokenPosition tempPos = current;
        FormatTokenPosition lstartnw = null;
        FormatTokenPosition prev = null;
        FormatTokenPosition lstart = null;
        prev = this.findPreviousEOL(current);
        lstart = this.findLineStart(prev);
        lstartnw = this.getInitialPosition(lstart);
        return lstartnw;
    }

    public FormatTokenPosition GetMostRecentELSEorIFStatement(FormatTokenPosition current) {
        Object temp = null;
        return null;
    }

    public FormatTokenPosition GetMostRecentIFStatement(FormatTokenPosition current) {
        return current;
    }

    public FormatTokenPosition GetMostRecentLineTerminatingWithPeriod(FormatTokenPosition current) {
        return current;
    }

    public FormatTokenPosition getPreviousTokenPosition(FormatTokenPosition current, int depth) {
        FormatTokenPosition tempPos = current;
        Object lstartnw = null;
        FormatTokenPosition prev = null;
        Object prev1 = null;
        Object lstart = null;
        for (int i = 0; i < depth; ++i) {
            while (this.isPreviousLineBlank(current)) {
                tempPos = this.findPreviousEOL(current);
                current = prev = this.getPreviousPosition(tempPos);
            }
            current = prev = this.GetPreviousLinePosition(current);
        }
        return current;
    }

    public boolean isStartingWithElse(FormatTokenPosition pos) {
        CobolLanguage language = CobolLanguage.get();
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = language.createLexer();
            lex.restart((LexerInput)input, null);
            while ((tok = lex.nextToken()) != null) {
                if (tok.getId().getIntId() != 180) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean isStartingWithIf(FormatTokenPosition pos) {
        CobolLanguage language = CobolLanguage.get();
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = language.createLexer();
            lex.restart((LexerInput)input, null);
            while ((tok = lex.nextToken()) != null) {
                if (tok.getId().getIntId() != 284) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean isIfOnlyStatement(FormatTokenPosition pos) {
        CobolLanguage language = CobolLanguage.get();
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = language.createLexer();
            lex.restart((LexerInput)input, null);
            boolean isifonly = false;
            while ((tok = lex.nextToken()) != null) {
                if (tok.getId().getIntId() == 284) {
                    isifonly = true;
                    while ((tok = lex.nextToken()) != null) {
                        if (tok.getId().getIntId() != 539) continue;
                        isifonly = false;
                        return isifonly;
                    }
                    continue;
                }
                isifonly = false;
            }
            return isifonly;
        }
        return false;
    }

    public boolean isIfThenStatement(FormatTokenPosition pos) {
        CobolLanguage language = CobolLanguage.get();
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = language.createLexer();
            lex.restart((LexerInput)input, null);
            boolean isifthen = false;
            while ((tok = lex.nextToken()) != null) {
                if (tok.getId().getIntId() == 284) {
                    while ((tok = lex.nextToken()) != null) {
                        if (tok.getId().getIntId() != 539) continue;
                        isifthen = true;
                        return isifthen;
                    }
                    continue;
                }
                isifthen = false;
            }
            return isifthen;
        }
        return false;
    }

    public int getIndentationInfo(FormatTokenPosition pos, IndentInfo idf) {
        FormatTokenPosition firstNWS;
        int indent = 0;
        if (this.isAnsiFormat()) {
            if (this.isIndentOnly()) {
                firstNWS = this.findLineFirstNonWhitespace(pos);
            } else {
                firstNWS = this.findLineFirstNonWhitespace(pos);
                int colOffset = this.getVisualColumnOffset(firstNWS);
                if (colOffset <= 7) {
                    firstNWS = pos;
                }
            }
        } else {
            firstNWS = this.findLineFirstNonWhitespace(pos);
        }
        if (firstNWS != null) {
            if (this.isFreeFormatComment(firstNWS.getToken())) {
                indent = this.getVisualColumnOffset(firstNWS);
                idf.setIndent(indent);
                idf.setType(3);
            } else {
                Token tok;
                CobolLanguage language = CobolLanguage.get();
                StringLexerInput input = new StringLexerInput(firstNWS.getToken().getImage());
                Lexer lex = language.createLexer();
                lex.restart((LexerInput)input, null);
                block6: while ((tok = lex.nextToken()) != null) {
                    switch (tok.getId().getIntId()) {
                        case 2: {
                            continue block6;
                        }
                        case 284: {
                            boolean onlyIf = true;
                            indent = this.getVisualColumnOffset(firstNWS);
                            idf.setIndent(indent);
                            idf.setType(31);
                            while ((tok = lex.nextToken()) != null) {
                                if (tok.getId().getIntId() != 539) continue;
                                indent = this.getVisualColumnOffset(firstNWS);
                                idf.setIndent(indent);
                                idf.setType(5);
                                onlyIf = false;
                            }
                            break block6;
                        }
                        case 190: {
                            indent = this.getVisualColumnOffset(firstNWS);
                            idf.setIndent(indent);
                            idf.setType(6);
                            break block6;
                        }
                        case 180: {
                            indent = this.getVisualColumnOffset(firstNWS);
                            idf.setIndent(indent);
                            idf.setType(30);
                            break block6;
                        }
                        default: {
                            indent = this.getVisualColumnOffset(firstNWS);
                            idf.setIndent(indent);
                            idf.setType(3);
                            break block6;
                        }
                    }
                }
            }
        }
        return indent;
    }

    public boolean getFreeFormat() {
        return true;
    }

    public int getIndent(FormatTokenPosition pos) {
        if (pos != null) {
            return this.getVisualColumnOffset(pos);
        }
        return 0;
    }

    public FormatTokenPosition getInitialPosition(FormatTokenPosition pos) {
        FormatTokenPosition firstNWS = this.findLineFirstNonWhitespace(pos);
        return firstNWS;
    }

    public boolean isPreviousLineEmpty(FormatTokenPosition pos) {
        FormatTokenPosition temp = this.getPreviousLine(pos);
        if (temp == null) {
            return false;
        }
        return this.findLineFirstNonWhitespace(temp) == null;
    }

    public boolean isPreviousLineComment(FormatTokenPosition pos) {
        FormatTokenPosition temp = this.getPreviousLine(pos);
        if (temp == null) {
            return false;
        }
        return this.isComment(temp);
    }

    public boolean isNextLineEmpty(FormatTokenPosition pos) {
        FormatTokenPosition temp = this.getNextLine(pos);
        if (temp == null) {
            return false;
        }
        return this.findLineFirstNonWhitespace(temp) == null;
    }

    public boolean isNextLineComment(FormatTokenPosition pos) {
        FormatTokenPosition temp = this.getNextLine(pos);
        if (temp == null) {
            return false;
        }
        return this.isComment(temp);
    }

    public FormatTokenPosition getPreviousLine(FormatTokenPosition current) {
        FormatTokenPosition temp = this.findLineStart(current);
        if (temp == null) {
            return null;
        }
        FormatTokenPosition prev = this.getPreviousPosition(temp);
        if (prev == null) {
            return null;
        }
        return this.findLineStart(prev);
    }

    public FormatTokenPosition getPreviousNonEmptyLine(FormatTokenPosition current) {
        FormatTokenPosition temp = current;
        while (this.isPreviousLineEmpty(current) | this.isPreviousLineComment(current)) {
            current = this.getPreviousLine(current);
        }
        temp = this.getPreviousLine(current);
        if (temp != null && this.isWhite(temp)) {
            temp = this.getInitialPosition(temp);
        }
        return temp;
    }

    public FormatTokenPosition getNextLine(FormatTokenPosition current) {
        FormatTokenPosition temp = this.findLineEnd(current);
        FormatTokenPosition prev = this.getNextPosition(temp);
        if (prev == null) {
            return null;
        }
        return prev;
    }

    public FormatTokenPosition getNextNonEmptyLine(FormatTokenPosition current) {
        FormatTokenPosition temp = current;
        while (this.isNextLineEmpty(current) | this.isNextLineComment(current)) {
            current = this.getNextLine(current);
        }
        return this.getNextLine(current);
    }

    public boolean isWhite(FormatTokenPosition pos) {
        CobolLanguage language = CobolLanguage.get();
        boolean status = true;
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = language.createLexer();
            lex.restart((LexerInput)input, null);
            while ((tok = lex.nextToken()) != null) {
                if (tok.getId().getIntId() == 2) continue;
                status = false;
                break;
            }
        }
        return status;
    }

    public boolean isELSEStatement(FormatTokenPosition pos) {
        CobolLanguage language = CobolLanguage.get();
        boolean status = false;
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = language.createLexer();
            lex.restart((LexerInput)input, null);
            while ((tok = lex.nextToken()) != null) {
                if (tok.getId().getIntId() != 180) continue;
                status = true;
            }
        }
        return status;
    }

    public boolean isReservedWord(FormatTokenPosition pos) {
        CobolLanguage language = CobolLanguage.get();
        boolean status = false;
        if (pos != null) {
            TokenCategory reserveCategory = language.getCategory("Reserved Words");
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage().trim());
            Lexer lex = language.createLexer();
            lex.restart((LexerInput)input, null);
            Token tok = lex.nextToken();
            status = reserveCategory.isMember(tok.getId());
        }
        return status;
    }

    public boolean isIFStatement(FormatTokenPosition pos) {
        CobolLanguage language = CobolLanguage.get();
        boolean status = false;
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = language.createLexer();
            lex.restart((LexerInput)input, null);
            while ((tok = lex.nextToken()) != null) {
                if (tok.getId().getIntId() != 284) continue;
                status = true;
            }
        }
        return status;
    }

    public boolean isThenStatement(FormatTokenPosition pos) {
        CobolLanguage language = CobolLanguage.get();
        boolean status = false;
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = language.createLexer();
            lex.restart((LexerInput)input, null);
            while ((tok = lex.nextToken()) != null) {
                if (tok.getId().getIntId() != 539) continue;
                status = true;
            }
        }
        return status;
    }

    public boolean isENDIFStatement(FormatTokenPosition pos) {
        CobolLanguage language = CobolLanguage.get();
        boolean status = false;
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = language.createLexer();
            lex.restart((LexerInput)input, null);
            while ((tok = lex.nextToken()) != null) {
                if (tok.getId().getIntId() != 190) continue;
                status = true;
            }
        }
        return status;
    }

    public boolean isProcedureDivision(FormatTokenPosition pos) {
        CobolLanguage language = CobolLanguage.get();
        boolean procstatus = false;
        boolean divstatus = false;
        if (pos != null) {
            Token tok;
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = language.createLexer();
            lex.restart((LexerInput)input, null);
            while ((tok = lex.nextToken()) != null) {
                if (tok.getId().getIntId() == 390) {
                    procstatus = true;
                }
                if (tok.getId().getIntId() != 143) continue;
                divstatus = true;
            }
        }
        return procstatus && divstatus;
    }

    public boolean isEndingWithPeriod(FormatTokenPosition pos) {
        CobolLanguage language = CobolLanguage.get();
        boolean status = false;
        if (pos != null) {
            String temp = pos.getToken().getImage();
            String trimmed = temp.trim();
            String sub = trimmed.trim().substring(trimmed.length() - 1);
            status = sub.equals(".");
        }
        return status;
    }

    public boolean isComment(FormatTokenPosition pos) {
        boolean status = false;
        if (pos != null) {
            String temp = pos.getToken().getImage();
            String trimmed = temp.trim();
            status = trimmed.trim().startsWith("*") || trimmed.trim().startsWith("/") || trimmed.trim().startsWith("-") ? true : (this.isAnsiFormat() ? temp.indexOf("*") == 6 || temp.indexOf("/") == 6 || temp.indexOf("-") == 6 : false);
        }
        return status;
    }

    public String getCommentChar(FormatTokenPosition pos) {
        String temp = pos.getToken().getImage();
        if (temp.indexOf("*") != -1) {
            return "*";
        }
        if (temp.indexOf("-") != -1) {
            return "-";
        }
        return "/";
    }

    public boolean isInAreaA(FormatTokenPosition pos) {
        boolean status = true;
        if (this.isAnsiFormat()) {
            if (this.getIndent(this.getInitialPosition(pos)) >= 11) {
                status = false;
            }
        } else if (this.getIndent(this.getInitialPosition(pos)) >= 4) {
            status = false;
        }
        return status;
    }

    public boolean isAnsiFormat() {
        return this.ansiformat;
    }
}

