/*
 * Decompiled with CFR 0.152.
 */
package patchsources;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class OpenProjectList_Dist {
    private static final TreeSet fsSet = new TreeSet(new Comparator(){

        public int compare(Object o1, Object o2) {
            return ((FileSystem)o1).getDisplayName().compareToIgnoreCase(((FileSystem)o2).getDisplayName());
        }

        public boolean equals(Object obj) {
            return super.equals(obj);
        }
    });

    public static List filterURL(String filePath) {
        class MyErrHandler
        implements ErrorHandler {
            private void annotate(SAXParseException exception) throws SAXException {
                ErrorManager.getDefault().annotate((Throwable)exception, 0, "Occurred at: " + exception.getSystemId() + ":" + exception.getLineNumber(), null, null, null);
            }

            public void fatalError(SAXParseException exception) throws SAXException {
                this.annotate(exception);
                throw exception;
            }

            public void error(SAXParseException exception) throws SAXException {
                this.annotate(exception);
                throw exception;
            }

            public void warning(SAXParseException exception) throws SAXException {
                this.annotate(exception);
                ErrorManager.getDefault().notify(1, (Throwable)exception);
            }
        }
        ArrayList<FileSystem> flist = new ArrayList<FileSystem>();
        Document doc = null;
        try {
            doc = XMLUtil.parse((InputSource)new InputSource(filePath + File.separatorChar + "NBPROJECT" + File.separatorChar + "PRIVATE" + File.separatorChar + "PRIVATE.XML"), (boolean)false, (boolean)true, (ErrorHandler)new MyErrHandler(), null);
        }
        catch (Exception e) {
            try {
                doc = XMLUtil.parse((InputSource)new InputSource(filePath + File.separatorChar + "nbproject" + File.separatorChar + "private" + File.separatorChar + "private.xml"), (boolean)false, (boolean)true, (ErrorHandler)new MyErrHandler(), null);
            }
            catch (Exception e1) {
                // empty catch block
            }
        }
        try {
            if (doc != null) {
                NodeList nlist = doc.getElementsByTagNameNS("http://www.netbeans.org/ns/remote-project/1", "remotefs");
                for (int i = 0; i < nlist.getLength(); ++i) {
                    NodeList l = nlist.item(i).getChildNodes();
                    for (int j = 0; j < l.getLength(); ++j) {
                        Text text;
                        if (l.item(j).getNodeType() != 3 || (text = (Text)l.item(j)).getNodeValue().trim().length() <= 0) continue;
                        FileSystem fs = (FileSystem)OpenProjectList_Dist.serialValue(text.getNodeValue());
                        flist.add(fs);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return flist;
    }

    public static Set getFsSet() {
        return fsSet;
    }

    private static Object serialValue(String val) throws ClassNotFoundException, IOException {
        if (val == null || val.length() == 0) {
            return null;
        }
        byte[] bytes = new byte[val.length() / 2];
        int count = 0;
        try {
            for (int i = 0; i < val.length(); ++i) {
                if (Character.isWhitespace(val.charAt(i))) continue;
                int tempI = Integer.parseInt(val.substring(i, i + 2), 16);
                if (tempI > 127) {
                    tempI -= 256;
                }
                bytes[count++] = (byte)tempI;
                ++i;
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            IOException e2 = new IOException("Cannot read value of <serialvalue> attribute from file XXXX");
            ErrorManager.getDefault().annotate((Throwable)e2, (Throwable)e);
            throw e2;
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes, 0, count);
        try {
            class SpecialObjectInputStream
            extends ObjectInputStream {
                public SpecialObjectInputStream(InputStream is) throws IOException {
                    super(is);
                    try {
                        this.enableResolveObject(true);
                    }
                    catch (SecurityException ex) {
                        throw new IOException(ex.toString());
                    }
                }

                protected Class resolveClass(ObjectStreamClass v) throws IOException, ClassNotFoundException {
                    ClassLoader cl = this.getNBClassLoader();
                    try {
                        return Class.forName(v.getName(), false, cl);
                    }
                    catch (ClassNotFoundException cnfe) {
                        String msg = "Offending classloader: " + cl;
                        ErrorManager.getDefault().annotate((Throwable)cnfe, 1, msg, null, null, null);
                        throw cnfe;
                    }
                }

                protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
                    String newN;
                    ObjectStreamClass ose = super.readClassDescriptor();
                    String name = ose.getName();
                    if (name == (newN = Utilities.translate((String)name))) {
                        return ose;
                    }
                    ClassLoader cl = this.getNBClassLoader();
                    try {
                        Class<?> origCl = Class.forName(name, false, cl);
                        return ObjectStreamClass.lookup(origCl);
                    }
                    catch (ClassNotFoundException ex) {
                        Class<?> clazz = Class.forName(newN, false, cl);
                        ObjectStreamClass newOse = ObjectStreamClass.lookup(clazz);
                        if (newOse == null) {
                            throw new NotSerializableException(newN);
                        }
                        return newOse;
                    }
                }

                private ClassLoader getNBClassLoader() {
                    ClassLoader c = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
                    return c != null ? c : ClassLoader.getSystemClassLoader();
                }
            }
            SpecialObjectInputStream ois = new SpecialObjectInputStream(bis);
            return ois.readObject();
        }
        catch (Exception e) {
            IOException e2 = new IOException("Cannot read value of <serialvalue> attribute from file XXXXX");
            ErrorManager.getDefault().annotate((Throwable)e2, (Throwable)e);
            throw e2;
        }
    }

    public static Project fileToProject(File projectDir) {
        try {
            FileObject fo = FileUtil.toFileObject((File)projectDir);
            if (fo != null && fo.isFolder()) {
                return ProjectManager.getDefault().findProject(fo);
            }
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

