/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remoteproject;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.distributed.common.cookies.RemotePropertyCookie;
import org.netbeans.modules.distributed.common.util.RemoteProjectSettings;
import org.netbeans.modules.distributed.common.util.Utils;
import org.netbeans.modules.distributed.remotefs.AbstractNetworkFileSystem;
import org.netbeans.modules.distributed.remoteproject.RemoteProjectPropertiesExecution;
import org.netbeans.modules.distributed.remoteproject.SurrogateNode;
import org.openide.awt.Actions;
import org.openide.explorer.propertysheet.PropertySheet;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeOperation;
import org.openide.util.HelpCtx;
import org.openide.util.actions.CookieAction;
import org.openide.util.actions.SystemAction;

public class RemotePropertiesAction
extends CookieAction {
    static final long serialVersionUID = 5485687384586248747L;
    static ThreadLocal activated = new ThreadLocal();

    protected Class[] cookieClasses() {
        return new Class[]{DataObject.class};
    }

    protected int mode() {
        return 7;
    }

    protected void performAction(Node[] activatedNodes) {
        RemoteProjectSettings rs;
        if (activatedNodes == null) {
            return;
        }
        RemotePropertyCookie rp = (RemotePropertyCookie)activatedNodes[0].getCookie(RemotePropertyCookie.class);
        if (rp != null) {
            rp.operations(activatedNodes);
            return;
        }
        DataObject dobj = (DataObject)activatedNodes[0].getCookie(DataObject.class);
        Project project = FileOwnerQuery.getOwner((FileObject)dobj.getPrimaryFile());
        if (project != null) {
            FileOwnerQuery.markExternalOwner((FileObject)dobj.getPrimaryFile(), (Project)project, (int)0);
        }
        if ((rs = (RemoteProjectSettings)project.getLookup().lookup(RemoteProjectSettings.class)) != null) {
            rs.refresh("ant");
        } else {
            Utils.writeDefault3GLXMLCompilerSettings(project);
        }
        if (dobj.getPrimaryFile().isRoot()) {
            RemoteProjectPropertiesExecution.doAction(activatedNodes);
            return;
        }
        final PropertySheet ps = new PropertySheet();
        SurrogateNode[] nds = new SurrogateNode[activatedNodes.length];
        for (int i = 0; i < activatedNodes.length; ++i) {
            nds[i] = new SurrogateNode((Children)new Children.Array(), activatedNodes[i]);
        }
        ps.setNodes((Node[])nds);
        final Node[] anodes = activatedNodes;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JDialog d = new JDialog();
                if (anodes.length > 1) {
                    d.setTitle("Remote Properties of Multiple Objects");
                } else {
                    d.setTitle("Remote Properties of " + anodes[0].getName());
                }
                d.setModal(true);
                d.getContentPane().setLayout(new BorderLayout());
                d.getContentPane().add((Component)ps, "Center");
                d.pack();
                d.show();
                d.dispose();
            }
        });
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes == null) {
            return false;
        }
        int nodeType = 0;
        int prevNodeType = -1;
        for (int i = 0; i < activatedNodes.length; ++i) {
            DataObject dobj = (DataObject)activatedNodes[i].getCookie(DataObject.class);
            if (dobj == null) {
                return false;
            }
            try {
                if (!(dobj.getPrimaryFile().getFileSystem() instanceof AbstractNetworkFileSystem)) {
                    return false;
                }
            }
            catch (FileStateInvalidException e) {
                return false;
            }
            nodeType = dobj.getCookie(RemotePropertyCookie.class) != null ? 0 : (dobj.getPrimaryFile().getExt().toLowerCase().equals("java") ? 1 : (dobj.getCookie(AntProjectCookie.class) != null ? 2 : 3));
            if (prevNodeType >= 0 && prevNodeType != nodeType) {
                return false;
            }
            prevNodeType = nodeType;
        }
        return true;
    }

    public JMenuItem getPopupPresenter() {
        Actions.MenuItem prop = new Actions.MenuItem((SystemAction)this, false);
        return prop;
    }

    public String getName() {
        return "Remote Properties";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected String iconResource() {
        return "org/openide/resources/actions/properties.gif";
    }

    protected boolean asynchronous() {
        return false;
    }

    static class ShowPropertiesInvoker
    implements Runnable {
        ShowPropertiesInvoker() {
        }

        public void run() {
            Node[] activatedNodes = (Node[])activated.get();
            activated.set(null);
            if (activatedNodes == null) {
                throw new IllegalStateException();
            }
            if (activatedNodes.length == 1) {
                DataObject dobj = (DataObject)activatedNodes[0].getCookie(DataObject.class);
                NodeOperation.getDefault().showProperties(activatedNodes[0]);
            } else {
                NodeOperation.getDefault().showProperties(activatedNodes);
            }
        }
    }
}

