/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remoteproject;

import java.awt.Image;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.Action;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.distributed.remoteexecute.BuildProject;
import org.netbeans.modules.distributed.remoteexecute.OfflineProject;
import org.netbeans.modules.distributed.remoteexecute.OnlineProject;
import org.netbeans.modules.distributed.remotefs.ftpfs.FTPFileSystem;
import org.netbeans.modules.distributed.remoteproject.OpenVMSSources;
import org.netbeans.modules.distributed.remoteproject.RemoteProject;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.openide.ErrorManager;
import org.openide.actions.ToolsAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

class RemoteProjectLogicalView
implements LogicalViewProvider {
    private RemoteProject project;

    public RemoteProjectLogicalView(RemoteProject project) {
        this.project = project;
    }

    public Node createLogicalView() {
        try {
            FileSystem fs = this.project.getProjectDirectory().getFileSystem();
            List list = this.project.getRoots();
            for (int i = 0; i < list.size(); ++i) {
                FileOwnerQuery.markExternalOwner((FileObject)((FileSystem)list.get(i)).getRoot(), (Project)this.project, (int)0);
            }
            Node mainNode = DataObject.find((FileObject)((FileSystem)list.get(OpenVMSSources.SRC_ROOT)).getRoot()).getNodeDelegate();
            return new ScenesNode(mainNode, mainNode, this.project);
        }
        catch (DataObjectNotFoundException donfe) {
            ErrorManager.getDefault().notify((Throwable)donfe);
            return new AbstractNode(Children.LEAF);
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify((Throwable)e);
            return new AbstractNode(Children.LEAF);
        }
    }

    public Node findPath(Node root, Object target) {
        if (target instanceof DataObject) {
            return null;
        }
        return null;
    }

    private static final class ScenesNode
    extends FilterNode {
        final RemoteProject project;
        private static final int BADGE_ICON_SHIFT_X = 16;
        private static final int BADGE_ICON_SHIFT_Y = 1;

        public ScenesNode(Node node, Node childrenNode, RemoteProject project) throws DataObjectNotFoundException {
            super(node, (Children)new LogicalViewChildren(project), (Lookup)new ProxyLookup(new Lookup[]{Lookups.singleton((Object)project), node.getLookup()}));
            this.project = project;
        }

        public ScenesNode(Node node, RemoteProject project) throws DataObjectNotFoundException {
            super(node, (Children)new FilterNode.Children(node), (Lookup)new ProxyLookup(new Lookup[]{Lookups.singleton((Object)project), node.getLookup()}));
            this.project = project;
        }

        public Image getIcon(int type) {
            Image img = ImageUtilities.loadImage((String)"org/netbeans/core/resources/mime.gif");
            List roots = this.project.getRoots();
            for (int i = 0; i < roots.size(); ++i) {
                FileSystem fs = (FileSystem)roots.get(i);
                HashSet<FileObject> files = new HashSet<FileObject>();
                files.add(fs.getRoot());
                img = fs.getStatus().annotateIcon(img, type, files);
            }
            return img;
        }

        public Image getOpenedIcon(int type) {
            return this.getIcon(type);
        }

        public Action[] getActions(boolean context) {
            return this.getAdditionalActions();
        }

        public String getDisplayName() {
            try {
                ProjectInformation info = (ProjectInformation)this.project.getLookup().lookup(ProjectInformation.class);
                if (info != null) {
                    return info.getDisplayName();
                }
                return this.project.getProjectDirectory().getName();
            }
            catch (Exception e) {
                return this.project.getProjectDirectory().getName();
            }
        }

        private Action[] getAdditionalActions() {
            ArrayList<Action> actions = new ArrayList<Action>();
            actions.add(CommonProjectActions.newFileAction());
            actions.add(CommonProjectActions.closeProjectAction());
            actions.add(CommonProjectActions.deleteProjectAction());
            actions.add((Action)SystemAction.get(BuildProject.class));
            actions.add((Action)SystemAction.get(OfflineProject.class));
            actions.add((Action)SystemAction.get(OnlineProject.class));
            actions.add(null);
            actions.add(null);
            actions.add((Action)SystemAction.get(ToolsAction.class));
            actions.add(null);
            Action pAction = CommonProjectActions.customizeProjectAction();
            actions.add(pAction);
            return actions.toArray(new Action[actions.size()]);
        }
    }

    private static final class SourceNode
    extends FilterNode {
        final RemoteProject project;
        final FileObject fo;

        public SourceNode(Node node, Node childrenNode, RemoteProject project, FileObject fo) throws DataObjectNotFoundException {
            super(node, (Children)new FilterNode.Children(node), (Lookup)new ProxyLookup(new Lookup[]{Lookups.singleton((Object)project), node.getLookup()}));
            this.project = project;
            this.fo = fo;
        }

        public SourceNode(Node node, RemoteProject project, FileObject fo) throws DataObjectNotFoundException {
            super(node, (Children)new FilterNode.Children(node), (Lookup)new ProxyLookup(new Lookup[]{Lookups.singleton((Object)project), node.getLookup()}));
            this.project = project;
            this.fo = fo;
        }

        public Image getIcon(int type) {
            return Utilities.loadImage((String)"org/netbeans/modules/java/j2seproject/ui/resources/packageRoot.gif");
        }

        public Image getOpenedIcon(int type) {
            return this.getIcon(type);
        }

        public String getDisplayName() {
            try {
                String prefix = "";
                if (this.fo.getFileSystem() instanceof FTPFileSystem) {
                    prefix = ((FTPFileSystem)this.fo.getFileSystem()).isConnected() ? "" : "<offline> ";
                }
                return prefix + FileUtil.toFile((FileObject)this.fo).getAbsolutePath();
            }
            catch (Exception e) {
                return this.project.getProjectDirectory().getName();
            }
        }
    }

    private static final class LogicalViewChildren
    extends Children.Keys {
        private RemoteProject project;

        public LogicalViewChildren(RemoteProject project) {
            this.project = project;
        }

        private Sources getSources() {
            return ProjectUtils.getSources((Project)this.project);
        }

        protected void addNotify() {
            super.addNotify();
            this.setKeys(this.getKeys());
        }

        protected Node[] createNodes(Object key) {
            Node[] result = new Node[]{};
            if (key instanceof SourceGroupKey) {
                try {
                    Node mainNode = DataObject.find((FileObject)((SourceGroupKey)key).fileObject).getNodeDelegate();
                    result = new Node[]{new SourceNode(mainNode, mainNode, this.project, ((SourceGroupKey)key).fileObject)};
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    // empty catch block
                }
            }
            return result;
        }

        private Collection getKeys() {
            if (this.project.getProjectDirectory() == null || !this.project.getProjectDirectory().isValid()) {
                return Collections.EMPTY_LIST;
            }
            Sources sources = this.getSources();
            SourceGroup[] groups = sources.getSourceGroups(null);
            ArrayList<SourceGroupKey> result = new ArrayList<SourceGroupKey>(groups.length);
            for (int i = 0; i < groups.length; ++i) {
                result.add(new SourceGroupKey(groups[i]));
            }
            return result;
        }
    }

    private static class SourceGroupKey {
        public final SourceGroup group;
        public final FileObject fileObject;

        SourceGroupKey(SourceGroup group) {
            this.group = group;
            this.fileObject = group.getRootFolder();
        }

        public int hashCode() {
            return this.fileObject.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SourceGroupKey)) {
                return false;
            }
            SourceGroupKey otherKey = (SourceGroupKey)obj;
            String thisDisplayName = this.group.getDisplayName();
            String otherDisplayName = otherKey.group.getDisplayName();
            return this.fileObject.equals(otherKey.fileObject) && thisDisplayName == null ? otherDisplayName == null : thisDisplayName.equals(otherDisplayName);
        }
    }
}

