/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.ideserverclient.diagnose;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.netbeans.modules.distributed.ideserverclient.RemoteLoginClient;
import org.openide.modules.ModuleInfo;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Lookup;

public class GatherInfo {
    private String lastErrMsg = "";
    private static final String USER_ENV_BEGIN = "USER_DIAG";
    private static final String USER_ENV_END = "USER_DIAG_END";
    private static final int REPORT_PAD = 52;

    public String getLastErrorMsg() {
        return this.lastErrMsg;
    }

    public static String padString(String moduleName) {
        StringBuffer buf = new StringBuffer();
        buf.append(moduleName);
        if (moduleName.length() < 52) {
            for (int i = moduleName.length(); i < 52; ++i) {
                buf.append(' ');
            }
        }
        return buf.toString();
    }

    public ArrayList getClientVersions() {
        Lookup.Result results = Lookup.getDefault().lookup(new Lookup.Template(ModuleInfo.class));
        Collection modules = results.allItems();
        Iterator it = modules.iterator();
        boolean i = false;
        ArrayList<String> arr = new ArrayList<String>();
        while (it.hasNext()) {
            Lookup.Item item = (Lookup.Item)it.next();
            ModuleInfo m = (ModuleInfo)item.getInstance();
            SpecificationVersion ver = m.getSpecificationVersion();
            if (!m.getCodeNameBase().startsWith("com.hp.openvms") && !m.getCodeNameBase().startsWith("com.compaq.openvms") && !m.getCodeNameBase().startsWith("org.netbeans.modules.distributed")) continue;
            arr.add(GatherInfo.padString(m.getCodeNameBase()) + ver.toString() + "\t" + (m.isEnabled() ? "enabled" : "disabled"));
        }
        return arr;
    }

    public ArrayList getClientEnv() {
        ArrayList<String> arr = new ArrayList<String>();
        arr.add("Product version\t" + new MessageFormat("NetBeans Platform Dev (Build {0})").format(new Object[]{System.getProperty("netbeans.buildnumber")}));
        arr.add("OS info:\t" + System.getProperty("os.name", "unknown") + " " + System.getProperty("os.version", "unknown") + " " + System.getProperty("os.arch", "unknown"));
        arr.add("JDK Info:\t" + System.getProperty("java.version", "unknown") + " " + System.getProperty("java.vm.name", "unknown") + " " + System.getProperty("java.vm.version", ""));
        arr.add("\t\t" + System.getProperty("java.vendor", "unknown") + " " + System.getProperty("java.home", "unknown"));
        arr.add("Home dir:\t" + System.getProperty("user.home", "unknown"));
        arr.add("Current dir:\t" + System.getProperty("user.dir", "unknown"));
        arr.add("NetBeans home:\t" + System.getProperty("netbeans.home"));
        arr.add("User dir:\t" + System.getProperty("netbeans.user"));
        return arr;
    }

    private String getUserDirValue() {
        return System.getProperty("netbeans.user");
    }

    public boolean isHostReachable(String hostName, int port) {
        try {
            Socket socket = null;
            Object os = null;
            DataInputStream is = null;
            socket = new Socket(hostName, port);
            is = new DataInputStream(socket.getInputStream());
        }
        catch (UnknownHostException e) {
            this.lastErrMsg = "IP address of the host " + hostName + " could not be determined";
            return false;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public boolean isIdeServerRunning(String hostName, int port) {
        String ret;
        RemoteLoginClient login = new RemoteLoginClient();
        this.lastErrMsg = ret = login.canFindLoginServer(hostName, port);
        return ret.equals("success");
    }

    public String getServerVersion(String host, int port) {
        String ret;
        RemoteLoginClient login = new RemoteLoginClient();
        this.lastErrMsg = ret = login.getServerVersionDirect(host, port);
        return ret;
    }

    public boolean authenUser(String hostName, String userName, char[] password, int port) {
        String ret;
        RemoteLoginClient login = new RemoteLoginClient();
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("VERSION", "1.0");
        hm.put("USER", userName.toLowerCase());
        hm.put("PASSWD", password);
        this.lastErrMsg = ret = login.authenticate(hm, hostName, port);
        return ret.equals("success");
    }

    public String[] getUserUAI(String hostName, String userName, char[] password, int port) {
        RemoteLoginClient login = new RemoteLoginClient();
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("VERSION", "1.0");
        hm.put("USER", userName.toLowerCase());
        hm.put("PASSWD", password);
        String outputs = login.getUserUAIInfo(hm, hostName, port);
        String quotas = outputs.substring(0, outputs.indexOf("Default")).trim();
        String defdev = outputs.substring(outputs.indexOf("Default"), outputs.length()).trim();
        return new String[]{quotas, defdev};
    }

    public String getUserEnv(String hostName, String userName, char[] password, int port) {
        RemoteLoginClient login = new RemoteLoginClient();
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("VERSION", "1.0");
        hm.put("USER", userName.toLowerCase());
        hm.put("PASSWD", password);
        String str = login.getUserEnv(hm, hostName, port);
        if (str == null || str.indexOf(USER_ENV_BEGIN) < 0 || str.indexOf(USER_ENV_END) < 0) {
            return "Can't determine the User Login Environment. Invalid output from the server";
        }
        return str.substring(str.indexOf(USER_ENV_BEGIN) + USER_ENV_BEGIN.length(), str.indexOf(USER_ENV_END));
    }

    public static void main(String[] args) {
        GatherInfo gi = new GatherInfo();
        gi.isHostReachable("yahoo.com", 1099);
    }
}

