/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.exesupport;

import com.hp.openvms.netbeans.exesupport.RemoteEXEExecution;
import com.hp.openvms.netbeans.utils.FileUtilityLang;
import java.io.File;
import java.io.IOException;
import java.util.ResourceBundle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.distributed.ideserverclient.RemoteRuntimeType;
import org.netbeans.modules.distributed.ideserverclient.settings.DistributedSettings;
import org.netbeans.modules.distributed.remoteexecute.RemoteExecutor;
import org.netbeans.modules.distributed.remoteexecute.RemoteProcessDescriptor;
import org.netbeans.modules.distributed.remoteexecute.TargetExecutor;
import org.netbeans.modules.distributed.remotefs.AbstractNetworkFileSystem;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.execution.ExecutorTask;
import org.openide.execution.NbProcessDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class RemoteExeExecutor
extends RemoteExecutor {
    RemoteProcessDescriptor remoteExecutor = null;
    private static final ResourceBundle bundle = NbBundle.getBundle(RemoteExecutor.class);

    public boolean isRemoteJavaCompile() {
        return false;
    }

    public ExecutorTask execute(DataObject obj) throws IOException {
        Boolean checkBox = null;
        AbstractNetworkFileSystem nfs = (AbstractNetworkFileSystem)obj.getPrimaryFile().getFileSystem();
        this.setChangeWorkingDir(true);
        checkBox = (Boolean)obj.getPrimaryFile().getAttribute("Run as Foreign Command");
        if (checkBox == null || checkBox.equals(new Boolean("false"))) {
            obj.getPrimaryFile().setAttribute("REMOTE_ARGUMENT", (Object)"");
            this.format = this.createMapFormat(obj, nfs);
            return super.execute(obj);
        }
        return this.foreignCommandexecute(obj);
    }

    public RemoteProcessDescriptor getRemoteExecutor(DataObject obj) {
        return this.getExternalExecutor(obj);
    }

    public synchronized RemoteProcessDescriptor getExternalExecutor(DataObject obj) {
        FileObject fobj = obj.getPrimaryFile();
        String[] cmds = new String[2];
        String vmsPath = fobj.getNameExt();
        try {
            File file = FileUtil.toFile((FileObject)fobj);
            if (Utilities.isWindows()) {
                cmds[0] = FileUtilityLang._winPathToOpenVMSPath(file.getAbsolutePath(), false, fobj);
            } else if (Utilities.isUnix() || Utilities.getOperatingSystem() == 16384) {
                cmds[0] = FileUtilityLang.unixPathToOpenVMSPath(file.getAbsolutePath(), false, fobj);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        Boolean bForeignCommand = (Boolean)obj.getPrimaryFile().getAttribute("Prompt for Runtime Arguments");
        Boolean bForeignCommandNotPrompt = (Boolean)obj.getPrimaryFile().getAttribute("Run as Foreign Command");
        cmds[0] = "fcommand := $ " + cmds[0];
        if (bForeignCommand == null) {
            bForeignCommand = new Boolean("false");
        }
        if (bForeignCommandNotPrompt == null) {
            bForeignCommandNotPrompt = new Boolean("false");
        }
        cmds[1] = bForeignCommand.equals(new Boolean("true")) ? "fcommand  " + RemoteEXEExecution.sFCommandArguments : "fcommand  " + (String)obj.getPrimaryFile().getAttribute("REMOTE_ARGUMENT");
        if (this.remoteExecutor == null) {
            this.remoteExecutor = new RemoteProcessDescriptor("", "", cmds);
        }
        return this.remoteExecutor;
    }

    public ExecutorTask foreignCommandexecute(DataObject obj) throws IOException {
        Boolean useXterm;
        NbProcessDescriptor npd;
        String cmd;
        AbstractNetworkFileSystem nfs = null;
        RemoteRuntimeType rrt = null;
        try {
            nfs = (AbstractNetworkFileSystem)obj.getPrimaryFile().getFileSystem();
        }
        catch (FileStateInvalidException exp) {
            // empty catch block
        }
        rrt = nfs.getRemoteRuntimeType();
        if (nfs == null || !(nfs instanceof AbstractNetworkFileSystem)) {
            IOException ioe = new IOException("The file " + obj.getNodeDelegate().getDisplayName() + " is not a remote file");
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)bundle.getString("EXC_no_remote_execution"), 2));
            ErrorManager.getDefault().annotate((Throwable)ioe, 1, null, null, null, null);
            throw ioe;
        }
        if (rrt == null) {
            IOException ioe = new IOException("");
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)"No matching remote server is found.\n Please go to Services Tab and add remote server", 2));
            ErrorManager.getDefault().annotate((Throwable)ioe, 1, null, null, null, null);
            throw ioe;
        }
        if (rrt.getRemoteRuntime() == null) {
            IOException ioe = new IOException("");
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)("Remote server \"" + rrt.getHostName() + "\" " + " is disconnected.\nPlease go to Services Tab and make connection using \"" + rrt.getUserName() + "\""), 1));
            ErrorManager.getDefault().annotate((Throwable)ioe, 1, null, null, null, null);
            throw ioe;
        }
        File file = FileUtil.toFile((FileObject)obj.getPrimaryFile().getParent());
        String cwd = null;
        if (this.getChangeWorkingDir()) {
            cwd = this.getWorkingDirectory(file, obj);
        }
        boolean useX = false;
        Boolean bobj = null;
        int displayNumber = 0;
        bobj = this.isRemoteJavaCompile() ? (Boolean)obj.getPrimaryFile().getAttribute("useXtermExecution") : (Boolean)obj.getPrimaryFile().getAttribute("useXtermExecution");
        useX = bobj != null ? bobj : (this.isRemoteJavaCompile() ? nfs.getUseXtermCompile() : nfs.getUseXtermExecution());
        if (useX) {
            Integer iobj = (Integer)obj.getPrimaryFile().getAttribute("xDisplayDeviceNumber");
            displayNumber = iobj != null ? iobj.intValue() : nfs.getXDisplayDeviceNumber();
        }
        if (useX && Utilities.isWindows() && (cmd = DistributedSettings.getDefault().getXServer()) != null && cmd.length() > 0) {
            try {
                Runtime.getRuntime().exec(cmd);
            }
            catch (IOException e) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)"Problem launching X Window sever on your desktop.", 2));
                ErrorManager.getDefault().annotate((Throwable)e, 1, null, null, null, null);
                throw e;
            }
        }
        RemoteProcessDescriptor rpd = obj.getPrimaryFile().getMIMEType().endsWith("ant+xml") ? ((npd = (NbProcessDescriptor)obj.getPrimaryFile().getAttribute("externalCompiler")) != null ? new RemoteProcessDescriptor(npd.getProcessName(), npd.getArguments(), "") : this.getRemoteExecutor(obj)) : this.getRemoteExecutor(obj);
        Project project = FileOwnerQuery.getOwner((FileObject)obj.getPrimaryFile());
        String projName = "";
        if (project != null) {
            projName = ProjectUtils.getInformation((Project)project).getDisplayName();
        }
        if ((useXterm = (Boolean)obj.getPrimaryFile().getAttribute("useXtermExecution")) == null) {
            useXterm = new Boolean("false");
        }
        TargetExecutor texec = new TargetExecutor(rrt, this.remoteExecutor, this.getErrorExpression(), useXterm, null, null, obj, 0);
        return texec.execute(projName + " (" + obj.getPrimaryFile().getNameExt() + ")");
    }
}

