/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.exesupport;

import java.io.IOException;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.DebuggerInfo;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.distributed.ideserverclient.settings.DistributedSettings;
import org.openide.LifecycleManager;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.CookieAction;

public final class RemoteDebugExecution
extends CookieAction {
    protected void performAction(Node[] activatedNodes) {
        final Node[] anodes = activatedNodes;
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                RemoteDebugExecution.doDebugAction(anodes);
            }
        });
    }

    public static void doDebugAction(final Node[] activatedNodes) {
        if (DistributedSettings.getDefault().getSaveAll()) {
            LifecycleManager.getDefault().saveAll();
        }
        Runnable loadProgram = new Runnable(){

            public void run() {
                DataObject dobj = (DataObject)activatedNodes[0].getCookie(DataObject.class);
                try {
                    FileSystem fs = dobj.getPrimaryFile().getFileSystem();
                    DebuggerManager.getDebuggerManager().startDebugging(DebuggerInfo.create((String)"RemoteDebugSessionProvider", (Object[])new Object[]{dobj}));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        SwingUtilities.invokeLater(loadProgram);
    }

    protected int mode() {
        return 7;
    }

    public String getName() {
        return "Remote Debug";
    }

    protected Class[] cookieClasses() {
        return new Class[]{DataObject.class};
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    public static boolean isEnable(Node[] node) {
        return true;
    }

    protected boolean enable(Node[] node) {
        return RemoteDebugExecution.isEnable(node);
    }
}

