/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.exesupport;

import com.hp.openvms.netbeans.exesupport.ExeDataObject;
import com.hp.openvms.netbeans.utils.FileUtilityLang;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.netbeans.modules.distributed.remotefs.ftpfs.FTPFileSystem;
import org.netbeans.modules.distributed.remotefs.ftpfs.RemoteFileSystem;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Utilities;

public class ExeDataNode
extends DataNode {
    private static final String IMAGE_ICON_BASE = "com/hp/openvms/netbeans/exesupport/resources/ExeIcon";

    public ExeDataNode(ExeDataObject obj) {
        super((DataObject)obj, Children.LEAF);
        this.setIconBase(IMAGE_ICON_BASE);
    }

    protected Sheet createSheet() {
        Sheet s = super.createSheet();
        Sheet.Set ss = s.get("properties");
        this.addRemoteProperties(ss);
        return s;
    }

    public void addRemoteProperties(Sheet.Set set) {
        set.put((Node.Property)this.createRemoteFilePathProperty());
        try {
            if (this.getDataObject().getPrimaryFile().getFileSystem() instanceof FTPFileSystem) {
                set.put((Node.Property)this.createFileResidenceProperty());
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
    }

    private PropertySupport createFileResidenceProperty() {
        class FileResidenceProperty
        extends PropertySupport.ReadOnly {
            public FileResidenceProperty() {
                super("File Residence", String.class, "File Residence", "Determine if the file should reside in local disk, server or both");
            }

            public Object getValue() {
                FileObject fobj = ExeDataNode.this.getDataObject().getPrimaryFile();
                Object obj = fobj.getAttribute("file_residence_mode");
                try {
                    RemoteFileSystem rf = (RemoteFileSystem)fobj.getFileSystem();
                    if (rf.getServerOnlyFileExts().isRegistered(fobj.getExt())) {
                        return "Server Only";
                    }
                }
                catch (FileStateInvalidException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
                if (obj != null) {
                    Integer itr = (Integer)obj;
                    String ret = "Make Client and Server";
                    switch (itr) {
                        case 1: {
                            ret = "Client Only";
                            break;
                        }
                        case 0: {
                            ret = "Server Only";
                            break;
                        }
                        case 2: {
                            ret = "Client and Server";
                        }
                    }
                    return ret;
                }
                return "Client and Server";
            }

            public boolean supportsDefaultValue() {
                return false;
            }
        }
        return new FileResidenceProperty();
    }

    private PropertySupport createRemoteFilePathProperty() {
        class RemoteFilePathPropertySupport
        extends PropertySupport.ReadOnly {
            public RemoteFilePathPropertySupport() {
                super("Remote File Path", String.class, "Remote File Path", "Remote File Path");
            }

            public Object getValue() {
                FileObject fobj = ExeDataNode.this.getDataObject().getPrimaryFile();
                Object obj = fobj.getAttribute("REMOTE_FILEPATH");
                if (obj != null) {
                    return obj;
                }
                String vmsPath = fobj.getNameExt();
                try {
                    File file = FileUtil.toFile((FileObject)fobj);
                    if (Utilities.isWindows()) {
                        vmsPath = FileUtilityLang._winPathToOpenVMSPath(file.getAbsolutePath(), false, fobj);
                    } else if (Utilities.isUnix() || Utilities.getOperatingSystem() == 16384) {
                        vmsPath = FileUtilityLang.unixPathToOpenVMSPath(file.getAbsolutePath(), false, fobj);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                return vmsPath;
            }

            public void setValue(Object val) throws InvocationTargetException {
                try {
                    FileObject fobj = ExeDataNode.this.getDataObject().getPrimaryFile();
                    fobj.setAttribute("REMOTE_FILEPATH", val);
                }
                catch (IOException ex) {
                    throw new InvocationTargetException(ex);
                }
            }

            public boolean supportsDefaultValue() {
                return true;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                FileObject fobj = ExeDataNode.this.getDataObject().getPrimaryFile();
                String vmsPath = fobj.getNameExt();
                try {
                    File file = FileUtil.toFile((FileObject)fobj);
                    if (Utilities.isWindows()) {
                        vmsPath = FileUtilityLang._winPathToOpenVMSPath(file.getAbsolutePath(), false, fobj);
                    } else if (Utilities.isUnix() || Utilities.getOperatingSystem() == 16384) {
                        vmsPath = FileUtilityLang.unixPathToOpenVMSPath(file.getAbsolutePath(), false, fobj);
                    }
                    this.setValue(vmsPath);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return new RemoteFilePathPropertySupport();
    }
}

