/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.debugsupport.debugger;

import com.hp.openvms.netbeans.debugsupport.RemoteDebuggerEngineProvider;
import com.hp.openvms.netbeans.debugsupport.breakpoints.RemoteBreakpoint;
import com.hp.openvms.netbeans.debugsupport.debugger.CallStackFrame;
import com.hp.openvms.netbeans.debugsupport.debugger.CallStackFrameImpl;
import com.hp.openvms.netbeans.debugsupport.debugger.Variable;
import com.hp.openvms.netbeans.debugsupport.event.RemoteBreakpointEvent;
import com.hp.openvms.netbeans.debugsupport.model.LocalsTreeModel;
import com.hp.openvms.netbeans.exesupport.RemoteWatchListCookie;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.Watch;
import org.netbeans.modules.distributed.common.util.FileUtility;
import org.netbeans.modules.distributed.common.util.Utils;
import org.netbeans.modules.distributed.ideserverclient.RemoteRuntimeType;
import org.netbeans.modules.distributed.remotefs.AbstractNetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.RemoteFSUtils;
import org.netbeans.modules.distributed.rmi.protocol.RemoteData;
import org.netbeans.modules.distributed.rmi.protocol.RemoteDebuggerInterruptAPI;
import org.netbeans.modules.distributed.rmi.protocol.RemoteErrorStream;
import org.netbeans.modules.distributed.rmi.protocol.RemoteInputStream;
import org.netbeans.modules.distributed.rmi.protocol.RemoteProcess;
import org.netbeans.modules.distributed.rmi.protocol.debug.DebugInfo;
import org.netbeans.modules.distributed.rmi.protocol.debug.LookupLinePacket;
import org.netbeans.modules.distributed.rmi.protocol.debug.MonitorPacket;
import org.netbeans.modules.distributed.rmi.protocol.debug.SourceDisplayInfo;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.DebuggerEngineProvider;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TreeModel;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Utilities;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.WindowManager;

public class RemoteDebugger
implements PropertyChangeListener {
    public static final String ENGINE_ID = "RemoteDebugSession/C";
    public static final String SESSION_ID = "RemoteDebugSession";
    public static final String SESSION_PROVIDER_ID = "RemoteDebugSessionProvider";
    public static final String PROP_STATE = "state";
    public static final String PROP_CURRENT_THREAD = "currentThread";
    public static final String PROP_CURRENT_CALL_STACK_FRAME = "currentCallStackFrame";
    public static final String PROP_SUSPEND = "suspend";
    public static final String STATE_NONE = "state_none";
    public static final String STATE_STARTING = "state_starting";
    public static final String STATE_LOADING = "state_loading";
    public static final String STATE_RUNNING = "state_running";
    public static final String STATE_STOPPED = "state_stopped";
    public static final String STATE_EXITED = "state_exited";
    public static final String REMOTE_DEBUG_TAG = "Remote Debug Server";
    private String bindingFileSpec;
    private DataObject dobj;
    private boolean userSpecifiedBinding = true;
    private boolean rpcConnected = false;
    private boolean dbgConnected = false;
    private String state = "state_none";
    private PropertyChangeSupport pcs;
    private RemoteDebuggerEngineProvider remoteDebuggerEngineProvider;
    private ArrayList callstack = new ArrayList();
    private CallStackFrame currentCallStackFrame;
    public final Object LOCK = new Object();
    private ContextProvider lookupProvider;
    private RemoteDebuggerInterruptAPI interruptRemoteDebugAPI;
    private ArrayList breakpointCache = new ArrayList();
    private String vmsPath = null;
    public ModelListener watchesViewListener = null;
    public DebuggerManagerListener debuggerManagerListener = null;
    public ModelListener localsViewListener = null;
    private LocalsTreeModel currentLocalsModel = null;
    private List currentLocals = new ArrayList();
    private DebugInfo currentDebugInfo = null;
    public static String remoteArguments;
    private Boolean boutputSwitch;
    private Boolean bRunAsForeignCommand;
    private Boolean bPromptForArguments;
    private LocalsTreeModel localsTreeModel;
    private static final String WAIT_DISPLAY = "Waiting for response from OpenVMS debug server...";
    private static final String DEFAULT_DISPLAY = "";
    private static StatusDisplayer statusDisplay;
    private int i = 0;

    private LocalsTreeModel getLocalsTreeModel() {
        if (this.localsTreeModel == null) {
            this.localsTreeModel = (LocalsTreeModel)this.lookupProvider.lookupFirst("LocalsView", TreeModel.class);
        }
        return this.localsTreeModel;
    }

    public RemoteDebugger(ContextProvider lookupProvider) {
        this.lookupProvider = lookupProvider;
        this.pcs = new PropertyChangeSupport(this);
        this.addPropertyChangeListener(this);
        this.dobj = (DataObject)lookupProvider.lookupFirst(null, DataObject.class);
        List l = lookupProvider.lookup(null, DebuggerEngineProvider.class);
        int k = l.size();
        for (int i = 0; i < k; ++i) {
            if (!(l.get(i) instanceof RemoteDebuggerEngineProvider)) continue;
            this.remoteDebuggerEngineProvider = (RemoteDebuggerEngineProvider)((Object)l.get(i));
        }
        if (this.remoteDebuggerEngineProvider == null) {
            throw new IllegalArgumentException("RemoteDebuggerEngineProvider has to be used to start RemoteDebugger!");
        }
        if (statusDisplay == null) {
            statusDisplay = StatusDisplayer.getDefault();
        }
    }

    public void setStarting() {
        this.setState(STATE_STARTING);
    }

    public void setLoading() {
        this.setState(STATE_LOADING);
    }

    public Variable getVariable(Object value) {
        return null;
    }

    public void fireRemoteBreakpointEvent(RemoteBreakpoint breakpoint, RemoteBreakpointEvent event) {
        breakpoint.fireRemoteBreakpointChange(event);
    }

    public ArrayList getCallStack() {
        return this.callstack;
    }

    public synchronized CallStackFrame getCurrentCallStackFrame() {
        if (this.callstack.size() > 0) {
            if (this.currentCallStackFrame == null) {
                this.currentCallStackFrame = (CallStackFrame)this.callstack.get(0);
            }
        } else {
            this.currentCallStackFrame = null;
        }
        return this.currentCallStackFrame;
    }

    public void setCurrentCallStackFrame(CallStackFrame callStackFrame) {
        CallStackFrame old = this.setCurrentCallStackFrameNoFire(callStackFrame);
        if (old == callStackFrame) {
            return;
        }
        this.pcs.firePropertyChange(PROP_CURRENT_CALL_STACK_FRAME, old, callStackFrame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CallStackFrame setCurrentCallStackFrameNoFire(CallStackFrame callStackFrame) {
        CallStackFrame old;
        RemoteDebugger remoteDebugger = this;
        synchronized (remoteDebugger) {
            if (callStackFrame == this.currentCallStackFrame) {
                return callStackFrame;
            }
            old = this.currentCallStackFrame;
            this.currentCallStackFrame = callStackFrame;
        }
        return old;
    }

    private int getXScreenNumber() {
        try {
            AbstractNetworkFileSystem nfs = (AbstractNetworkFileSystem)this.dobj.getPrimaryFile().getFileSystem();
            if (nfs != null) {
                return nfs.getXDisplayDeviceNumber();
            }
        }
        catch (Exception exp) {
            ErrorManager.getDefault().notify((Throwable)exp);
        }
        return 0;
    }

    private boolean getUseXterm() {
        try {
            Boolean bobj = (Boolean)this.dobj.getPrimaryFile().getAttribute("useXtermExecution");
            if (bobj != null) {
                return bobj;
            }
            AbstractNetworkFileSystem nfs = (AbstractNetworkFileSystem)this.dobj.getPrimaryFile().getFileSystem();
            if (nfs != null) {
                return nfs.getUseXtermExecution();
            }
        }
        catch (Exception exp) {
            ErrorManager.getDefault().notify((Throwable)exp);
        }
        return false;
    }

    public RemoteRuntimeType getRemoteRuntimeTypefromVMSDebugger() {
        block5: {
            try {
                AbstractNetworkFileSystem nfs = (AbstractNetworkFileSystem)this.dobj.getPrimaryFile().getFileSystem();
                if (nfs == null) break block5;
                final RemoteRuntimeType rrt = nfs.getRemoteRuntimeType();
                if (rrt == null) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)"Remote server  does not exist.\nPlease go to the Services Tab and create a connection", 2));
                    break block5;
                }
                if (!rrt.isConnected()) {
                    ++this.i;
                    if (this.i % 2 == 0) {
                        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

                            public void run() {
                                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)("Remote server \"" + rrt.getHostName() + "\" " + " is disconnected.\nPlease go to Services Tab and make connection using \"" + rrt.getUserName() + "\""), 1));
                            }
                        });
                    }
                    return null;
                }
                return rrt;
            }
            catch (Exception exp) {
                ErrorManager.getDefault().notify((Throwable)exp);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getLocalVariables() {
        List list = this.currentLocals;
        synchronized (list) {
            return this.currentLocals;
        }
    }

    private void stackUpdate(DebugInfo debugInfo) {
        SourceDisplayInfo sdi = debugInfo.getCurrentLine();
        if (sdi == null) {
            this.callstack.clear();
        } else {
            String vmsName = sdi.getFileName();
            String unixName = FileUtility.openVMSPathToUnixPath(vmsName, false);
            FileObject[] fo = RemoteFSUtils.fromFile(unixName);
            File file = FileUtil.toFile((FileObject)fo[0]);
            CallStackFrameImpl frame = new CallStackFrameImpl(this, DEFAULT_DISPLAY, file.getName(), file.getAbsolutePath(), Integer.toString(sdi.getLineNumber()), DEFAULT_DISPLAY);
            this.callstack.clear();
            this.callstack.add(frame);
            this.setCurrentCallStackFrameNoFire(frame);
        }
    }

    public static void showWatchesView(final DataObject dobj) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                RemoteDebugger.showWatchesView(new Node[]{dobj.getNodeDelegate()});
            }
        });
    }

    public static void showWatchesView(Node[] nodes) {
        try {
            FileObject fo = Repository.getDefault().getDefaultFileSystem().findResource("Actions/Window/Debug/com-hp-openvms-netbeans-debugsupport-action-RemoteWatchView.instance");
            DataObject obj = DataObject.find((FileObject)fo);
            InstanceCookie ic = (InstanceCookie)obj.getCookie(InstanceCookie.class);
            ActionEvent action = new ActionEvent(nodes, 0, "ADD_REMOTE_WATCH");
            ((Action)ic.instanceCreate()).actionPerformed(action);
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    private void registerEditorAnnotatorListener() {
        Watch watch = DebuggerManager.getDebuggerManager().createWatch(this.toString());
        watch.remove();
    }

    public static void dialogBox(String exeFileName) {
        remoteArguments = JOptionPane.showInputDialog(null, "Arguments for " + exeFileName, "Enter the arguments ", 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startDebugger() throws Exception {
        FileObject fobj = this.dobj.getPrimaryFile();
        Object obj = this.dobj.getPrimaryFile().getAttribute("Run as Foreign Command");
        this.bRunAsForeignCommand = (Boolean)this.dobj.getPrimaryFile().getAttribute("Run as Foreign Command");
        this.bPromptForArguments = (Boolean)this.dobj.getPrimaryFile().getAttribute("Prompt for Runtime Arguments");
        String exeFileName = fobj.getNameExt();
        if (this.bRunAsForeignCommand == null) {
            this.bRunAsForeignCommand = new Boolean("false");
        }
        if (this.bPromptForArguments == null) {
            this.bPromptForArguments = new Boolean("false");
        }
        if (this.bRunAsForeignCommand.equals(new Boolean("true")) && this.bPromptForArguments.equals(new Boolean("true"))) {
            RemoteDebugger.dialogBox(exeFileName);
        } else if (this.bRunAsForeignCommand.equals(new Boolean("true")) && !this.bPromptForArguments.equals(new Boolean("true"))) {
            remoteArguments = (String)this.dobj.getPrimaryFile().getAttribute("REMOTE_ARGUMENT");
        }
        RemoteDebugger remoteDebugger = this;
        synchronized (remoteDebugger) {
            this.setStarting();
            if (!this.startDebugServer()) {
                this.finish();
                return;
            }
            this.registerEditorAnnotatorListener();
            RemoteDebugger.showWatchesView(this.dobj);
            DebugInfo debugInfo = this.run(this.localsViewListener != null);
            if (debugInfo.getCurrentLine() != null) {
                this.stackUpdate(debugInfo);
            }
            this.currentDebugInfo = debugInfo;
            this.localVarUpdate(debugInfo);
            this.setWatches();
            this.setLoading();
            this.setStopped();
        }
    }

    private void resetStack() {
        this.callstack.clear();
    }

    private void printDebugMsg(DebugInfo debugInfo) {
        InputOutput ioput = IOProvider.getDefault().getIO(REMOTE_DEBUG_TAG, false);
        if (debugInfo.getErrorMsg() != null) {
            ioput.getOut().println((Object)debugInfo.getErrorMsg());
        }
        if (debugInfo.getMsg() != null) {
            ioput.getOut().println(debugInfo.getMsg());
        }
    }

    private DebugInfo go(boolean includeTrace, boolean updateLocalVars) {
        RemoteRuntimeType curRrt = this.getRemoteRuntimeTypefromVMSDebugger();
        try {
            this.setStatus(WAIT_DISPLAY);
            DebugInfo debugInfo = curRrt.getRemoteRuntime().getRemoteDebuggerAPI().go(includeTrace, updateLocalVars);
            this.setStatus(DEFAULT_DISPLAY);
            this.printDebugMsg(debugInfo);
            return debugInfo;
        }
        catch (RemoteException e) {
            ErrorManager.getDefault().notify((Throwable)e);
            this.setStatus(DEFAULT_DISPLAY);
            return null;
        }
    }

    public void interrupt() {
        try {
            this.interruptRemoteDebugAPI.abort();
        }
        catch (RemoteException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    private void stopRemoteDebugServer() {
        RemoteRuntimeType curRrt = this.getRemoteRuntimeTypefromVMSDebugger();
        if (curRrt == null || curRrt.getRemoteRuntime() == null) {
            return;
        }
        try {
            curRrt.getRemoteRuntime().getRemoteDebuggerAPI().stopServer();
            this.setStatus(DEFAULT_DISPLAY);
        }
        catch (RemoteException e) {
            ErrorManager.getDefault().notify((Throwable)e);
            this.setStatus(DEFAULT_DISPLAY);
        }
    }

    public void finish() {
        DebuggerManager.getDebuggerManager().removeDebuggerListener("watches", this.debuggerManagerListener);
        this.stopRemoteDebugServer();
        this.resetStack();
        this.setState(STATE_NONE);
        this.remoteDebuggerEngineProvider.getDestructor().killEngine();
        ((Session)this.lookupProvider.lookupFirst(null, Session.class)).kill();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        RemoteDebugger remoteDebugger = this;
        synchronized (remoteDebugger) {
            this.setState(STATE_RUNNING);
            DebugInfo debugInfo = this.go(false, this.localsViewListener != null);
            if (debugInfo == null) {
                return;
            }
            if (debugInfo.getCurrentLine() == null) {
                this.finish();
            } else {
                this.stackUpdate(debugInfo);
                this.watchUpdate(debugInfo);
                if (debugInfo.getCurrentScope() != null) {
                    this.currentDebugInfo = debugInfo;
                }
                this.localVarUpdate(debugInfo);
                this.setStopped();
            }
        }
    }

    private void localVarUpdate(DebugInfo info) {
        if (this.localsViewListener != null && info.getLocalVars() != null) {
            this.currentLocals = info.getLocalVars();
            this.updateLocalsModel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void localVarUpdate() {
        RemoteDebugger remoteDebugger = this;
        synchronized (remoteDebugger) {
            if (this.currentDebugInfo != null) {
                try {
                    RemoteRuntimeType curRrt = this.getRemoteRuntimeTypefromVMSDebugger();
                    this.setStatus(WAIT_DISPLAY);
                    DebugInfo debugInfo = curRrt.getRemoteRuntime().getRemoteDebuggerAPI().getLocalVars(this.currentDebugInfo);
                    this.setStatus(DEFAULT_DISPLAY);
                    this.currentLocals = debugInfo.getLocalVars();
                    this.updateLocalsModel();
                }
                catch (RemoteException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                    this.setStatus(DEFAULT_DISPLAY);
                }
            }
        }
    }

    private void watchUpdate(DebugInfo debugInfo) {
        List monitors = debugInfo.getMonitors();
        RemoteWatchListCookie rwl = (RemoteWatchListCookie)this.dobj.getCookie(RemoteWatchListCookie.class);
        Map myWatchListMap = rwl.getExprWatchMap();
        if (monitors != null) {
            for (MonitorPacket mPacket : monitors) {
                if (!myWatchListMap.containsKey(mPacket.getOs_expression())) continue;
                myWatchListMap.put(mPacket.getOs_expression(), mPacket.getOs_value());
            }
            this.updateWatchesModel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stepOver() {
        RemoteDebugger remoteDebugger = this;
        synchronized (remoteDebugger) {
            this.setState(STATE_RUNNING);
            RemoteRuntimeType curRrt = this.getRemoteRuntimeTypefromVMSDebugger();
            try {
                this.setStatus(WAIT_DISPLAY);
                DebugInfo debugInfo = curRrt.getRemoteRuntime().getRemoteDebuggerAPI().stepOver(false, this.localsViewListener != null);
                this.setStatus(DEFAULT_DISPLAY);
                this.printDebugMsg(debugInfo);
                this.stackUpdate(debugInfo);
                this.watchUpdate(debugInfo);
                this.localVarUpdate(debugInfo);
                if (debugInfo.getCurrentScope() != null) {
                    this.currentDebugInfo = debugInfo;
                }
                this.setStopped();
            }
            catch (RemoteException e) {
                ErrorManager.getDefault().notify((Throwable)e);
                this.setStatus(DEFAULT_DISPLAY);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stepInto() {
        RemoteDebugger remoteDebugger = this;
        synchronized (remoteDebugger) {
            this.setState(STATE_RUNNING);
            RemoteRuntimeType curRrt = this.getRemoteRuntimeTypefromVMSDebugger();
            try {
                this.setStatus(WAIT_DISPLAY);
                DebugInfo debugInfo = curRrt.getRemoteRuntime().getRemoteDebuggerAPI().stepInto(false, this.localsViewListener != null);
                this.setStatus(DEFAULT_DISPLAY);
                this.printDebugMsg(debugInfo);
                this.stackUpdate(debugInfo);
                this.watchUpdate(debugInfo);
                this.localVarUpdate(debugInfo);
                if (debugInfo.getCurrentScope() != null) {
                    this.currentDebugInfo = debugInfo;
                }
                this.setStopped();
            }
            catch (RemoteException e) {
                ErrorManager.getDefault().notify((Throwable)e);
                this.setStatus(DEFAULT_DISPLAY);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stepOut() {
        RemoteDebugger remoteDebugger = this;
        synchronized (remoteDebugger) {
            this.setState(STATE_RUNNING);
            RemoteRuntimeType curRrt = this.getRemoteRuntimeTypefromVMSDebugger();
            try {
                this.setStatus(WAIT_DISPLAY);
                DebugInfo debugInfo = curRrt.getRemoteRuntime().getRemoteDebuggerAPI().stepOut(false, this.localsViewListener != null);
                this.setStatus(DEFAULT_DISPLAY);
                this.printDebugMsg(debugInfo);
                this.stackUpdate(debugInfo);
                this.watchUpdate(debugInfo);
                this.localVarUpdate(debugInfo);
                if (debugInfo.getCurrentScope() != null) {
                    this.currentDebugInfo = debugInfo;
                }
                this.setStopped();
            }
            catch (RemoteException e) {
                ErrorManager.getDefault().notify((Throwable)e);
                this.setStatus(DEFAULT_DISPLAY);
            }
        }
    }

    public void breakpointInsertCache(SourceDisplayInfo info) {
        this.breakpointCache.add(info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DebugInfo[] breakpointInsertFlushCache() {
        DebugInfo[] sdis = new DebugInfo[]{};
        RemoteDebugger remoteDebugger = this;
        synchronized (remoteDebugger) {
            try {
                if (this.breakpointCache.size() > 0) {
                    RemoteRuntimeType curRrt = this.getRemoteRuntimeTypefromVMSDebugger();
                    this.setStatus(WAIT_DISPLAY);
                    sdis = curRrt.getRemoteRuntime().getRemoteDebuggerAPI().setBreakpoint(this.breakpointCache.toArray(new SourceDisplayInfo[0]));
                    this.setStatus(DEFAULT_DISPLAY);
                    this.breakpointCache.clear();
                }
            }
            catch (RemoteException e) {
                ErrorManager.getDefault().notify((Throwable)e);
                this.setStatus(DEFAULT_DISPLAY);
            }
        }
        return sdis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DebugInfo breakpointInsert(SourceDisplayInfo info) {
        DebugInfo ret = null;
        RemoteDebugger remoteDebugger = this;
        synchronized (remoteDebugger) {
            try {
                DebugInfo[] sdis = null;
                RemoteRuntimeType curRrt = this.getRemoteRuntimeTypefromVMSDebugger();
                this.setStatus(WAIT_DISPLAY);
                sdis = curRrt.getRemoteRuntime().getRemoteDebuggerAPI().setBreakpoint(new SourceDisplayInfo[]{info});
                this.setStatus(DEFAULT_DISPLAY);
                ret = sdis[0];
            }
            catch (RemoteException e) {
                ErrorManager.getDefault().notify((Throwable)e);
                this.setStatus(DEFAULT_DISPLAY);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void breakpointRemove(LookupLinePacket info) {
        RemoteDebugger remoteDebugger = this;
        synchronized (remoteDebugger) {
            try {
                RemoteRuntimeType curRrt = this.getRemoteRuntimeTypefromVMSDebugger();
                this.setStatus(WAIT_DISPLAY);
                curRrt.getRemoteRuntime().getRemoteDebuggerAPI().removeBreakpoint(info);
                this.setStatus(DEFAULT_DISPLAY);
            }
            catch (RemoteException e) {
                ErrorManager.getDefault().notify((Throwable)e);
                this.setStatus(DEFAULT_DISPLAY);
            }
        }
    }

    private DebugInfo run(boolean updateLocalVars) {
        RemoteRuntimeType curRrt = this.getRemoteRuntimeTypefromVMSDebugger();
        DebugInfo debugInfo = null;
        try {
            InputOutput ioput;
            this.setStatus(WAIT_DISPLAY);
            this.interruptRemoteDebugAPI = curRrt.getRemoteRuntime().getRemoteDebuggerAPI().getRemoteDebuggerInterruptAPI();
            debugInfo = this.bRunAsForeignCommand.equals(new Boolean("true")) & remoteArguments != null ? curRrt.getRemoteRuntime().getRemoteDebuggerAPI().run(this.vmsPath, remoteArguments, updateLocalVars) : curRrt.getRemoteRuntime().getRemoteDebuggerAPI().run(this.vmsPath, DEFAULT_DISPLAY, updateLocalVars);
            this.setStatus(DEFAULT_DISPLAY);
            if (debugInfo.getErrorMsg() != null) {
                ioput = IOProvider.getDefault().getIO(REMOTE_DEBUG_TAG, false);
                ioput.getOut().println((Object)debugInfo.getErrorMsg());
            }
            if (debugInfo.getMsg() != null) {
                ioput = IOProvider.getDefault().getIO(REMOTE_DEBUG_TAG, false);
                ioput.getOut().println(debugInfo.getMsg());
            }
        }
        catch (RemoteException e) {
            ErrorManager.getDefault().notify((Throwable)e);
            this.setStatus(DEFAULT_DISPLAY);
        }
        return debugInfo;
    }

    public static String getCurrentDirectory(DataObject dobj) {
        File file = FileUtil.toFile((FileObject)dobj.getPrimaryFile().getParent());
        String curDir = null;
        if (Utilities.isWindows()) {
            curDir = RemoteFSUtils._winPathToOpenVMSPath(file.getAbsolutePath(), file.isDirectory(), dobj.getPrimaryFile());
        } else if (Utilities.isUnix() || Utilities.getOperatingSystem() == 16384) {
            curDir = RemoteFSUtils.unixPathToOpenVMSPath(file.getAbsolutePath(), file.isDirectory(), dobj.getPrimaryFile());
        }
        return curDir;
    }

    private boolean startDebugServer() throws IOException {
        try {
            int MAX_REMOTE_BUF_SIZE = 64;
            RemoteRuntimeType curRrt = this.getRemoteRuntimeTypefromVMSDebugger();
            if (curRrt == null) {
                return false;
            }
            String clientIP = Utils.getIntendedHostAddress();
            int scrnNumber = this.getXScreenNumber();
            boolean useXterm = this.getUseXterm();
            String curDir = RemoteDebugger.getCurrentDirectory(this.dobj);
            this.vmsPath = curDir + this.dobj.getPrimaryFile().getNameExt();
            this.setStatus(WAIT_DISPLAY);
            final RemoteProcess serverProcess = curRrt.getRemoteRuntime().getRemoteDebuggerAPI().connect(clientIP, curDir, scrnNumber, useXterm);
            this.setStatus(DEFAULT_DISPLAY);
            final RemoteInputStream istream = serverProcess.getInputStream();
            final RemoteErrorStream estream = serverProcess.getErrorStream();
            final InputOutput ioput = IOProvider.getDefault().getIO(REMOTE_DEBUG_TAG, false);
            ioput.getOut().reset();
            ioput.select();
            ioput.setFocusTaken(true);
            ioput.setErrVisible(false);
            ioput.setErrSeparated(false);
            ioput.setInputVisible(true);
            if (serverProcess != null) {
                ioput.getOut().println("Debug server started...");
            } else {
                ioput.getOut().println("Debug Server failed to start...");
            }
            Thread inThread = new Thread(new Runnable(){

                public void run() {
                    try {
                        String inStr;
                        BufferedReader in = new BufferedReader(ioput.getIn());
                        while ((inStr = in.readLine()) != null) {
                            RemoteDebugger.this.doCommand(inStr);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace(System.err);
                    }
                }
            });
            inThread.start();
            Thread thr = new Thread(new Runnable(){

                public void run() {
                    try {
                        byte[] buf = new byte[64];
                        RemoteData remoteData = istream.read(buf, 0, 64);
                        while (remoteData.getReturn() > 0) {
                            ioput.getOut().print(new String(remoteData.getData(), 0, remoteData.getReturn()));
                            remoteData = istream.read(buf, 0, 64);
                        }
                        serverProcess.destroy();
                    }
                    catch (IOException e) {
                        e.printStackTrace(System.err);
                    }
                }
            });
            thr.start();
            Thread thr2 = new Thread(new Runnable(){

                public void run() {
                    try {
                        byte[] buf = new byte[64];
                        RemoteData remoteData = estream.read(buf, 0, 64);
                        while (remoteData.getReturn() > 0) {
                            ioput.getOut().print(new String(remoteData.getData(), 0, remoteData.getReturn()));
                            remoteData = estream.read(buf, 0, 64);
                        }
                        serverProcess.destroy();
                    }
                    catch (IOException e) {
                        e.printStackTrace(System.err);
                    }
                }
            });
            thr2.start();
            return true;
        }
        catch (Exception e) {
            this.setStatus(DEFAULT_DISPLAY);
            return false;
        }
    }

    public void break_disable(int breakpointNumber) {
    }

    private void updateWatchMapSingle(DebugInfo debugInfo, String newWatchExpr, List myWatchList, Map exprWatchMap) {
        String remoteWatchExpr = ((MonitorPacket)debugInfo.getMonitors().get(0)).getOs_expression();
        if (!remoteWatchExpr.equals(newWatchExpr)) {
            exprWatchMap.remove(newWatchExpr);
            myWatchList.remove(newWatchExpr);
            myWatchList.add(remoteWatchExpr);
        }
        exprWatchMap.put(remoteWatchExpr, ((MonitorPacket)debugInfo.getMonitors().get(0)).getOs_value());
    }

    private void updateWatchMapMultiple(DebugInfo debugInfo, List myWatchList, Map exprWatchMap, int index) {
        String remoteWatchExpr = ((MonitorPacket)debugInfo.getMonitors().get(0)).getOs_expression();
        if (!remoteWatchExpr.equals(myWatchList.get(index))) {
            exprWatchMap.remove(myWatchList.get(index));
            myWatchList.remove(index);
            myWatchList.add(index, remoteWatchExpr);
        }
        exprWatchMap.put(remoteWatchExpr, ((MonitorPacket)debugInfo.getMonitors().get(0)).getOs_value());
    }

    private void setWatches() {
        RemoteRuntimeType curRrt = this.getRemoteRuntimeTypefromVMSDebugger();
        try {
            RemoteWatchListCookie rwl = (RemoteWatchListCookie)this.dobj.getCookie(RemoteWatchListCookie.class);
            List myWatchList = rwl.getRemoteWatchList();
            Map exprWatchMap = rwl.getExprWatchMap();
            this.setStatus(WAIT_DISPLAY);
            DebugInfo[] debugInfoList = curRrt.getRemoteRuntime().getRemoteDebuggerAPI().setWatches(myWatchList.toArray(new String[0]));
            this.setStatus(DEFAULT_DISPLAY);
            for (int i = 0; i < debugInfoList.length; ++i) {
                this.printDebugMsg(debugInfoList[i]);
                if (debugInfoList[i].getMonitors() != null) {
                    this.updateWatchMapMultiple(debugInfoList[i], myWatchList, exprWatchMap, i);
                    continue;
                }
                String msg = debugInfoList[i].getMsg();
                if (msg == null) {
                    msg = "Watchpoint could not be set.";
                }
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg, 1));
            }
            this.updateWatchesModel();
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify((Throwable)e);
            this.setStatus(DEFAULT_DISPLAY);
        }
    }

    public void setWatch(String sWatch) {
        RemoteRuntimeType curRrt = this.getRemoteRuntimeTypefromVMSDebugger();
        try {
            RemoteWatchListCookie rwl = (RemoteWatchListCookie)this.dobj.getCookie(RemoteWatchListCookie.class);
            List myWatchList = rwl.getRemoteWatchList();
            Map exprWatchMap = rwl.getExprWatchMap();
            this.setStatus(WAIT_DISPLAY);
            DebugInfo[] debugInfoList = curRrt.getRemoteRuntime().getRemoteDebuggerAPI().setWatches(new String[]{sWatch});
            this.setStatus(DEFAULT_DISPLAY);
            this.printDebugMsg(debugInfoList[0]);
            if (debugInfoList[0].getMonitors() != null) {
                this.updateWatchMapSingle(debugInfoList[0], sWatch, myWatchList, exprWatchMap);
            } else {
                String msg = debugInfoList[0].getMsg();
                if (msg == null) {
                    msg = "Watchpoint could not be set.";
                }
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg, 1));
            }
            this.updateWatchesModel();
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify((Throwable)e);
            this.setStatus(DEFAULT_DISPLAY);
        }
    }

    public void cancelWatch(String sWatch) {
        RemoteRuntimeType curRrt = this.getRemoteRuntimeTypefromVMSDebugger();
        try {
            this.setStatus(WAIT_DISPLAY);
            DebugInfo debugInfo = curRrt.getRemoteRuntime().getRemoteDebuggerAPI().cancelWatch(sWatch);
            this.setStatus(DEFAULT_DISPLAY);
            this.printDebugMsg(debugInfo);
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify((Throwable)e);
            this.setStatus(DEFAULT_DISPLAY);
        }
    }

    private boolean isExitCommand(String command) {
        return command.toLowerCase().startsWith("exi") || command.toLowerCase().startsWith("quit");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doCommand(String command) {
        RemoteDebugger remoteDebugger = this;
        synchronized (remoteDebugger) {
            this.setState(STATE_RUNNING);
            RemoteRuntimeType curRrt = this.getRemoteRuntimeTypefromVMSDebugger();
            try {
                this.setStatus(WAIT_DISPLAY);
                DebugInfo debugInfo = curRrt.getRemoteRuntime().getRemoteDebuggerAPI().doCommand(command, this.localsViewListener != null);
                this.setStatus(DEFAULT_DISPLAY);
                this.printDebugMsg(debugInfo);
                this.stackUpdate(debugInfo);
                this.watchUpdate(debugInfo);
                this.localVarUpdate(debugInfo);
                if (debugInfo.getCurrentScope() != null) {
                    this.currentDebugInfo = debugInfo;
                }
                if (debugInfo.getCurrentLine() != null) {
                    this.setStopped();
                } else {
                    this.finish();
                }
            }
            catch (RemoteException e) {
                this.setStatus(DEFAULT_DISPLAY);
                if (this.isExitCommand(command)) {
                    this.finish();
                } else {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
                return false;
            }
            return true;
        }
    }

    public void updateWatchesModel() {
        RemoteWatchListCookie rwl = (RemoteWatchListCookie)this.dobj.getCookie(RemoteWatchListCookie.class);
        rwl.updateRemoteWatchModel(this);
    }

    public String getExpressionValue(String expression) {
        RemoteWatchListCookie rwl = (RemoteWatchListCookie)this.dobj.getCookie(RemoteWatchListCookie.class);
        Map myWatchListMap = rwl.getExprWatchMap();
        if (myWatchListMap.containsKey(expression)) {
            return (String)myWatchListMap.get(expression);
        }
        return DEFAULT_DISPLAY;
    }

    public void registerLocalsModel(LocalsTreeModel ltm) {
        this.currentLocalsModel = ltm;
    }

    public void registerLocalsListener(ModelListener ml) {
        this.localsViewListener = ml;
        if (this.localsViewListener != null) {
            this.localVarUpdate();
        }
        this.updateLocalsModel();
    }

    public void updateLocalsModel() {
        if (this.localsViewListener == null) {
            return;
        }
        this.localsViewListener.modelChanged((ModelEvent)new ModelEvent.TreeChanged((Object)this.currentLocalsModel));
    }

    public void setVariableValue(String name, String value) {
    }

    public String getVariableType(String expression) {
        RemoteWatchListCookie rwl = (RemoteWatchListCookie)this.dobj.getCookie(RemoteWatchListCookie.class);
        if (rwl == null) {
            return DEFAULT_DISPLAY;
        }
        Map myWatchListMap = rwl.getExprWatchMap();
        if (myWatchListMap.containsKey(expression)) {
            return "REMOTE";
        }
        return DEFAULT_DISPLAY;
    }

    public String getState() {
        return this.state;
    }

    public void setRunning() {
        this.setState(STATE_RUNNING);
    }

    public void setStopped() {
        this.setState(STATE_STOPPED);
    }

    private void setState(String state) {
        if (state == this.state) {
            return;
        }
        String oldState = this.state;
        this.state = state;
        this.firePropertyChange(PROP_STATE, oldState, state);
    }

    public void propertyChange(PropertyChangeEvent evt) {
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(propertyName, l);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(propertyName, l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    private void firePropertyChange(String name, Object o, Object n) {
        this.pcs.firePropertyChange(name, o, n);
    }

    private void setStatus(String aMessage) {
        try {
            statusDisplay.setStatusText(aMessage);
        }
        catch (Exception exp) {
            ErrorManager.getDefault().notify((Throwable)exp);
        }
    }

    class MyDebuggerManagerListener
    extends DebuggerManagerAdapter {
        List watches;

        public MyDebuggerManagerListener(DataObject dobj) {
            RemoteWatchListCookie remoteWatch = (RemoteWatchListCookie)dobj.getCookie(RemoteWatchListCookie.class);
            this.watches = remoteWatch.updateWatchList();
        }

        public void watchAdded(Watch watch) {
            if (!this.watches.contains(watch.getExpression())) {
                this.watches.add(watch);
                RemoteDebugger.this.setWatch(watch.getExpression());
            }
        }

        public void watchRemoved(Watch watch) {
            Watch[] nbWatches = DebuggerManager.getDebuggerManager().getWatches();
            for (int i = 0; nbWatches != null && i < nbWatches.length; ++i) {
                if (!watch.getExpression().equals(nbWatches[i].getExpression())) continue;
                return;
            }
            if (this.watches.contains(watch.getExpression())) {
                RemoteDebugger.this.cancelWatch(watch.getExpression());
            }
            this.watches.remove(watch.getExpression());
        }
    }
}

