/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.debugsupport.debugger;

import com.hp.openvms.netbeans.debugsupport.breakpoints.FunctionBreakpoint;
import com.hp.openvms.netbeans.debugsupport.breakpoints.LineBreakpoint;
import com.hp.openvms.netbeans.debugsupport.debugger.CallStackFrame;
import com.hp.openvms.netbeans.debugsupport.debugger.EditorContext;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.netbeans.api.debugger.DebuggerManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;

public class EditorContextBridge {
    public static final String FUNCTION = "function";
    public static final String LINE = "line";
    private static EditorContext context;

    public static EditorContext getContext() {
        if (context == null) {
            List l = DebuggerManager.getDebuggerManager().lookup(null, EditorContext.class);
            context = (EditorContext)l.get(0);
            int k = l.size();
            for (int i = 1; i < k; ++i) {
                context = new CompoundContextProvider((EditorContext)l.get(i), context);
            }
        }
        return context;
    }

    public static boolean showSource(String url, int lineNumber, Object timeStamp) {
        return EditorContextBridge.getContext().showSource(url, lineNumber, timeStamp);
    }

    public static boolean showSource(CallStackFrame csf) {
        String fullname = csf.getFullname();
        if (fullname != null) {
            String url;
            File file = new File(fullname);
            FileObject fo = FileUtil.toFileObject((File)file);
            try {
                InputStream is = fo.getInputStream();
                if (is == null) {
                    return false;
                }
                URL tmpurl = fo.getURL();
                url = fo.getURL().toExternalForm();
            }
            catch (FileStateInvalidException ex) {
                url = Utilities.isWindows() ? "file:/" + fo.getPath().replace(" ", "%20") : "file:/" + fo.getPath();
            }
            catch (IOException ex) {
                return false;
            }
            return EditorContextBridge.getContext().showSource(url, csf.getLineNumber(), null);
        }
        return false;
    }

    public static void createTimeStamp(Object timeStamp) {
        EditorContextBridge.getContext().createTimeStamp(timeStamp);
    }

    public static void disposeTimeStamp(Object timeStamp) {
        EditorContextBridge.getContext().disposeTimeStamp(timeStamp);
    }

    public static Object annotate(String url, int lineNumber, String annotationType, Object timeStamp) {
        return EditorContextBridge.getContext().annotate(url, lineNumber, annotationType, timeStamp);
    }

    public static Object annotate(CallStackFrame csf, String annotationType) {
        File file;
        String fullname = csf.getFullname();
        if (fullname != null && (file = new File(fullname)).exists()) {
            String url;
            FileObject fo = FileUtil.toFileObject((File)file);
            try {
                url = fo.getURL().toExternalForm();
            }
            catch (FileStateInvalidException ex) {
                url = Utilities.isWindows() ? "file:/" + fo.getPath().replace(" ", "%20") : "file:" + fo.getPath();
            }
            return EditorContextBridge.getContext().annotate(url, csf.getLineNumber(), annotationType, null);
        }
        return null;
    }

    public static void removeAnnotation(Object annotation) {
        EditorContextBridge.getContext().removeAnnotation(annotation);
    }

    public static int getLineNumber(Object annotation, Object timeStamp) {
        return EditorContextBridge.getContext().getLineNumber(annotation, timeStamp);
    }

    public static int getCurrentLineNumber() {
        return EditorContextBridge.getContext().getCurrentLineNumber();
    }

    public static int getMostRecentLineNumber() {
        return EditorContextBridge.getContext().getMostRecentLineNumber();
    }

    public static String getCurrentURL() {
        return EditorContextBridge.getContext().getCurrentURL();
    }

    public static String getMostRecentURL() {
        return EditorContextBridge.getContext().getMostRecentURL();
    }

    public static String getCurrentFunctionName() {
        return EditorContextBridge.getContext().getCurrentFunctionName();
    }

    public static String getSelectedFunctionName() {
        return EditorContextBridge.getContext().getSelectedFunctionName();
    }

    public static int getFieldLineNumber(String url, String className, String fieldName) {
        return EditorContextBridge.getContext().getFieldLineNumber(url, className, fieldName);
    }

    public String getCurrentMIMEType() {
        return EditorContextBridge.getContext().getCurrentMIMEType();
    }

    public static String getMostRecentMIMEType() {
        return EditorContextBridge.getContext().getMostRecentMIMEType();
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        EditorContextBridge.getContext().addPropertyChangeListener(l);
    }

    public static void removePropertyChangeListener(PropertyChangeListener l) {
        EditorContextBridge.getContext().removePropertyChangeListener(l);
    }

    public static String getFileName(LineBreakpoint b) {
        try {
            return EditorContextBridge.basename(new File(new URL(b.getURL()).getFile()).getName());
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private static String basename(String name) {
        int idx = name.lastIndexOf(47);
        if (idx > 0) {
            return name.substring(idx);
        }
        return name;
    }

    public static boolean showSource(LineBreakpoint b, Object timeStamp) {
        if (b.getLineNumber() < 1) {
            return EditorContextBridge.showSource(b.getURL(), 1, timeStamp);
        }
        return EditorContextBridge.showSource(b.getURL(), b.getLineNumber(), timeStamp);
    }

    public static String getDefaultType() {
        return LINE;
    }

    public static Object annotate(LineBreakpoint b) {
        boolean isConditional;
        String url = b.getURL();
        int lineNumber = b.getLineNumber();
        if (lineNumber < 1) {
            return null;
        }
        String condition = b.getCondition();
        boolean bl = isConditional = condition != null && !condition.trim().equals("");
        String annotationType = b.isEnabled() ? (isConditional ? EditorContext.CONDITIONAL_BREAKPOINT_ANNOTATION_TYPE : EditorContext.BREAKPOINT_ANNOTATION_TYPE) : (isConditional ? EditorContext.DISABLED_CONDITIONAL_BREAKPOINT_ANNOTATION_TYPE : EditorContext.DISABLED_BREAKPOINT_ANNOTATION_TYPE);
        return EditorContextBridge.annotate(url, lineNumber, annotationType, null);
    }

    public static Object annotate(FunctionBreakpoint b) {
        boolean isConditional;
        String url = b.getURL();
        int lineNumber = b.getLineNumber();
        if (lineNumber < 1) {
            return null;
        }
        String condition = b.getCondition();
        boolean bl = isConditional = condition != null && !condition.trim().equals("");
        String annotationType = b.isEnabled() ? (isConditional ? EditorContext.CONDITIONAL_BREAKPOINT_ANNOTATION_TYPE : EditorContext.BREAKPOINT_ANNOTATION_TYPE) : (isConditional ? EditorContext.DISABLED_CONDITIONAL_BREAKPOINT_ANNOTATION_TYPE : EditorContext.DISABLED_BREAKPOINT_ANNOTATION_TYPE);
        return EditorContextBridge.annotate(url, lineNumber, annotationType, null);
    }

    public static String getRelativePath(String className) {
        String sourceName = className.replace('.', '/') + ".java";
        return sourceName;
    }

    private static String convertSlash(String original) {
        return original.replace(File.separatorChar, '/');
    }

    private static class CompoundAnnotation {
        Object annotation1;
        Object annotation2;
    }

    private static class CompoundContextProvider
    extends EditorContext {
        private EditorContext cp1;
        private EditorContext cp2;

        CompoundContextProvider(EditorContext cp1, EditorContext cp2) {
            this.cp1 = cp1;
            this.cp2 = cp2;
        }

        public void createTimeStamp(Object timeStamp) {
            this.cp1.createTimeStamp(timeStamp);
            this.cp2.createTimeStamp(timeStamp);
        }

        public void disposeTimeStamp(Object timeStamp) {
            this.cp1.disposeTimeStamp(timeStamp);
            this.cp2.disposeTimeStamp(timeStamp);
        }

        public void updateTimeStamp(Object timeStamp, String url) {
            this.cp1.updateTimeStamp(timeStamp, url);
            this.cp2.updateTimeStamp(timeStamp, url);
        }

        public String getCurrentURL() {
            String s = this.cp1.getCurrentURL();
            if (s.trim().length() < 1) {
                return this.cp2.getCurrentURL();
            }
            return s;
        }

        public String getMostRecentURL() {
            String s = this.cp1.getMostRecentURL();
            if (s.trim().length() < 1) {
                return this.cp2.getMostRecentURL();
            }
            return s;
        }

        public int getCurrentLineNumber() {
            int i = this.cp1.getCurrentLineNumber();
            if (i < 1) {
                return this.cp2.getCurrentLineNumber();
            }
            return i;
        }

        public int getMostRecentLineNumber() {
            int i = this.cp1.getMostRecentLineNumber();
            if (i < 1) {
                return this.cp2.getMostRecentLineNumber();
            }
            return i;
        }

        public String getCurrentFunctionName() {
            String s = this.cp1.getCurrentFunctionName();
            if (s == null || s.trim().length() < 1) {
                return this.cp2.getCurrentFunctionName();
            }
            return s;
        }

        public String getSelectedFunctionName() {
            String s = this.cp1.getSelectedFunctionName();
            if (s == null || s.trim().length() < 1) {
                return this.cp2.getSelectedFunctionName();
            }
            return s;
        }

        public void removeAnnotation(Object annotation) {
            CompoundAnnotation ca = (CompoundAnnotation)annotation;
            this.cp1.removeAnnotation(ca.annotation1);
            this.cp2.removeAnnotation(ca.annotation2);
        }

        public Object annotate(String sourceName, int lineNumber, String annotationType, Object timeStamp) {
            CompoundAnnotation ca = new CompoundAnnotation();
            ca.annotation1 = this.cp1.annotate(sourceName, lineNumber, annotationType, timeStamp);
            ca.annotation2 = this.cp2.annotate(sourceName, lineNumber, annotationType, timeStamp);
            return ca;
        }

        public int getLineNumber(Object annotation, Object timeStamp) {
            CompoundAnnotation ca = new CompoundAnnotation();
            int ln = this.cp1.getLineNumber(ca.annotation1, timeStamp);
            if (ln >= 0) {
                return ln;
            }
            return this.cp2.getLineNumber(ca.annotation2, timeStamp);
        }

        public boolean showSource(String sourceName, int lineNumber, Object timeStamp) {
            return this.cp1.showSource(sourceName, lineNumber, timeStamp) | this.cp2.showSource(sourceName, lineNumber, timeStamp);
        }

        public int getFieldLineNumber(String url, String className, String fieldName) {
            int ln = this.cp1.getFieldLineNumber(url, className, fieldName);
            if (ln != -1) {
                return ln;
            }
            return this.cp2.getFieldLineNumber(url, className, fieldName);
        }

        public String getCurrentMIMEType() {
            String s = this.cp1.getCurrentMIMEType();
            if (s == null) {
                return this.cp2.getCurrentMIMEType();
            }
            return s;
        }

        public String getMostRecentMIMEType() {
            String s = this.cp1.getMostRecentMIMEType();
            if (s == null) {
                return this.cp2.getMostRecentMIMEType();
            }
            return s;
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
            this.cp1.addPropertyChangeListener(l);
            this.cp2.addPropertyChangeListener(l);
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
            this.cp1.removePropertyChangeListener(l);
            this.cp2.removePropertyChangeListener(l);
        }

        public void addPropertyChangeListener(String propertyName, PropertyChangeListener l) {
            this.cp1.addPropertyChangeListener(propertyName, l);
            this.cp2.addPropertyChangeListener(propertyName, l);
        }

        public void removePropertyChangeListener(String propertyName, PropertyChangeListener l) {
            this.cp1.removePropertyChangeListener(propertyName, l);
            this.cp2.removePropertyChangeListener(propertyName, l);
        }
    }
}

