/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.debugsupport.breakpoints;

import com.hp.openvms.netbeans.debugsupport.breakpoints.ActionsPanel;
import com.hp.openvms.netbeans.debugsupport.breakpoints.LineBreakpoint;
import com.hp.openvms.netbeans.debugsupport.debugger.EditorContextBridge;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.text.StyledDocument;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.spi.debugger.ui.Controller;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.NbDocument;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class LineBreakpointPanel
extends JPanel
implements Controller,
HelpCtx.Provider {
    private ActionsPanel actionsPanel;
    private LineBreakpoint breakpoint;
    private boolean createBreakpoint = false;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JPanel pActions;
    private JPanel pSettings;
    private JScrollPane spCondition;
    private JEditorPane tfCondition;
    private JTextField tfFileName;
    private JTextField tfLineNumber;

    public LineBreakpointPanel() {
        this(LineBreakpointPanel.createBreakpoint());
        this.createBreakpoint = true;
    }

    public LineBreakpointPanel(LineBreakpoint b) {
        String mime = null;
        String url = b.getURL();
        this.breakpoint = b;
        this.initComponents();
        try {
            FileObject fo = URLMapper.findFileObject((URL)new URL(url));
            if (fo != null) {
                mime = fo.getMIMEType();
            }
        }
        catch (MalformedURLException mue) {
            // empty catch block
        }
        if (url.length() > 0 && mime != null && (mime.equals("text/x-c++") || mime.equals("text/x-c") || mime.equals("text/x-fortran"))) {
            try {
                URI uri = new URI(url);
                String path = uri.getPath();
                if (Utilities.isWindows() && path.charAt(0) == '/') {
                    path = path.substring(1);
                }
                this.tfFileName.setText(path);
            }
            catch (Exception e) {
                this.tfFileName.setText(url);
            }
        } else {
            this.tfFileName.setEditable(true);
        }
        this.tfLineNumber.setText(Integer.toString(b.getLineNumber()));
        this.tfCondition.setText(b.getCondition());
        this.setupConditionPane();
        this.actionsPanel = new ActionsPanel(b);
        this.pActions.add((Component)this.actionsPanel, "Center");
    }

    private static LineBreakpoint createBreakpoint() {
        String url = EditorContextBridge.getMostRecentURL();
        int lnum = EditorContextBridge.getMostRecentLineNumber();
        LineBreakpoint lb = LineBreakpoint.create(url, lnum);
        lb.setPrintText(NbBundle.getBundle(LineBreakpointPanel.class).getString("CTL_Line_Breakpoint_Print_Text"));
        return lb;
    }

    private static int findNumLines(String url) {
        DataObject dataObject;
        FileObject file;
        try {
            file = URLMapper.findFileObject((URL)new URL(url));
        }
        catch (MalformedURLException e) {
            return 0;
        }
        if (file == null) {
            return 0;
        }
        try {
            dataObject = DataObject.find((FileObject)file);
        }
        catch (DataObjectNotFoundException ex) {
            return 0;
        }
        EditorCookie ec = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        if (ec == null) {
            return 0;
        }
        ec.prepareDocument().waitFinished();
        StyledDocument d = ec.getDocument();
        if (!(d instanceof StyledDocument)) {
            return 0;
        }
        StyledDocument sd = d;
        return NbDocument.findLineNumber((StyledDocument)sd, (int)sd.getLength());
    }

    private void setupConditionPane() {
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NetbeansDebuggerBreakpointLineGDB");
    }

    private void initComponents() {
        this.pSettings = new JPanel();
        this.jLabel3 = new JLabel();
        this.jLabel5 = new JLabel();
        this.tfFileName = new JTextField();
        this.jLabel1 = new JLabel();
        this.tfLineNumber = new JTextField();
        this.spCondition = new JScrollPane();
        this.tfCondition = new JEditorPane();
        this.pActions = new JPanel();
        this.jPanel1 = new JPanel();
        this.setLayout(new GridBagLayout());
        this.pSettings.setLayout(new GridBagLayout());
        this.pSettings.setBorder(BorderFactory.createTitledBorder(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/gdb/breakpoints/Bundle").getString("L_Line_Breakpoint_BorderTitle")));
        this.jLabel3.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/gdb/breakpoints/Bundle").getString("MN_L_Line_Breakpoint_File_Name").charAt(0));
        this.jLabel3.setLabelFor(this.tfFileName);
        this.jLabel3.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/gdb/breakpoints/Bundle").getString("L_Line_Breakpoint_File_Name"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel3.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/gdb/breakpoints/Bundle").getString("ACSD_L_Line_Breakpoint_File_Name"));
        this.jLabel5.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/gdb/breakpoints/Bundle").getString("MN_L_Line_Breakpoint_Condition").charAt(0));
        this.jLabel5.setLabelFor(this.tfCondition);
        this.jLabel5.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/gdb/breakpoints/Bundle").getString("L_Line_Breakpoint_Condition"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.jLabel5, gridBagConstraints);
        this.jLabel5.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/gdb/breakpoints/Bundle").getString("ACSD_L_Line_Breakpoint_Condition"));
        this.tfFileName.setEditable(false);
        this.tfFileName.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/gdb/breakpoints/Bundle").getString("TTT_TF_Line_Breakpoint_File_Name"));
        this.tfFileName.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.tfFileName, gridBagConstraints);
        this.tfFileName.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/gdb/breakpoints/Bundle").getString("ACSD_TF_Line_Breakpoint_File_Name"));
        this.jLabel1.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/gdb/breakpoints/Bundle").getString("MN_L_Line_Breakpoint_Line_Number").charAt(0));
        this.jLabel1.setLabelFor(this.tfLineNumber);
        this.jLabel1.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/gdb/breakpoints/Bundle").getString("L_Line_Breakpoint_Line_Number"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel1.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/gdb/breakpoints/Bundle").getString("ACSD_L_Line_Breakpoint_Line_Number"));
        this.tfLineNumber.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/gdb/breakpoints/Bundle").getString("TTT_TF_Line_Breakpoint_Line_Number"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.tfLineNumber, gridBagConstraints);
        this.tfLineNumber.getAccessibleContext().setAccessibleName("Line number");
        this.tfLineNumber.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/gdb/breakpoints/Bundle").getString("ACSD_TF_Line_Breakpoint_Line_Number"));
        this.spCondition.setHorizontalScrollBarPolicy(31);
        this.spCondition.setToolTipText(NbBundle.getMessage(LineBreakpointPanel.class, (String)"ACSD_TF_Line_Breakpoint_Condition"));
        this.tfCondition.setEditable(false);
        this.tfCondition.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/gdb/breakpoints/Bundle").getString("HINT_UnimplementedCondition"));
        this.tfCondition.setToolTipText(NbBundle.getMessage(LineBreakpointPanel.class, (String)"ACSD_TF_Line_Breakpoint_Condition"));
        this.tfCondition.setContentType("text/x-java");
        this.tfCondition.setEnabled(false);
        this.spCondition.setViewportView(this.tfCondition);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.spCondition, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pSettings, gridBagConstraints);
        this.pActions.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pActions, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    public boolean ok() {
        String msg = this.validateBreakpoint();
        if (msg != null) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg));
            return false;
        }
        this.actionsPanel.ok();
        this.breakpoint.setLineNumber(Integer.parseInt(this.tfLineNumber.getText().trim()));
        this.breakpoint.setCondition(this.tfCondition.getText());
        DebuggerManager dm = DebuggerManager.getDebuggerManager();
        Breakpoint[] bs = dm.getBreakpoints();
        int k = bs.length;
        for (int i = 0; i < k; ++i) {
            String condition;
            String url;
            if (!(bs[i] instanceof LineBreakpoint)) continue;
            LineBreakpoint lb = (LineBreakpoint)bs[i];
            if (this.breakpoint.getLineNumber() != lb.getLineNumber() || !(url = this.breakpoint.getURL()).equals(lb.getURL()) || ((condition = this.breakpoint.getCondition()) == null ? lb.getCondition() != null : !condition.equals(lb.getCondition()))) continue;
            if (!lb.isEnabled()) {
                bs[i].enable();
            }
            return true;
        }
        if (this.createBreakpoint) {
            DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)this.breakpoint);
        }
        return true;
    }

    public boolean cancel() {
        return true;
    }

    public boolean isValid() {
        return true;
    }

    private String validateBreakpoint() {
        File file;
        String path = this.tfFileName.getText();
        if (path == null || path.length() == 0) {
            return NbBundle.getMessage(LineBreakpointPanel.class, (String)"MSG_No_File_Name_Spec");
        }
        if (!(path.charAt(0) != '/' && path.charAt(0) != '\'' || (file = new File(path)).exists())) {
            return NbBundle.getMessage(LineBreakpointPanel.class, (String)"MSG_File_Name_Does_Not_Exist");
        }
        try {
            int line = Integer.parseInt(this.tfLineNumber.getText().trim());
            if (line <= 0) {
                return NbBundle.getMessage(LineBreakpointPanel.class, (String)"MSG_NonPositive_Line_Number_Spec");
            }
            int maxLine = LineBreakpointPanel.findNumLines(this.breakpoint.getURL());
            if (maxLine == 0) {
                maxLine = Integer.MAX_VALUE;
            }
            if (line > maxLine) {
                return NbBundle.getMessage(LineBreakpointPanel.class, (String)"MSG_TooBig_Line_Number_Spec", (Object)Integer.toString(line), (Object)Integer.toString(maxLine));
            }
        }
        catch (NumberFormatException e) {
            return NbBundle.getMessage(LineBreakpointPanel.class, (String)"MSG_No_Line_Number_Spec");
        }
        return null;
    }
}

