/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.debugsupport.breakpoints;

import com.hp.openvms.netbeans.debugsupport.breakpoints.BreakpointImpl;
import com.hp.openvms.netbeans.debugsupport.breakpoints.BreakpointsReader;
import com.hp.openvms.netbeans.debugsupport.breakpoints.FunctionBreakpoint;
import com.hp.openvms.netbeans.debugsupport.breakpoints.FunctionBreakpointImpl;
import com.hp.openvms.netbeans.debugsupport.breakpoints.LineBreakpoint;
import com.hp.openvms.netbeans.debugsupport.breakpoints.LineBreakpointImpl;
import com.hp.openvms.netbeans.debugsupport.breakpoints.PersistenceManager;
import com.hp.openvms.netbeans.debugsupport.breakpoints.RemoteBreakpoint;
import com.hp.openvms.netbeans.debugsupport.debugger.RemoteDebugger;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.LazyActionsManagerListener;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.Watch;
import org.netbeans.modules.distributed.rmi.protocol.debug.DebugInfo;
import org.netbeans.modules.distributed.rmi.protocol.debug.LookupLinePacket;
import org.netbeans.spi.debugger.ContextProvider;

public class BreakpointsEngineListener
extends LazyActionsManagerListener
implements PropertyChangeListener,
DebuggerManagerListener {
    private RemoteDebugger debugger;
    private Session session;
    private BreakpointsReader breakpointsReader;
    private HashMap breakpointToImpl = new HashMap();

    public BreakpointsEngineListener(ContextProvider lookupProvider) {
        this.debugger = (RemoteDebugger)lookupProvider.lookupFirst(null, RemoteDebugger.class);
        this.session = (Session)lookupProvider.lookupFirst(null, Session.class);
        this.debugger.addPropertyChangeListener("state", this);
        this.breakpointsReader = PersistenceManager.findBreakpointsReader();
    }

    protected void destroy() {
        this.debugger.removePropertyChangeListener("state", this);
        DebuggerManager.getDebuggerManager().removeDebuggerListener("breakpoints", (DebuggerManagerListener)this);
        this.removeBreakpointImpls();
        this.unvalidateBreakpoints();
    }

    public String[] getProperties() {
        return new String[]{"asd"};
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getOldValue() == "state_starting" && evt.getNewValue() == "state_loading") {
            this.createBreakpointImpls();
            DebuggerManager.getDebuggerManager().addDebuggerListener("breakpoints", (DebuggerManagerListener)this);
        }
    }

    public void actionPerformed(Object action) {
    }

    public void breakpointAdded(Breakpoint breakpoint) {
        this.createBreakpointImpl(breakpoint, false);
    }

    public void breakpointRemoved(Breakpoint breakpoint) {
        this.removeBreakpointImpl(breakpoint, true);
    }

    public Breakpoint[] initBreakpoints() {
        return new Breakpoint[0];
    }

    public void initWatches() {
    }

    public void sessionAdded(Session session) {
    }

    public void sessionRemoved(Session session) {
    }

    public void watchAdded(Watch watch) {
    }

    public void watchRemoved(Watch watch) {
    }

    public void engineAdded(DebuggerEngine engine) {
        System.err.println("BEL.engineAdded: ");
    }

    public void engineRemoved(DebuggerEngine engine) {
        System.err.println("BEL.engineRemoved: ");
    }

    private void createBreakpointImpls() {
        Breakpoint[] bs = DebuggerManager.getDebuggerManager().getBreakpoints();
        int k = bs.length;
        int remoteBrkpCount = 0;
        ArrayList<Integer> globalBrkpList = new ArrayList<Integer>();
        if (k > 0) {
            int i;
            for (i = 0; i < k; ++i) {
                if (!(bs[i] instanceof RemoteBreakpoint)) continue;
                this.createBreakpointImpl(bs[i], true);
                ++remoteBrkpCount;
                globalBrkpList.add(new Integer(i));
            }
            DebugInfo[] sdis = this.debugger.breakpointInsertFlushCache();
            for (i = 0; i < remoteBrkpCount; ++i) {
                LookupLinePacket packet;
                if (sdis[i] == null || sdis[i].getLookupLinePackets() == null || (packet = (LookupLinePacket)sdis[i].getLookupLinePackets().get(0)) == null) continue;
                ((LineBreakpoint)bs[(Integer)globalBrkpList.get(i)]).setLookupLinePacket(packet);
            }
        } else {
            this.debugger.setRunning();
        }
    }

    private void removeBreakpointImpls() {
        Breakpoint[] bs = DebuggerManager.getDebuggerManager().getBreakpoints();
        int k = bs.length;
        for (int i = 0; i < k; ++i) {
            if (!(bs[i] instanceof RemoteBreakpoint)) continue;
            this.removeBreakpointImpl(bs[i], false);
        }
    }

    private void unvalidateBreakpoints() {
        Breakpoint[] bs = DebuggerManager.getDebuggerManager().getBreakpoints();
        int k = bs.length;
        for (int i = 0; i < k; ++i) {
            if (!(bs[i] instanceof RemoteBreakpoint)) continue;
            ((RemoteBreakpoint)bs[i]).setState(0);
        }
    }

    public void fixBreakpointImpls() {
        Iterator i = this.breakpointToImpl.values().iterator();
        while (i.hasNext()) {
            ((BreakpointImpl)i.next()).fixed();
        }
    }

    private void createBreakpointImpl(Breakpoint b, boolean writeToCache) {
        if (this.breakpointToImpl.containsKey(b)) {
            return;
        }
        if (b instanceof LineBreakpoint) {
            this.breakpointToImpl.put(b, new LineBreakpointImpl((LineBreakpoint)b, this.breakpointsReader, this.debugger, this.session, writeToCache));
        } else if (b instanceof FunctionBreakpoint) {
            this.breakpointToImpl.put(b, new FunctionBreakpointImpl((FunctionBreakpoint)b, this.breakpointsReader, this.debugger, this.session));
        }
    }

    private void removeBreakpointImpl(Breakpoint b, boolean removeFromServer) {
        BreakpointImpl impl = (BreakpointImpl)this.breakpointToImpl.get(b);
        if (impl != null) {
            if (removeFromServer && ((LineBreakpoint)b).getLookupLinePacket() != null) {
                this.debugger.breakpointRemove(((LineBreakpoint)b).getLookupLinePacket());
            }
            impl.remove();
            this.breakpointToImpl.remove(b);
        }
    }
}

