/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.dclsupport.dcl.datasys;

import com.hp.openvms.netbeans.dclsupport.dcl.BaseCompilerType;
import com.hp.openvms.netbeans.dclsupport.dcl.DCLCompilerType;
import com.hp.openvms.netbeans.dclsupport.dcl.MMSCompilerType;
import com.hp.openvms.netbeans.dclsupport.dcl.SHCompilerType;
import com.hp.openvms.netbeans.dclsupport.dcl.datasys.MMSDataObject;
import com.hp.openvms.netbeans.dclsupport.dcl.datasys.SHDataObject;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.distributed.common.propertyeditors.BoolEditor;
import org.netbeans.modules.distributed.common.propertyeditors.StringEditor2;
import org.netbeans.modules.distributed.common.util.RemoteProjectSettings;
import org.netbeans.modules.distributed.ideserverclient.settings.DistributedSettings;
import org.netbeans.modules.distributed.remotefs.AbstractNetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.propertyeditor.FileEditor;
import org.netbeans.modules.distributed.remotefs.propertyeditor.RemoteFSFile;
import org.openide.compiler.CompilerSupport;
import org.openide.compiler.ExternalCompiler;
import org.openide.cookies.CompilerCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;

public class DCLBuildSupport
extends CompilerSupport {
    public static final String PROP_FILE_PARAMS = "cpqDclCompileParams";
    public static final String PROP_BUILD_DIR = "cpqDclBuildDirectory";
    public static final String PROP_EXTERNAL_COMPILER = "cqpDclExternalCompiler";
    public static final String PROP_OUTPUT_SWITCH = "cqpDclOutputSwitch";
    public static final String PROP_PARAMETERS_PROMPT = "cqpDclPromptForParams";
    public static final String PROP_RESET = "cpqDclReset";
    public static final String PROP_TARGET = "cpqDclTarget";
    public static final int DCL_TYPE = 0;
    public static final int MMS_TYPE = 1;
    public static final int SH_TYPE = 2;
    protected static final ResourceBundle bundle = NbBundle.getBundle(DCLBuildSupport.class);
    protected MultiDataObject.Entry entry;
    int sType = 0;
    String sRemoteProperty;

    public DCLBuildSupport(MultiDataObject.Entry entry, Class cookie) {
        super(entry, cookie);
        this.entry = entry;
        if (entry.getDataObject() instanceof MMSDataObject) {
            this.sType = 1;
            this.sRemoteProperty = "Prompt for Qualifiers and Additional Targets";
        } else if (entry.getDataObject() instanceof SHDataObject) {
            this.sType = 2;
            this.sRemoteProperty = "Prompt for Arguments";
        } else {
            this.sRemoteProperty = "Prompt for Parameters";
        }
    }

    public FileObject getFileObject() {
        return this.entry.getFile();
    }

    private BaseCompilerType getProjCompilerType() {
        Project project = FileOwnerQuery.getOwner((FileObject)this.getFileObject());
        if (project != null) {
            RemoteProjectSettings rs = (RemoteProjectSettings)project.getLookup().lookup(RemoteProjectSettings.class);
            if (rs != null) {
                rs.refreshAll();
            }
            if (this.sType == 0) {
                if (rs == null) {
                    return new DCLCompilerType(this.getFileObject());
                }
                return (DCLCompilerType)((Object)rs.getCompilerSettings("dcl"));
            }
            if (this.sType == 2) {
                if (rs == null) {
                    return new SHCompilerType(this.getFileObject());
                }
                return (SHCompilerType)((Object)rs.getCompilerSettings("sh"));
            }
            if (rs == null) {
                return new MMSCompilerType(this.getFileObject());
            }
            return (MMSCompilerType)((Object)rs.getCompilerSettings("mms"));
        }
        return null;
    }

    public void addProperties(Sheet.Set set) {
        set.put((Node.Property)this.createBuildProperty());
        set.put((Node.Property)this.createExternalCompilerProperty());
        if (this.sType == 1) {
            set.put((Node.Property)this.createTargetProperty());
        }
        set.put((Node.Property)this.createOutputSwitchProperty());
        set.put((Node.Property)this.createXDisplayDeviceNumber());
        set.put((Node.Property)this.createPromptForParameter());
    }

    protected String getString(String s) {
        return bundle.getString(s);
    }

    public ExternalCompiler.ErrorExpression errorExpression() {
        return this.getProjCompilerType().getErrorExpression();
    }

    private String getFlaggedNameOutputSwitch(String dispName, String name) {
        return dispName;
    }

    public void setBuildDirectory(RemoteFSFile buildDir) throws IOException {
        this.entry.getFile().setAttribute(PROP_BUILD_DIR, (Object)buildDir);
    }

    public RemoteFSFile getBuildDirectory() {
        this.getTargets();
        Object buildDir = this.entry.getFile().getAttribute(PROP_BUILD_DIR);
        if (buildDir == null) {
            return this.getProjCompilerType().getBuildDirectory();
        }
        if (buildDir != null && !(buildDir instanceof RemoteFSFile)) {
            try {
                this.entry.getFile().setAttribute(PROP_BUILD_DIR, null);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return this.getProjCompilerType().getBuildDirectory();
        }
        return (RemoteFSFile)buildDir;
    }

    public void setOutputSwitch(Boolean outputSwitch) throws IOException {
        this.entry.getFile().setAttribute(PROP_OUTPUT_SWITCH, (Object)outputSwitch);
    }

    public void setPromptForParameter(Boolean promptForParameter) throws IOException {
        this.entry.getFile().setAttribute("Prompt for Parameters", (Object)promptForParameter);
    }

    public Boolean getOutputSwitch() {
        Boolean outputSwitch = (Boolean)this.entry.getFile().getAttribute(PROP_OUTPUT_SWITCH);
        if (outputSwitch == null) {
            return this.getProjCompilerType().outputSwitch();
        }
        return outputSwitch;
    }

    public Boolean getPromptForParameter() {
        Boolean promptForParameter = (Boolean)this.entry.getFile().getAttribute(PROP_PARAMETERS_PROMPT);
        if (promptForParameter == null) {
            return Boolean.FALSE;
        }
        return promptForParameter;
    }

    private String getCurrentFileDir() {
        try {
            String rootDir = FileUtil.toFile((FileObject)this.entry.getDataObject().getPrimaryFile().getFileSystem().getRoot()).getAbsolutePath();
            String fileDir = this.entry.getDataObject().getPrimaryFile().getParent().getPackageName('/');
            Object objectDir = null;
            return rootDir + '/' + fileDir;
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getTarget() {
        String target = (String)this.entry.getFile().getAttribute(PROP_TARGET);
        if (target != null) {
            return target;
        }
        String[] ts = this.getTargets();
        if (ts.length > 0) {
            return ts[0];
        }
        return "";
    }

    public void setTarget(String target) throws IOException {
        this.entry.getFile().setAttribute(PROP_TARGET, (Object)target);
    }

    public String[] getTargets() {
        InputStream istrm = null;
        try {
            istrm = this.entry.getDataObject().getPrimaryFile().getInputStream();
            TargetParser tp = new TargetParser();
            String[] strs = tp.parse(istrm);
            istrm.close();
            return strs;
        }
        catch (Exception e) {
            if (istrm != null) {
                try {
                    istrm.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return new String[0];
        }
    }

    public String getExternalCompiler() {
        String ec = (String)this.entry.getFile().getAttribute(PROP_EXTERNAL_COMPILER);
        if (ec == null) {
            return this.getProjCompilerType().getExternalCompilerString();
        }
        return ec;
    }

    private void setExternalCompiler(String externalCompiler) throws IOException {
        this.entry.getFile().setAttribute(PROP_EXTERNAL_COMPILER, (Object)externalCompiler);
    }

    protected void setDefaultFunction(PropertySupport ps, String propName, String helpID) {
        try {
            ps.setValue("method", (Object)FileObject.class.getMethod("getAttribute", String.class));
            ps.setValue("param", (Object)propName);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        ps.setValue("object", (Object)this.entry.getFile());
        ps.setValue("helpID", (Object)helpID);
    }

    private String getFlaggedName(String dispName, String name) {
        return dispName;
    }

    private void flagProperty(String dispProp, String prop) {
    }

    private PropertySupport createXDisplayDeviceNumber() {
        class XDisplayDeviceNumberPropertySupport
        extends PropertySupport.ReadWrite {
            public XDisplayDeviceNumberPropertySupport() {
                super("X Display Device Number", Integer.class, "X Display Device Number", "Defines the screen associated with the display device");
            }

            public Object getValue() {
                FileSystem fs = null;
                try {
                    fs = DCLBuildSupport.this.entry.getFile().getFileSystem();
                }
                catch (FileStateInvalidException e) {
                    // empty catch block
                }
                if (fs instanceof AbstractNetworkFileSystem) {
                    Integer obj = (Integer)DCLBuildSupport.this.entry.getFile().getAttribute("xDisplayDeviceNumber");
                    if (obj != null) {
                        return obj;
                    }
                    return new Integer(((AbstractNetworkFileSystem)fs).getXDisplayDeviceNumber());
                }
                return new Integer(DistributedSettings.getDefault().getXDisplayDeviceNumber());
            }

            public void setValue(Object val) throws InvocationTargetException {
                try {
                    DCLBuildSupport.this.entry.getFile().setAttribute("xDisplayDeviceNumber", val);
                }
                catch (IOException ex) {
                    throw new InvocationTargetException(ex);
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }
        }
        return new XDisplayDeviceNumberPropertySupport();
    }

    private PropertySupport createBuildProperty() {
        class PropertySupportBuildDirectory
        extends PropertySupport.ReadWrite {
            public PropertySupportBuildDirectory() {
                super(DCLBuildSupport.PROP_BUILD_DIR, RemoteFSFile.class, DCLBuildSupport.this.getFlaggedName(bundle.getString("PROP_buildDirectory"), DCLBuildSupport.PROP_BUILD_DIR), bundle.getString("HINT_buildDirectory"));
                this.setValue("directories", Boolean.TRUE);
                this.setValue("files", Boolean.FALSE);
                this.setValue("3gl", Boolean.TRUE);
                this.setValue("fileName", DCLBuildSupport.this.entry.getFile().getNameExt());
                try {
                    if (DCLBuildSupport.this.entry.getFile().getFileSystem() instanceof AbstractNetworkFileSystem) {
                        this.setValue("remoteFS", DCLBuildSupport.this.entry.getFile().getFileSystem());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (DCLBuildSupport.this.getProjCompilerType().getBuildDirectory() != null) {
                    this.setValue("projvalue", DCLBuildSupport.this.getProjCompilerType().getBuildDirectory());
                }
                DCLBuildSupport.this.setDefaultFunction((PropertySupport)this, DCLBuildSupport.PROP_BUILD_DIR, "com.hp.openvms.netbeans.dclsupport.settings.DCLFileExecuteSettings");
            }

            public Object getValue() {
                return DCLBuildSupport.this.getBuildDirectory();
            }

            public void setValue(Object val) throws InvocationTargetException {
                if (val instanceof RemoteFSFile || val == null) {
                    try {
                        DCLBuildSupport.this.setBuildDirectory((RemoteFSFile)val);
                        DCLBuildSupport.this.flagProperty(DCLBuildSupport.this.getFlaggedName(bundle.getString("PROP_buildDirectory"), DCLBuildSupport.PROP_BUILD_DIR), DCLBuildSupport.PROP_BUILD_DIR);
                    }
                    catch (IOException e) {
                        throw new InvocationTargetException(e);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                try {
                    DCLBuildSupport.this.setBuildDirectory(null);
                    DCLBuildSupport.this.setBuildDirectory(DCLBuildSupport.this.getBuildDirectory());
                }
                catch (IOException e) {
                    throw new InvocationTargetException(e);
                }
            }

            public PropertyEditor getPropertyEditor() {
                return new FileEditor();
            }
        }
        return new PropertySupportBuildDirectory();
    }

    private PropertySupport createExternalCompilerProperty() {
        class ExternalCompilerPropertySupport
        extends PropertySupport.ReadWrite {
            public ExternalCompilerPropertySupport() {
                super(DCLBuildSupport.PROP_EXTERNAL_COMPILER, String.class, DCLBuildSupport.this.getFlaggedName(bundle.getString("PROP_EXTERNAL_COMPILER"), DCLBuildSupport.PROP_EXTERNAL_COMPILER), bundle.getString("HINT_EXTERNAL_COMPILER"));
                DCLBuildSupport.this.setDefaultFunction((PropertySupport)this, DCLBuildSupport.PROP_EXTERNAL_COMPILER, "com.hp.openvms.netbeans.dclsupport.settings.DCLFileExecuteSettings");
            }

            public Object getValue() {
                return DCLBuildSupport.this.getExternalCompiler();
            }

            public void setValue(Object val) throws InvocationTargetException {
                try {
                    DCLBuildSupport.this.setExternalCompiler((String)val);
                    DCLBuildSupport.this.flagProperty(DCLBuildSupport.this.getFlaggedName(bundle.getString("PROP_EXTERNAL_COMPILER"), DCLBuildSupport.PROP_EXTERNAL_COMPILER), DCLBuildSupport.PROP_EXTERNAL_COMPILER);
                }
                catch (IOException e) {
                    throw new InvocationTargetException(e);
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                try {
                    DCLBuildSupport.this.setExternalCompiler(null);
                    DCLBuildSupport.this.setExternalCompiler(DCLBuildSupport.this.getExternalCompiler());
                    DCLBuildSupport.this.flagProperty(DCLBuildSupport.this.getFlaggedName(bundle.getString("PROP_EXTERNAL_COMPILER"), DCLBuildSupport.PROP_EXTERNAL_COMPILER), DCLBuildSupport.PROP_EXTERNAL_COMPILER);
                }
                catch (IOException e) {
                    throw new InvocationTargetException(e);
                }
            }

            public PropertyEditor getPropertyEditor() {
                return new StringEditor2();
            }
        }
        return new ExternalCompilerPropertySupport();
    }

    private PropertySupport createTargetProperty() {
        class PropertySupportTarget
        extends PropertySupport.ReadWrite {
            public PropertySupportTarget() {
                super(DCLBuildSupport.PROP_TARGET, String.class, DCLBuildSupport.this.getFlaggedName(bundle.getString("PROP_target"), DCLBuildSupport.PROP_TARGET), bundle.getString("HINT_target"));
            }

            public Object getValue() {
                return DCLBuildSupport.this.getTarget();
            }

            public void setValue(Object val) throws InvocationTargetException {
                if (val instanceof String || val == null) {
                    try {
                        DCLBuildSupport.this.setTarget((String)val);
                        DCLBuildSupport.this.flagProperty(DCLBuildSupport.this.getFlaggedName(bundle.getString("PROP_target"), DCLBuildSupport.PROP_TARGET), DCLBuildSupport.PROP_TARGET);
                    }
                    catch (IOException e) {
                        throw new InvocationTargetException(e);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }

            public PropertyEditor getPropertyEditor() {
                return new TagEditor();
            }
        }
        return new PropertySupportTarget();
    }

    private PropertySupport createOutputSwitchProperty() {
        class OutputSwitchPropertySupport
        extends PropertySupport.ReadWrite {
            public OutputSwitchPropertySupport() {
                super(DCLBuildSupport.PROP_OUTPUT_SWITCH, Object.class, DCLBuildSupport.this.getFlaggedNameOutputSwitch(bundle.getString("PROP_OUTPUT_SWITCH"), DCLBuildSupport.PROP_OUTPUT_SWITCH), bundle.getString("HINT_OUTPUT_SWITCH"));
                DCLBuildSupport.this.setDefaultFunction((PropertySupport)this, DCLBuildSupport.PROP_OUTPUT_SWITCH, "com.hp.openvms.netbeans.hpsupport.settings.DCLFileExecuteSettings");
                if (DCLBuildSupport.this.getProjCompilerType().outputSwitch() != null) {
                    this.setValue("projValue", DCLBuildSupport.this.getProjCompilerType().outputSwitch());
                }
            }

            public Object getValue() {
                FileSystem fs = null;
                try {
                    fs = DCLBuildSupport.this.entry.getFile().getFileSystem();
                }
                catch (FileStateInvalidException e) {
                    // empty catch block
                }
                if (fs instanceof AbstractNetworkFileSystem) {
                    Boolean bobj = (Boolean)DCLBuildSupport.this.entry.getFile().getAttribute("useXtermExecution");
                    if (bobj != null) {
                        return bobj;
                    }
                    return new Boolean(((AbstractNetworkFileSystem)fs).getUseXtermExecution());
                }
                return DCLBuildSupport.this.getOutputSwitch();
            }

            public void setValue(Object val) throws InvocationTargetException {
                try {
                    FileSystem fs = null;
                    try {
                        fs = DCLBuildSupport.this.entry.getFile().getFileSystem();
                    }
                    catch (FileStateInvalidException fileStateInvalidException) {
                        // empty catch block
                    }
                    if (fs instanceof AbstractNetworkFileSystem) {
                        DCLBuildSupport.this.entry.getFile().setAttribute("useXtermExecution", val);
                    } else {
                        DCLBuildSupport.this.setOutputSwitch((Boolean)val);
                    }
                    DCLBuildSupport.this.flagProperty(DCLBuildSupport.this.getFlaggedNameOutputSwitch(bundle.getString("PROP_OUTPUT_SWITCH"), DCLBuildSupport.PROP_OUTPUT_SWITCH), DCLBuildSupport.PROP_OUTPUT_SWITCH);
                }
                catch (IOException e) {
                    throw new InvocationTargetException(e);
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }

            public PropertyEditor getPropertyEditor() {
                return new BoolEditor();
            }
        }
        return new OutputSwitchPropertySupport();
    }

    private PropertySupport createPromptForParameter() {
        class PromptForParameterSupport
        extends PropertySupport.ReadWrite {
            public PromptForParameterSupport() {
                super(DCLBuildSupport.this.sRemoteProperty, Boolean.class, DCLBuildSupport.this.sRemoteProperty, DCLBuildSupport.this.sRemoteProperty);
            }

            public Object getValue() {
                FileSystem fs = null;
                try {
                    fs = DCLBuildSupport.this.entry.getFile().getFileSystem();
                }
                catch (FileStateInvalidException e) {
                    // empty catch block
                }
                if (fs instanceof AbstractNetworkFileSystem) {
                    Boolean bobj = (Boolean)DCLBuildSupport.this.entry.getFile().getAttribute("Prompt for Parameters");
                    if (bobj != null) {
                        return bobj;
                    }
                    return Boolean.FALSE;
                }
                return Boolean.FALSE;
            }

            public void setValue(Object val) throws InvocationTargetException {
                try {
                    FileSystem fs = null;
                    try {
                        fs = DCLBuildSupport.this.entry.getFile().getFileSystem();
                    }
                    catch (FileStateInvalidException fileStateInvalidException) {
                        // empty catch block
                    }
                    if (fs instanceof AbstractNetworkFileSystem) {
                        DCLBuildSupport.this.entry.getFile().setAttribute("Prompt for Parameters", val);
                    } else {
                        DCLBuildSupport.this.setPromptForParameter((Boolean)val);
                    }
                }
                catch (IOException e) {
                    throw new InvocationTargetException(e);
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }

            public PropertyEditor getPropertyEditor() {
                return new BoolEditor();
            }
        }
        return new PromptForParameterSupport();
    }

    public static class RemoteCompile
    extends DCLBuildSupport
    implements CompilerCookie.Compile {
        public RemoteCompile(MultiDataObject.Entry entry) {
            super(entry, CompilerCookie.Compile.class);
        }
    }

    public static class Compile
    extends DCLBuildSupport
    implements CompilerCookie.Compile {
        public Compile(MultiDataObject.Entry entry) {
            super(entry, CompilerCookie.Compile.class);
        }
    }

    private class TagEditor
    extends PropertyEditorSupport {
        private TagEditor() {
        }

        public String getAsText() {
            return (String)this.getValue();
        }

        public void setAsText(String v) throws IllegalArgumentException {
            this.setValue(v);
        }

        public String[] getTags() {
            return DCLBuildSupport.this.getTargets();
        }
    }

    class TargetParser {
        TargetParser() {
        }

        public String[] parse(InputStream istrm) throws IOException {
            Vector<String> vec = new Vector<String>();
            BufferedReader br = new BufferedReader(new InputStreamReader(istrm));
            String str = null;
            StringBuffer prevSb = new StringBuffer();
            while ((str = br.readLine()) != null) {
                Pattern p;
                Matcher m;
                StringBuffer sb = new StringBuffer(str);
                for (int i = sb.length() - 1; i >= 0 && (sb.charAt(i) == ' ' || sb.charAt(i) == '\t'); --i) {
                    sb.deleteCharAt(i);
                }
                if (sb.length() > 0 && (sb.charAt(sb.length() - 1) == '-' || sb.charAt(sb.length() - 1) == '\\')) {
                    sb.deleteCharAt(sb.length() - 1);
                    prevSb.append(sb);
                    continue;
                }
                prevSb.append(sb);
                String sbstr = prevSb.toString().trim().toLowerCase();
                if (!sbstr.startsWith("#") && !sbstr.startsWith("!") && (m = (p = Pattern.compile("(.+)\\s(depends_on|:)\\s(.*)")).matcher(sbstr)).matches()) {
                    vec.add(m.group(1));
                }
                if (prevSb.length() <= 0) continue;
                prevSb.delete(0, prevSb.length());
            }
            return vec.toArray(new String[0]);
        }
    }
}

