/*
 * Decompiled with CFR 0.152.
 */
package com.compaq.openvms.netbeans.edtkeypad;

import com.compaq.openvms.netbeans.edtkeypad.EDTCustomActions;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.editor.ActionFactory;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.MultiKeyBinding;
import org.netbeans.editor.Registry;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.StatusBar;
import org.netbeans.editor.Utilities;

public class EDTInitializer
extends Settings.AbstractInitializer {
    public static final String NAME = "edt-settings-initializer";
    public static final String CELL_DIRECTION = "direction";
    public static final String DIR_FORWARD = "Forward";
    public static final String DIR_REVERSE = "Reverse";
    public static final String IGNORE_NEXT = "flagIgnoreNext";
    protected static boolean bSelectionInProgress = false;
    protected static char[] lineBuffer = null;
    protected static char[] wordBuffer = null;
    protected static char[] charBuffer = null;
    public static final String repeatFactorAction = "edt-gold";
    public static final String helpAction = "edt-help";
    public static final String findNextAction = "edt-find-next";
    public static final String delLineAction = "edt-del-line";
    public static final String findAction = "edt-find-action";
    public static final String undoDelLineAction = "edt-undo-del-line";
    public static final String openLineAction = "edt-openline";
    public static final String toggleCaseAction = "edt-change-case";
    public static final String deleteToEolAction = "edt-del-eol";
    public static final String specialInsertAction = "edt-spec-insert";
    public static final String bottomAction = "edt-end";
    public static final String topAction = "edt-begin";
    public static final String cutReplaceAction = "edt-cut-replace";
    public static final String undoDelWordAction = "edt-undo-del-word";
    public static final String undoDelCharAction = "edt-undo-del-char";
    public static final String resetAction = "edt-reset";
    public static final String substBuffAction = "edt-subst";
    public static final String lineAction = "edt-line";
    public static final String wordAction = "edt-word";
    public static final String eolAction = "edt-eol";
    public static final String charAction = "edt-char";
    public static final String reverseDirectionAction = "edt-reverse";
    public static final String forwardDirectionAction = "edt-advance";
    public static final String cutAction = "edt-cut";
    public static final String pageAction = "edt-page";
    public static final String sectionAction = "edt-section";
    public static final String cutAppendAction = "edt-cut-append";
    public static final String delWordAction = "edt-del-word";
    public static final String delCharAction = "edt-del-char";
    public static final String startRangeAction = "edt-select";
    public static final String upLineAction = "edt-up";
    public static final String downLineAction = "edt-down";
    public static final String leftCharAction = "edt-left";
    public static final String rightCharAction = "edt-right";
    public static final String upPageAction = "edt-prev";
    public static final String downPageAction = "edt-next";
    public static final String copyAction = "edt-copy";
    public static final String begLnAction = "edt-begline";
    public static final String endLnAction = "edt-endline";
    public static final String startRangeWithToggleAction = "edt-select-toggle";
    public static final String previousWindowAction = "edt-prev-window";
    public static final String nextWindowAction = "edt-next-window";
    public static final String forwardIndentAction = "edt-indent-forward";
    public static final String reverseIndentAction = "edt-indent-reverse";
    public static final String upArrowActionJ14 = "edt-up-j14";
    public static final String downArrowActionJ14 = "edt-down-j14";
    public static final String leftArrowActionJ14 = "edt-left-j14";
    public static final String rightArrowActionJ14 = "edt-right-j14";
    public static final String pageUpActionJ14 = "edt-pgup-j14";
    public static final String pageDownActionJ14 = "edt-pgdown-j14";
    public static final String homeActionJ14 = "edt-home-j14";
    public static final String endActionJ14 = "edt-end-j14";
    public static final String insertActionJ14 = "edt-insert-j14";
    public static final String deleteActionJ14 = "edt-delete-j14";
    public static final String goldUpArrowActionJ14 = "edt-gold-up-j14";
    public static final String goldDownArrowActionJ14 = "edt-gold-down-j14";
    public static final String goldLeftArrowActionJ14 = "edt-gold-left-j14";
    public static final String goldRightArrowActionJ14 = "edt-gold-right-j14";
    public static final String goldPageUpActionJ14 = "edt-gold-pgup-j14";
    public static final String goldPageDownActionJ14 = "edt-gold-pgdown-j14";
    public static final String goldHomeActionJ14 = "edt-gold-home-j14";
    public static final String goldEndActionJ14 = "edt-gold-end-j14";
    public static final String goldInsertActionJ14 = "edt-gold-insert-j14";
    public static final String goldDeleteActionJ14 = "edt-gold-delete-j14";
    public static final String goldEnterActionJ14 = "edt-gold-enter-j14";
    public static final String edtKitInstallAction = "edt-kitinstall-action";
    public static final String lineActionNL = "edt-line-nl";
    public static final String wordActionNL = "edt-word-nl";
    public static final String eolActionNL = "edt-eol-nl";
    public static final String charActionNL = "edt-char-nl";
    public static final String reverseDirectionActionNL = "edt-reverse-nl";
    public static final String forwardDirectionActionNL = "edt-advance-nl";
    public static final String cutActionNL = "edt-cut-nl";
    public static final String pageActionNL = "edt-page-nl";
    public static final String sectionActionNL = "edt-section-nl";
    public static final String cutAppendActionNL = "edt-cut-append-nl";
    public static final String startRangeActionNL = "edt-select-nl";
    public static final String num0TypedAction = "edt-num0-typed";
    public static final String num1TypedAction = "edt-num1-typed";
    public static final String num2TypedAction = "edt-num2-typed";
    public static final String num3TypedAction = "edt-num3-typed";
    public static final String num4TypedAction = "edt-num4-typed";
    public static final String num5TypedAction = "edt-num5-typed";
    public static final String num6TypedAction = "edt-num6-typed";
    public static final String num7TypedAction = "edt-num7-typed";
    public static final String num8TypedAction = "edt-num8-typed";
    public static final String num9TypedAction = "edt-num9-typed";
    public static final String keyDivTypedAction = "edt-key-div-typed";
    public static final String keyMultTypedAction = "edt-key-mult-typed";
    public static final String keySubtTypedAction = "edt-key-subt-typed";
    public static final String keyPlusTypedAction = "edt-key-plus-typed";
    public static final String keyDecTypedAction = "edt-key-dec-typed";
    public static final String keyCommaTypedAction = "edt-key-comma-typed";
    public static final String backspaceAction = "edt-backspace";
    protected static boolean debugVerbose = Boolean.getBoolean("netbeans.edtkeypad.debug.verbose");
    protected static boolean debugTrace = Boolean.getBoolean("netbeans.edtkeypad.debug.trace") || debugVerbose;
    protected static boolean debugCaret = Boolean.getBoolean("netbeans.edtkeypad.debug.caret") || debugVerbose;
    protected static boolean debugStack = Boolean.getBoolean("netbeans.edtkeypad.debug.stack");
    protected static boolean debugSB = Boolean.getBoolean("netbeans.edtkeypad.debug.statusbar") || debugVerbose;
    protected static boolean isDecKeyboard = System.getProperty("Startup.OpenVMS.edtkeypad.DECkeyboard") == null ? false : Boolean.getBoolean("Startup.OpenVMS.edtkeypad.DECkeyboard");
    protected static boolean doNavPCKeys = System.getProperty("netbeans.edtkeypad.navigatePCkeys") == null ? false : Boolean.getBoolean("netbeans.edtkeypad.navigatePCkeys");
    protected static boolean isVms = false;
    protected static boolean isJDK14 = true;

    public EDTInitializer() {
        super(NAME);
        if (debugTrace) {
            System.out.println("edt trace: constructor");
        }
        EDTInitializer.initEdtkeypad();
    }

    public void updateSettingsMap(Class kitClass, Map settingsMap) {
        block7: {
            if (debugTrace) {
                System.out.println("edt trace: updateSettingsMap for kitClass  " + (kitClass == null ? " null" : kitClass.getName()));
            }
            if (kitClass == BaseKit.class) {
                try {
                    SettingsUtil.updateListSetting((Map)settingsMap, (String)"kit-install-action-name-list", (Object[])new Object[]{edtKitInstallAction});
                    SettingsUtil.updateListSetting((Map)settingsMap, (String)"custom-action-list", (Object[])new Object[]{new EDTKitInstallAction(), new BaseKit.InsertTabAction(), new ActionFactory.ToggleTypingModeAction(), new EDTCustomActions.BackspaceAction(), new EDTCustomActions.FindNextAction(), new EDTCustomActions.DelLineAction(), new EDTCustomActions.UndoDelLineAction(), new EDTCustomActions.DeleteToEolAction(), new EDTCustomActions.UndoDelWordAction(), new EDTCustomActions.UndoDelCharAction(), new EDTCustomActions.SubstBuffAction(), new EDTCustomActions.LineAction(), new EDTCustomActions.WordAction(), new EDTCustomActions.EolAction(), new EDTCustomActions.CharAction(), new EDTCustomActions.ForwardDirectionAction(), new EDTCustomActions.ReverseDirectionAction(), new EDTCustomActions.PageAction(), new EDTCustomActions.SectionAction(), new EDTCustomActions.CutAppendAction(), new EDTCustomActions.CutReplaceAction(), new EDTCustomActions.DelWordAction(), new EDTCustomActions.DelCharAction(), new EDTCustomActions.StartRangeAction(), new EDTCustomActions.StartRangeWithToggleAction(), new EDTCustomActions.ResetAction(), new EDTCustomActions.BottomAction(), new EDTCustomActions.TopAction(), new EDTCustomActions.PreviousWindowAction(), new EDTCustomActions.NextWindowAction(), new EDTCustomActions.UpLineAction(), new EDTCustomActions.DownLineAction(), new EDTCustomActions.RightCharAction(), new EDTCustomActions.LeftCharAction(), new EDTCustomActions.UpPageAction(), new EDTCustomActions.DownPageAction(), new EDTCustomActions.CopyAction(), new EDTCustomActions.BegLnAction(), new EDTCustomActions.EndLnAction(), new EDTCustomActions.OpenLineAction(), new EDTCustomActions.ToggleCaseAction(), new EDTCustomActions.HelpAction(), new EDTCustomActions.FindAction(), new EDTCustomActions.CutAction(), new EDTCustomActions.CutActionNL(), new EDTCustomActions.LineActionNL(), new EDTCustomActions.WordActionNL(), new EDTCustomActions.EolActionNL(), new EDTCustomActions.CharActionNL(), new EDTCustomActions.ReverseDirectionActionNL(), new EDTCustomActions.ForwardDirectionActionNL(), new EDTCustomActions.PageActionNL(), new EDTCustomActions.SectionActionNL(), new EDTCustomActions.CutAppendActionNL(), new EDTCustomActions.StartRangeActionNL(), new EDTCustomActions.Num0TypedAction(), new EDTCustomActions.Num1TypedAction(), new EDTCustomActions.Num2TypedAction(), new EDTCustomActions.Num3TypedAction(), new EDTCustomActions.Num4TypedAction(), new EDTCustomActions.Num5TypedAction(), new EDTCustomActions.Num6TypedAction(), new EDTCustomActions.Num7TypedAction(), new EDTCustomActions.Num8TypedAction(), new EDTCustomActions.Num9TypedAction(), new EDTCustomActions.KeyDivTypedAction(), new EDTCustomActions.KeyMultTypedAction(), new EDTCustomActions.KeySubtTypedAction(), new EDTCustomActions.KeyPlusTypedAction(), new EDTCustomActions.KeyDecTypedAction(), new EDTCustomActions.KeyCommaTypedAction(), new EDTCustomActions.UpArrowActionJ14(), new EDTCustomActions.DownArrowActionJ14(), new EDTCustomActions.RightArrowActionJ14(), new EDTCustomActions.LeftArrowActionJ14(), new EDTCustomActions.PageUpActionJ14(), new EDTCustomActions.PageDownActionJ14(), new EDTCustomActions.HomeActionJ14(), new EDTCustomActions.EndActionJ14(), new EDTCustomActions.InsertActionJ14(), new EDTCustomActions.DeleteActionJ14(), new EDTCustomActions.GoldUpArrowActionJ14(), new EDTCustomActions.GoldDownArrowActionJ14(), new EDTCustomActions.GoldRightArrowActionJ14(), new EDTCustomActions.GoldLeftArrowActionJ14(), new EDTCustomActions.GoldPageUpActionJ14(), new EDTCustomActions.GoldPageDownActionJ14(), new EDTCustomActions.GoldHomeActionJ14(), new EDTCustomActions.GoldEndActionJ14(), new EDTCustomActions.GoldInsertActionJ14(), new EDTCustomActions.GoldDeleteActionJ14(), new EDTCustomActions.GoldEnterActionJ14()});
                    SettingsUtil.updateListSetting((Map)settingsMap, (String)"key-bindings", (Object[])this.NumpadKeyBindings());
                    SettingsUtil.updateListSetting((Map)settingsMap, (String)"key-bindings", (Object[])this.ConsecutiveGoldBindings());
                    SettingsUtil.updateListSetting((Map)settingsMap, (String)"key-bindings", (Object[])this.NumpadOverlayKeyBindingsForPC());
                    SettingsUtil.updateListSetting((Map)settingsMap, (String)"key-bindings", (Object[])this.StandardNavKeyBindingsForPC());
                    if (debugVerbose) {
                        System.out.println("vms == false");
                    }
                    SettingsUtil.updateListSetting((Map)settingsMap, (String)"key-bindings", (Object[])this.SmartNavKeyBindingsForPC());
                    if (debugVerbose) {
                        System.out.println("edt: lists updated: " + Settings.initializersToString());
                    }
                    if (debugStack) {
                        new Throwable().printStackTrace();
                    }
                }
                catch (Exception ex) {
                    if (!debugStack) break block7;
                    ex.printStackTrace();
                }
            }
        }
    }

    private MultiKeyBinding[] NumpadKeyBindings() {
        int edtCharKey;
        int edtWordKey;
        int edtLineKey;
        int edtFindNextKey;
        int edtHelpKey;
        int edtGoldKey;
        if (debugTrace) {
            System.out.println("edt trace: NumpadKeyBindings");
        }
        int wordModifierMask = 0;
        if (isDecKeyboard) {
            edtGoldKey = 61448;
            edtHelpKey = 61449;
            edtFindNextKey = 61450;
            edtLineKey = 61451;
            edtWordKey = 109;
            edtCharKey = 108;
        } else {
            edtGoldKey = 144;
            edtHelpKey = 111;
            edtFindNextKey = 106;
            edtLineKey = 109;
            edtCharKey = 107;
            edtWordKey = isVms ? 109 : 107;
            wordModifierMask = 1;
        }
        KeyStroke goldKey = KeyStroke.getKeyStroke(edtGoldKey, 0);
        try {
            return new MultiKeyBinding[]{new MultiKeyBinding(new KeyStroke[]{KeyStroke.getKeyStroke(9, 0)}, "insert-tab"), new MultiKeyBinding(new KeyStroke[]{KeyStroke.getKeyStroke(10, 0)}, "insert-break"), new MultiKeyBinding(new KeyStroke[]{KeyStroke.getKeyStroke(8, 0)}, backspaceAction), new MultiKeyBinding(new KeyStroke[]{KeyStroke.getKeyStroke(edtHelpKey, 0)}, helpAction), new MultiKeyBinding(new KeyStroke[]{KeyStroke.getKeyStroke(edtFindNextKey, 0)}, findNextAction), new MultiKeyBinding(new KeyStroke[]{KeyStroke.getKeyStroke(edtLineKey, 0)}, delLineAction), new MultiKeyBinding(new KeyStroke[]{goldKey, KeyStroke.getKeyStroke(edtFindNextKey, 0)}, findAction), new MultiKeyBinding(new KeyStroke[]{goldKey, KeyStroke.getKeyStroke(edtLineKey, 0)}, undoDelLineAction), new MultiKeyBinding(new KeyStroke[]{goldKey, KeyStroke.getKeyStroke(110, 0)}, resetAction), new MultiKeyBinding(new KeyStroke[]{goldKey, KeyStroke.getKeyStroke(96, 0)}, openLineAction), new MultiKeyBinding(new KeyStroke[]{goldKey, KeyStroke.getKeyStroke(97, 0)}, toggleCaseAction), new MultiKeyBinding(new KeyStroke[]{goldKey, KeyStroke.getKeyStroke(98, 0)}, deleteToEolAction), new MultiKeyBinding(new KeyStroke[]{goldKey, KeyStroke.getKeyStroke(100, 0)}, bottomAction), new MultiKeyBinding(new KeyStroke[]{goldKey, KeyStroke.getKeyStroke(101, 0)}, topAction), new MultiKeyBinding(new KeyStroke[]{goldKey, KeyStroke.getKeyStroke(102, 0)}, "paste-from-clipboard"), new MultiKeyBinding(new KeyStroke[]{goldKey, KeyStroke.getKeyStroke(105, 0)}, cutReplaceAction), new MultiKeyBinding(new KeyStroke[]{KeyStroke.getKeyStroke(edtGoldKey, wordModifierMask), KeyStroke.getKeyStroke(edtWordKey, wordModifierMask)}, undoDelWordAction), new MultiKeyBinding(new KeyStroke[]{goldKey, KeyStroke.getKeyStroke(edtCharKey, 0)}, undoDelCharAction), new MultiKeyBinding(new KeyStroke[]{goldKey, KeyStroke.getKeyStroke(10, 0)}, substBuffAction), new MultiKeyBinding(KeyStroke.getKeyStroke(96, 0), lineActionNL), new MultiKeyBinding(KeyStroke.getKeyStroke(97, 0), wordActionNL), new MultiKeyBinding(KeyStroke.getKeyStroke(98, 0), eolActionNL), new MultiKeyBinding(KeyStroke.getKeyStroke(99, 0), charActionNL), new MultiKeyBinding(KeyStroke.getKeyStroke(100, 0), forwardDirectionActionNL), new MultiKeyBinding(KeyStroke.getKeyStroke(101, 0), reverseDirectionActionNL), new MultiKeyBinding(KeyStroke.getKeyStroke(102, 0), cutActionNL), new MultiKeyBinding(KeyStroke.getKeyStroke(103, 0), pageActionNL), new MultiKeyBinding(KeyStroke.getKeyStroke(104, 0), sectionActionNL), new MultiKeyBinding(KeyStroke.getKeyStroke(105, 0), cutAppendActionNL), new MultiKeyBinding(new KeyStroke[]{KeyStroke.getKeyStroke(edtWordKey, wordModifierMask)}, delWordAction), new MultiKeyBinding(KeyStroke.getKeyStroke(110, 0), startRangeActionNL), new MultiKeyBinding(KeyStroke.getKeyStroke(edtCharKey, 0), delCharAction), new MultiKeyBinding(KeyStroke.getKeyStroke('0'), num0TypedAction), new MultiKeyBinding(KeyStroke.getKeyStroke('1'), num1TypedAction), new MultiKeyBinding(KeyStroke.getKeyStroke('2'), num2TypedAction), new MultiKeyBinding(KeyStroke.getKeyStroke('3'), num3TypedAction), new MultiKeyBinding(KeyStroke.getKeyStroke('4'), num4TypedAction), new MultiKeyBinding(KeyStroke.getKeyStroke('5'), num5TypedAction), new MultiKeyBinding(KeyStroke.getKeyStroke('6'), num6TypedAction), new MultiKeyBinding(KeyStroke.getKeyStroke('7'), num7TypedAction), new MultiKeyBinding(KeyStroke.getKeyStroke('8'), num8TypedAction), new MultiKeyBinding(KeyStroke.getKeyStroke('9'), num9TypedAction), new MultiKeyBinding(KeyStroke.getKeyStroke('/'), keyDivTypedAction), new MultiKeyBinding(KeyStroke.getKeyStroke('*'), keyMultTypedAction), new MultiKeyBinding(KeyStroke.getKeyStroke('-'), keySubtTypedAction), new MultiKeyBinding(KeyStroke.getKeyStroke('+'), keyPlusTypedAction), new MultiKeyBinding(KeyStroke.getKeyStroke('.'), keyDecTypedAction), new MultiKeyBinding(KeyStroke.getKeyStroke(','), keyCommaTypedAction), new MultiKeyBinding(KeyStroke.getKeyStroke(155, 8), "toggle-typing-mode")};
        }
        catch (Exception e) {
            if (debugVerbose) {
                System.out.println("unexpected exception");
            }
            if (System.getProperty("netbeans.debug.exceptions") != null) {
                e.printStackTrace();
            }
            return new MultiKeyBinding[0];
        }
    }

    private MultiKeyBinding[] ConsecutiveGoldBindings() {
        int edtCharKey;
        int edtWordKey;
        int edtLineKey;
        int edtFindNextKey;
        int edtGoldKey;
        if (debugTrace) {
            System.out.println("edt trace: ConsecutiveGoldBindings");
        }
        int wordModifierMask = 0;
        if (isDecKeyboard) {
            edtGoldKey = 61448;
            int edtHelpKey = 61449;
            edtFindNextKey = 61450;
            edtLineKey = 61451;
            edtWordKey = 109;
            edtCharKey = 108;
        } else {
            edtGoldKey = 144;
            int edtHelpKey = 111;
            edtFindNextKey = 106;
            edtLineKey = 109;
            edtCharKey = 107;
            edtWordKey = isVms ? 109 : 107;
            wordModifierMask = 1;
        }
        KeyStroke goldKey = KeyStroke.getKeyStroke(edtGoldKey, 0);
        try {
            return new MultiKeyBinding[]{new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, KeyStroke.getKeyStroke(edtFindNextKey, 0)}, findAction), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, KeyStroke.getKeyStroke(edtLineKey, 0)}, undoDelLineAction), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, KeyStroke.getKeyStroke(110, 0)}, resetAction), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, KeyStroke.getKeyStroke(96, 0)}, openLineAction), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, KeyStroke.getKeyStroke(97, 0)}, toggleCaseAction), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, KeyStroke.getKeyStroke(98, 0)}, deleteToEolAction), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, KeyStroke.getKeyStroke(100, 0)}, bottomAction), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, KeyStroke.getKeyStroke(101, 0)}, topAction), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, KeyStroke.getKeyStroke(102, 0)}, "paste-from-clipboard"), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, KeyStroke.getKeyStroke(105, 0)}, cutReplaceAction), new MultiKeyBinding(new KeyStroke[]{KeyStroke.getKeyStroke(edtGoldKey, wordModifierMask), KeyStroke.getKeyStroke(edtGoldKey, wordModifierMask), KeyStroke.getKeyStroke(edtWordKey, wordModifierMask)}, undoDelWordAction), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, KeyStroke.getKeyStroke(edtCharKey, 0)}, undoDelCharAction), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, KeyStroke.getKeyStroke(10, 0)}, substBuffAction), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, goldKey, KeyStroke.getKeyStroke(edtFindNextKey, 0)}, findAction), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, goldKey, KeyStroke.getKeyStroke(edtLineKey, 0)}, undoDelLineAction), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, goldKey, KeyStroke.getKeyStroke(edtLineKey, 0)}, undoDelLineAction), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, goldKey, KeyStroke.getKeyStroke(110, 0)}, resetAction), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, goldKey, KeyStroke.getKeyStroke(96, 0)}, openLineAction), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, goldKey, KeyStroke.getKeyStroke(97, 0)}, toggleCaseAction), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, goldKey, KeyStroke.getKeyStroke(98, 0)}, deleteToEolAction), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, goldKey, KeyStroke.getKeyStroke(100, 0)}, bottomAction), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, goldKey, KeyStroke.getKeyStroke(101, 0)}, topAction), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, goldKey, KeyStroke.getKeyStroke(102, 0)}, "paste-from-clipboard"), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, goldKey, KeyStroke.getKeyStroke(105, 0)}, cutReplaceAction), new MultiKeyBinding(new KeyStroke[]{KeyStroke.getKeyStroke(edtGoldKey, wordModifierMask), KeyStroke.getKeyStroke(edtGoldKey, wordModifierMask), KeyStroke.getKeyStroke(edtGoldKey, wordModifierMask), KeyStroke.getKeyStroke(edtWordKey, wordModifierMask)}, undoDelWordAction), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, goldKey, KeyStroke.getKeyStroke(edtCharKey, 0)}, undoDelCharAction), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, goldKey, KeyStroke.getKeyStroke(10, 0)}, substBuffAction)};
        }
        catch (Exception e) {
            if (debugVerbose) {
                System.out.println("unexecpted exception");
            }
            if (System.getProperty("netbeans.debug.exceptions") != null) {
                e.printStackTrace();
            }
            return new MultiKeyBinding[0];
        }
    }

    private MultiKeyBinding[] NumpadOverlayKeyBindingsForPC() {
        if (debugTrace) {
            System.out.println("edt trace: NumpadOverlayKeyBindingsForPC");
        }
        KeyStroke goldKey = KeyStroke.getKeyStroke(144, 0);
        return new MultiKeyBinding[]{new MultiKeyBinding(new KeyStroke[]{goldKey, KeyStroke.getKeyStroke(127, 0)}, resetAction), new MultiKeyBinding(new KeyStroke[]{goldKey, KeyStroke.getKeyStroke(155, 0)}, openLineAction), new MultiKeyBinding(new KeyStroke[]{goldKey, KeyStroke.getKeyStroke(35, 0)}, toggleCaseAction), new MultiKeyBinding(new KeyStroke[]{goldKey, KeyStroke.getKeyStroke(40, 0)}, deleteToEolAction), new MultiKeyBinding(new KeyStroke[]{goldKey, KeyStroke.getKeyStroke(37, 0)}, bottomAction), new MultiKeyBinding(new KeyStroke[]{goldKey, KeyStroke.getKeyStroke(12, 0)}, topAction), new MultiKeyBinding(new KeyStroke[]{goldKey, KeyStroke.getKeyStroke(39, 0)}, "paste-from-clipboard"), new MultiKeyBinding(new KeyStroke[]{goldKey, KeyStroke.getKeyStroke(33, 0)}, cutReplaceAction), new MultiKeyBinding(KeyStroke.getKeyStroke(155, 0), lineAction), new MultiKeyBinding(KeyStroke.getKeyStroke(35, 0), wordAction), new MultiKeyBinding(KeyStroke.getKeyStroke(225, 0), eolAction), new MultiKeyBinding(KeyStroke.getKeyStroke(40, 0), eolAction), new MultiKeyBinding(KeyStroke.getKeyStroke(34, 0), charAction), new MultiKeyBinding(KeyStroke.getKeyStroke(226, 0), forwardDirectionAction), new MultiKeyBinding(KeyStroke.getKeyStroke(37, 0), forwardDirectionAction), new MultiKeyBinding(KeyStroke.getKeyStroke(12, 0), reverseDirectionAction), new MultiKeyBinding(KeyStroke.getKeyStroke(227, 0), cutAction), new MultiKeyBinding(KeyStroke.getKeyStroke(39, 0), cutAction), new MultiKeyBinding(KeyStroke.getKeyStroke(36, 0), pageAction), new MultiKeyBinding(KeyStroke.getKeyStroke(224, 0), sectionAction), new MultiKeyBinding(KeyStroke.getKeyStroke(38, 0), sectionAction), new MultiKeyBinding(KeyStroke.getKeyStroke(33, 0), cutAppendAction), new MultiKeyBinding(KeyStroke.getKeyStroke(127, 0), startRangeAction), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, KeyStroke.getKeyStroke(127, 0)}, resetAction), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, KeyStroke.getKeyStroke(155, 0)}, openLineAction), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, KeyStroke.getKeyStroke(35, 0)}, toggleCaseAction), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, KeyStroke.getKeyStroke(40, 0)}, deleteToEolAction), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, KeyStroke.getKeyStroke(37, 0)}, bottomAction), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, KeyStroke.getKeyStroke(12, 0)}, topAction), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, KeyStroke.getKeyStroke(39, 0)}, "paste-from-clipboard"), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, KeyStroke.getKeyStroke(33, 0)}, cutReplaceAction), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, KeyStroke.getKeyStroke(127, 0)}, resetAction), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, KeyStroke.getKeyStroke(155, 0)}, openLineAction), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, KeyStroke.getKeyStroke(35, 0)}, toggleCaseAction), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, KeyStroke.getKeyStroke(40, 0)}, deleteToEolAction), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, KeyStroke.getKeyStroke(37, 0)}, bottomAction), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, KeyStroke.getKeyStroke(12, 0)}, topAction), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, KeyStroke.getKeyStroke(39, 0)}, "paste-from-clipboard"), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, KeyStroke.getKeyStroke(33, 0)}, cutReplaceAction), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, goldKey, KeyStroke.getKeyStroke(127, 0)}, resetAction), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, goldKey, KeyStroke.getKeyStroke(155, 0)}, openLineAction), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, goldKey, KeyStroke.getKeyStroke(35, 0)}, toggleCaseAction), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, goldKey, KeyStroke.getKeyStroke(40, 0)}, deleteToEolAction), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, goldKey, KeyStroke.getKeyStroke(37, 0)}, bottomAction), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, goldKey, KeyStroke.getKeyStroke(12, 0)}, topAction), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, goldKey, KeyStroke.getKeyStroke(39, 0)}, "paste-from-clipboard"), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, goldKey, KeyStroke.getKeyStroke(33, 0)}, cutReplaceAction), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, goldKey, KeyStroke.getKeyStroke(127, 0)}, resetAction), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, goldKey, KeyStroke.getKeyStroke(155, 0)}, openLineAction), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, goldKey, KeyStroke.getKeyStroke(35, 0)}, toggleCaseAction), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, goldKey, KeyStroke.getKeyStroke(40, 0)}, deleteToEolAction), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, goldKey, KeyStroke.getKeyStroke(37, 0)}, bottomAction), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, goldKey, KeyStroke.getKeyStroke(12, 0)}, topAction), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, goldKey, KeyStroke.getKeyStroke(39, 0)}, "paste-from-clipboard"), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, goldKey, KeyStroke.getKeyStroke(33, 0)}, cutReplaceAction)};
    }

    private MultiKeyBinding[] StandardNavKeyBindingsForPC() {
        if (debugTrace) {
            System.out.println("edt trace: StandardNavKeyBindingsForPC");
        }
        return new MultiKeyBinding[]{new MultiKeyBinding(KeyStroke.getKeyStroke(40, 1), "selection-down"), new MultiKeyBinding(KeyStroke.getKeyStroke(38, 1), "selection-up"), new MultiKeyBinding(KeyStroke.getKeyStroke(37, 1), "selection-backward"), new MultiKeyBinding(KeyStroke.getKeyStroke(39, 1), "selection-forward"), new MultiKeyBinding(KeyStroke.getKeyStroke(67, 2), "copy-to-clipboard"), new MultiKeyBinding(KeyStroke.getKeyStroke(88, 2), "cut-to-clipboard"), new MultiKeyBinding(KeyStroke.getKeyStroke(86, 2), "paste-from-clipboard"), new MultiKeyBinding(KeyStroke.getKeyStroke(65, 2), "select-all"), new MultiKeyBinding(KeyStroke.getKeyStroke(90, 2), "undo"), new MultiKeyBinding(KeyStroke.getKeyStroke(82, 2), "redo")};
    }

    private MultiKeyBinding[] SmartNavKeyBindingsForPC() {
        if (debugTrace) {
            System.out.println("edt trace: SmartNavKeyBindingsForPC");
        }
        KeyStroke goldKey = KeyStroke.getKeyStroke(144, 0);
        return new MultiKeyBinding[]{new MultiKeyBinding(KeyStroke.getKeyStroke(39, 0), rightArrowActionJ14), new MultiKeyBinding(KeyStroke.getKeyStroke(37, 0), leftArrowActionJ14), new MultiKeyBinding(KeyStroke.getKeyStroke(40, 0), downArrowActionJ14), new MultiKeyBinding(KeyStroke.getKeyStroke(38, 0), upArrowActionJ14), new MultiKeyBinding(KeyStroke.getKeyStroke(127, 0), deleteActionJ14), new MultiKeyBinding(KeyStroke.getKeyStroke(155, 0), insertActionJ14), new MultiKeyBinding(KeyStroke.getKeyStroke(34, 0), pageDownActionJ14), new MultiKeyBinding(KeyStroke.getKeyStroke(33, 0), pageUpActionJ14), new MultiKeyBinding(KeyStroke.getKeyStroke(36, 0), homeActionJ14), new MultiKeyBinding(KeyStroke.getKeyStroke(35, 0), endActionJ14), new MultiKeyBinding(new KeyStroke[]{goldKey, KeyStroke.getKeyStroke(155, 0)}, goldInsertActionJ14), new MultiKeyBinding(new KeyStroke[]{goldKey, KeyStroke.getKeyStroke(127, 0)}, goldDeleteActionJ14), new MultiKeyBinding(new KeyStroke[]{goldKey, KeyStroke.getKeyStroke(36, 0)}, goldHomeActionJ14), new MultiKeyBinding(new KeyStroke[]{goldKey, KeyStroke.getKeyStroke(35, 0)}, goldEndActionJ14), new MultiKeyBinding(new KeyStroke[]{goldKey, KeyStroke.getKeyStroke(33, 0)}, goldPageUpActionJ14), new MultiKeyBinding(new KeyStroke[]{goldKey, KeyStroke.getKeyStroke(34, 0)}, goldPageDownActionJ14), new MultiKeyBinding(new KeyStroke[]{goldKey, KeyStroke.getKeyStroke(10, 0)}, goldEnterActionJ14), new MultiKeyBinding(new KeyStroke[]{goldKey, KeyStroke.getKeyStroke(38, 0)}, goldUpArrowActionJ14), new MultiKeyBinding(new KeyStroke[]{goldKey, KeyStroke.getKeyStroke(40, 0)}, goldDownArrowActionJ14), new MultiKeyBinding(new KeyStroke[]{goldKey, KeyStroke.getKeyStroke(37, 0)}, goldLeftArrowActionJ14), new MultiKeyBinding(new KeyStroke[]{goldKey, KeyStroke.getKeyStroke(39, 0)}, goldRightArrowActionJ14), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, KeyStroke.getKeyStroke(155, 0)}, goldInsertActionJ14), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, KeyStroke.getKeyStroke(127, 0)}, goldDeleteActionJ14), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, KeyStroke.getKeyStroke(36, 0)}, goldHomeActionJ14), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, KeyStroke.getKeyStroke(35, 0)}, goldEndActionJ14), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, KeyStroke.getKeyStroke(33, 0)}, goldPageUpActionJ14), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, KeyStroke.getKeyStroke(34, 0)}, goldPageDownActionJ14), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, KeyStroke.getKeyStroke(10, 0)}, goldEnterActionJ14), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, KeyStroke.getKeyStroke(38, 0)}, goldUpArrowActionJ14), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, KeyStroke.getKeyStroke(40, 0)}, goldDownArrowActionJ14), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, KeyStroke.getKeyStroke(37, 0)}, goldLeftArrowActionJ14), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, KeyStroke.getKeyStroke(39, 0)}, goldRightArrowActionJ14), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, goldKey, KeyStroke.getKeyStroke(155, 0)}, goldInsertActionJ14), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, goldKey, KeyStroke.getKeyStroke(127, 0)}, goldDeleteActionJ14), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, goldKey, KeyStroke.getKeyStroke(36, 0)}, goldHomeActionJ14), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, goldKey, KeyStroke.getKeyStroke(35, 0)}, goldEndActionJ14), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, goldKey, KeyStroke.getKeyStroke(33, 0)}, goldPageUpActionJ14), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, goldKey, KeyStroke.getKeyStroke(34, 0)}, goldPageDownActionJ14), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, goldKey, KeyStroke.getKeyStroke(10, 0)}, goldEnterActionJ14), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, goldKey, KeyStroke.getKeyStroke(38, 0)}, goldUpArrowActionJ14), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, goldKey, KeyStroke.getKeyStroke(40, 0)}, goldDownArrowActionJ14), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, goldKey, KeyStroke.getKeyStroke(37, 0)}, goldLeftArrowActionJ14), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, goldKey, KeyStroke.getKeyStroke(39, 0)}, goldRightArrowActionJ14)};
    }

    private MultiKeyBinding[] VMSNavKeyBindingsForPC() {
        if (debugTrace) {
            System.out.println("edt trace: VMSNavKeyBindingsForPC");
        }
        KeyStroke goldKey = KeyStroke.getKeyStroke(144, 0);
        return new MultiKeyBinding[]{new MultiKeyBinding(new KeyStroke[]{goldKey, KeyStroke.getKeyStroke(155, 0)}, "find"), new MultiKeyBinding(new KeyStroke[]{goldKey, KeyStroke.getKeyStroke(127, 0)}, resetAction), new MultiKeyBinding(new KeyStroke[]{goldKey, KeyStroke.getKeyStroke(36, 0)}, undoDelWordAction), new MultiKeyBinding(new KeyStroke[]{goldKey, KeyStroke.getKeyStroke(35, 0)}, topAction), new MultiKeyBinding(new KeyStroke[]{goldKey, KeyStroke.getKeyStroke(33, 0)}, copyAction), new MultiKeyBinding(new KeyStroke[]{goldKey, KeyStroke.getKeyStroke(34, 0)}, bottomAction), new MultiKeyBinding(new KeyStroke[]{goldKey, KeyStroke.getKeyStroke(38, 0)}, previousWindowAction), new MultiKeyBinding(new KeyStroke[]{goldKey, KeyStroke.getKeyStroke(40, 0)}, nextWindowAction), new MultiKeyBinding(new KeyStroke[]{goldKey, KeyStroke.getKeyStroke(37, 0)}, "shift-line-left"), new MultiKeyBinding(new KeyStroke[]{goldKey, KeyStroke.getKeyStroke(39, 0)}, "shift-line-right"), new MultiKeyBinding(new KeyStroke[]{KeyStroke.getKeyStroke(127, 0)}, startRangeWithToggleAction), new MultiKeyBinding(new KeyStroke[]{KeyStroke.getKeyStroke(36, 0)}, "paste-from-clipboard"), new MultiKeyBinding(new KeyStroke[]{KeyStroke.getKeyStroke(35, 0)}, upPageAction), new MultiKeyBinding(new KeyStroke[]{KeyStroke.getKeyStroke(33, 0)}, cutAction), new MultiKeyBinding(new KeyStroke[]{KeyStroke.getKeyStroke(34, 0)}, downPageAction), new MultiKeyBinding(new KeyStroke[]{KeyStroke.getKeyStroke(38, 0)}, upLineAction), new MultiKeyBinding(new KeyStroke[]{KeyStroke.getKeyStroke(40, 0)}, downLineAction), new MultiKeyBinding(new KeyStroke[]{KeyStroke.getKeyStroke(37, 0)}, leftCharAction), new MultiKeyBinding(new KeyStroke[]{KeyStroke.getKeyStroke(39, 0)}, rightCharAction), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, KeyStroke.getKeyStroke(155, 0)}, "find"), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, KeyStroke.getKeyStroke(127, 0)}, resetAction), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, KeyStroke.getKeyStroke(36, 0)}, undoDelWordAction), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, KeyStroke.getKeyStroke(35, 0)}, topAction), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, KeyStroke.getKeyStroke(33, 0)}, copyAction), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, KeyStroke.getKeyStroke(34, 0)}, bottomAction), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, KeyStroke.getKeyStroke(38, 0)}, previousWindowAction), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, KeyStroke.getKeyStroke(40, 0)}, nextWindowAction), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, KeyStroke.getKeyStroke(37, 0)}, "shift-line-left"), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, KeyStroke.getKeyStroke(39, 0)}, "shift-line-right"), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, goldKey, KeyStroke.getKeyStroke(155, 0)}, "find"), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, goldKey, KeyStroke.getKeyStroke(127, 0)}, resetAction), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, goldKey, KeyStroke.getKeyStroke(36, 0)}, undoDelWordAction), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, goldKey, KeyStroke.getKeyStroke(35, 0)}, topAction), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, goldKey, KeyStroke.getKeyStroke(33, 0)}, copyAction), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, goldKey, KeyStroke.getKeyStroke(34, 0)}, bottomAction), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, goldKey, KeyStroke.getKeyStroke(38, 0)}, previousWindowAction), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, goldKey, KeyStroke.getKeyStroke(40, 0)}, nextWindowAction), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, goldKey, KeyStroke.getKeyStroke(37, 0)}, "shift-line-left"), new MultiKeyBinding(new KeyStroke[]{goldKey, goldKey, goldKey, KeyStroke.getKeyStroke(39, 0)}, "shift-line-right")};
    }

    private static void initEdtkeypad() {
        if (debugTrace) {
            System.out.println("edt trace: initEdtkeypad");
        }
        Iterator itr = Registry.getComponentIterator();
        while (itr.hasNext()) {
            JTextComponent c = (JTextComponent)itr.next();
            EditorUI editorUI = Utilities.getEditorUI((JTextComponent)c);
            StatusBar sb = editorUI.getStatusBar();
            if (sb != null) {
                if (debugSB) {
                    System.out.println("sb ok 2");
                }
                if (sb.getCellByName(CELL_DIRECTION) == null) {
                    if (debugSB) {
                        System.out.println("init sbs: adding direction cell.  count is " + sb.getCellCount() + "visible = " + sb.isVisible());
                    }
                    sb.addCell(4, CELL_DIRECTION, new String[]{DIR_FORWARD, DIR_REVERSE}).setHorizontalAlignment(4);
                    if (debugSB) {
                        System.out.println("init sbs: added direction cell.  count is " + sb.getCellCount() + "visible = " + sb.isVisible());
                    }
                }
                sb.setText(CELL_DIRECTION, DIR_FORWARD);
            }
            if (!isJDK14 || isVms) continue;
            KeyListener keyListener = new KeyListener(){

                public void keyPressed(KeyEvent evt) {
                    ((JComponent)evt.getSource()).putClientProperty(KeyEvent.class, evt);
                }

                public void keyTyped(KeyEvent evt) {
                }

                public void keyReleased(KeyEvent evt) {
                }
            };
            c.addKeyListener(keyListener);
        }
        if (!isVms && System.getProperty("netbeans.edtkeypad.navigatePCkeys") == null) {
            doNavPCKeys = true;
        }
    }

    public static void main(String[] args) {
        EditorRegistry.addPropertyChangeListener((PropertyChangeListener)new EDTKitInstallAction());
        if (debugTrace) {
            System.out.println("edt trace: EDTInitializer main entered");
        }
        if (!isVms && !isJDK14 && System.getProperty("netbeans.edtkeypad.enable_for_windows_jdk13") == null) {
            if (debugTrace) {
                System.out.println("edt trace: windows requires Java2 SDK 1.4. good-bye");
            }
            return;
        }
        Settings.removeInitializer((String)NAME);
        Settings.addInitializer((Settings.Initializer)new EDTInitializer(), (int)4);
        Settings.reset();
        if (debugVerbose) {
            System.out.println(Settings.initializersToString());
        }
        if (debugStack) {
            new Throwable().printStackTrace();
        }
        if (debugTrace) {
            System.out.println("edt trace: EDTInitializer main completed");
        }
        if (debugTrace) {
            System.out.println("switches are: \ndebugVerbose=" + debugVerbose + " " + "debugCaret=" + debugCaret + " " + "debugStack=" + debugStack + '\n' + "isDecKeyboard=" + isDecKeyboard + " " + "isVms=" + isVms + " " + "isJDK14=" + isJDK14 + " " + "doNavPCKeys = " + doNavPCKeys);
        }
    }

    public static class EDTKitInstallAction
    extends BaseAction
    implements PropertyChangeListener {
        public EDTKitInstallAction() {
            super(EDTInitializer.edtKitInstallAction);
        }

        public void actionPerformed(ActionEvent evt, final JTextComponent target) {
            if (debugTrace) {
                System.out.println("edt trace: edtKitInstallAction");
            }
            if (debugSB) {
                System.out.println(evt.toString());
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (target == null) {
                        return;
                    }
                    EditorUI editorUI = Utilities.getEditorUI((JTextComponent)target);
                    StatusBar sb = editorUI.getStatusBar();
                    if (sb == null) {
                        return;
                    }
                    if (sb.getCellCount() == 0) {
                        return;
                    }
                    if (debugSB) {
                        System.out.println("sb ok 1");
                    }
                    if (sb.getCellByName(EDTInitializer.CELL_DIRECTION) == null) {
                        if (debugSB) {
                            System.out.println("SB dflt direction: adding direction cell. count is " + sb.getCellCount() + "visible = " + sb.isVisible());
                        }
                        sb.addCell(4, EDTInitializer.CELL_DIRECTION, new String[]{EDTInitializer.DIR_FORWARD, EDTInitializer.DIR_REVERSE}).setHorizontalAlignment(0);
                        if (debugSB) {
                            System.out.println("SB dflt direction: added direction cell. count is " + sb.getCellCount() + "visible = " + sb.isVisible());
                        }
                    }
                    sb.setText(EDTInitializer.CELL_DIRECTION, EDTInitializer.DIR_FORWARD);
                    KeyListener keyListener = new KeyListener(){

                        public void keyPressed(KeyEvent evt) {
                            ((JComponent)evt.getSource()).putClientProperty(KeyEvent.class, evt);
                        }

                        public void keyTyped(KeyEvent evt) {
                            if (debugVerbose) {
                                System.out.println("my keyTyped");
                            }
                        }

                        public void keyReleased(KeyEvent evt) {
                        }
                    };
                    target.addKeyListener(keyListener);
                    if (debugVerbose) {
                        System.out.println("key listener added");
                    }
                    if (debugTrace) {
                        System.out.println("end KIT_INSTALL action for new editorui");
                    }
                }
            });
        }

        public void propertyChange(PropertyChangeEvent evt) {
            final JTextComponent target = EditorRegistry.lastFocusedComponent();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (target == null) {
                        return;
                    }
                    EditorUI editorUI = Utilities.getEditorUI((JTextComponent)target);
                    if (editorUI == null) {
                        return;
                    }
                    StatusBar sb = editorUI.getStatusBar();
                    if (sb == null) {
                        return;
                    }
                    if (sb.getCellCount() == 0) {
                        return;
                    }
                    if (debugSB) {
                        System.out.println("sb ok 1");
                    }
                    if (sb.getCellByName(EDTInitializer.CELL_DIRECTION) == null) {
                        if (debugSB) {
                            System.out.println("SB dflt direction: adding direction cell. count is " + sb.getCellCount() + "visible = " + sb.isVisible());
                        }
                        sb.addCell(4, EDTInitializer.CELL_DIRECTION, new String[]{EDTInitializer.DIR_FORWARD, EDTInitializer.DIR_REVERSE}).setHorizontalAlignment(0);
                        if (debugSB) {
                            System.out.println("SB dflt direction: added direction cell. count is " + sb.getCellCount() + "visible = " + sb.isVisible());
                        }
                    }
                    sb.setText(EDTInitializer.CELL_DIRECTION, EDTInitializer.DIR_FORWARD);
                    KeyListener keyListener = new KeyListener(){

                        public void keyPressed(KeyEvent evt) {
                            ((JComponent)evt.getSource()).putClientProperty(KeyEvent.class, evt);
                        }

                        public void keyTyped(KeyEvent evt) {
                            if (debugVerbose) {
                                System.out.println("my keyTyped");
                            }
                        }

                        public void keyReleased(KeyEvent evt) {
                        }
                    };
                    target.addKeyListener(keyListener);
                    if (debugVerbose) {
                        System.out.println("key listener added");
                    }
                    if (debugTrace) {
                        System.out.println("end KIT_INSTALL action for new editorui");
                    }
                }
            });
        }
    }
}

