/*
 * Decompiled with CFR 0.152.
 */
package com.compaq.openvms.netbeans.edtkeypad;

import com.compaq.openvms.netbeans.edtkeypad.EDTInitializer;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.GuardedException;
import org.netbeans.editor.StatusBar;
import org.netbeans.editor.Utilities;
import org.openide.actions.NextTabAction;
import org.openide.actions.PreviousTabAction;
import org.openide.util.HelpCtx;
import org.openide.util.actions.CallbackSystemAction;

public class EDTCustomActions {
    public static final String IGNORE_NEXT = "flagIgnoreNext";
    protected static boolean bSelectionInProgress = false;
    protected static char[] lineBuffer = null;
    protected static char[] wordBuffer = null;
    protected static char[] charBuffer = null;

    public EDTCustomActions() {
        if (EDTInitializer.debugTrace) {
            System.out.println("edt trace: EDT CustomActions ctor");
        }
    }

    private static String getStatusBarDirection(JTextComponent target) {
        StatusBar sb;
        if (EDTInitializer.debugTrace) {
            System.out.println("edt trace: getStatusBarDirection");
        }
        if ((sb = Utilities.getEditorUI((JTextComponent)target).getStatusBar()) == null) {
            return "";
        }
        if (EDTInitializer.debugSB) {
            System.out.println("sb ok 3; get sb dir = " + sb.getText("direction"));
        }
        return sb.getText("direction");
    }

    private static void setStatusBarDirection(JTextComponent target, String strDirection) {
        if (EDTInitializer.debugTrace) {
            System.out.println("edt trace: setStatusBarDirection");
        }
        if (target == null) {
            return;
        }
        StatusBar sb = Utilities.getEditorUI((JTextComponent)target).getStatusBar();
        if (sb == null) {
            return;
        }
        if (sb.getCellCount() == 0) {
            return;
        }
        if (sb.getCellByName("direction") == null) {
            if (EDTInitializer.debugSB) {
                System.out.println("sb ok 4; set sb dir = unexpected adding direction cell");
            }
            sb.addCell(4, "direction", new String[]{"Forward", "Reverse"}).setHorizontalAlignment(4);
        }
        sb.setText("direction", strDirection);
        if (EDTInitializer.debugSB) {
            System.out.println("set sb dir = " + sb.getText("direction"));
        }
    }

    private static void ResetSelection(JTextComponent target) {
        if (EDTInitializer.debugVerbose) {
            System.out.println("deselecting");
        }
        bSelectionInProgress = false;
        if (target == null) {
            return;
        }
        Caret caret = target.getCaret();
        try {
            if (caret.isSelectionVisible()) {
                caret.setSelectionVisible(false);
            }
        }
        catch (Exception e) {
            target.getToolkit().beep();
        }
    }

    private static int findPrevFF(char[] chars, int offset, int len) {
        int idx = len - offset - 1;
        while (len > 0) {
            char ch;
            if ((ch = chars[idx--]) == '\f') {
                if (EDTInitializer.debugVerbose) {
                    System.out.println("findFF: found it. returning idx (offby1) = " + idx);
                }
                return idx + 1;
            }
            --len;
        }
        if (EDTInitializer.debugVerbose) {
            System.out.println("findFF: not found. idx=" + idx);
        }
        return -1;
    }

    private static int findNextFF(char[] chars, int offset, int len) {
        int idx = offset;
        while (len > 0) {
            char ch;
            if ((ch = chars[idx++]) == '\f') {
                if (EDTInitializer.debugVerbose) {
                    System.out.println("findFF: found it. returning idx (offby1) = " + idx);
                }
                return idx - 1;
            }
            --len;
        }
        if (EDTInitializer.debugVerbose) {
            System.out.println("findFF: not found. idx=" + idx);
        }
        return -1;
    }

    private static int getNextPageMark(JTextComponent target, int dotPos) throws BadLocationException {
        int docLen;
        if (EDTInitializer.debugTrace) {
            System.out.println("edt trace: getNextPageMark - dotpos = " + dotPos);
        }
        BaseDocument doc = Utilities.getDocument((JTextComponent)target);
        int bufSize = (Integer)doc.getProperty((Object)"read-buffer-size");
        char[] getBuf = new char[bufSize];
        int retval = docLen = doc.getLength();
        int newOffset = dotPos;
        int foundIdx = 0;
        int getLen = Math.min(bufSize, docLen - newOffset);
        if (EDTInitializer.debugCaret) {
            System.out.println("gnpm: getlen = " + getLen);
        }
        getBuf = doc.getChars(dotPos, getLen);
        if (EDTInitializer.debugCaret) {
            System.out.println("gnpm: b4 loop: textlength = " + getBuf.length + " dotpos = " + dotPos);
            if (getLen > 0) {
                System.out.println("gnpm  firstchar = " + getBuf[0]);
            }
        }
        while (getBuf.length > 0) {
            if (EDTInitializer.debugCaret) {
                System.out.println("gnpm: begin loop: len = " + getBuf.length);
            }
            if ((foundIdx = EDTCustomActions.findNextFF(getBuf, 0, getBuf.length)) != -1) {
                retval = newOffset + foundIdx + 1;
                if (!EDTInitializer.debugCaret) break;
                System.out.println("gnpm: leaving loop. found it. retval = " + retval);
                break;
            }
            foundIdx = 0;
            getLen = Math.min(bufSize, docLen - (newOffset += bufSize));
            if (getLen < 0) break;
            if (EDTInitializer.debugCaret) {
                System.out.println("getlen = " + getLen + " docLen = " + docLen + " newOffset = " + newOffset);
            }
            getBuf = doc.getChars(newOffset, getLen);
            if (!EDTInitializer.debugCaret) continue;
            System.out.println("gnpm: bottom loop: textlength = " + getBuf.length + " newOffset = " + newOffset + " firstchar = " + getBuf[0]);
        }
        if (EDTInitializer.debugCaret) {
            System.out.println("gnpm: after loop: foundIdx = " + foundIdx + " newOffset = " + newOffset + " retval =  " + retval);
        }
        return retval;
    }

    private static int getPreviousPageMark(JTextComponent target, int dotPos) throws BadLocationException {
        if (EDTInitializer.debugTrace) {
            System.out.println("edt trace: getPreviousPageMark - dotpos = " + dotPos);
        }
        BaseDocument doc = Utilities.getDocument((JTextComponent)target);
        int bufSize = (Integer)doc.getProperty((Object)"read-buffer-size");
        char[] getBuf = new char[bufSize];
        int retval = 0;
        int newOffset = dotPos;
        int foundIdx = 0;
        int getLen = Math.min(bufSize, newOffset);
        newOffset -= getLen;
        if (EDTInitializer.debugCaret) {
            System.out.println("gppm: b4 loop: getlen = " + getLen + " newOffset = " + newOffset);
        }
        getBuf = doc.getChars(newOffset, getLen);
        while (getBuf.length > 0) {
            if (EDTInitializer.debugCaret) {
                String str = new String(getBuf);
                System.out.println("gppm: looptop: Scanning string\n" + str.substring(0, Math.min(5, getLen)) + " [...] " + " len = " + getBuf.length);
            }
            if ((foundIdx = EDTCustomActions.findPrevFF(getBuf, 0, getBuf.length)) != -1) {
                retval = newOffset + foundIdx;
                if (!EDTInitializer.debugCaret) break;
                System.out.println("gppm: leaving loop. found it. retval = " + retval + "newoffset = " + newOffset + " foundIdx = " + foundIdx);
                break;
            }
            foundIdx = 0;
            getLen = Math.min(bufSize, newOffset);
            if (getLen < 0) break;
            getBuf = doc.getChars(newOffset -= getLen, getLen);
            if (!EDTInitializer.debugCaret) continue;
            System.out.println("gppm: loopbottom: getlen = " + getLen + " newOffset = " + newOffset);
        }
        if (EDTInitializer.debugCaret) {
            System.out.println("gppm: after loop: foundIdx = " + foundIdx + " newOffset = " + newOffset + " retval =  " + retval);
        }
        return retval;
    }

    public static class GoldEnterActionJ14
    extends BaseAction {
        public GoldEnterActionJ14() {
            super("edt-gold-enter-j14");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: GoldEnterActionJ14");
            }
            KeyEvent kevt = (KeyEvent)target.getClientProperty(KeyEvent.class);
            int keyLoc = kevt.getKeyLocation();
            if (EDTInitializer.debugVerbose) {
                System.out.println("keyLoc = " + (keyLoc == 4 ? " numpad" : " standard"));
            }
            Action a = null;
            if (keyLoc == 4) {
                a = Utilities.getKit((JTextComponent)target).getActionByName("edt-subst");
            }
            if (a != null) {
                a.actionPerformed(evt);
            }
        }
    }

    public static class GoldDeleteActionJ14
    extends BaseAction {
        public GoldDeleteActionJ14() {
            super("edt-gold-delete-j14");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: GoldDeleteActionJ14");
            }
            KeyEvent kevt = (KeyEvent)target.getClientProperty(KeyEvent.class);
            int keyLoc = kevt.getKeyLocation();
            if (EDTInitializer.debugVerbose) {
                System.out.println("keyLoc = " + (keyLoc == 4 ? " numpad" : " standard"));
            }
            Action a = null;
            if (keyLoc == 4) {
                a = Utilities.getKit((JTextComponent)target).getActionByName("edt-reset");
            } else if (!EDTInitializer.doNavPCKeys) {
                a = Utilities.getKit((JTextComponent)target).getActionByName("edt-reset");
            }
            if (a != null) {
                a.actionPerformed(evt);
            }
        }
    }

    public static class GoldInsertActionJ14
    extends BaseAction {
        public GoldInsertActionJ14() {
            super("edt-gold-insert-j14");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: GoldinsertActionJ14");
            }
            KeyEvent kevt = (KeyEvent)target.getClientProperty(KeyEvent.class);
            int keyLoc = kevt.getKeyLocation();
            if (EDTInitializer.debugVerbose) {
                System.out.println("keyLoc = " + (keyLoc == 4 ? " numpad" : " standard"));
            }
            Action a = null;
            if (keyLoc == 4) {
                a = Utilities.getKit((JTextComponent)target).getActionByName("edt-openline");
            } else if (!EDTInitializer.doNavPCKeys) {
                a = Utilities.getKit((JTextComponent)target).getActionByName("find");
            }
            if (a != null) {
                a.actionPerformed(evt);
            }
        }
    }

    public static class GoldEndActionJ14
    extends BaseAction {
        public GoldEndActionJ14() {
            super("edt-gold-end-j14");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: GoldendActionJ14");
            }
            KeyEvent kevt = (KeyEvent)target.getClientProperty(KeyEvent.class);
            int keyLoc = kevt.getKeyLocation();
            if (EDTInitializer.debugVerbose) {
                System.out.println("keyLoc = " + (keyLoc == 4 ? " numpad" : " standard"));
            }
            Action a = null;
            if (keyLoc == 4) {
                a = Utilities.getKit((JTextComponent)target).getActionByName("edt-change-case");
            } else if (!EDTInitializer.doNavPCKeys) {
                a = Utilities.getKit((JTextComponent)target).getActionByName("edt-begin");
            }
            if (a != null) {
                a.actionPerformed(evt);
            }
        }
    }

    public static class GoldHomeActionJ14
    extends BaseAction {
        public GoldHomeActionJ14() {
            super("edt-gold-home-j14");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: GoldhomeActionJ14");
            }
            KeyEvent kevt = (KeyEvent)target.getClientProperty(KeyEvent.class);
            int keyLoc = kevt.getKeyLocation();
            if (EDTInitializer.debugVerbose) {
                System.out.println("keyLoc = " + (keyLoc == 4 ? " numpad" : " standard"));
            }
            Action a = null;
            if (keyLoc == 4) {
                return;
            }
            if (!EDTInitializer.doNavPCKeys) {
                a = Utilities.getKit((JTextComponent)target).getActionByName("paste-from-clipboard");
            }
            if (a != null) {
                a.actionPerformed(evt);
            }
        }
    }

    public static class GoldPageDownActionJ14
    extends BaseAction {
        public GoldPageDownActionJ14() {
            super("edt-gold-pgdown-j14");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: GoldpageDownActionJ14");
            }
            KeyEvent kevt = (KeyEvent)target.getClientProperty(KeyEvent.class);
            int keyLoc = kevt.getKeyLocation();
            if (EDTInitializer.debugVerbose) {
                System.out.println("keyLoc = " + (keyLoc == 4 ? " numpad" : " standard"));
            }
            Action a = null;
            if (keyLoc == 4) {
                return;
            }
            if (!EDTInitializer.doNavPCKeys) {
                a = Utilities.getKit((JTextComponent)target).getActionByName("edt-end");
            }
            if (a != null) {
                a.actionPerformed(evt);
            }
        }
    }

    public static class GoldPageUpActionJ14
    extends BaseAction {
        public GoldPageUpActionJ14() {
            super("edt-gold-pgup-j14");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: GoldpageUpActionJ14");
            }
            KeyEvent kevt = (KeyEvent)target.getClientProperty(KeyEvent.class);
            int keyLoc = kevt.getKeyLocation();
            if (EDTInitializer.debugVerbose) {
                System.out.println("keyLoc = " + (keyLoc == 4 ? " numpad" : " standard"));
            }
            Action a = null;
            if (keyLoc == 4) {
                a = Utilities.getKit((JTextComponent)target).getActionByName("edt-cut-replace");
            } else if (!EDTInitializer.doNavPCKeys) {
                a = Utilities.getKit((JTextComponent)target).getActionByName("edt-copy");
            }
            if (a != null) {
                a.actionPerformed(evt);
            }
        }
    }

    public static class GoldDownArrowActionJ14
    extends BaseAction {
        public GoldDownArrowActionJ14() {
            super("edt-gold-down-j14");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: GoldDownArrowActionJ14");
            }
            KeyEvent kevt = (KeyEvent)target.getClientProperty(KeyEvent.class);
            int keyLoc = kevt.getKeyLocation();
            if (EDTInitializer.debugVerbose) {
                System.out.println("keyLoc = " + (keyLoc == 4 ? " numpad" : " standard"));
            }
            Action a = keyLoc == 4 ? Utilities.getKit((JTextComponent)target).getActionByName("edt-del-eol") : Utilities.getKit((JTextComponent)target).getActionByName("edt-next-window");
            a.actionPerformed(evt);
        }
    }

    public static class GoldUpArrowActionJ14
    extends BaseAction {
        public GoldUpArrowActionJ14() {
            super("edt-gold-up-j14");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: GoldUpArrowActionJ14");
            }
            KeyEvent kevt = (KeyEvent)target.getClientProperty(KeyEvent.class);
            int keyLoc = kevt.getKeyLocation();
            if (EDTInitializer.debugVerbose) {
                System.out.println("keyLoc = " + (keyLoc == 4 ? " numpad" : " standard"));
            }
            if (keyLoc == 4) {
                return;
            }
            Action a = Utilities.getKit((JTextComponent)target).getActionByName("edt-prev-window");
            a.actionPerformed(evt);
        }
    }

    public static class GoldLeftArrowActionJ14
    extends BaseAction {
        public GoldLeftArrowActionJ14() {
            super("edt-gold-left-j14");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: GoldLeftArrowActionJ14");
            }
            KeyEvent kevt = (KeyEvent)target.getClientProperty(KeyEvent.class);
            int keyLoc = kevt.getKeyLocation();
            if (EDTInitializer.debugVerbose) {
                System.out.println("keyLoc = " + (keyLoc == 4 ? " numpad" : " standard"));
            }
            Action a = keyLoc == 4 ? Utilities.getKit((JTextComponent)target).getActionByName("edt-end") : Utilities.getKit((JTextComponent)target).getActionByName("shift-line-left");
            a.actionPerformed(evt);
        }
    }

    public static class GoldRightArrowActionJ14
    extends BaseAction {
        public GoldRightArrowActionJ14() {
            super("edt-gold-right-j14");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: GoldRightArrowActionJ14");
            }
            KeyEvent kevt = (KeyEvent)target.getClientProperty(KeyEvent.class);
            int keyLoc = kevt.getKeyLocation();
            if (EDTInitializer.debugVerbose) {
                System.out.println("keyLoc = " + (keyLoc == 4 ? " numpad" : " standard"));
            }
            Action a = keyLoc == 4 ? Utilities.getKit((JTextComponent)target).getActionByName("paste-from-clipboard") : Utilities.getKit((JTextComponent)target).getActionByName("shift-line-right");
            a.actionPerformed(evt);
        }
    }

    public static class DeleteActionJ14
    extends BaseAction {
        public DeleteActionJ14() {
            super("edt-delete-j14");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: deleteActionJ14");
            }
            KeyEvent kevt = (KeyEvent)target.getClientProperty(KeyEvent.class);
            int keyLoc = kevt.getKeyLocation();
            if (EDTInitializer.debugVerbose) {
                System.out.println("keyLoc = " + (keyLoc == 4 ? " numpad" : " standard"));
            }
            Action a = keyLoc == 4 ? Utilities.getKit((JTextComponent)target).getActionByName("edt-select") : (EDTInitializer.doNavPCKeys ? Utilities.getKit((JTextComponent)target).getActionByName("delete-next") : Utilities.getKit((JTextComponent)target).getActionByName("edt-select-toggle"));
            a.actionPerformed(evt);
        }
    }

    public static class InsertActionJ14
    extends BaseAction {
        public InsertActionJ14() {
            super("edt-insert-j14");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: insertActionJ14");
            }
            KeyEvent kevt = (KeyEvent)target.getClientProperty(KeyEvent.class);
            int keyLoc = kevt.getKeyLocation();
            if (EDTInitializer.debugVerbose) {
                System.out.println("keyLoc = " + (keyLoc == 4 ? " numpad" : " standard"));
            }
            Action a = keyLoc == 4 ? Utilities.getKit((JTextComponent)target).getActionByName("edt-line") : (EDTInitializer.doNavPCKeys ? Utilities.getKit((JTextComponent)target).getActionByName("toggle-typing-mode") : Utilities.getKit((JTextComponent)target).getActionByName("edt-find-action"));
            a.actionPerformed(evt);
        }
    }

    public static class EndActionJ14
    extends BaseAction {
        public EndActionJ14() {
            super("edt-end-j14");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: endActionJ14");
            }
            KeyEvent kevt = (KeyEvent)target.getClientProperty(KeyEvent.class);
            int keyLoc = kevt.getKeyLocation();
            if (EDTInitializer.debugVerbose) {
                System.out.println("keyLoc = " + (keyLoc == 4 ? " numpad" : " standard"));
            }
            Action a = keyLoc == 4 ? Utilities.getKit((JTextComponent)target).getActionByName("edt-word") : (EDTInitializer.doNavPCKeys ? Utilities.getKit((JTextComponent)target).getActionByName("edt-endline") : Utilities.getKit((JTextComponent)target).getActionByName("edt-prev"));
            a.actionPerformed(evt);
        }
    }

    public static class HomeActionJ14
    extends BaseAction {
        public HomeActionJ14() {
            super("edt-home-j14");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: homeActionJ14");
            }
            KeyEvent kevt = (KeyEvent)target.getClientProperty(KeyEvent.class);
            int keyLoc = kevt.getKeyLocation();
            if (EDTInitializer.debugVerbose) {
                System.out.println("keyLoc = " + (keyLoc == 4 ? " numpad" : " standard"));
            }
            Action a = keyLoc == 4 ? Utilities.getKit((JTextComponent)target).getActionByName("edt-page") : (EDTInitializer.doNavPCKeys ? Utilities.getKit((JTextComponent)target).getActionByName("edt-begline") : Utilities.getKit((JTextComponent)target).getActionByName("paste-from-clipboard"));
            a.actionPerformed(evt);
        }
    }

    public static class PageDownActionJ14
    extends BaseAction {
        public PageDownActionJ14() {
            super("edt-pgdown-j14");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: pageDownActionJ14");
            }
            KeyEvent kevt = (KeyEvent)target.getClientProperty(KeyEvent.class);
            int keyLoc = kevt.getKeyLocation();
            if (EDTInitializer.debugVerbose) {
                System.out.println("keyLoc = " + (keyLoc == 4 ? " numpad" : " standard"));
            }
            Action a = keyLoc == 4 ? Utilities.getKit((JTextComponent)target).getActionByName("edt-char") : Utilities.getKit((JTextComponent)target).getActionByName("edt-next");
            a.actionPerformed(evt);
        }
    }

    public static class PageUpActionJ14
    extends BaseAction {
        public PageUpActionJ14() {
            super("edt-pgup-j14");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: pageUpActionJ14");
            }
            KeyEvent kevt = (KeyEvent)target.getClientProperty(KeyEvent.class);
            int keyLoc = kevt.getKeyLocation();
            if (EDTInitializer.debugVerbose) {
                System.out.println("keyLoc = " + (keyLoc == 4 ? " numpad" : " standard"));
            }
            Action a = keyLoc == 4 ? Utilities.getKit((JTextComponent)target).getActionByName("edt-cut-append") : (EDTInitializer.doNavPCKeys ? Utilities.getKit((JTextComponent)target).getActionByName("edt-prev") : Utilities.getKit((JTextComponent)target).getActionByName("edt-cut"));
            a.actionPerformed(evt);
        }
    }

    public static class DownArrowActionJ14
    extends BaseAction {
        public DownArrowActionJ14() {
            super("edt-down-j14");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: DownArrowActionJ14");
            }
            KeyEvent kevt = (KeyEvent)target.getClientProperty(KeyEvent.class);
            int keyLoc = kevt.getKeyLocation();
            if (EDTInitializer.debugVerbose) {
                System.out.println("keyLoc = " + (keyLoc == 4 ? " numpad" : " standard"));
            }
            Action a = keyLoc == 4 ? Utilities.getKit((JTextComponent)target).getActionByName("edt-eol") : Utilities.getKit((JTextComponent)target).getActionByName("edt-down");
            a.actionPerformed(evt);
        }
    }

    public static class UpArrowActionJ14
    extends BaseAction {
        public UpArrowActionJ14() {
            super("edt-up-j14");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: UpArrowActionJ14");
            }
            KeyEvent kevt = (KeyEvent)target.getClientProperty(KeyEvent.class);
            int keyLoc = kevt.getKeyLocation();
            if (EDTInitializer.debugVerbose) {
                System.out.println("keyLoc = " + (keyLoc == 4 ? " numpad" : " standard"));
            }
            Action a = keyLoc == 4 ? Utilities.getKit((JTextComponent)target).getActionByName("edt-section") : Utilities.getKit((JTextComponent)target).getActionByName("edt-up");
            a.actionPerformed(evt);
        }
    }

    public static class LeftArrowActionJ14
    extends BaseAction {
        public LeftArrowActionJ14() {
            super("edt-left-j14");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: LeftArrowActionJ14");
            }
            KeyEvent kevt = (KeyEvent)target.getClientProperty(KeyEvent.class);
            int keyLoc = kevt.getKeyLocation();
            if (EDTInitializer.debugVerbose) {
                System.out.println("keyLoc = " + (keyLoc == 4 ? " numpad" : " standard"));
            }
            Action a = keyLoc == 4 ? Utilities.getKit((JTextComponent)target).getActionByName("edt-advance") : Utilities.getKit((JTextComponent)target).getActionByName("edt-left");
            a.actionPerformed(evt);
        }
    }

    public static class RightArrowActionJ14
    extends BaseAction {
        public RightArrowActionJ14() {
            super("edt-right-j14");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: RightArrowActionJ14");
            }
            KeyEvent kevt = (KeyEvent)target.getClientProperty(KeyEvent.class);
            int keyLoc = kevt.getKeyLocation();
            if (EDTInitializer.debugVerbose) {
                System.out.println("keyLoc = " + (keyLoc == 4 ? " numpad" : " standard"));
            }
            Action a = keyLoc == 4 ? Utilities.getKit((JTextComponent)target).getActionByName("edt-cut") : Utilities.getKit((JTextComponent)target).getActionByName("edt-right");
            a.actionPerformed(evt);
        }
    }

    public static class KeyCommaTypedAction
    extends BaseAction {
        public KeyCommaTypedAction() {
            super("edt-key-comma-typed");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: KeyCommaTypedAction");
            }
            evt = new ActionEvent(evt.getSource(), evt.getID(), ",");
            Boolean b = (Boolean)this.getValue(EDTCustomActions.IGNORE_NEXT);
            if (EDTInitializer.debugVerbose) {
                System.out.println("ignore flag = " + b);
            }
            if (b != null && b.booleanValue()) {
                this.putValue(EDTCustomActions.IGNORE_NEXT, Boolean.FALSE);
                return;
            }
            BaseKit kit = Utilities.getKit((JTextComponent)target);
            Action a = kit.getActionByName("default-typed");
            a.actionPerformed(evt);
        }
    }

    public static class KeyDecTypedAction
    extends BaseAction {
        public KeyDecTypedAction() {
            super("edt-key-dec-typed");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: KeyDecTypedAction");
            }
            evt = new ActionEvent(evt.getSource(), evt.getID(), ".");
            Boolean b = (Boolean)this.getValue(EDTCustomActions.IGNORE_NEXT);
            if (b != null && b.booleanValue()) {
                this.putValue(EDTCustomActions.IGNORE_NEXT, Boolean.FALSE);
                return;
            }
            BaseKit kit = Utilities.getKit((JTextComponent)target);
            Action a = kit.getActionByName("default-typed");
            a.actionPerformed(evt);
        }
    }

    public static class KeyPlusTypedAction
    extends BaseAction {
        public KeyPlusTypedAction() {
            super("edt-key-plus-typed");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: KeyPlusTypedAction");
            }
            evt = new ActionEvent(evt.getSource(), evt.getID(), "+");
            Boolean b = (Boolean)this.getValue(EDTCustomActions.IGNORE_NEXT);
            if (EDTInitializer.debugVerbose) {
                System.out.println("ignore flag = " + b);
            }
            if (b != null && b.booleanValue()) {
                this.putValue(EDTCustomActions.IGNORE_NEXT, Boolean.FALSE);
                return;
            }
            BaseKit kit = Utilities.getKit((JTextComponent)target);
            Action a = kit.getActionByName("default-typed");
            a.actionPerformed(evt);
        }
    }

    public static class KeySubtTypedAction
    extends BaseAction {
        public KeySubtTypedAction() {
            super("edt-key-subt-typed");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: KeySubtTypedAction");
            }
            evt = new ActionEvent(evt.getSource(), evt.getID(), "-");
            Boolean b = (Boolean)this.getValue(EDTCustomActions.IGNORE_NEXT);
            if (EDTInitializer.debugVerbose) {
                System.out.println("ignore flag = " + b);
            }
            if (b != null && b.booleanValue()) {
                this.putValue(EDTCustomActions.IGNORE_NEXT, Boolean.FALSE);
                return;
            }
            BaseKit kit = Utilities.getKit((JTextComponent)target);
            Action a = kit.getActionByName("default-typed");
            a.actionPerformed(evt);
        }
    }

    public static class KeyMultTypedAction
    extends BaseAction {
        public KeyMultTypedAction() {
            super("edt-key-mult-typed");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: KeyMultTypedAction");
            }
            evt = new ActionEvent(evt.getSource(), evt.getID(), "*");
            Boolean b = (Boolean)this.getValue(EDTCustomActions.IGNORE_NEXT);
            if (EDTInitializer.debugVerbose && b == null) {
                System.out.println("flag is null");
            }
            if (b != null && b.booleanValue()) {
                if (EDTInitializer.debugVerbose) {
                    System.out.println("flag = " + b);
                }
                this.putValue(EDTCustomActions.IGNORE_NEXT, Boolean.FALSE);
                return;
            }
            BaseKit kit = Utilities.getKit((JTextComponent)target);
            Action a = kit.getActionByName("default-typed");
            a.actionPerformed(evt);
        }
    }

    public static class KeyDivTypedAction
    extends BaseAction {
        public KeyDivTypedAction() {
            super("edt-key-div-typed");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: KeyDivTypedAction");
            }
            evt = new ActionEvent(evt.getSource(), evt.getID(), "/");
            Boolean b = (Boolean)this.getValue(EDTCustomActions.IGNORE_NEXT);
            if (b != null && b.booleanValue()) {
                this.putValue(EDTCustomActions.IGNORE_NEXT, Boolean.FALSE);
                if (EDTInitializer.debugVerbose) {
                    System.out.println("IGNORE_NEXT was true. returning.");
                }
                return;
            }
            if (EDTInitializer.debugVerbose) {
                System.out.println("IGNORE NEXT was not true: ");
                if (b == null) {
                    System.out.println("b was null");
                }
            }
            BaseKit kit = Utilities.getKit((JTextComponent)target);
            if (EDTInitializer.debugTrace) {
                System.out.println(kit.getClass().getName());
            }
            Action a = kit.getActionByName("default-typed");
            a.actionPerformed(evt);
        }
    }

    public static class Num9TypedAction
    extends BaseAction {
        public Num9TypedAction() {
            super("edt-num9-typed");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: Num9TypedAction");
            }
            evt = new ActionEvent(evt.getSource(), evt.getID(), "9");
            Boolean b = (Boolean)this.getValue(EDTCustomActions.IGNORE_NEXT);
            if (b != null && b.booleanValue()) {
                this.putValue(EDTCustomActions.IGNORE_NEXT, Boolean.FALSE);
                return;
            }
            BaseKit kit = Utilities.getKit((JTextComponent)target);
            Action a = kit.getActionByName("default-typed");
            a.actionPerformed(evt);
        }
    }

    public static class Num8TypedAction
    extends BaseAction {
        public Num8TypedAction() {
            super("edt-num8-typed");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: Num8TypedAction");
            }
            evt = new ActionEvent(evt.getSource(), evt.getID(), "8");
            Boolean b = (Boolean)this.getValue(EDTCustomActions.IGNORE_NEXT);
            if (b != null && b.booleanValue()) {
                this.putValue(EDTCustomActions.IGNORE_NEXT, Boolean.FALSE);
                return;
            }
            BaseKit kit = Utilities.getKit((JTextComponent)target);
            Action a = kit.getActionByName("default-typed");
            a.actionPerformed(evt);
        }
    }

    public static class Num7TypedAction
    extends BaseAction {
        public Num7TypedAction() {
            super("edt-num7-typed");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: Num7TypedAction");
            }
            evt = new ActionEvent(evt.getSource(), evt.getID(), "7");
            Boolean b = (Boolean)this.getValue(EDTCustomActions.IGNORE_NEXT);
            if (b != null && b.booleanValue()) {
                this.putValue(EDTCustomActions.IGNORE_NEXT, Boolean.FALSE);
                return;
            }
            BaseKit kit = Utilities.getKit((JTextComponent)target);
            Action a = kit.getActionByName("default-typed");
            a.actionPerformed(evt);
        }
    }

    public static class Num6TypedAction
    extends BaseAction {
        public Num6TypedAction() {
            super("edt-num6-typed");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: Num6TypedAction");
            }
            evt = new ActionEvent(evt.getSource(), evt.getID(), "6");
            Boolean b = (Boolean)this.getValue(EDTCustomActions.IGNORE_NEXT);
            if (b != null && b.booleanValue()) {
                this.putValue(EDTCustomActions.IGNORE_NEXT, Boolean.FALSE);
                return;
            }
            BaseKit kit = Utilities.getKit((JTextComponent)target);
            Action a = kit.getActionByName("default-typed");
            a.actionPerformed(evt);
        }
    }

    public static class Num5TypedAction
    extends BaseAction {
        public Num5TypedAction() {
            super("edt-num5-typed");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: Num5TypedAction");
            }
            evt = new ActionEvent(evt.getSource(), evt.getID(), "5");
            Boolean b = (Boolean)this.getValue(EDTCustomActions.IGNORE_NEXT);
            if (b != null && b.booleanValue()) {
                this.putValue(EDTCustomActions.IGNORE_NEXT, Boolean.FALSE);
                return;
            }
            BaseKit kit = Utilities.getKit((JTextComponent)target);
            Action a = kit.getActionByName("default-typed");
            a.actionPerformed(evt);
        }
    }

    public static class Num4TypedAction
    extends BaseAction {
        public Num4TypedAction() {
            super("edt-num4-typed");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: Num4TypedAction");
            }
            evt = new ActionEvent(evt.getSource(), evt.getID(), "4");
            Boolean b = (Boolean)this.getValue(EDTCustomActions.IGNORE_NEXT);
            if (b != null && b.booleanValue()) {
                this.putValue(EDTCustomActions.IGNORE_NEXT, Boolean.FALSE);
                return;
            }
            BaseKit kit = Utilities.getKit((JTextComponent)target);
            Action a = kit.getActionByName("default-typed");
            a.actionPerformed(evt);
        }
    }

    public static class Num3TypedAction
    extends BaseAction {
        public Num3TypedAction() {
            super("edt-num3-typed");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: Num3TypedAction");
            }
            evt = new ActionEvent(evt.getSource(), evt.getID(), "3");
            Boolean b = (Boolean)this.getValue(EDTCustomActions.IGNORE_NEXT);
            if (b != null && b.booleanValue()) {
                this.putValue(EDTCustomActions.IGNORE_NEXT, Boolean.FALSE);
                return;
            }
            BaseKit kit = Utilities.getKit((JTextComponent)target);
            Action a = kit.getActionByName("default-typed");
            a.actionPerformed(evt);
        }
    }

    public static class Num2TypedAction
    extends BaseAction {
        public Num2TypedAction() {
            super("edt-num2-typed");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: Num2TypedAction");
            }
            evt = new ActionEvent(evt.getSource(), evt.getID(), "2");
            Boolean b = (Boolean)this.getValue(EDTCustomActions.IGNORE_NEXT);
            if (b != null && b.booleanValue()) {
                this.putValue(EDTCustomActions.IGNORE_NEXT, Boolean.FALSE);
                return;
            }
            BaseKit kit = Utilities.getKit((JTextComponent)target);
            Action a = kit.getActionByName("default-typed");
            a.actionPerformed(evt);
        }
    }

    public static class Num1TypedAction
    extends BaseAction {
        public Num1TypedAction() {
            super("edt-num1-typed");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: Num1TypedAction");
            }
            evt = new ActionEvent(evt.getSource(), evt.getID(), "1");
            Boolean b = (Boolean)this.getValue(EDTCustomActions.IGNORE_NEXT);
            if (b != null && b.booleanValue()) {
                this.putValue(EDTCustomActions.IGNORE_NEXT, Boolean.FALSE);
                return;
            }
            BaseKit kit = Utilities.getKit((JTextComponent)target);
            Action a = kit.getActionByName("default-typed");
            a.actionPerformed(evt);
        }
    }

    public static class Num0TypedAction
    extends BaseAction {
        public Num0TypedAction() {
            super("edt-num0-typed");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: Num0TypedAction");
            }
            evt = new ActionEvent(evt.getSource(), evt.getID(), "0");
            Boolean b = (Boolean)this.getValue(EDTCustomActions.IGNORE_NEXT);
            if (b == null && EDTInitializer.debugVerbose) {
                System.out.println("flag not found");
            }
            if (b != null && b.booleanValue()) {
                this.putValue(EDTCustomActions.IGNORE_NEXT, Boolean.FALSE);
                return;
            }
            BaseKit kit = Utilities.getKit((JTextComponent)target);
            Action a = kit.getActionByName("default-typed");
            a.actionPerformed(evt);
        }
    }

    public static class CutActionNL
    extends BaseAction {
        public CutActionNL() {
            super("edt-cut-nl");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            try {
                if (EDTInitializer.debugTrace) {
                    System.out.println("edt trace: CutActionNL");
                }
                Action a = Utilities.getKit((JTextComponent)target).getActionByName("cut-to-clipboard");
                a.actionPerformed(evt);
                EDTCustomActions.ResetSelection(target);
            }
            catch (Exception ex) {
                target.getToolkit().beep();
            }
            Keymap km = target.getKeymap();
            Action kta = null;
            if (km != null) {
                kta = km.getAction(KeyStroke.getKeyStroke('6'));
            }
            if (kta != null) {
                kta.putValue(EDTCustomActions.IGNORE_NEXT, Boolean.TRUE);
            }
        }
    }

    public static class StartRangeActionNL
    extends BaseAction {
        public StartRangeActionNL() {
            super("edt-select-nl");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            try {
                if (EDTInitializer.debugTrace) {
                    System.out.println("edt trace: StartRangeActionNL");
                }
                Action a = Utilities.getKit((JTextComponent)target).getActionByName("edt-select");
                a.actionPerformed(evt);
            }
            catch (Exception ex) {
                target.getToolkit().beep();
            }
            Keymap km = target.getKeymap();
            Action kta = null;
            if (km != null) {
                kta = km.getAction(KeyStroke.getKeyStroke('.'));
            }
            if (kta != null) {
                kta.putValue(EDTCustomActions.IGNORE_NEXT, Boolean.TRUE);
            }
        }
    }

    public static class CutAppendActionNL
    extends BaseAction {
        public CutAppendActionNL() {
            super("edt-cut-append-nl");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            try {
                if (EDTInitializer.debugTrace) {
                    System.out.println("edt trace: CutAppendActionNL");
                }
                Action a = Utilities.getKit((JTextComponent)target).getActionByName("edt-cut-append");
                a.actionPerformed(evt);
            }
            catch (Exception ex) {
                target.getToolkit().beep();
            }
            Keymap km = target.getKeymap();
            Action kta = null;
            if (km != null) {
                kta = km.getAction(KeyStroke.getKeyStroke('9'));
            }
            if (kta != null) {
                kta.putValue(EDTCustomActions.IGNORE_NEXT, Boolean.TRUE);
            }
        }
    }

    public static class SectionActionNL
    extends BaseAction {
        public SectionActionNL() {
            super("edt-section-nl");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            try {
                if (EDTInitializer.debugTrace) {
                    System.out.println("edt trace: SectionActionNL");
                }
                Action a = Utilities.getKit((JTextComponent)target).getActionByName("edt-section");
                a.actionPerformed(evt);
            }
            catch (Exception ex) {
                target.getToolkit().beep();
            }
            Keymap km = target.getKeymap();
            Action kta = null;
            if (km != null) {
                kta = km.getAction(KeyStroke.getKeyStroke('8'));
            }
            if (kta != null) {
                kta.putValue(EDTCustomActions.IGNORE_NEXT, Boolean.TRUE);
            }
        }
    }

    public static class PageActionNL
    extends BaseAction {
        public PageActionNL() {
            super("edt-page-nl");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            try {
                if (EDTInitializer.debugTrace) {
                    System.out.println("edt trace: PageActionNL");
                }
                Action a = Utilities.getKit((JTextComponent)target).getActionByName("edt-page");
                a.actionPerformed(evt);
            }
            catch (Exception ex) {
                target.getToolkit().beep();
            }
            Keymap km = target.getKeymap();
            Action kta = null;
            if (km != null) {
                kta = km.getAction(KeyStroke.getKeyStroke('7'));
            }
            if (kta != null) {
                kta.putValue(EDTCustomActions.IGNORE_NEXT, Boolean.TRUE);
            }
        }
    }

    public static class ForwardDirectionActionNL
    extends BaseAction {
        public ForwardDirectionActionNL() {
            super("edt-advance-nl");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            try {
                if (EDTInitializer.debugTrace) {
                    System.out.println("edt trace: ForwardDirectionActionNL");
                }
                Action a = Utilities.getKit((JTextComponent)target).getActionByName("edt-advance");
                a.actionPerformed(evt);
            }
            catch (Exception ex) {
                target.getToolkit().beep();
            }
            Keymap km = target.getKeymap();
            Action kta = null;
            if (km != null) {
                kta = km.getAction(KeyStroke.getKeyStroke('4'));
            }
            if (kta != null) {
                kta.putValue(EDTCustomActions.IGNORE_NEXT, Boolean.TRUE);
            }
        }
    }

    public static class ReverseDirectionActionNL
    extends BaseAction {
        public ReverseDirectionActionNL() {
            super("edt-reverse-nl");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            try {
                if (EDTInitializer.debugTrace) {
                    System.out.println("edt trace: ReverseDirectionActionNL");
                }
                Action a = Utilities.getKit((JTextComponent)target).getActionByName("edt-reverse");
                a.actionPerformed(evt);
            }
            catch (Exception ex) {
                target.getToolkit().beep();
            }
            Keymap km = target.getKeymap();
            Action kta = null;
            if (km != null) {
                kta = km.getAction(KeyStroke.getKeyStroke('5'));
            }
            if (kta != null) {
                kta.putValue(EDTCustomActions.IGNORE_NEXT, Boolean.TRUE);
            }
        }
    }

    public static class CharActionNL
    extends BaseAction {
        public CharActionNL() {
            super("edt-char-nl");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            try {
                if (EDTInitializer.debugTrace) {
                    System.out.println("edt trace: CharActionNL");
                }
                Action a = Utilities.getKit((JTextComponent)target).getActionByName("edt-char");
                a.actionPerformed(evt);
            }
            catch (Exception ex) {
                target.getToolkit().beep();
            }
            Keymap km = target.getKeymap();
            Action kta = null;
            if (km != null) {
                kta = km.getAction(KeyStroke.getKeyStroke('3'));
            }
            if (kta != null) {
                kta.putValue(EDTCustomActions.IGNORE_NEXT, Boolean.TRUE);
            }
        }
    }

    public static class EolActionNL
    extends BaseAction {
        public EolActionNL() {
            super("edt-eol-nl");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            try {
                if (EDTInitializer.debugTrace) {
                    System.out.println("edt trace: EolActionNL");
                }
                Action a = Utilities.getKit((JTextComponent)target).getActionByName("edt-eol");
                a.actionPerformed(evt);
            }
            catch (Exception ex) {
                target.getToolkit().beep();
            }
            Keymap km = target.getKeymap();
            Action kta = null;
            if (km != null) {
                kta = km.getAction(KeyStroke.getKeyStroke('2'));
            }
            if (kta != null) {
                kta.putValue(EDTCustomActions.IGNORE_NEXT, Boolean.TRUE);
            }
        }
    }

    public static class WordActionNL
    extends BaseAction {
        public WordActionNL() {
            super("edt-word-nl");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: WordActionNL");
            }
            try {
                Action a = Utilities.getKit((JTextComponent)target).getActionByName("edt-word");
                a.actionPerformed(evt);
            }
            catch (Exception ex) {
                target.getToolkit().beep();
            }
            Keymap km = target.getKeymap();
            Action kta = null;
            if (km != null) {
                kta = km.getAction(KeyStroke.getKeyStroke('1'));
            }
            if (kta != null) {
                kta.putValue(EDTCustomActions.IGNORE_NEXT, Boolean.TRUE);
            }
        }
    }

    public static class LineActionNL
    extends BaseAction {
        public LineActionNL() {
            super("edt-line-nl");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            try {
                if (EDTInitializer.debugTrace) {
                    System.out.println("edt trace: LineActionNL");
                }
                Action a = Utilities.getKit((JTextComponent)target).getActionByName("edt-line");
                a.actionPerformed(evt);
            }
            catch (Exception ex) {
                target.getToolkit().beep();
            }
            Keymap km = target.getKeymap();
            Action kta = null;
            if (km != null) {
                kta = km.getAction(KeyStroke.getKeyStroke('0'));
            } else if (EDTInitializer.debugVerbose) {
                System.out.println("edt: km was null");
            }
            if (kta != null) {
                kta.putValue(EDTCustomActions.IGNORE_NEXT, Boolean.TRUE);
            } else if (EDTInitializer.debugVerbose) {
                System.out.println("edt: action was null, flag not set");
            }
        }
    }

    public static class CopyAction
    extends BaseAction {
        public CopyAction() {
            super("edt-copy");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: CopyAction");
            }
            try {
                BaseKit kit = Utilities.getKit((JTextComponent)target);
                Action a = kit.getActionByName("copy-to-clipboard");
                a.actionPerformed(evt);
                EDTCustomActions.ResetSelection(target);
            }
            catch (Exception ex) {
                target.getToolkit().beep();
            }
        }
    }

    public static class CutAction
    extends BaseAction {
        public CutAction() {
            super("edt-cut");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: cutAction");
            }
            try {
                BaseKit kit = Utilities.getKit((JTextComponent)target);
                Action a = kit.getActionByName("cut-to-clipboard");
                a.actionPerformed(evt);
                EDTCustomActions.ResetSelection(target);
            }
            catch (Exception ex) {
                target.getToolkit().beep();
            }
        }
    }

    public static class PreviousWindowAction
    extends BaseAction {
        public PreviousWindowAction() {
            super("edt-prev-window");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: PreviousWindowAction");
            }
            try {
                CallbackSystemAction MyPreviousTabAction = (CallbackSystemAction)CallbackSystemAction.findObject(PreviousTabAction.class);
                MyPreviousTabAction.performAction();
            }
            catch (Exception ex) {
                target.getToolkit().beep();
            }
        }
    }

    public static class NextWindowAction
    extends BaseAction {
        public NextWindowAction() {
            super("edt-next-window");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: NextWindowAction");
            }
            try {
                CallbackSystemAction MyNextTabAction = (CallbackSystemAction)CallbackSystemAction.findObject(NextTabAction.class);
                MyNextTabAction.performAction();
            }
            catch (Exception ex) {
                target.getToolkit().beep();
            }
        }
    }

    public static class DownPageAction
    extends BaseAction {
        public DownPageAction() {
            super("edt-next");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: DownPageAction");
            }
            try {
                BaseKit kit = Utilities.getKit((JTextComponent)target);
                Action a = bSelectionInProgress ? kit.getActionByName("selection-page-down") : kit.getActionByName("page-down");
                a.actionPerformed(evt);
            }
            catch (Exception ex) {
                target.getToolkit().beep();
            }
        }
    }

    public static class UpPageAction
    extends BaseAction {
        public UpPageAction() {
            super("edt-prev");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: UpPageAction");
            }
            try {
                BaseKit kit = Utilities.getKit((JTextComponent)target);
                Action a = bSelectionInProgress ? kit.getActionByName("selection-page-up") : kit.getActionByName("page-up");
                a.actionPerformed(evt);
            }
            catch (Exception ex) {
                target.getToolkit().beep();
            }
        }
    }

    public static class LeftCharAction
    extends BaseAction {
        public LeftCharAction() {
            super("edt-left");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: LeftCharAction");
            }
            try {
                BaseKit kit = Utilities.getKit((JTextComponent)target);
                Action a = bSelectionInProgress ? kit.getActionByName("selection-backward") : kit.getActionByName("caret-backward");
                a.actionPerformed(evt);
            }
            catch (Exception ex) {
                target.getToolkit().beep();
            }
        }
    }

    public static class RightCharAction
    extends BaseAction {
        public RightCharAction() {
            super("edt-right");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: RightCharAction");
            }
            try {
                BaseKit kit = Utilities.getKit((JTextComponent)target);
                Action a = bSelectionInProgress ? kit.getActionByName("selection-forward") : kit.getActionByName("caret-forward");
                a.actionPerformed(evt);
            }
            catch (Exception ex) {
                target.getToolkit().beep();
            }
        }
    }

    public static class DownLineAction
    extends BaseAction {
        public DownLineAction() {
            super("edt-down");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: DownLineAction");
            }
            try {
                BaseKit kit = Utilities.getKit((JTextComponent)target);
                Action a = bSelectionInProgress ? kit.getActionByName("selection-down") : kit.getActionByName("caret-down");
                a.actionPerformed(evt);
            }
            catch (Exception ex) {
                target.getToolkit().beep();
            }
        }
    }

    public static class UpLineAction
    extends BaseAction {
        public UpLineAction() {
            super("edt-up");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: UpLineAction");
            }
            try {
                BaseKit kit = Utilities.getKit((JTextComponent)target);
                Action a = bSelectionInProgress ? kit.getActionByName("selection-up") : kit.getActionByName("caret-up");
                a.actionPerformed(evt);
            }
            catch (Exception ex) {
                target.getToolkit().beep();
            }
        }
    }

    public static class HelpAction
    extends BaseAction {
        public HelpAction() {
            super("edt-help");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: HelpAction");
            }
            try {
                HelpCtx help = new HelpCtx("com-compaq-openvms-netbeans-edtkeypad-help_htm");
                if (EDTInitializer.debugVerbose) {
                    System.out.println("help = " + help);
                }
            }
            catch (Exception ex) {
                target.getToolkit().beep();
            }
            Keymap km = target.getKeymap();
            Action kta = null;
            if (km != null) {
                kta = km.getAction(KeyStroke.getKeyStroke('/'));
            }
            if (kta != null) {
                kta.putValue(EDTCustomActions.IGNORE_NEXT, Boolean.TRUE);
                if (EDTInitializer.debugVerbose) {
                    System.out.println("set IGNORE_NEXT to true. action = " + kta.toString());
                }
            }
        }
    }

    public static class ResetAction
    extends BaseAction {
        public ResetAction() {
            super("edt-reset");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: resetAction");
            }
            EDTCustomActions.setStatusBarDirection(target, "Forward");
            EDTCustomActions.ResetSelection(target);
        }
    }

    public static class StartRangeWithToggleAction
    extends BaseAction {
        public StartRangeWithToggleAction() {
            super("edt-select-toggle");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: StartRangeWithToggleAction");
            }
            if (EDTInitializer.debugVerbose) {
                System.out.println("evt = " + evt.toString());
            }
            if (bSelectionInProgress) {
                EDTCustomActions.ResetSelection(target);
            }
            bSelectionInProgress = true;
        }
    }

    public static class StartRangeAction
    extends BaseAction {
        public StartRangeAction() {
            super("edt-select");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: StartRangeAction");
            }
            if (EDTInitializer.debugVerbose) {
                System.out.println("evt cmd = " + evt.getActionCommand().toString());
            }
            bSelectionInProgress = true;
        }
    }

    public static class DelCharAction
    extends BaseAction {
        public DelCharAction() {
            super("edt-del-char");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: DelCharAction");
            }
            if (target != null) {
                if (!target.isEditable() || !target.isEnabled()) {
                    target.getToolkit().beep();
                    return;
                }
                try {
                    block14: {
                        BaseDocument doc = Utilities.getDocument((JTextComponent)target);
                        Caret caret = target.getCaret();
                        int dotPos = caret.getDot();
                        if (EDTInitializer.debugCaret) {
                            System.out.println("edt: dotpos to delete = " + dotPos);
                        }
                        try {
                            charBuffer = doc.getChars(dotPos, 1);
                            if (EDTInitializer.debugVerbose) {
                                System.out.println("edt: char to delete is: " + charBuffer[0]);
                            }
                        }
                        catch (BadLocationException ex) {
                            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                                ex.printStackTrace();
                            }
                            if (!EDTInitializer.debugVerbose) break block14;
                            System.out.println("edt: BadLocationException");
                        }
                    }
                    BaseKit kit = Utilities.getKit((JTextComponent)target);
                    Action a = kit.getActionByName("delete-next");
                    a.actionPerformed(evt);
                }
                catch (Exception ex) {
                    if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                        ex.printStackTrace();
                    }
                    if (EDTInitializer.debugVerbose) {
                        System.out.println("edt: exception");
                    }
                    target.getToolkit().beep();
                }
            }
            Keymap km = target.getKeymap();
            Action kta = null;
            if (km != null) {
                kta = EDTInitializer.isDecKeyboard ? km.getAction(KeyStroke.getKeyStroke(',')) : km.getAction(KeyStroke.getKeyStroke('+'));
            }
            if (kta != null) {
                kta.putValue(EDTCustomActions.IGNORE_NEXT, Boolean.TRUE);
            }
        }
    }

    public static class DelWordAction
    extends BaseAction {
        public DelWordAction() {
            super("edt-del-word");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: DelWordAction");
            }
            if (target != null) {
                if (!target.isEditable() || !target.isEnabled()) {
                    target.getToolkit().beep();
                    return;
                }
                try {
                    BaseDocument doc = Utilities.getDocument((JTextComponent)target);
                    Caret caret = target.getCaret();
                    int dotPos = caret.getDot();
                    int eowPos = Utilities.getFirstNonWhiteFwd((BaseDocument)doc, (int)dotPos);
                    if (eowPos == dotPos && (eowPos = Utilities.getWordEnd((JTextComponent)target, (int)dotPos) + 1) == 0) {
                        eowPos = Utilities.getRowEnd((JTextComponent)target, (int)dotPos);
                    }
                    if (EDTInitializer.debugCaret) {
                        System.out.println("edt: " + EDTCustomActions.getStatusBarDirection(target) + ": dot=" + dotPos + " eowPos=" + eowPos);
                    }
                    wordBuffer = doc.getChars(dotPos, eowPos - dotPos);
                    doc.remove(dotPos, eowPos - dotPos);
                    if (EDTInitializer.debugCaret) {
                        String str = new String(wordBuffer);
                        System.out.println("edt: deleted word is: " + str);
                    }
                }
                catch (GuardedException e) {
                    target.getToolkit().beep();
                }
                catch (BadLocationException ex) {}
            } else if (EDTInitializer.debugVerbose) {
                System.out.println("edt: no deleted word");
            }
            Keymap km = target.getKeymap();
            Action kta = null;
            if (km != null) {
                kta = EDTInitializer.isVms ? km.getAction(KeyStroke.getKeyStroke('-')) : km.getAction(KeyStroke.getKeyStroke('+'));
            }
            if (kta == null) {
                if (EDTInitializer.debugVerbose) {
                    System.out.println("edt: did not getAction");
                }
                return;
            }
            kta.putValue(EDTCustomActions.IGNORE_NEXT, Boolean.TRUE);
            if (EDTInitializer.debugVerbose) {
                System.out.println("edt: kta= " + kta.toString());
            }
        }
    }

    public static class CutAppendAction
    extends BaseAction {
        public CutAppendAction() {
            super("edt-cut-append");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: CutAppendAction");
            }
            try {
                EDTCustomActions.ResetSelection(target);
            }
            catch (Exception ex) {
                target.getToolkit().beep();
            }
        }
    }

    public static class TopAction
    extends BaseAction {
        public TopAction() {
            super("edt-begin");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: TopAction");
            }
            try {
                BaseKit kit = Utilities.getKit((JTextComponent)target);
                Action a = bSelectionInProgress ? kit.getActionByName("selection-begin") : kit.getActionByName("caret-begin");
                a.actionPerformed(evt);
            }
            catch (Exception ex) {
                target.getToolkit().beep();
            }
        }
    }

    public static class BottomAction
    extends BaseAction {
        public BottomAction() {
            super("edt-end");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: BottomAction");
            }
            try {
                BaseKit kit = Utilities.getKit((JTextComponent)target);
                Action a = bSelectionInProgress ? kit.getActionByName("selection-end") : kit.getActionByName("caret-end");
                a.actionPerformed(evt);
            }
            catch (Exception ex) {
                target.getToolkit().beep();
            }
        }
    }

    public static class SectionAction
    extends BaseAction {
        public SectionAction() {
            super("edt-section");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: SectionAction");
            }
            try {
                BaseKit kit = Utilities.getKit((JTextComponent)target);
                Action a = EDTCustomActions.getStatusBarDirection(target) == "Reverse" ? (bSelectionInProgress ? kit.getActionByName("selection-page-up") : kit.getActionByName("page-up")) : (bSelectionInProgress ? kit.getActionByName("selection-page-down") : kit.getActionByName("page-down"));
                a.actionPerformed(evt);
            }
            catch (Exception ex) {
                target.getToolkit().beep();
            }
        }
    }

    public static class PageAction
    extends BaseAction {
        public PageAction() {
            super("edt-page");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: PageAction");
            }
            if (target != null) {
                try {
                    Caret caret = target.getCaret();
                    int dotPos = caret.getDot();
                    dotPos = EDTCustomActions.getStatusBarDirection(target) == "Reverse" ? EDTCustomActions.getPreviousPageMark(target, dotPos) : EDTCustomActions.getNextPageMark(target, dotPos);
                    if (bSelectionInProgress) {
                        caret.moveDot(dotPos);
                    } else {
                        caret.setDot(dotPos);
                    }
                }
                catch (BadLocationException ex) {
                    target.getToolkit().beep();
                }
            }
        }
    }

    public static class WordAction
    extends BaseAction {
        public WordAction() {
            super("edt-word");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: WordAction");
            }
            try {
                BaseKit kit = Utilities.getKit((JTextComponent)target);
                Action a = EDTCustomActions.getStatusBarDirection(target) == "Reverse" ? (bSelectionInProgress ? kit.getActionByName("selection-previous-word") : kit.getActionByName("caret-previous-word")) : (bSelectionInProgress ? kit.getActionByName("selection-next-word") : kit.getActionByName("caret-next-word"));
                a.actionPerformed(evt);
            }
            catch (Exception ex) {
                target.getToolkit().beep();
            }
        }
    }

    public static class OpenLineAction
    extends BaseAction {
        public OpenLineAction() {
            super("edt-openline");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: OpenLineAction");
            }
            try {
                BaseKit kit = Utilities.getKit((JTextComponent)target);
                Action a = kit.getActionByName("insert-break");
                a.actionPerformed(evt);
                a = kit.getActionByName("caret-up");
                a.actionPerformed(evt);
            }
            catch (Exception ex) {
                target.getToolkit().beep();
            }
        }
    }

    public static class ToggleCaseAction
    extends BaseAction {
        public ToggleCaseAction() {
            super("edt-change-case");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: ToggleCaseAction");
            }
            if (target != null) {
                if (!target.isEditable() || !target.isEnabled()) {
                    target.getToolkit().beep();
                    return;
                }
                try {
                    Caret caret = target.getCaret();
                    BaseDocument doc = (BaseDocument)target.getDocument();
                    if (caret.isSelectionVisible()) {
                        int startPos = target.getSelectionStart();
                        int endPos = target.getSelectionEnd();
                        Utilities.changeCase((BaseDocument)doc, (int)startPos, (int)(endPos - startPos), (int)2);
                        caret.setSelectionVisible(false);
                        caret.setDot(endPos);
                    } else {
                        int dotPos = caret.getDot();
                        Utilities.changeCase((BaseDocument)doc, (int)dotPos, (int)1, (int)2);
                        if (EDTCustomActions.getStatusBarDirection(target) == "Reverse") {
                            caret.setDot(dotPos - 1);
                        } else {
                            caret.setDot(dotPos + 1);
                        }
                    }
                }
                catch (BadLocationException e) {
                    target.getToolkit().beep();
                }
            }
        }
    }

    public static class LineAction
    extends BaseAction {
        public LineAction() {
            super("edt-line");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: LineAction");
            }
            try {
                Action a;
                String forwardAction;
                String beginLineAction;
                String downAction;
                String upAction;
                BaseKit kit = Utilities.getKit((JTextComponent)target);
                int dotPos = 0;
                int bolPos = 0;
                int eolPos = 0;
                if (target != null) {
                    BaseDocument doc = Utilities.getDocument((JTextComponent)target);
                    Caret caret = target.getCaret();
                    dotPos = caret.getDot();
                    bolPos = Utilities.getRowStart((JTextComponent)target, (int)dotPos);
                    eolPos = Utilities.getRowEnd((JTextComponent)target, (int)dotPos);
                    if (EDTInitializer.debugCaret) {
                        System.out.println("edt: " + EDTCustomActions.getStatusBarDirection(target) + ": dot=" + dotPos + " bol=" + bolPos + " eolPos=" + eolPos);
                    }
                }
                if (bSelectionInProgress) {
                    upAction = "selection-up";
                    downAction = "selection-down";
                    beginLineAction = "selection-line-first-column";
                    forwardAction = "selection-forward";
                } else {
                    upAction = "caret-up";
                    downAction = "caret-down";
                    beginLineAction = "caret-line-first-column";
                    forwardAction = "caret-forward";
                }
                if (EDTCustomActions.getStatusBarDirection(target) == "Reverse") {
                    a = dotPos == bolPos ? kit.getActionByName(upAction) : kit.getActionByName(beginLineAction);
                } else if (dotPos == eolPos) {
                    a = kit.getActionByName(forwardAction);
                } else {
                    if (dotPos != bolPos) {
                        a = kit.getActionByName(beginLineAction);
                        a.actionPerformed(evt);
                    }
                    a = kit.getActionByName(downAction);
                }
                a.actionPerformed(evt);
            }
            catch (Exception ex) {
                target.getToolkit().beep();
            }
        }
    }

    public static class CutReplaceAction
    extends BaseAction {
        public CutReplaceAction() {
            super("edt-cut-replace");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: CutReplaceAction");
            }
            try {
                BaseKit kit = Utilities.getKit((JTextComponent)target);
                Action a = kit.getActionByName("replace");
                a.actionPerformed(evt);
                EDTCustomActions.ResetSelection(null);
            }
            catch (Exception ex) {
                target.getToolkit().beep();
            }
        }
    }

    public static class SubstBuffAction
    extends BaseAction {
        public SubstBuffAction() {
            super("edt-subst");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: SubstBuffAction");
            }
            try {
                BaseKit kit = Utilities.getKit((JTextComponent)target);
                Action a = kit.getActionByName("replace");
                a.actionPerformed(evt);
                EDTCustomActions.ResetSelection(null);
            }
            catch (Exception ex) {
                target.getToolkit().beep();
            }
        }
    }

    public static class UndoDelCharAction
    extends BaseAction {
        public UndoDelCharAction() {
            super("edt-undo-del-char");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            block6: {
                if (EDTInitializer.debugTrace) {
                    System.out.println("edt trace: UndoDelCharAction");
                }
                try {
                    if (target == null) break block6;
                    Caret caret = target.getCaret();
                    BaseDocument doc = Utilities.getDocument((JTextComponent)target);
                    if (doc == null) break block6;
                    try {
                        String str = new String(charBuffer);
                        int startpos = caret.getDot();
                        doc.insertString(startpos, str, null);
                        caret.setDot(startpos);
                        if (EDTInitializer.debugCaret) {
                            System.out.println("edt: inserted buffer = " + str + "at location  " + caret.getDot());
                        }
                    }
                    catch (BadLocationException ex) {
                        target.getToolkit().beep();
                    }
                }
                catch (Exception ex) {
                    target.getToolkit().beep();
                }
            }
        }
    }

    public static class UndoDelWordAction
    extends BaseAction {
        public UndoDelWordAction() {
            super("edt-undo-del-word");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: UndoDelWordAction");
            }
            if (target != null) {
                if (!target.isEditable() || !target.isEnabled()) {
                    target.getToolkit().beep();
                    return;
                }
                Caret caret = target.getCaret();
                BaseDocument doc = Utilities.getDocument((JTextComponent)target);
                if (doc != null) {
                    try {
                        if (wordBuffer != null) {
                            String str = new String(wordBuffer);
                            int startpos = caret.getDot();
                            doc.insertString(startpos, str, null);
                            caret.setDot(startpos);
                            if (EDTInitializer.debugCaret) {
                                System.out.println("edt: inserted buffer = " + str + "at location  " + caret.getDot());
                            }
                        }
                    }
                    catch (BadLocationException ex) {
                        target.getToolkit().beep();
                    }
                }
            }
        }
    }

    public static class UndoDelLineAction
    extends BaseAction {
        public UndoDelLineAction() {
            super("edt-undo-del-line");
            if (EDTInitializer.debugVerbose) {
                System.out.println("edt: an action ctor - undo del line");
            }
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: UndoDelLineAction");
            }
            if (target != null) {
                if (!target.isEditable() || !target.isEnabled()) {
                    target.getToolkit().beep();
                    return;
                }
                Caret caret = target.getCaret();
                BaseDocument doc = Utilities.getDocument((JTextComponent)target);
                if (doc != null) {
                    if (EDTInitializer.debugVerbose) {
                        System.out.println("edt: inserting linebuffer");
                    }
                    try {
                        if (lineBuffer != null) {
                            String str = new String(lineBuffer);
                            int startpos = caret.getDot();
                            doc.insertString(startpos, str, null);
                            caret.setDot(startpos);
                            if (EDTInitializer.debugCaret) {
                                System.out.println("edt: inserted buffer = " + str + "at location  " + caret.getDot());
                            }
                        }
                    }
                    catch (BadLocationException ex) {
                        target.getToolkit().beep();
                    }
                }
            }
        }
    }

    public static class DelLineAction
    extends BaseAction {
        public DelLineAction() {
            super("edt-del-line");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: DelLineAction");
            }
            if (target != null) {
                if (!target.isEditable() || !target.isEnabled()) {
                    target.getToolkit().beep();
                    return;
                }
                try {
                    BaseDocument doc = Utilities.getDocument((JTextComponent)target);
                    Caret caret = target.getCaret();
                    int dotPos = caret.getDot();
                    int eolPos = Utilities.getRowEnd((JTextComponent)target, (int)dotPos) + 1;
                    eolPos = Math.min(eolPos, doc.getLength());
                    if (EDTInitializer.debugCaret) {
                        System.out.println("edt: " + EDTCustomActions.getStatusBarDirection(target) + ": dot=" + dotPos + " eolPos=" + eolPos);
                    }
                    lineBuffer = doc.getChars(dotPos, eolPos - dotPos);
                    doc.remove(dotPos, eolPos - dotPos);
                    if (EDTInitializer.debugCaret) {
                        String str = new String(lineBuffer);
                        System.out.println("edt: deleted line is: " + str);
                    }
                }
                catch (BadLocationException ex) {
                    target.getToolkit().beep();
                }
            } else if (EDTInitializer.debugVerbose) {
                System.out.println("edt: no deleted line");
            }
            Keymap km = target.getKeymap();
            Action kta = null;
            if (km != null) {
                kta = km.getAction(KeyStroke.getKeyStroke('-'));
            }
            if (kta != null) {
                kta.putValue(EDTCustomActions.IGNORE_NEXT, Boolean.TRUE);
            }
        }
    }

    public static class FindAction
    extends BaseAction {
        public FindAction() {
            super("edt-find-action");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: FindAction");
            }
            try {
                BaseKit kit = Utilities.getKit((JTextComponent)target);
                Action a = kit.getActionByName("find");
                a.actionPerformed(evt);
            }
            catch (Exception ex) {
                target.getToolkit().beep();
            }
        }
    }

    public static class FindNextAction
    extends BaseAction {
        public FindNextAction() {
            super("edt-find-next");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: FindNextAction");
            }
            try {
                BaseKit kit = Utilities.getKit((JTextComponent)target);
                Action a = EDTCustomActions.getStatusBarDirection(target) == "Reverse" ? kit.getActionByName("find-previous") : kit.getActionByName("find-next");
                a.actionPerformed(evt);
                Keymap km = target.getKeymap();
                Action kta = null;
                if (km != null) {
                    kta = km.getAction(KeyStroke.getKeyStroke('*'));
                }
                if (kta != null) {
                    kta.putValue(EDTCustomActions.IGNORE_NEXT, Boolean.TRUE);
                }
            }
            catch (Exception ex) {
                target.getToolkit().beep();
            }
        }
    }

    public static class CharAction
    extends BaseAction {
        public CharAction() {
            super("edt-char");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: CharAction");
            }
            try {
                BaseKit kit = Utilities.getKit((JTextComponent)target);
                Action a = EDTCustomActions.getStatusBarDirection(target) == "Reverse" ? (bSelectionInProgress ? kit.getActionByName("selection-backward") : kit.getActionByName("caret-backward")) : (bSelectionInProgress ? kit.getActionByName("selection-forward") : kit.getActionByName("caret-forward"));
                a.actionPerformed(evt);
            }
            catch (Exception ex) {
                target.getToolkit().beep();
            }
        }
    }

    public static class DeleteToEolAction
    extends BaseAction {
        public DeleteToEolAction() {
            super("edt-del-eol");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: DeleteToEolAction");
            }
            if (target != null) {
                if (!target.isEditable() || !target.isEnabled()) {
                    target.getToolkit().beep();
                    return;
                }
                try {
                    String strLF = null;
                    BaseDocument doc = Utilities.getDocument((JTextComponent)target);
                    Caret caret = target.getCaret();
                    int dotPos = caret.getDot();
                    int eolPos = Utilities.getRowEnd((JTextComponent)target, (int)dotPos);
                    if (EDTInitializer.debugCaret) {
                        System.out.println("DelToEol: dotPos=" + dotPos + " eolPos=" + eolPos);
                    }
                    if (dotPos == eolPos) {
                        strLF = doc.getText(dotPos, 1);
                        doc.remove(dotPos, 1);
                        eolPos = Utilities.getRowEnd((JTextComponent)target, (int)dotPos);
                        if (EDTInitializer.debugCaret) {
                            System.out.println("DelToEol2: dotPos=" + dotPos + " eolPos=" + eolPos);
                        }
                    }
                    lineBuffer = doc.getChars(dotPos, eolPos - dotPos);
                    if (strLF != null) {
                        String strLine = strLF + new String(lineBuffer);
                        if (EDTInitializer.debugCaret) {
                            System.out.println("strLine = " + strLine);
                        }
                        lineBuffer = strLine.toCharArray();
                    }
                    doc.remove(dotPos, eolPos - dotPos);
                    if (EDTInitializer.debugCaret) {
                        String str = new String(lineBuffer);
                        System.out.println("edt: deleted line is: " + str);
                    }
                }
                catch (GuardedException e) {
                    target.getToolkit().beep();
                }
                catch (BadLocationException ex) {
                    target.getToolkit().beep();
                }
            }
        }
    }

    public static class EndLnAction
    extends BaseAction {
        public EndLnAction() {
            super("edt-endline");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: EndLnAction");
            }
            try {
                BaseKit kit = Utilities.getKit((JTextComponent)target);
                Action a = bSelectionInProgress ? kit.getActionByName("selection-end-line") : kit.getActionByName("caret-end-line");
                a.actionPerformed(evt);
            }
            catch (Exception ex) {
                target.getToolkit().beep();
            }
        }
    }

    public static class BegLnAction
    extends BaseAction {
        public BegLnAction() {
            super("edt-begline");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: BegLnAction");
            }
            try {
                BaseKit kit = Utilities.getKit((JTextComponent)target);
                Action a = bSelectionInProgress ? kit.getActionByName("selection-begin-line") : kit.getActionByName("caret-begin-line");
                a.actionPerformed(evt);
            }
            catch (Exception ex) {
                target.getToolkit().beep();
            }
        }
    }

    public static class EolAction
    extends BaseAction {
        public EolAction() {
            super("edt-eol");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: EolAction");
            }
            try {
                String endLineAction;
                String beginLineAction;
                String downAction;
                BaseKit kit = Utilities.getKit((JTextComponent)target);
                int dotPos = 0;
                int bolPos = 0;
                int eolPos = 0;
                if (target != null) {
                    BaseDocument doc = Utilities.getDocument((JTextComponent)target);
                    Caret caret = target.getCaret();
                    dotPos = caret.getDot();
                    bolPos = Utilities.getRowStart((JTextComponent)target, (int)dotPos);
                    eolPos = Utilities.getRowEnd((JTextComponent)target, (int)dotPos);
                    if (EDTInitializer.debugCaret) {
                        System.out.println(EDTCustomActions.getStatusBarDirection(target) + ": dot=" + dotPos + " bol=" + bolPos + " eolPos=" + eolPos);
                    }
                }
                if (bSelectionInProgress) {
                    downAction = "selection-down";
                    beginLineAction = "selection-line-first-column";
                    endLineAction = "selection-end-line";
                } else {
                    downAction = "caret-down";
                    beginLineAction = "caret-line-first-column";
                    endLineAction = "caret-end-line";
                }
                if (EDTCustomActions.getStatusBarDirection(target) == "Reverse") {
                    Action a;
                    if (bolPos == 0) {
                        return;
                    }
                    if (dotPos != bolPos) {
                        a = kit.getActionByName(beginLineAction);
                        a.actionPerformed(evt);
                        if (EDTInitializer.debugCaret) {
                            System.out.println("performed = " + a.toString());
                        }
                    }
                    a = kit.getActionByName("edt-left");
                    a.actionPerformed(evt);
                    if (EDTInitializer.debugCaret) {
                        System.out.println("performed = " + a.toString());
                    }
                } else {
                    Action a;
                    if (dotPos == eolPos) {
                        a = kit.getActionByName(downAction);
                        a.actionPerformed(evt);
                        if (EDTInitializer.debugCaret) {
                            System.out.println("performed = " + a.toString());
                        }
                    }
                    a = kit.getActionByName(endLineAction);
                    a.actionPerformed(evt);
                    if (EDTInitializer.debugCaret) {
                        System.out.println("performed = " + a.toString());
                    }
                }
            }
            catch (Exception ex) {
                target.getToolkit().beep();
            }
        }
    }

    public static class BackspaceAction
    extends BaseAction {
        public BackspaceAction() {
            super("edt-backspace", 22);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            block8: {
                if (target != null) {
                    if (!target.isEditable() || !target.isEnabled()) {
                        target.getToolkit().beep();
                        return;
                    }
                    BaseDocument doc = (BaseDocument)target.getDocument();
                    Caret caret = target.getCaret();
                    int dot = caret.getDot();
                    int mark = caret.getMark();
                    try {
                        if (dot != mark) {
                            doc.remove(Math.min(dot, mark), Math.abs(dot - mark));
                            break block8;
                        }
                        doc.atomicLock();
                        try {
                            char ch = doc.getChars(dot - 1, 1)[0];
                            doc.remove(dot - 1, 1);
                            this.charBackspaced(doc, dot - 1, caret, ch);
                        }
                        finally {
                            doc.atomicUnlock();
                        }
                    }
                    catch (BadLocationException e) {
                        target.getToolkit().beep();
                    }
                }
            }
        }

        protected void charBackspaced(BaseDocument doc, int dotPos, Caret caret, char ch) throws BadLocationException {
        }
    }

    public static class StartNewLine
    extends BaseAction {
        public StartNewLine() {
            super("start-new-line", 14);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (!target.isEditable() || !target.isEnabled()) {
                target.getToolkit().beep();
                return;
            }
            BaseDocument doc = (BaseDocument)target.getDocument();
            doc.atomicLock();
            try {
                Caret caret = target.getCaret();
                int dotpos = caret.getDot();
                doc.insertString(dotpos, "-", null);
                doc.remove(dotpos, 1);
                int eolDot = Utilities.getRowEnd((JTextComponent)target, (int)caret.getDot());
                int newDotPos = doc.getFormatter().indentNewLine((Document)doc, eolDot);
                caret.setDot(newDotPos);
            }
            catch (BadLocationException ex) {
                ex.printStackTrace();
            }
            finally {
                doc.atomicUnlock();
            }
        }
    }

    public static class ReverseDirectionAction
    extends BaseAction {
        public ReverseDirectionAction() {
            super("edt-reverse");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: ReverseDirectionAction");
            }
            EDTCustomActions.setStatusBarDirection(target, "Reverse");
        }
    }

    public static class ForwardDirectionAction
    extends BaseAction {
        public ForwardDirectionAction() {
            super("edt-advance");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: ForwardDirectionAction");
            }
            EDTCustomActions.setStatusBarDirection(target, "Forward");
        }
    }
}

