/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remotefs.wizard;

import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.distributed.remotefs.wizard.RemoteRuntimeVisualPanel;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class RemoteRuntimePanel
implements WizardDescriptor.ValidatingPanel {
    private static final String VALIDIDATE_MSG = "The Java source level for this project is higher than the version of Java used on the remote server chosen.\nPlease change the source level property for this project before converting it to a remote project.";
    private RemoteRuntimeVisualPanel component;
    private String jdkVer = null;

    public RemoteRuntimePanel() {
    }

    public RemoteRuntimePanel(String jdkVer) {
        this.jdkVer = jdkVer;
    }

    public Component getComponent() {
        if (this.component == null) {
            this.component = new RemoteRuntimeVisualPanel(this);
        }
        return this.component;
    }

    public HelpCtx getHelp() {
        return HelpCtx.DEFAULT_HELP;
    }

    private boolean checkSourceLevel(String srcLevel, String svrSrcLevel) {
        if (svrSrcLevel.indexOf(46) != svrSrcLevel.lastIndexOf(46)) {
            int secondDot = svrSrcLevel.indexOf(46);
            secondDot = svrSrcLevel.indexOf(46, secondDot + 1);
            svrSrcLevel = svrSrcLevel.substring(0, secondDot);
        }
        return !(Float.parseFloat(srcLevel) > Float.parseFloat(svrSrcLevel));
    }

    public boolean isValid() {
        return ((RemoteRuntimeVisualPanel)this.getComponent()).getRemoteRuntimeType() != null;
    }

    public final void addChangeListener(ChangeListener l) {
    }

    public final void removeChangeListener(ChangeListener l) {
    }

    public void validate() throws WizardValidationException {
        String svrJDKVer;
        if (this.jdkVer != null && !this.checkSourceLevel(this.jdkVer, svrJDKVer = ((RemoteRuntimeVisualPanel)this.getComponent()).getRemoteRuntimeType().getJDKVersion())) {
            throw new WizardValidationException((JComponent)this.getComponent(), NbBundle.getMessage(RemoteRuntimePanel.class, (String)"MSG_INVALID_SVR"), NbBundle.getMessage(RemoteRuntimePanel.class, (String)"MSG_INVALID_SVR"));
        }
    }

    public void readSettings(Object settings) {
    }

    public void storeSettings(Object settings) {
        WizardDescriptor wiz = (WizardDescriptor)settings;
        wiz.putProperty("remote_runtime", (Object)this.component.getRemoteRuntimeType());
    }
}

