/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remotefs.wizard;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.distributed.common.util.FileUtility;
import org.netbeans.modules.distributed.ideserverclient.RemoteRuntimeType;
import org.netbeans.modules.distributed.remotefs.wizard.NewFolder;
import org.netbeans.modules.distributed.rmi.protocol.RemoteFileInfoExt;
import org.netbeans.modules.distributed.rmi.protocol.RemoteFileService;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public class RemoteFileSelectFrame
extends JDialog {
    public RemoteRuntimeType rt = null;
    public DefaultTreeCellRenderer icon = new DefaultTreeCellRenderer();
    public String pathSelected = null;
    private JButton jButton1;
    private JScrollPane jScrollPane1;
    private JTree jTree1;
    private JButton newFolder_button;
    private JButton ok_button;
    private JTextField ovms_path;
    private DefaultMutableTreeNode temp = null;
    private DefaultMutableTreeNode defaultMutableTreeNode = null;
    private TreeModel treeModel = new DefaultTreeModel(this.defaultMutableTreeNode);

    public RemoteFileSelectFrame() {
        this.initComponents();
    }

    public RemoteFileSelectFrame(Frame owner, boolean modal, RemoteRuntimeType rt) {
        super(owner, modal);
        this.rt = rt;
        this.defaultMutableTreeNode = new DefaultMutableTreeNode(rt.getHostName() + "@" + rt.getUserName(), true);
        this.treeModel = new DefaultTreeModel(this.defaultMutableTreeNode);
        this.initComponents();
        URL urlopen = this.getClass().getResource("resources/openfolder.gif");
        URL urlclose = this.getClass().getResource("resources/folder.gif");
        ImageIcon openIcon = new ImageIcon(urlopen);
        ImageIcon closeIcon = new ImageIcon(urlclose);
        this.icon.setLeafIcon(closeIcon);
        this.icon.setClosedIcon(closeIcon);
        this.icon.setOpenIcon(openIcon);
        this.jTree1.setCellRenderer(this.icon);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTree1 = new JTree();
        this.newFolder_button = new JButton();
        this.ovms_path = new JTextField();
        this.ok_button = new JButton();
        this.jButton1 = new JButton();
        this.setDefaultCloseOperation(2);
        this.setCursor(new Cursor(0));
        this.setLocationByPlatform(true);
        this.jTree1.setModel(this.treeModel);
        this.jTree1.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent evt) {
                RemoteFileSelectFrame.this.jTree1ValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTree1);
        this.newFolder_button.setIcon(UIManager.getIcon("FileChooser.newFolderIcon"));
        this.newFolder_button.setText(NbBundle.getMessage(RemoteFileSelectFrame.class, (String)"RemoteFileSelectFrame.newFolder_button.text"));
        this.newFolder_button.setToolTipText(NbBundle.getMessage(RemoteFileSelectFrame.class, (String)"RemoteFileSelectFrame.newFolder_button.toolTipText"));
        this.newFolder_button.setAlignmentY(0.0f);
        this.newFolder_button.setBorder(BorderFactory.createBevelBorder(0));
        this.newFolder_button.setBorderPainted(false);
        this.newFolder_button.setEnabled(false);
        this.newFolder_button.setFocusPainted(false);
        this.newFolder_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RemoteFileSelectFrame.this.newFolder_buttonActionPerformed(evt);
            }
        });
        this.ovms_path.setText(NbBundle.getMessage(RemoteFileSelectFrame.class, (String)"RemoteFileSelectFrame.ovms_path.text"));
        this.ok_button.setText(NbBundle.getMessage(RemoteFileSelectFrame.class, (String)"RemoteFileSelectFrame.ok_button.text"));
        this.ok_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RemoteFileSelectFrame.this.ok_buttonActionPerformed(evt);
            }
        });
        this.jButton1.setText(NbBundle.getMessage(RemoteFileSelectFrame.class, (String)"RemoteFileSelectFrame.jButton1.text"));
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RemoteFileSelectFrame.this.jButton1ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 229, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.ok_button).addPreferredGap(0, 82, Short.MAX_VALUE).add((Component)this.jButton1).add(27, 27, 27)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.ovms_path, -1, 219, Short.MAX_VALUE).addContainerGap()).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap(166, Short.MAX_VALUE).add((Component)this.newFolder_button, -2, 27, -2).add(36, 36, 36)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.newFolder_button, -2, 22, -2).addPreferredGap(0).add((Component)this.jScrollPane1, -2, 253, -2).addPreferredGap(0, 32, Short.MAX_VALUE).add((Component)this.ovms_path, -2, -1, -2).add(18, 18, 18).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.ok_button).add((Component)this.jButton1)).addContainerGap()));
        this.pack();
    }

    private void jTree1ValueChanged(TreeSelectionEvent evt) {
        this.jTree1.repaint();
        TreePath currentSelection = this.jTree1.getSelectionPath();
        DefaultTreeModel model = (DefaultTreeModel)this.jTree1.getModel();
        if (currentSelection != null) {
            if (currentSelection.getPathCount() > 1) {
                this.newFolder_button.setEnabled(true);
            } else {
                this.newFolder_button.setEnabled(false);
            }
            if (currentSelection.getLastPathComponent().toString().equals(this.rt.getHostName() + "@" + this.rt.getUserName())) {
                try {
                    RemoteFileService rfs = this.rt.getRemoteFileService();
                    ArrayList roots = rfs.listRoots();
                    Iterator i = roots.iterator();
                    while (i.hasNext()) {
                        this.temp = new DefaultMutableTreeNode(i.next());
                        this.defaultMutableTreeNode.add(this.temp);
                    }
                    this.temp = new DefaultMutableTreeNode("/SYS$SYSROOT/SYSMGR");
                    this.defaultMutableTreeNode.add(this.temp);
                }
                catch (RemoteException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            } else {
                try {
                    currentSelection = this.jTree1.getSelectionPath();
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)currentSelection.getLastPathComponent();
                    String str_path = this.OVMSpathofile(currentSelection);
                    node.removeAllChildren();
                    RemoteFileService rfs = this.rt.getRemoteFileService();
                    ArrayList files = rfs.findFilesDates(str_path, "(.*)");
                    Iterator itr = files.iterator();
                    this.temp = null;
                    RemoteFileInfoExt rf = null;
                    while (itr.hasNext()) {
                        rf = (RemoteFileInfoExt)itr.next();
                        if (!rf.isDirectory()) continue;
                        String filename = rf.getFileName().endsWith(".DIR") ? rf.getFileName().substring(0, rf.getFileName().length() - 4) : rf.getFileName();
                        this.temp = new DefaultMutableTreeNode(filename, true);
                        node.add(this.temp);
                    }
                    model.reload(node);
                }
                catch (RemoteException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            String selectedpath = this.toPath(currentSelection);
            this.ovms_path.setText(FileUtility.unixPathToOpenVMSPath(selectedpath, true));
            this.jTree1.repaint();
        }
    }

    private void newFolder_buttonActionPerformed(ActionEvent evt) {
        TreePath currentSelection = this.jTree1.getSelectionPath();
        NewFolder dialog = new NewFolder(WindowManager.getDefault().getMainWindow(), true, "New Folder", this);
        dialog.setLocation(500, 300);
        dialog.setVisible(true);
    }

    private void ok_buttonActionPerformed(ActionEvent evt) {
        this.jTree1.getSelectionPath();
        this.pathSelected = this.toPath(this.jTree1.getSelectionPath());
        this.dispose();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private String OVMSpathofile(TreePath path) {
        Object f = null;
        StringBuffer sb = new StringBuffer();
        for (int i = 1; i < path.getPathCount(); ++i) {
            sb.append(path.getPathComponent(i) + "/");
        }
        return sb.toString();
    }

    public void createfolder(String s) {
        try {
            String path = this.OVMSpathofile(this.jTree1.getSelectionPath());
            RemoteFileService rfs = this.rt.getRemoteFileService();
            TreePath currentSelection = this.jTree1.getSelectionPath();
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)currentSelection.getLastPathComponent();
            DefaultMutableTreeNode newnode = null;
            DefaultTreeModel model = (DefaultTreeModel)this.jTree1.getModel();
            path = path + s + "/";
            if (!rfs.fileExists(path)) {
                rfs.mkdirs(path);
                newnode = new DefaultMutableTreeNode(s);
                node.add(newnode);
                model.reload(node);
                this.jTree1.setSelectionPath(currentSelection.pathByAddingChild(newnode));
            } else {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)("Directory with name : " + s + " already exist .\n Please give a different directory name."), 0));
                this.jTree1.setSelectionPath(currentSelection);
            }
        }
        catch (RemoteException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public String toPath(TreePath path) {
        StringBuffer sb = new StringBuffer();
        for (int i = 1; i < path.getPathCount(); ++i) {
            sb.append(path.getPathComponent(i) + "/");
        }
        return sb.toString();
    }
}

