/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remotefs.propertyeditor;

import java.awt.BorderLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import org.netbeans.modules.distributed.remotefs.RemoteJarFileSystem;
import org.netbeans.modules.distributed.remotefs.property.RemoteJarRootProperty;
import org.netbeans.modules.distributed.remotefs.propertyeditor.RemoteJarRootEditor;
import org.netbeans.modules.distributed.remotefs.propertyeditor.RemoteRootJPanel;

public class RemoteJarRootCustomEditor
extends RemoteRootJPanel
implements PropertyChangeListener {
    private RemoteJarRootEditor remoteJarRootEditor;

    public RemoteJarRootCustomEditor(RemoteJarRootEditor editor) {
        super("Local Archive File", "Remote Archive File", "Remote Archive:");
        this.remoteJarRootEditor = editor;
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    public Object getPropertyValue() throws IllegalStateException {
        RemoteJarRootProperty rrp = (RemoteJarRootProperty)this.remoteJarRootEditor.getValue();
        RemoteJarFileSystem nfs = rrp.getNetworkJarFS();
        return new RemoteJarRootProperty(nfs, this.getRemoteDirectory(), this.getLocalDirectory());
    }

    private void fireValueChanged() {
        if (this.remoteJarRootEditor != null) {
            this.remoteJarRootEditor.setValue(this.getPropertyValue());
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        boolean update = false;
        String prop = e.getPropertyName();
        if ("directoryChanged".equals(prop) || "SelectedFileChangedProperty".equals(prop) || prop.equals("ancestor")) {
            JFileChooser fileChooser = this.getFileChooser();
            File selFile = fileChooser.getSelectedFile();
            if (selFile == null) {
                selFile = fileChooser.getCurrentDirectory();
            }
            this.getTextField().setText("");
            String remoteDir = this.remoteJarRootEditor.getRemoteJarFile(selFile.getAbsolutePath());
            if (!remoteDir.equals("")) {
                this.getTextField().setText(remoteDir);
            }
            this.fireValueChanged();
        }
    }

    public void createRemoteDirectory() {
        this.getFileChooser().addPropertyChangeListener(this);
        this.getTextField().addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        RemoteJarRootCustomEditor.this.fireValueChanged();
                    }
                });
            }
        });
    }
}

