/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remotefs.ftpfs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.modules.distributed.common.util.FileUtility;
import org.netbeans.modules.distributed.common.util.Utils;
import org.netbeans.modules.distributed.remotefs.ftpfs.RemoteClient;
import org.netbeans.modules.distributed.remotefs.ftpfs.RemoteDefaultAttributes;
import org.netbeans.modules.distributed.remotefs.ftpfs.RemoteFileAttributes;
import org.netbeans.modules.distributed.remotefs.ftpfs.RemoteFileName;
import org.netbeans.modules.distributed.remotefs.ftpfs.RemoteFileSystem;
import org.netbeans.modules.distributed.remotefs.ftpfs.actions.RemoteOutputStream;
import org.netbeans.modules.distributed.remotefs.ftpfs.actions.Sync;
import org.netbeans.modules.distributed.remotefs.ftpfs.actions.SyncTablePanel;
import org.netbeans.modules.distributed.remotefs.ftpfs.actions.SyncTablePanelFileOpen;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.windows.InputOutput;

public class RemoteFile {
    private static final boolean DEBUG = true;
    public static final String LAST_MODIFIED_CACHE = "ftp_cache_lastmodified";
    public static final String LAST_MODIFIED_SERVER = "ftp_remote_lastmodified";
    public static final int MAX_FTP_VMS_TXT_FILE_SIZE = 30000;
    private RemoteFile parent;
    private RemoteClient client;
    private Notify notify;
    private RemoteFileAttributes attrib;
    protected File file;
    private RemoteFile[] children = new RemoteFile[0];
    private Vector childrenvector = new Vector();
    private RequestProcessor rp;
    private static final String PATH_SEP = "/";
    private Sync.SyncState clientStatus = Sync.SyncState.Unknown;
    private Sync.SyncState serverStatus = Sync.SyncState.Unknown;
    public static final int NOT_EQUAL = 0;
    public static final int EQUAL = 1;
    public static final int NONE = 2;
    public static final int DIRECTORY = 3;
    private static final int OPEN = 4;
    public static final int SERVER_FILE_MISSING = 5;
    public static final int CLIENT_FILE_MISSING = 6;
    public static final int SERVER_MOD_CLIENT_MISSING = 7;
    public static final int CLIENT_MOD_SERVER_MISSING = 8;
    public static final int BOTH_MODIFIED = 9;
    public static final int SERVER_ONLY = 10;
    public static final int SERVER_NEW_CLIENT_MISSING = 11;
    public static final int CLIENT_NEW_SERVER_MISSING = 12;
    public static final int MISSING = -1;
    public static final int CACHE_MISSING = -1;
    public static final int SERVER_MISSING = -1;
    public static final int HISTORY_MISSING = -2;
    public static final int CACHE_HISTORY_MISSING = -2;
    public static final int SERVER_HISTORY_MISSING = -2;
    public static final int FILE_RES_SERVER_ONLY = 0;
    public static final int FILE_RES_CLIENT_ONLY = 1;
    public static final int FILE_RES_CLIENT_SERVER = 2;
    private boolean onserver;
    private long cachelastmodified = -2L;
    private long serverlastmodified = -2L;
    private boolean childrenchanged = false;
    private boolean nextnochildren = false;
    private RemoteFileSystem remoteFS;
    private String mimeType;
    private int fileResidenceMode = 2;
    private boolean fileOpen = false;

    public RemoteFile(RemoteFileAttributes attrib, RemoteFile parent, RemoteClient client, Notify notify, RequestProcessor rp, File file, boolean onserver, RemoteFileSystem rfs) throws IOException {
        this.attrib = attrib;
        this.parent = parent;
        this.client = client;
        this.notify = notify;
        this.file = file;
        this.onserver = onserver;
        this.rp = rp;
        this.remoteFS = rfs;
        if (attrib.isDirectory()) {
            if (client.isConnected()) {
                if (!onserver) {
                    client.mkdir(this.getName());
                }
                this.onserver = true;
            }
            if (!file.exists()) {
                file.mkdirs();
            }
        } else {
            String name = file.getAbsolutePath().substring(rfs.getLocalRoot().length() + 1);
            name = name.replace(File.separatorChar, '/');
            if (!file.exists()) {
                long cachemodified = -1L;
            } else {
                long cachemodified = file.lastModified();
            }
            Long lastMod = (Long)this.remoteFS.getFileAttribute(name, LAST_MODIFIED_CACHE);
            this.cachelastmodified = lastMod == null || lastMod == 0L ? -2L : lastMod;
            if (!onserver) {
                long servermodified = -1L;
            } else {
                long servermodified = attrib.getDate().getTime();
            }
            lastMod = (Long)this.remoteFS.getFileAttribute(name, LAST_MODIFIED_SERVER);
            this.serverlastmodified = lastMod == null || lastMod == 0L ? -2L : lastMod;
            Integer fileResidenceModeInt = (Integer)this.remoteFS.getFileAttribute(name, "file_residence_mode");
            this.fileResidenceMode = fileResidenceModeInt != null ? fileResidenceModeInt : (this.remoteFS.getServerOnlyFileExts().isRegistered(name) ? 0 : 2);
        }
    }

    public boolean isDir() {
        return this.attrib.isDirectory();
    }

    public File getFile() {
        return this.file;
    }

    public synchronized RemoteFile[] getChildren(RemoteFileSystem ffs) {
        this.childrenchanged = false;
        try {
            this.getChildrenBlock(ffs);
        }
        catch (IOException e) {
            ErrorManager.getDefault().getInstance("org.netbeans.modules.distributed").notify((Throwable)e);
        }
        if (this.childrenchanged) {
            this.notify.fileChanged(this.getName().getFullName());
        }
        return this.children;
    }

    private RemoteFile[] getChildrenBlock(RemoteFileSystem rfs) throws IOException {
        File[] cache;
        Set<Object> serverset;
        Set<Object> childrenset;
        if (this.children == null) {
            // empty if block
        }
        TreeMap<String, RemoteFile> childrenmap = null;
        if (this.children == null) {
            childrenset = new TreeSet(new CaseIgnoreComparator());
        } else {
            childrenmap = new TreeMap<String, RemoteFile>(new CaseIgnoreComparator());
            for (int i = 0; i < this.children.length; ++i) {
                if (this.children[i] == null) continue;
                if (this.remoteFS.getIgnoredFiles() != null && this.remoteFS.getIgnoredFiles().isRegistered(this.children[i].getName().getName())) {
                    this.childrenvector.remove(this.children[i]);
                    this.children[i] = null;
                    continue;
                }
                if (this.remoteFS.getIgnoreHiddenFiles() && this.children[i].getName().getName().startsWith(".")) {
                    this.childrenvector.remove(this.children[i]);
                    this.children[i] = null;
                    continue;
                }
                if (this.remoteFS.getIgnoredFolders() != null && this.remoteFS.getIgnoredFolders().isRegistered(this.children[i].getName().getName())) {
                    this.childrenvector.remove(this.children[i]);
                    this.children[i] = null;
                    continue;
                }
                childrenmap.put(this.children[i].getName().getName(), this.children[i]);
            }
            childrenset = childrenmap.keySet();
        }
        TreeMap<String, RemoteFileAttributes> servermap = new TreeMap<String, RemoteFileAttributes>(new CaseIgnoreComparator());
        if (this.notify.isRefreshServer() && this.onserver && this.client.isConnected()) {
            RemoteFileAttributes[] RemoteFiles = this.client.list(this.getName());
            if (RemoteFiles != null) {
                for (int i = 0; i < RemoteFiles.length; ++i) {
                    if (RemoteFiles[i] != null && (this.remoteFS.getIgnoredFiles() != null && this.remoteFS.getIgnoredFiles().isRegistered(RemoteFiles[i].getName().getName()) || this.remoteFS.getIgnoredFolders() != null && this.remoteFS.getIgnoredFolders().isRegistered(RemoteFiles[i].getName().getName()) || this.remoteFS.getIgnoreHiddenFiles() && RemoteFiles[i].getName().getName().startsWith(".")) || RemoteFiles[i] == null) continue;
                    servermap.put(RemoteFiles[i].getName().getName(), RemoteFiles[i]);
                }
            }
            serverset = servermap.keySet();
        } else {
            serverset = new TreeSet(new CaseIgnoreComparator());
        }
        TreeSet<String> cacheset = new TreeSet<String>(new CaseIgnoreComparator());
        if (this.notify.isScanCache() && (cache = this.file.listFiles()) != null) {
            for (int i = 0; i < cache.length; ++i) {
                String fname = cache[i].getName();
                if (fname != null && (this.remoteFS.getIgnoredFiles() != null && this.remoteFS.getIgnoredFiles().isRegistered(fname) || this.remoteFS.getIgnoreHiddenFiles() && fname.startsWith(".") || this.remoteFS.getIgnoredFolders() != null && this.remoteFS.getIgnoredFolders().isRegistered(fname)) || fname.endsWith(RemoteDefaultAttributes.ATTR_NAME_EXT_XML) || fname.endsWith(RemoteDefaultAttributes.ATTR_NAME_EXT_XML + "~") || fname.endsWith(".shadow")) continue;
                if (cache[i].isFile() && fname.indexOf(46) < 0) {
                    fname = fname + '.';
                }
                if (serverset.contains(fname)) {
                    cacheset.add(((RemoteFileAttributes)servermap.get(fname)).getName().getName());
                    continue;
                }
                cacheset.add(fname);
            }
        }
        if (!childrenset.containsAll(cacheset) && !serverset.containsAll(cacheset)) {
            TreeSet<String> set6 = new TreeSet<String>(new CaseIgnoreComparator());
            set6.addAll(cacheset);
            set6.removeAll(childrenset);
            set6.removeAll(serverset);
            if (!set6.isEmpty()) {
                for (String name : set6) {
                    boolean isDirectory = new File(this.file, name).isDirectory();
                    RemoteFileAttributes remoteFileAttributes = new RemoteFileAttributes(this.getName().createNew(name, isDirectory), isDirectory);
                    RemoteFile rf = new RemoteFile(remoteFileAttributes, this, this.client, this.notify, this.rp, new File(this.file, name), false, rfs);
                    rf.refresh();
                    if (rf.getFileAttributes() != null && rf.getFileAttributes().getSize() != 0L && rf.getFileAttributes().getDate().getTime() != 0L) {
                        cacheset.remove(name);
                        cacheset.add(rf.getName().getName());
                    }
                    this.childrenvector.addElement(rf);
                    this.childrenchanged = true;
                }
            }
        }
        TreeSet<Object> set1_3 = new TreeSet<Object>(new CaseIgnoreComparator());
        set1_3.addAll(serverset);
        if (!childrenset.containsAll(serverset)) {
            TreeSet<Object> set2_7 = new TreeSet<Object>(new CaseIgnoreComparator());
            set2_7.addAll(serverset);
            set2_7.removeAll(childrenset);
            if (!set2_7.isEmpty()) {
                Iterator it = set2_7.iterator();
                while (it.hasNext()) {
                    RemoteFileAttributes at = (RemoteFileAttributes)servermap.get(it.next());
                    RemoteFile remoteFile = new RemoteFile(at, this, this.client, this.notify, this.rp, new File(this.file, at.getName().getName()), true, rfs);
                    remoteFile.refresh(at);
                    this.childrenvector.addElement(remoteFile);
                    this.childrenchanged = true;
                }
                set1_3.removeAll(set2_7);
            }
        }
        Iterator it = set1_3.iterator();
        while (it.hasNext()) {
            RemoteFileAttributes at = (RemoteFileAttributes)servermap.get(it.next());
            ((RemoteFile)childrenmap.get(at.getName().getName())).refresh(at);
        }
        if (!serverset.containsAll(childrenset)) {
            TreeSet<Object> set4_5 = new TreeSet<Object>(new CaseIgnoreComparator());
            set4_5.addAll(childrenset);
            set4_5.removeAll(serverset);
            if (!set4_5.isEmpty()) {
                for (String string : set4_5) {
                    RemoteFile f = (RemoteFile)childrenmap.get(string);
                    if (!this.onserver) {
                        f.onserver = false;
                    }
                    f.refresh();
                }
            }
        }
        this.children = this.childrenvector.toArray(this.children);
        return this.children;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    protected RemoteFileAttributes getFileAttributes() throws IOException {
        RemoteFileAttributes fileAt = this.client.listFile(this.getParent() == null ? "" : this.getParent().getName().getFullName(), this.getName());
        if (fileAt == null) {
            return null;
        }
        return fileAt;
    }

    public void refresh(boolean isSave) throws IOException {
        this.refresh(null, isSave);
    }

    public void refresh(RemoteFileAttributes at) throws IOException {
        this.refresh(at, false);
    }

    public void refresh() throws IOException {
        this.refresh(null, false);
    }

    public Sync.SyncState getClientStatus() {
        return this.clientStatus;
    }

    public Sync.SyncState getServerStatus() {
        return this.serverStatus;
    }

    public String getStatusString() {
        return this.clientStatus + "|" + this.serverStatus;
    }

    public synchronized void copyToServer() throws IOException {
        this.save();
    }

    public synchronized void copyToClient() throws IOException {
        this.load();
    }

    private boolean isFileSaveMode() {
        return Thread.currentThread().getName().startsWith("AWT-EventQueue");
    }

    private boolean isManualRefreshMode() {
        return Thread.currentThread().getName().equals("FTP-Refresh");
    }

    private boolean isGetAllMode() {
        return Thread.currentThread().getName().startsWith("getall");
    }

    private boolean isFolderRefreshMode() {
        return Thread.currentThread().getName().equals("Folder recognizer");
    }

    private boolean isManualSyncMode() {
        return Thread.currentThread().getName().equals("FTP-Synchronize");
    }

    /*
     * Unable to fully structure code
     */
    private void doFileSyncAction(Sync.SyncAction action, boolean isSave) throws IOException {
        logger = Utils.getStatusLogger(this.remoteFS.getLocalRoot(), "sync");
        loggerRefresh = Utils.getStatusLogger(this.remoteFS.getLocalRoot(), "refresh");
        if (this.isManualSyncMode()) {
            logger.info("Synchronizing " + this.file.getAbsolutePath());
            StatusDisplayer.getDefault().setStatusText("Synchronizing " + this.file.getAbsolutePath());
        } else if (this.isManualRefreshMode() || this.isFolderRefreshMode()) {
            loggerRefresh.info("Refreshing " + this.file.getAbsolutePath());
            StatusDisplayer.getDefault().setStatusText("Refreshing " + this.file.getAbsolutePath());
        }
        if ((this.file.getName().toLowerCase().endsWith(".pdf") || this.file.getName().toLowerCase().endsWith(".xml")) && !this.file.exists()) {
            try {
                if (this.isManualSyncMode()) {
                    logger.info("Getting " + this.getName().getFullName());
                } else if (this.isManualRefreshMode() || this.isFolderRefreshMode()) {
                    loggerRefresh.info("Getting " + this.getName().getFullName());
                }
                this.load();
            }
            catch (IOException e) {
                if (this.isManualSyncMode()) {
                    logger.info("Error:" + e.getMessage());
                }
                throw e;
            }
        }
        if (action == Sync.SyncAction.server_to_client) {
            try {
                if (this.isManualSyncMode() || this.isFolderRefreshMode()) {
                    logger.info("Getting " + this.getName().getFullName());
                }
                if (!this.remoteFS.getAutoSync() && !this.isManualSyncMode() || this.isManualRefreshMode()) ** GOTO lbl48
                this.load();
            }
            catch (IOException e) {
                if (this.isManualSyncMode()) {
                    logger.info("Error:" + e.getMessage());
                }
                throw e;
            }
        } else if (action == Sync.SyncAction.client_to_server) {
            try {
                if (this.isManualSyncMode() || this.isFolderRefreshMode()) {
                    logger.info("Putting " + this.file.getAbsolutePath());
                }
                if (!this.remoteFS.getAutoSync() && !this.isManualSyncMode() || this.isManualRefreshMode() || this.isGetAllMode()) ** GOTO lbl48
                this.save();
            }
            catch (IOException e) {
                if (this.isManualSyncMode()) {
                    logger.info("Error:" + e.getMessage());
                }
                throw e;
            }
        } else if (action != Sync.SyncAction.none && action != Sync.SyncAction.remove_from_history && action != Sync.SyncAction.conflict_dialog && action == Sync.SyncAction.throw_exception) {
            this.fileOpen = false;
            throw new IOException("invalid state has occured :No such client nor server file");
        }
lbl48:
        // 6 sources

        if (this.fileOpen) {
            if (!(this.getClientStatus() != Sync.SyncState.Missing && this.getClientStatus() != Sync.SyncState.NoSuchFile || this.file.exists())) {
                this.file.createNewFile();
            }
            SyncTablePanelFileOpen.showSyncFiles(this, true);
            StatusDisplayer.getDefault().setStatusText("");
            return;
        }
        if (!this.file.getName().endsWith("~") && action == Sync.SyncAction.conflict_dialog && (this.isManualSyncMode() || isSave)) {
            SyncTablePanel.showSyncFiles(this, false, this.isManualSyncMode());
        }
        StatusDisplayer.getDefault().setStatusText("");
    }

    protected synchronized void refresh(RemoteFileAttributes at, boolean isSave) throws IOException {
        if (this.isManualSyncMode()) {
            Logger logger = Utils.getStatusLogger(this.remoteFS.getLocalRoot(), "sync");
            if (this.remoteFS.getPrintSyncAllStop() && this.remoteFS.getStopSyncAll()) {
                logger.info("Stopped!");
                this.remoteFS.setPrintSyncAllStop(false);
            } else if (this.remoteFS.getPrintSyncAllStop() && this.remoteFS.getRemoteRuntimeType() != null && this.remoteFS.getRemoteRuntimeType().getRemoteServerError()) {
                logger.info("Aborted due to disconnected server!");
                this.remoteFS.setPrintSyncAllStop(false);
            }
            if (this.remoteFS.getStopSyncAll() || this.remoteFS.getRemoteRuntimeType() != null && this.remoteFS.getRemoteRuntimeType().getRemoteServerError()) {
                return;
            }
        }
        try {
            if (!this.remoteFS.isConnected()) {
                return;
            }
            if (this.isDirectory()) {
                boolean serverdeleted;
                boolean cachedeleted;
                boolean bl = cachedeleted = !this.file.exists();
                if (at == null && this.client.isConnected()) {
                    RemoteFileAttributes newattr = this.getFileAttributes();
                    if (newattr == null) {
                        return;
                    }
                    serverdeleted = !newattr.isDirectory() || newattr.getDate().getTime() == 0L;
                } else {
                    boolean bl2 = serverdeleted = this.client.isConnected() && this.onserver && at != null && at.getDate().getTime() == 0L;
                }
                if (serverdeleted) {
                    this.onserver = false;
                }
                if (cachedeleted && serverdeleted) {
                    this.parent.deleteChild(this);
                    return;
                }
                if (cachedeleted && !serverdeleted) {
                    if (!this.parent.file.exists()) {
                        this.file.mkdirs();
                    } else {
                        this.file.mkdir();
                    }
                }
                if (!serverdeleted) {
                    this.onserver = true;
                }
                if (!cachedeleted && serverdeleted) {
                    String[] list = this.file.list();
                    if (list == null || list.length == 0) {
                        this.deleteFile();
                        this.parent.deleteChild(this);
                    } else {
                        this.client.mkdir(this.getName());
                    }
                }
            } else {
                RemoteFileAttributes newattr = null;
                if (this.client.isConnected()) {
                    if (at == null) {
                        newattr = this.getFileAttributes();
                        if (newattr == null) {
                            return;
                        }
                    } else {
                        newattr = at;
                    }
                    this.onserver = false;
                    if (newattr != null) {
                        this.onserver = false;
                        if (!(this.onserver || newattr.getDate().getTime() == 0L && newattr.getSize() == 0L)) {
                            this.attrib = newattr;
                            this.onserver = true;
                        }
                    }
                } else {
                    return;
                }
                long servermodified = !this.onserver ? -1L : newattr.getDate().getTime();
                long cachemodified = !this.file.exists() ? -1L : this.file.lastModified();
                if (servermodified == -1L && cachemodified == -1L) {
                    this.parent.deleteChild(this);
                    this.fileOpen = false;
                    return;
                }
                this.clientStatus = Sync.getSyncState(this.cachelastmodified, cachemodified);
                this.serverStatus = Sync.getSyncState(this.serverlastmodified, servermodified);
                Sync.SyncAction action = this.isManualSyncMode() || this.file.getName().endsWith(".class") ? Sync.getManualSyncAction(this.clientStatus, this.serverStatus) : Sync.getAction(this.clientStatus, this.serverStatus);
                if (this.getFileResidenceMode() == 1 || this.getFileResidenceMode() == 0 && !this.isFolderRefreshMode()) {
                    action = Sync.SyncAction.none;
                }
                this.doFileSyncAction(action, isSave);
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            this.fileOpen = false;
        }
    }

    public void downloadAll(InputOutput io) throws IOException {
        if (!this.client.isConnected()) {
            return;
        }
        Logger logger = Utils.getStatusLogger(this.remoteFS.getLocalRoot(), "getall");
        if (this.isDirectory()) {
            if (!this.file.exists()) {
                StatusDisplayer.getDefault().setStatusText("Creating " + this.file.getAbsolutePath());
                logger.info("Creating " + this.file.getAbsolutePath());
                this.file.mkdirs();
            }
            this.getChildren(this.remoteFS);
            for (int i = 0; i < this.children.length; ++i) {
                if (this.children[i] == null) continue;
                if (!this.children[i].remoteFS.getStopDownloadAll()) {
                    if (this.children[i].getFileResidenceMode() == 1 || this.children[i].getFileResidenceMode() == 0) continue;
                    this.children[i].downloadAll(io);
                    this.children[i].refresh();
                    continue;
                }
                break;
            }
        } else if (this.onserver) {
            StatusDisplayer.getDefault().setStatusText("Getting " + this.getName().getFullName());
            logger.info("Getting " + this.getName().getFullName());
            this.load();
        } else {
            StatusDisplayer.getDefault().setStatusText(this.getName().getFullName() + " does not exist");
            logger.info(this.getName().getFullName() + " does not exist");
        }
    }

    public void uploadAll(InputOutput io) throws IOException {
        if (!this.client.isConnected()) {
            return;
        }
        Logger logger = Utils.getStatusLogger(this.remoteFS.getLocalRoot(), "putall");
        if (this.isDirectory()) {
            if (!this.onserver) {
                StatusDisplayer.getDefault().setStatusText("Creating " + this.getName().getFullName());
                logger.log(Level.INFO, "Creating " + this.getName().getFullName());
                this.client.mkdir(this.getName());
            }
            this.onserver = true;
            this.getChildren(this.remoteFS);
            for (int i = 0; i < this.children.length; ++i) {
                if (this.children[i] == null) continue;
                if (!this.children[i].remoteFS.getStopUploadAll() && this.children[i].remoteFS.getRemoteRuntimeType() != null && !this.children[i].remoteFS.getRemoteRuntimeType().getRemoteServerError()) {
                    if (this.children[i].getFileResidenceMode() == 1) continue;
                    this.children[i].uploadAll(io);
                    this.children[i].refresh();
                    continue;
                }
                break;
            }
        } else if (this.file.exists()) {
            StatusDisplayer.getDefault().setStatusText("Putting " + this.file.getAbsolutePath());
            logger.info("Putting " + this.file.getAbsolutePath());
            this.save();
        } else {
            StatusDisplayer.getDefault().setStatusText(this.file.getAbsolutePath() + " does not exist");
            logger.info(this.file.getAbsolutePath() + " does not exist");
        }
    }

    public void cleanCache() throws IOException {
        if (this.isDirectory()) {
            for (int i = 0; i < this.children.length; ++i) {
                if (this.children[i] == null) continue;
                this.children[i].cleanCache();
            }
        } else {
            this.file.delete();
            String name = this.file.getAbsolutePath().substring(this.remoteFS.getLocalRoot().length());
            this.remoteFS.setFileAttribute(name, LAST_MODIFIED_CACHE, null);
        }
    }

    public String[] getStringChildren(RemoteFileSystem ffs) throws IOException {
        this.getChildren(ffs);
        String[] s = new String[this.children.length];
        for (int i = 0; i < this.children.length; ++i) {
            if (this.children[i] == null) continue;
            String fname = this.children[i].getName().getName();
            s[i] = fname.endsWith(".JAVA") ? fname.replaceAll("\\.JAVA", ".java") : (fname.endsWith(".CLASS") ? fname.replaceAll("\\.CLASS", ".class") : (fname.endsWith(".JAR") ? fname.replaceAll("\\.JAR", ".jar") : fname));
        }
        return s;
    }

    public RemoteFile getChild(String name) throws IOException {
        this.getChildren(this.remoteFS);
        return this.getExistingChild(name);
    }

    public RemoteFile getExistingChild(String name) throws IOException {
        for (int i = 0; i < this.children.length; ++i) {
            if (this.children[i] == null || !this.children[i].getName().getName().equalsIgnoreCase(name)) continue;
            return this.children[i];
        }
        return null;
    }

    public RemoteFile find(String name) throws IOException {
        RemoteFile thisfile = this;
        StringTokenizer st = new StringTokenizer(name, PATH_SEP);
        while (st.hasMoreTokens()) {
            String next = st.nextToken();
            RemoteFile newfile = thisfile.getExistingChild(next);
            if (newfile == null) {
                newfile = thisfile.getChild(next);
            }
            if ((thisfile = newfile) != null) continue;
            break;
        }
        return thisfile;
    }

    public RemoteFile getParent() {
        return this.parent;
    }

    public boolean isDirectory() {
        return this.attrib.isDirectory();
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public RemoteFileName getName() {
        return this.attrib.getName();
    }

    protected void load() throws IOException {
        if (!this.client.isConnected()) {
            return;
        }
        if (this.isDirectory()) {
            return;
        }
        try {
            if (!this.client.isConnected()) {
                return;
            }
            if (this.file.getName().toLowerCase().endsWith("obj")) {
                return;
            }
            String name = this.file.getAbsolutePath().substring(this.remoteFS.getLocalRoot().length() + 1);
            name = name.replace(File.separatorChar, '/');
            boolean fileCopied = false;
            if (this.file.getName().toLowerCase().endsWith(".jar") || this.file.getName().toLowerCase().endsWith(".class")) {
                this.client.get(this.getName(), this.file, false);
                fileCopied = true;
            } else if (this.file.getName().toLowerCase().endsWith(".form") || this.file.getName().endsWith("~")) {
                this.client.get(this.getName(), this.file, true);
                fileCopied = true;
            } else if (this.remoteFS.getAsciiFileExts().isRegistered(name.substring(name.lastIndexOf(46) >= 0 ? name.lastIndexOf(46) : 0))) {
                this.client.get(this.getName(), this.file, true);
                fileCopied = true;
            } else if (this.mimeType != null && this.mimeType.startsWith("text")) {
                this.client.get(this.getName(), this.file, true);
                fileCopied = true;
            } else {
                Boolean bool = (Boolean)this.remoteFS.getFileAttribute(name, "org.netbeans.modules.text.IsTextFile");
                if (bool != null && bool.booleanValue()) {
                    this.client.get(this.getName(), this.file, true);
                    fileCopied = true;
                } else {
                    this.mimeType = FileUtil.getMIMEType((String)name.substring(name.lastIndexOf(46) >= 0 ? name.lastIndexOf(46) + 1 : 0));
                    if (this.mimeType != null && this.mimeType.startsWith("text")) {
                        this.client.get(this.getName(), this.file, true);
                        fileCopied = true;
                    } else {
                        this.client.get(this.getName(), this.file, true);
                        fileCopied = true;
                    }
                }
            }
            RemoteFileAttributes rfa = this.getFileAttributes();
            if (fileCopied) {
                if (rfa != null) {
                    this.attrib = rfa;
                    this.cachelastmodified = this.file.lastModified();
                    this.serverlastmodified = this.attrib.getDate().getTime();
                    this.remoteFS.setFileAttribute(name, LAST_MODIFIED_SERVER, new Long(this.serverlastmodified));
                    this.remoteFS.setFileAttribute(name, LAST_MODIFIED_CACHE, new Long(this.cachelastmodified));
                    this.clientStatus = Sync.SyncState.UpToDate;
                    this.serverStatus = Sync.SyncState.UpToDate;
                } else {
                    this.clientStatus = Sync.SyncState.Unknown;
                    this.serverStatus = Sync.SyncState.Unknown;
                }
            }
        }
        catch (IOException e) {
            if (e.getMessage().startsWith("550")) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)(" File Name: " + FileUtility.unixPathToOpenVMSPath(RemoteFile.this.getName().getFullName(), RemoteFile.this.isDirectory()) + "\n" + e.getMessage()), 2));
                    }
                });
            }
            throw e;
        }
        if (this.getName() != null) {
            StatusDisplayer.getDefault().setStatusText("");
        }
    }

    protected void save() throws IOException {
        Logger loggerRefresh = Utils.getStatusLogger(this.remoteFS.getLocalRoot(), "refresh");
        if (!this.file.exists()) {
            return;
        }
        if (!this.isDirectory()) {
            if (!this.client.isConnected()) {
                return;
            }
            try {
                String name = this.file.getAbsolutePath().substring(this.remoteFS.getLocalRoot().length() + 1);
                name = name.replace(File.separatorChar, '/');
                boolean fileCopied = false;
                if ((this.file.getName().indexOf(42) >= 0 || this.file.getName().indexOf(37) >= 0) && this.fileResidenceMode != 1) {
                    this.fileResidenceMode = 1;
                    this.remoteFS.setFileAttribute(name, "file_residence_mode", new Integer(this.fileResidenceMode));
                    loggerRefresh.info(this.file.getName() + " did not get copied to the server due to the illegal file name!");
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)("The filename, \"" + RemoteFile.this.file.getName() + "\" ,contains the '*' or '%' character, which are not legal EFS characters on OpenVMS. The FTP residence of the file has been changed to client-only."), 2));
                        }
                    });
                } else if (this.file.getName().toLowerCase().endsWith(".jar") || this.file.getName().toLowerCase().endsWith(".class") || this.file.getName().toLowerCase().endsWith(".nbm")) {
                    if (!this.remoteFS.checkAndupdateRemoteServerError(name)) {
                        this.client.put(this.file, this.getName(), false);
                        this.remoteFS.changeBinFileToSTRMLF(FileUtility.unixPathToOpenVMSPath(this.getName().getFullName(), false));
                        fileCopied = true;
                    } else if (this.isManualRefreshMode() || this.isFolderRefreshMode()) {
                        loggerRefresh.info(this.file.getName() + " did not get copied to the server due to the disconnected remote server!");
                        StatusDisplayer.getDefault().setStatusText(this.file.getName() + " did not get copied to the server due to the disconnected remote server!");
                    }
                } else if (this.file.getName().toLowerCase().endsWith(".form") || this.file.getName().endsWith("~")) {
                    FileUtility.fixCRLF(this.file);
                    this.client.put(this.file, this.getName(), true);
                    fileCopied = true;
                } else if (this.remoteFS.getAsciiFileExts().isRegistered(name.substring(name.lastIndexOf(46) >= 0 ? name.lastIndexOf(46) : 0))) {
                    FileUtility.fixCRLF(this.file);
                    this.client.put(this.file, this.getName(), true);
                    fileCopied = true;
                } else if (this.mimeType != null && this.mimeType.startsWith("text")) {
                    FileUtility.fixCRLF(this.file);
                    this.client.put(this.file, this.getName(), true);
                    fileCopied = true;
                } else {
                    Boolean bool = (Boolean)this.remoteFS.getFileAttribute(name, "org.netbeans.modules.text.IsTextFile");
                    if (bool != null && bool.booleanValue()) {
                        FileUtility.fixCRLF(this.file);
                        this.client.put(this.file, this.getName(), true);
                        fileCopied = true;
                    } else {
                        this.mimeType = FileUtil.getMIMEType((String)name.substring(name.lastIndexOf(46) >= 0 ? name.lastIndexOf(46) + 1 : 0));
                        if (this.mimeType != null && this.mimeType.startsWith("text")) {
                            FileUtility.fixCRLF(this.file);
                            this.client.put(this.file, this.getName(), true);
                            fileCopied = true;
                        } else {
                            this.client.put(this.file, this.getName(), true);
                            fileCopied = true;
                        }
                    }
                }
                if (fileCopied) {
                    RemoteFileAttributes rfa = this.getFileAttributes();
                    if (rfa != null) {
                        this.attrib = rfa;
                        this.serverlastmodified = this.attrib.getDate().getTime();
                        this.cachelastmodified = this.file.lastModified();
                        this.onserver = true;
                        this.remoteFS.setFileAttribute(name, LAST_MODIFIED_SERVER, new Long(this.serverlastmodified));
                        this.remoteFS.setFileAttribute(name, LAST_MODIFIED_CACHE, new Long(this.cachelastmodified));
                        this.clientStatus = Sync.SyncState.UpToDate;
                        this.serverStatus = Sync.SyncState.UpToDate;
                    } else {
                        this.clientStatus = Sync.SyncState.Unknown;
                        this.serverStatus = Sync.SyncState.Unknown;
                    }
                } else {
                    this.onserver = false;
                }
            }
            catch (IOException e) {
                if (e.getMessage().startsWith("550")) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)(" File Name: " + FileUtility.unixPathToOpenVMSPath(RemoteFile.this.getName().getFullName(), RemoteFile.this.isDirectory()) + "\n" + e.getMessage()), 2));
                        }
                    });
                }
                throw e;
            }
        }
        StatusDisplayer.getDefault().setStatusText("");
    }

    public InputStream getInputStream() throws IOException {
        if (this.isDirectory()) {
            throw new FileNotFoundException("Can't get inputstream from directory " + this.file.getPath());
        }
        this.fileOpen = true;
        this.refresh();
        if (!this.file.exists()) {
            return null;
        }
        return new FileInputStream(this.file);
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.isDirectory()) {
            throw new IOException("Can't get outputstream from directory " + this.file.getPath());
        }
        return new RemoteOutputStream(this);
    }

    public long getSize() throws IOException {
        return this.file.length();
    }

    public boolean isReadOnly() {
        return false;
    }

    public Date lastModified() throws IOException {
        long cdate = this.file.lastModified();
        if (cdate == 0L) {
            long l = cdate = this.attrib != null ? this.attrib.getDate().getTime() : 0L;
            if (cdate == 0L) {
                cdate = new Date().getTime();
            }
        }
        return new Date(cdate);
    }

    protected void deleteFile() throws IOException {
        if (this.isDirectory()) {
            this.getChildren(this.remoteFS);
            for (int i = 0; i < this.children.length; ++i) {
                if (this.children[i] != null && !this.onserver) {
                    this.children[i].onserver = false;
                }
                if (this.children[i] == null) continue;
                this.children[i].deleteFile();
            }
            new File(this.file, ".nbattrs").delete();
            this.children = new RemoteFile[0];
            this.childrenchanged = true;
            this.childrenvector.removeAllElements();
            if (this.onserver && this.client.isConnected()) {
                this.client.rmdir(this.getName());
            }
        } else {
            if (this.onserver && this.client.isConnected()) {
                this.client.delete(this.getName());
            }
            String name = this.file.getAbsolutePath().substring(this.remoteFS.getLocalRoot().length() + 1);
            name = name.replace(File.separatorChar, '/');
            this.remoteFS.setFileAttribute(name, LAST_MODIFIED_SERVER, null);
            this.remoteFS.setFileAttribute(name, LAST_MODIFIED_CACHE, null);
            this.remoteFS.setFileAttribute(name, "file_residence_mode", null);
        }
        if (this.file.exists()) {
            this.file.delete();
        }
    }

    public void delete() throws IOException {
        this.deleteFile();
        this.parent.deleteChild(this);
    }

    public void deleteServerFile() throws IOException {
        if (this.onserver && this.client.isConnected()) {
            this.client.delete(this.getName());
        }
        String name = this.file.getAbsolutePath().substring(this.remoteFS.getLocalRoot().length() + 1);
        name = name.replace(File.separatorChar, '/');
        this.remoteFS.setFileAttribute(name, LAST_MODIFIED_SERVER, null);
        this.serverStatus = Sync.SyncState.NoSuchFile;
    }

    public void deleteClientFile() throws IOException {
        if (this.file.exists()) {
            // empty if block
        }
        if (this.file.delete()) {
            String name = this.file.getAbsolutePath().substring(this.remoteFS.getLocalRoot().length() + 1);
            name = name.replace(File.separatorChar, '/');
            this.remoteFS.setFileAttribute(name, LAST_MODIFIED_CACHE, null);
            this.clientStatus = Sync.SyncState.NoSuchFile;
        }
    }

    protected void deleteChild(RemoteFile child) {
        this.childrenvector.removeElement(child);
        this.children = this.childrenvector.toArray(this.children);
        this.childrenchanged = true;
    }

    public void rename(String name) throws IOException {
        if (this.isRoot()) {
            throw new IOException("Cannot rename root of filesystem");
        }
        if (this.parent.getChild(name) != null && !name.equalsIgnoreCase(".nbattrs~")) {
            throw new IOException("File " + this.getName().getFullName() + PATH_SEP + name + " already exists");
        }
        if (this.client.isConnected()) {
            this.client.rename(this.getName(), name);
        } else {
            this.onserver = false;
        }
        this.attrib.getName().setName(name);
        File tmp = new File(this.file.getParentFile(), name);
        this.file.renameTo(tmp);
        this.file = tmp;
    }

    public RemoteFile createData(String name, RemoteFileSystem rf) throws IOException {
        if (this.getChild(name) != null) {
            throw new IOException("File " + this.getName().getFullName() + PATH_SEP + name + " already exists");
        }
        return this.createFile(new RemoteFileAttributes(this.getName().createNew(name, false), false), false, rf);
    }

    public RemoteFile createFolder(String name, RemoteFileSystem rfs) throws IOException {
        if (this.getChild(name) != null) {
            throw new IOException("Folder " + this.getName().getFullName() + PATH_SEP + name + " already exists");
        }
        return this.createFile(new RemoteFileAttributes(this.getName().createNew(name, true), true), false, rfs);
    }

    private RemoteFile createFile(RemoteFileAttributes a, boolean onserver, RemoteFileSystem rfs) throws IOException {
        RemoteFile newfile = new RemoteFile(a, this, this.client, this.notify, this.rp, new File(this.file, a.getName().getName()), onserver, rfs);
        File f = new File(this.file, a.getName().getName());
        if (!f.exists()) {
            boolean isError;
            boolean bl = isError = !f.createNewFile();
            boolean bl2 = isError ? true : (isError = !f.exists());
            if (isError) {
                throw new IOException("Error creating a new file " + f.getAbsolutePath() + " on a local disk");
            }
        }
        this.childrenvector.addElement(newfile);
        this.childrenchanged = true;
        this.children = this.childrenvector.toArray(this.children);
        return newfile;
    }

    public File getCacheFile() {
        return this.file;
    }

    public RemoteFileSystem getRemoteFS() {
        return this.remoteFS;
    }

    public void setFileResidenceMode(int newMode, FileObject fobj) throws IOException {
        if (this.fileResidenceMode == newMode) {
            return;
        }
        if (this.fileResidenceMode == 1) {
            if (newMode == 0) {
                // empty if block
            }
            if (newMode == 2) {
                this.fileResidenceMode = newMode;
                fobj.setAttribute("file_residence_mode", (Object)new Integer(this.fileResidenceMode));
            }
        } else if (this.fileResidenceMode == 0) {
            if (newMode == 1) {
                // empty if block
            }
            if (newMode == 2) {
                this.fileResidenceMode = newMode;
                fobj.setAttribute("file_residence_mode", (Object)new Integer(this.fileResidenceMode));
            }
        } else if (this.fileResidenceMode == 2) {
            if (newMode == 0) {
                if (this.getServerStatus() != Sync.SyncState.Missing && this.getServerStatus() != Sync.SyncState.NoSuchFile) {
                    this.deleteClientFile();
                    this.fileResidenceMode = newMode;
                }
            } else if (this.getClientStatus() != Sync.SyncState.Missing && this.getClientStatus() != Sync.SyncState.NoSuchFile) {
                this.deleteServerFile();
                this.fileResidenceMode = newMode;
            }
            fobj.setAttribute("file_residence_mode", (Object)new Integer(this.fileResidenceMode));
        }
    }

    public int getFileResidenceMode() {
        if (this.remoteFS.getServerOnlyFileExts().isRegistered(this.file.getName())) {
            return 0;
        }
        return this.fileResidenceMode;
    }

    public boolean equals(Object obj) {
        return this.file.getAbsolutePath().equalsIgnoreCase(((RemoteFile)obj).file.getAbsolutePath());
    }

    static interface RequestProcessor {
        public void post(Runnable var1);
    }

    static interface Notify {
        public boolean isRefreshServer();

        public boolean isScanCache();

        public boolean isAlwaysRefresh();

        public void setAlwaysRefresh(boolean var1);

        public int notifyWhichFile(String var1, Date var2, long var3, Date var5, long var6);

        public int notifyBothFilesChanged(String var1, Date var2, long var3, Date var5, long var6);

        public boolean isDownloadServerChangedFile();

        public boolean notifyServerChanged(String var1, Date var2, long var3, Date var5, long var6);

        public boolean notifyCacheExtDelete(String var1, boolean var2);

        public boolean notifyServerExtDelete(String var1, boolean var2);

        public void fileChanged(String var1);

        public void notifyException(Exception var1);
    }

    class CaseIgnoreComparator
    implements Comparator {
        CaseIgnoreComparator() {
        }

        public int compare(Object obj1, Object obj2) {
            return ((String)obj1).toLowerCase().compareTo(((String)obj2).toLowerCase());
        }

        public boolean equals(Object obj) {
            return true;
        }
    }
}

