/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remotefs;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.distributed.remotefs.AbstractNetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.ftpfs.FTPFileSystem;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Utilities;
import patchsources.OpenProjectList_Dist;

public final class MyURLMapperProxy
extends URLMapper {
    private static URLMapper DEFAULT;

    public static void setDefault(URLMapper m) {
        assert (DEFAULT == null);
        assert (m != null);
        DEFAULT = m;
    }

    public URL getURL(FileObject fo, int type) {
        if (fo == null) {
            return null;
        }
        try {
            if (fo.getFileSystem() instanceof AbstractNetworkFileSystem) {
                String path = fo.getPath();
                File f = new File(((AbstractNetworkFileSystem)fo.getFileSystem()).getLocalRoot() + File.separatorChar + path);
                try {
                    return f != null ? MyURLMapperProxy.fileToURL(f, fo) : null;
                }
                catch (MalformedURLException mfx) {
                    return null;
                }
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    private static AbstractNetworkFileSystem searchFS(String filePath) {
        Iterator itr = OpenProjectList_Dist.getFsSet().iterator();
        filePath = filePath + File.separatorChar;
        while (itr.hasNext()) {
            Object obj = itr.next();
            FileSystem fs = (FileSystem)obj;
            if (!(fs instanceof AbstractNetworkFileSystem) || !filePath.toUpperCase().startsWith(((AbstractNetworkFileSystem)fs).getLocalRoot().toUpperCase() + File.separatorChar)) continue;
            return (AbstractNetworkFileSystem)fs;
        }
        return null;
    }

    private static AbstractNetworkFileSystem mountFS(String filePath) {
        AbstractNetworkFileSystem fs = MyURLMapperProxy.searchFS(filePath);
        if (fs == null && (new File(filePath + File.separatorChar + "nbproject" + File.separatorChar + "project.xml").exists() || new File(filePath + File.separatorChar + "NBPROJECT" + File.separatorChar + "PROJECT.XML").exists())) {
            List list = OpenProjectList_Dist.filterURL(filePath);
            for (int i = 0; i < list.size(); ++i) {
                OpenProjectList_Dist.getFsSet().add(list.get(i));
            }
            fs = MyURLMapperProxy.searchFS(filePath);
        }
        return fs;
    }

    private FileObject recursiveRefresh(AbstractNetworkFileSystem fs, String path) {
        FileObject retVal = ((FileSystem)fs).getRoot();
        String root = fs.getLocalRoot();
        int startIndex = 0;
        while (path.indexOf(47, startIndex) > 0) {
            String spath = path.substring(startIndex, path.indexOf(47, startIndex));
            if ((retVal = retVal.getFileObject(spath, "")) != null) {
                retVal.getChildren(false);
                startIndex = path.indexOf(47, startIndex) + 1;
                continue;
            }
            retVal = null;
            break;
        }
        return retVal;
    }

    public FileObject[] getFileObjects(URL url) {
        String filePath = null;
        try {
            File f = new File(URI.create(url.toExternalForm()));
            filePath = FileUtil.normalizeFile((File)f).getAbsolutePath();
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        AbstractNetworkFileSystem fs = MyURLMapperProxy.mountFS(filePath);
        if (fs == null) {
            return null;
        }
        if (filePath.equalsIgnoreCase(fs.getLocalRoot())) {
            return new FileObject[]{((FileSystem)fs).getRoot()};
        }
        String fname = filePath.substring(fs.getLocalRoot().length() + 1).replace('\\', '/') + '/';
        FileObject retVal = this.recursiveRefresh(fs, fname);
        if (retVal == null) {
            return null;
        }
        return new FileObject[]{retVal};
    }

    private static boolean isWindowsDriveRoot(File file) {
        return (Utilities.isWindows() || Utilities.getOperatingSystem() == 2048) && file.getParent() == null;
    }

    static URL fileToURL(File file, FileObject fo) throws MalformedURLException {
        URL retVal = null;
        try {
            if (!(fo.getFileSystem() instanceof FTPFileSystem)) {
                return null;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (MyURLMapperProxy.isWindowsDriveRoot(file)) {
            retVal = new URL("file:/" + file.getAbsolutePath());
        } else {
            String pathSeparator;
            String urlDef;
            if (fo.isFolder() && (!fo.isValid() || fo.isVirtual()) && !(urlDef = file.toURI().toURL().toExternalForm()).endsWith(pathSeparator = "/")) {
                retVal = new URL(urlDef + pathSeparator);
            }
            retVal = retVal == null ? file.toURI().toURL() : retVal;
        }
        return retVal;
    }
}

