/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remoteexecute.generic;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.netbeans.modules.distributed.common.util.FileUtility;
import org.netbeans.modules.distributed.remoteexecute.RemoteExecutor;
import org.netbeans.modules.distributed.remotefs.AbstractNetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.RemoteFSUtils;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.MapFormat;
import org.openide.util.Utilities;

public class RemoteGenericExecutor
extends RemoteExecutor {
    private String target = "";
    private static final long serialVersionUID = 4921782425419448322L;
    public static final String PROP_USE_XTERM = "useXterm";
    public static final String PROP_FILE_EXTENSION = "includeFileExtension";
    public static final String PROP_FILE_UNIX_PATH = "useUnixFilePath";
    public static final String PROP_USE_FILENAME_ONLY = "useFileNameOnly";
    public static final String TAG_FILE = "file";
    public static final String TAG_CURRENT_DIR = "current dir";
    public static final String TAG_ARGUMENTS = "arguments";
    public static final String TAG_ROOT_DIR = "root dir";

    public RemoteGenericExecutor() {
        this.setUseUnixFilePath(false);
        this.setUseFileNameOnly(false);
        this.setIncludeFileExtension(true);
        this.setChangeWorkingDir(true);
        this.setRemoteExecutor(this.getExternalExecutor());
    }

    public boolean isRemoteJavaCompile() {
        return false;
    }

    protected void createDefaultMapFormat(DataObject obj) throws IOException {
        AbstractNetworkFileSystem nfs = null;
        try {
            nfs = (AbstractNetworkFileSystem)obj.getPrimaryFile().getFileSystem();
            MapFormat mf = super.createMapFormat(obj, nfs);
            Map m = mf.getMap();
            FileObject fobj = obj.getPrimaryFile();
            String vmsPath = (String)m.get(TAG_FILE);
            String curDir = (String)m.get(TAG_CURRENT_DIR);
            String rootDir = (String)m.get(TAG_ROOT_DIR);
            if (this.getUseUnixFilePath()) {
                if (!this.getUseFileNameOnly()) {
                    vmsPath = FileUtility.openVMSPathToUnixPath(vmsPath, false);
                }
                m.put(TAG_CURRENT_DIR, FileUtility.openVMSPathToUnixPath(curDir, true));
                m.put(TAG_ROOT_DIR, FileUtility.openVMSPathToUnixPath(rootDir, true));
            }
            if (this.getUseFileNameOnly()) {
                vmsPath = fobj.getNameExt();
            }
            if (!this.getIncludeFileExtension() && fobj.getExt().length() != 0) {
                vmsPath = vmsPath.substring(0, vmsPath.lastIndexOf(46));
            }
            m.put(TAG_FILE, vmsPath);
            this.format = mf;
        }
        catch (FileStateInvalidException exp) {
        }
        catch (IOException e) {
            throw e;
        }
    }

    public boolean getUseXterm() {
        return this.useXterm;
    }

    public void setUseXterm(boolean useX) {
        boolean old = this.useXterm;
        this.useXterm = useX;
    }

    public boolean getChangeWorkingDir() {
        return this.changeWorkingDir;
    }

    public void setChangeWorkingDir(boolean workingDir) {
        boolean old = this.changeWorkingDir;
        this.changeWorkingDir = workingDir;
    }

    public boolean getUseFileNameOnly() {
        return this.useFileNameOnly;
    }

    public void setUseFileNameOnly(boolean fileNameOnly) {
        boolean old = this.useFileNameOnly;
        this.useFileNameOnly = fileNameOnly;
    }

    public String getTarget() {
        return this.target;
    }

    public synchronized void setTarget(String nue) {
        String old = this.target;
        this.target = nue;
    }

    public boolean getIncludeFileExtension() {
        return this.includeFileExtension;
    }

    public void setIncludeFileExtension(boolean fileExt) {
        boolean old = this.includeFileExtension;
        this.includeFileExtension = fileExt;
    }

    public boolean getUseUnixFilePath() {
        return this.useUnixFilePath;
    }

    public void setUseUnixFilePath(boolean useUnixPath) {
        boolean old = this.useUnixFilePath;
        this.useUnixFilePath = useUnixPath;
    }

    public ExecutorTask execute(DataObject obj) throws IOException {
        this.createDefaultMapFormat(obj);
        return super.execute(obj);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.distributed.RemoteExecutor");
    }

    public String getWorkingDirectory(File file, DataObject obj) {
        String cwd = null;
        if (this.workingDirectory != null) {
            if (Utilities.isWindows()) {
                cwd = RemoteFSUtils.__winPathToOpenVMSPath(this.workingDirectory.getAbsolutePath(), true);
                cwd = FileUtility.openVMSPathToUnixPath(cwd, true);
            } else if (Utilities.isUnix() || Utilities.getOperatingSystem() == 16384) {
                cwd = FileUtility.unixPathToOpenVMSPath(this.workingDirectory.getAbsolutePath(), true);
            }
        } else if (Utilities.isWindows()) {
            cwd = RemoteFSUtils._winPathToOpenVMSPath(file.getAbsolutePath(), true, obj.getPrimaryFile().getParent());
        } else if (Utilities.isUnix() || Utilities.getOperatingSystem() == 16384) {
            cwd = RemoteFSUtils.unixPathToOpenVMSPath(file.getAbsolutePath(), true, obj.getPrimaryFile().getParent());
        }
        return cwd;
    }
}

