/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remoteexecute;

import java.util.Iterator;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.distributed.common.util.Utils;
import org.netbeans.modules.distributed.remotefs.ftpfs.FTPFileSystem;
import org.netbeans.modules.distributed.remotefs.ftpfs.RemoteFileSystem;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.actions.NodeAction;
import patchsources.OpenProjectList_Dist;

public class OfflineProject
extends NodeAction {
    private static final String NAME = "Go Offline";

    public String getName() {
        return NAME;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    protected boolean enable(Node[] activatedNodes) {
        for (int j = 0; j < activatedNodes.length; ++j) {
            FileObject fobj;
            int i;
            Lookup lookup = activatedNodes[j].getLookup();
            Project project = (Project)lookup.lookup(Project.class);
            if (project == null) {
                return false;
            }
            Sources srcs = ProjectUtils.getSources((Project)project);
            SourceGroup[] sgroups = srcs.getSourceGroups("generic");
            SourceGroup[] jgroups = srcs.getSourceGroups("java");
            for (i = 0; i < sgroups.length; ++i) {
                fobj = sgroups[i].getRootFolder();
                try {
                    if (!(fobj.getFileSystem() instanceof FTPFileSystem) || !((FTPFileSystem)fobj.getFileSystem()).isConnected()) continue;
                    return true;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            for (i = 0; i < jgroups.length; ++i) {
                fobj = jgroups[i].getRootFolder();
                try {
                    if (!(fobj.getFileSystem() instanceof FTPFileSystem) || !((FTPFileSystem)fobj.getFileSystem()).isConnected()) continue;
                    return true;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    protected void performAction(Node[] activatedNodes) {
        for (int j = 0; j < activatedNodes.length; ++j) {
            Lookup lookup = activatedNodes[j].getLookup();
            Project project = (Project)lookup.lookup(Project.class);
            if (project == null) continue;
            Iterator itr = OpenProjectList_Dist.getFsSet().iterator();
            List list = Utils.quickFilterURL(FileUtil.toFile((FileObject)project.getProjectDirectory()).getAbsolutePath());
            while (itr.hasNext()) {
                FileSystem fs = (FileSystem)itr.next();
                String pRoot = FileUtil.toFile((FileObject)fs.getRoot()).getAbsolutePath();
                for (int i = 0; i < list.size(); ++i) {
                    if (!((String)list.get(i)).equalsIgnoreCase(pRoot) || !(fs instanceof RemoteFileSystem)) continue;
                    ((RemoteFileSystem)fs).disconnectOnBackground();
                }
            }
        }
    }
}

