/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.ideserverclient.actions;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import org.netbeans.modules.distributed.ideserverclient.diagnose.GatherInfo;
import org.netbeans.modules.distributed.ideserverclient.diagnose.GatherInfoPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

public class RemoteDiagnosticAction
extends CallableSystemAction {
    private Dialog myDialog;
    private GatherInfoPanel panel;

    private void displayReport() {
        InputOutput io = IOProvider.getDefault().getIO("Remote Server Diagnostics Report", true);
        io.closeInputOutput();
        io.select();
        io.setFocusTaken(true);
        io.setErrVisible(false);
        io.setErrSeparated(false);
        GatherInfo report = new GatherInfo();
        io.getOut().println("Remote Server Diagnostics Report");
        io.getOut().println("=================================\n");
        io.getOut().println("Distributed NetBeans Client Info");
        io.getOut().println("--------------------------------");
        ArrayList list = report.getClientVersions();
        Iterator itr = list.iterator();
        while (itr.hasNext()) {
            io.getOut().println((String)itr.next());
        }
        io.getOut().println();
        io.getOut().println("NetBeans Environment");
        io.getOut().println("--------------------");
        list = report.getClientEnv();
        itr = list.iterator();
        while (itr.hasNext()) {
            io.getOut().println((String)itr.next());
        }
        io.getOut().println();
        io.getOut().println("Remote Connection Tests");
        io.getOut().println("-----------------------");
        io.getOut().println(GatherInfo.padString("Server Name/IP Address") + this.panel.getHostName());
        io.getOut().println(GatherInfo.padString("OpenVMS Username") + this.panel.getUserName());
        io.getOut().print(GatherInfo.padString("Server host Connectivity"));
        if (!report.isHostReachable(this.panel.getHostName(), this.panel.getRMIPort())) {
            io.getOut().println("FAIL\n" + report.getLastErrorMsg());
            io.getOut().println("\nFinished");
            io.getOut().close();
            return;
        }
        io.getOut().println("PASS");
        io.getOut().print(GatherInfo.padString("IDE$SERVER Availability"));
        if (!report.isIdeServerRunning(this.panel.getHostName(), this.panel.getRMIPort())) {
            io.getOut().println("FAIL\n" + report.getLastErrorMsg());
            io.getOut().println("\nFinished");
            io.getOut().close();
            return;
        }
        io.getOut().println("PASS");
        io.getOut().println("\tServer version is " + report.getServerVersion(this.panel.getHostName(), this.panel.getRMIPort()));
        io.getOut().print(GatherInfo.padString("User Authentication"));
        if (!report.authenUser(this.panel.getHostName(), this.panel.getUserName(), this.panel.getPassword(), this.panel.getRMIPort())) {
            io.getOut().println("FAIL\n" + report.getLastErrorMsg());
            io.getOut().println("\nFinished");
            io.getOut().close();
            return;
        }
        io.getOut().println("PASS");
        io.getOut().print(GatherInfo.padString("Quota Checks"));
        String[] outputs = report.getUserUAI(this.panel.getHostName(), this.panel.getUserName(), this.panel.getPassword(), this.panel.getRMIPort());
        if (outputs[0].length() > 0) {
            io.getOut().println("FAIL\n" + outputs[0]);
        } else {
            io.getOut().println("PASS");
        }
        io.getOut().println();
        io.getOut().print(outputs[1].substring(0, outputs[1].indexOf(10)) + "\n");
        io.getOut().print(outputs[1].substring(outputs[1].indexOf(10) + 1, outputs[1].length()) + "\n");
        io.getOut().println();
        io.getOut().println();
        io.getOut().println("User Login Environment");
        io.getOut().println("----------------------");
        io.getOut().println(report.getUserEnv(this.panel.getHostName(), this.panel.getUserName(), this.panel.getPassword(), this.panel.getRMIPort()));
        io.getOut().println("\nFinished");
        io.getOut().close();
    }

    public void performAction() {
        ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RemoteDiagnosticAction.this.myDialog.dispose();
                if (e.getSource() == DialogDescriptor.OK_OPTION) {
                    RemoteDiagnosticAction.this.panel;
                    GatherInfoPanel.setUserName(RemoteDiagnosticAction.this.panel.getUserName());
                    RemoteDiagnosticAction.this.panel;
                    GatherInfoPanel.setHostName(RemoteDiagnosticAction.this.panel.getHostName());
                    Thread thr = new Thread(new Runnable(){

                        public void run() {
                            RemoteDiagnosticAction.this.displayReport();
                        }
                    });
                    thr.start();
                }
            }
        };
        this.panel = new GatherInfoPanel();
        DialogDescriptor dd = new DialogDescriptor((Object)this.panel, NbBundle.getMessage(RemoteDiagnosticAction.class, (String)"LBL_RemoteDiagnosticAction"), false, listener);
        dd.setValid(false);
        this.panel.setDialogDescriptor(dd);
        this.myDialog = DialogDisplayer.getDefault().createDialog(dd);
        this.myDialog.show();
    }

    public String getName() {
        return NbBundle.getMessage(RemoteDiagnosticAction.class, (String)"LBL_RemoteDiagnosticAction");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected void initialize() {
        super.initialize();
    }
}

