/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.pascalsupport.pascal;

import com.hp.openvms.netbeans.baseclasses.compiler.AlphaVMSCompilerGroup;
import com.hp.openvms.netbeans.pascalsupport.pascal.PascalCompiler;
import com.hp.openvms.netbeans.pascalsupport.pascal.PascalCompilerType;
import com.hp.openvms.netbeans.pascalsupport.pascal.datasys.PascalCompilerSupport;
import com.hp.openvms.netbeans.utils.FileUtilityLang;
import com.hp.openvms.netbeans.utils.OrderedMap;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.openide.compiler.Compiler;
import org.openide.execution.NbProcessDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.MapFormat;
import org.openide.util.Utilities;

public class PascalCompilerGroup
extends AlphaVMSCompilerGroup {
    private PascalCompilerType compilerSvcType = null;
    protected boolean isRemote;

    public boolean getIsRemote() {
        return this.isRemote;
    }

    public void add(Compiler c) throws IllegalArgumentException {
        if (((PascalCompiler)c).isUpToDate()) {
            return;
        }
        super.add(c);
        this.compilerSvcType = ((PascalCompiler)c).getCompilerSvcType();
        this.isRemote = ((PascalCompiler)c).isRemote();
    }

    public void makeAbstract() {
    }

    public static class PascalFormat
    extends MapFormat {
        public static final String TAG_OPTIMIZE = "optimize";
        public static final String TAG_OPTIONS = "options";
        public static final String TAG_CHECK = "check";
        public static final String TAG_BUILD_DIRECTORY = "buildDirectory";
        public static final String TAG_LIST_DIRECTORY = "listDirectory";
        public static final String TAG_DIAGNOSTIC_DIRECTORY = "dignosticDirectory";
        public static final String TAG_ANALYSIS_DIRECTORY = "analysisDirectory";
        public static final String TAG_OBJECT_DIRECTORY = "objectDirectory";
        public static final String TAG_INCLUDE_DIRECTORY = "includeDirectory";
        public static final String TAG_OTHERS = "others";
        public static final String TAG_INCLUDE = "include";
        public static final String TAG_LIBRARY = "library";
        public static final String TAG_DEBUG = "debug";
        public static final String TAG_OTHER_OPTIONS = "otherOptions";
        public static final String TAG_FILE = "file";
        public static final String TAG_MAKEFILE = "command file";
        public static final String TAG_GLOBAL_QUALIFIER = "Global Qualifiers";
        public static final String TAG_LOCAL_QUALIFIER = "Local Qualifiers";
        public static final String TAG_FILENAME = "file name";
        public static final String TAG_EXT = "file extension";
        public static final String TAG_DEVICE = "device";
        public static final String TAG_DIRECTORY = "directory";
        String[] PascalCmds;
        private boolean isRemote;

        public PascalFormat(boolean isRemote) {
            super(new HashMap(7));
            this.isRemote = isRemote;
        }

        public PascalFormat(DataObject[] files, String[] fnames, boolean isRemote) {
            super(new HashMap(7));
            this.isRemote = isRemote;
            this.composeCmds(files, fnames);
        }

        private void fillMap(PascalCompilerSupport pascalSupport, String vmsPath, String unixPath, DataObject dobj) {
            Map map = this.getMap();
            String makefileString = pascalSupport.getMakefileCompiler() == null ? "" : pascalSupport.getMakefileCompiler().getAbsolutePath();
            if (makefileString != null && makefileString.length() > 0) {
                makefileString = this.isRemote ? FileUtilityLang.unixPathToOpenVMSPath(makefileString, false) : FileUtilityLang.unixPathToOpenVMSPath(makefileString, false);
            }
            String ext = dobj.getPrimaryFile().getExt();
            map.put(TAG_EXT, ext);
            String fname = vmsPath.substring(0, vmsPath.length() - ext.length());
            if (fname.endsWith(".")) {
                fname = fname.substring(0, fname.length() - 1);
            }
            map.put(TAG_FILENAME, fname);
            map.put(TAG_DEVICE, vmsPath.substring(0, vmsPath.indexOf(":")));
            map.put(TAG_DIRECTORY, vmsPath.substring(0, vmsPath.length() - dobj.getPrimaryFile().getNameExt().length()));
            map.put(TAG_FILE, vmsPath);
            map.put(TAG_MAKEFILE, makefileString);
            map.put(TAG_GLOBAL_QUALIFIER, pascalSupport.getGlobalQualifier());
            map.put(TAG_LOCAL_QUALIFIER, pascalSupport.getLocalQualifier());
        }

        private String calculateObjectDir(String buildDir, DataObject dobj, String filePath) {
            String buildDirectory = buildDir.trim();
            FileObject fobj = dobj.getPrimaryFile();
            if ((buildDirectory.equals("") || buildDirectory.equals(".")) && filePath != null && !filePath.equals("")) {
                if (this.isRemote && Utilities.isWindows()) {
                    String curDir = (String)fobj.getAttribute("REMOTE_FILEPATH");
                    if (curDir == null || curDir.length() == 0) {
                        File pfile = FileUtil.toFile((FileObject)fobj.getParent());
                        return FileUtilityLang._winPathToOpenVMSPath(pfile.getAbsolutePath(), true, fobj.getParent());
                    }
                } else if (this.isRemote) {
                    String curDir = (String)fobj.getAttribute("REMOTE_FILEPATH");
                    if (curDir == null || curDir.length() == 0) {
                        File pfile = FileUtil.toFile((FileObject)fobj.getParent());
                        return FileUtilityLang.unixPathToOpenVMSPath(pfile.getAbsolutePath(), true, fobj.getParent());
                    }
                } else {
                    int slashIndex = filePath.lastIndexOf(47);
                    if (slashIndex > 0) {
                        return FileUtilityLang.unixPathToOpenVMSPath(filePath.substring(0, slashIndex), true);
                    }
                }
            } else if (this.isRemote) {
                if (buildDirectory.startsWith("/")) {
                    buildDirectory = FileUtilityLang.unixPathToOpenVMSPath(buildDirectory, true);
                }
            } else {
                buildDirectory = FileUtilityLang.unixPathToOpenVMSPath(buildDirectory, true);
            }
            return buildDirectory;
        }

        private String createArguments(String arguments) {
            return this.format(arguments);
        }

        private String createProcessName(String procNameString) {
            String procName = this.format(procNameString);
            if (procName.indexOf(47) >= 0) {
                if (procName.charAt(0) == '@') {
                    procName = procName.substring(1);
                    procName = "@" + FileUtilityLang.unixPathToOpenVMSPath(procName, false);
                } else {
                    procName = FileUtilityLang.unixPathToOpenVMSPath(procName, false);
                }
            }
            return procName;
        }

        private String createDCLProcessName(String procNameString) {
            String procName = this.format(procNameString);
            return procName;
        }

        protected void composeCmds(DataObject[] files, String[] fnames) {
            OrderedMap oMap = new OrderedMap();
            for (int i = 0; i < files.length; ++i) {
                boolean useMakefile = false;
                FileObject fobj = files[i].getPrimaryFile();
                File file = FileUtil.toFile((FileObject)fobj);
                String filePath = this.isRemote ? (Utilities.getOperatingSystem() == 16384 || Utilities.isUnix() ? FileUtilityLang.unixPathToOpenVMSPath(file.getAbsolutePath(), false, fobj) : FileUtilityLang._winPathToOpenVMSPath(file.getAbsolutePath(), false, fobj)) : fnames[i];
                Node.Cookie cookie = files[i].getCookie(PascalCompilerSupport.class);
                if (cookie == null && (cookie = files[i].getCookie(PascalCompilerSupport.class)) == null) continue;
                PascalCompilerSupport pascalSupport = (PascalCompilerSupport)cookie;
                NbProcessDescriptor desc = null;
                if (pascalSupport.getBuildOption().equals(Boolean.TRUE)) {
                    desc = new NbProcessDescriptor(pascalSupport.getBuildCommand(), "");
                    useMakefile = true;
                } else {
                    desc = pascalSupport.getExternalCompiler();
                }
                this.fillMap(pascalSupport, filePath, fnames[i], files[i]);
                String procName = useMakefile ? this.createDCLProcessName(desc.getProcessName()) : this.createProcessName(desc.getProcessName());
                String arguments = this.createArguments(desc.getArguments());
                String cmdLine = procName + " " + arguments;
                cmdLine = cmdLine.trim();
                if (cmdLine.length() == 0) continue;
                String buildDirectory = null;
                buildDirectory = this.calculateObjectDir(pascalSupport.getBuildDirectory() == null ? "" : pascalSupport.getBuildDirectory().getAbsolutePath(), files[i], fnames[i]);
                oMap.put(cmdLine, buildDirectory);
            }
            Iterator itr = oMap.iterator();
            this.PascalCmds = new String[oMap.size() * 2];
            int i = 0;
            while (itr.hasNext()) {
                OrderedMap.Pair mapEntry = (OrderedMap.Pair)itr.next();
                String key = (String)mapEntry.getKey();
                if (mapEntry.getValue() != null) {
                    this.PascalCmds[i++] = "set default " + mapEntry.getValue();
                    this.PascalCmds[i] = key;
                } else {
                    this.PascalCmds[i] = (String)mapEntry.getKey();
                }
                ++i;
            }
        }

        public String[] getCmds() {
            return this.PascalCmds;
        }
    }
}

