/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.debugsupport.debugger;

import com.hp.openvms.netbeans.debugsupport.debugger.CallStackFrame;
import com.hp.openvms.netbeans.debugsupport.debugger.LocalVariable;
import com.hp.openvms.netbeans.debugsupport.debugger.RemoteDebugger;
import com.hp.openvms.netbeans.debugsupport.model.Local;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CallStackFrameImpl
implements CallStackFrame {
    private CallStackFrame sf;
    private RemoteDebugger debugger;
    private int lineNumber;
    private String func;
    private String file;
    private String fullname;
    private String frameNumber;
    private String address;
    private int state;
    private LocalVariable[] cachedVisibleLocalVariables = null;
    private List cachedLocalVariables = null;

    public CallStackFrameImpl(RemoteDebugger debugger, String func, String file, String fullname, String lnum, String address) {
        this.debugger = debugger;
        this.set(func, file, fullname, lnum, address);
        this.frameNumber = null;
    }

    public void set(String func, String file, String fullname, String lnum, String address) {
        this.func = func;
        this.file = file;
        this.fullname = fullname;
        this.address = address;
        if (lnum != null) {
            try {
                this.lineNumber = Integer.parseInt(lnum);
            }
            catch (NumberFormatException ex) {
                this.lineNumber = 1;
            }
        } else {
            this.lineNumber = -1;
        }
        this.setState(2);
    }

    public void setFrameNumber(String frameNumber) {
        this.frameNumber = frameNumber;
    }

    public String getFrameNumber() {
        return this.frameNumber;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public String getFunctionName() {
        return this.func;
    }

    public String getFileName() {
        return this.file;
    }

    public String getFullname() {
        return this.fullname;
    }

    public String getAddr() {
        return this.address;
    }

    public void makeCurrent() {
    }

    public void setState(int state) {
        if (state != this.state && (state == 1 || state == 2)) {
            this.state = state;
        }
    }

    public boolean isObsolete() {
        return this.state == 1;
    }

    public void popFrame() {
    }

    public CallStackFrame getStackFrame() {
        return this.sf;
    }

    private List fillLocalVariables(List l) {
        Iterator itr = l.iterator();
        ArrayList<Local> locals = new ArrayList<Local>();
        while (itr.hasNext()) {
            Local local;
            String sValue;
            List lv = (List)itr.next();
            String sName = (String)lv.get(0);
            String sType = (String)lv.get(1);
            if (lv.get(2) instanceof String) {
                sValue = (String)lv.get(2);
                local = new Local(this.debugger, sName, sType, sValue, this);
                locals.add(local);
                continue;
            }
            sValue = "#(length=" + ((List)lv.get(2)).size() + ")";
            local = new Local(this.debugger, sName, sType, sValue, this);
            List fields = this.fillLocalVariables((List)lv.get(2));
            for (int i = 0; i < fields.size(); ++i) {
                local.addField((Local)fields.get(i));
            }
            locals.add(local);
        }
        return locals;
    }

    public LocalVariable[] getLocalVariables() {
        List l = this.debugger.getLocalVariables();
        if (l == null) {
            this.cachedLocalVariables = l;
            return new LocalVariable[0];
        }
        int n = l.size();
        boolean j = false;
        if (this.cachedVisibleLocalVariables != null && this.cachedLocalVariables == l) {
            return this.cachedVisibleLocalVariables;
        }
        List arrList = this.fillLocalVariables(l);
        LocalVariable[] locals = arrList.toArray(new LocalVariable[0]);
        this.cachedVisibleLocalVariables = locals;
        this.cachedLocalVariables = l;
        return locals;
    }

    public LocalVariable[] visibleVariables() {
        if (this.cachedVisibleLocalVariables != null) {
            return this.cachedVisibleLocalVariables;
        }
        return new LocalVariable[0];
    }
}

