/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.dclsupport.dcl;

import com.hp.openvms.netbeans.dclsupport.dcl.datasys.DCLBuildSupport;
import com.hp.openvms.netbeans.dclsupport.dcl.datasys.MMSDataObject;
import com.hp.openvms.netbeans.dclsupport.dcl.datasys.SHDataObject;
import java.io.File;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import org.netbeans.modules.distributed.common.util.FileUtility;
import org.netbeans.modules.distributed.remoteexecute.RemoteExecutor;
import org.netbeans.modules.distributed.remoteexecute.RemoteProcessDescriptor;
import org.netbeans.modules.distributed.remotefs.AbstractNetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.RemoteFSUtils;
import org.netbeans.modules.distributed.remotefs.propertyeditor.RemoteFSFile;
import org.netbeans.modules.distributed.remotefs.smb.NetworkFileSystem;
import org.openide.compiler.ExternalCompiler;
import org.openide.cookies.CompilerCookie;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.MapFormat;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class RemoteDCLExecutor
extends RemoteExecutor {
    private String target = "";
    private static final long serialVersionUID = 4921782425419448222L;
    private static ResourceBundle bundle;
    private ExternalCompiler.ErrorExpression errorExpression;

    public RemoteDCLExecutor(DataObject dobj) {
        this.setChangeWorkingDir(true);
        DCLBuildSupport dclrb = (DCLBuildSupport)dobj.getCookie(CompilerCookie.class);
        this.errorExpression = dclrb.errorExpression();
    }

    public ExternalCompiler.ErrorExpression getErrorExpression() {
        return this.errorExpression;
    }

    public boolean isRemoteJavaCompile() {
        return false;
    }

    public synchronized RemoteProcessDescriptor getExternalExecutor() {
        return this.remoteExecutor;
    }

    protected void createDefaultMapFormat(DataObject obj, String target) throws IOException {
        AbstractNetworkFileSystem nfs = null;
        try {
            String file;
            nfs = (AbstractNetworkFileSystem)obj.getPrimaryFile().getFileSystem();
            MapFormat mf = super.createMapFormat(obj, nfs);
            if (target.equals("")) {
                Node.Cookie cookie;
                if (obj instanceof MMSDataObject && (cookie = obj.getCookie(DCLBuildSupport.class)) != null) {
                    DCLBuildSupport dclSupport = (DCLBuildSupport)cookie;
                    mf.getMap().put("target", dclSupport.getTarget());
                }
            } else {
                mf.getMap().put("target", target);
            }
            if (obj instanceof SHDataObject && (file = (String)mf.getMap().get("file")) != null && !file.startsWith("/")) {
                file = FileUtility.openVMSPathToUnixPath(file, false);
                mf.getMap().put("file", file);
            }
            this.format = mf;
        }
        catch (FileStateInvalidException exp) {
        }
        catch (IOException e) {
            throw e;
        }
    }

    public String ParameterPromptDialogBox(String sFileExtName, String sInputTitle, String sWindowTitle) {
        return JOptionPane.showInputDialog(null, sInputTitle + sFileExtName, sWindowTitle, 3);
    }

    public ExecutorTask execute(DataObject obj, String target) throws IOException {
        DCLBuildSupport dclrb = (DCLBuildSupport)obj.getCookie(CompilerCookie.class);
        FileObject fobj = obj.getPrimaryFile();
        String cmd = dclrb.getExternalCompiler();
        Boolean bCheckBox = (Boolean)obj.getPrimaryFile().getAttribute("Prompt for Parameters");
        if (bCheckBox == null) {
            bCheckBox = Boolean.FALSE;
        }
        if (bCheckBox.equals(Boolean.TRUE)) {
            cmd = obj instanceof MMSDataObject ? cmd + " " + this.ParameterPromptDialogBox(fobj.getNameExt(), "Qualifiers and Additional Targets for ", "Enter Qualifiers and Additional Targets") : (obj instanceof SHDataObject ? cmd + " " + this.ParameterPromptDialogBox(fobj.getNameExt(), "Arguments for ", "Enter the Arguments") : cmd + " " + this.ParameterPromptDialogBox(fobj.getNameExt(), "Parameters for ", "Enter the Parameters"));
        }
        this.remoteExecutor = new RemoteProcessDescriptor(cmd, "", NbBundle.getBundle(RemoteDCLExecutor.class).getString("MSG_RemoteDCLExecutorHint"));
        this.createDefaultMapFormat(obj, target);
        try {
            if (obj.getPrimaryFile().getFileSystem() instanceof NetworkFileSystem) {
                Thread.currentThread();
                Thread.sleep(2000L);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return super.execute(obj);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.distributed.RemoteDCLExecutor");
    }

    public String getWorkingDirectory(File file, DataObject obj) {
        String cwd = null;
        if (this.workingDirectory != null) {
            if (Utilities.isWindows()) {
                cwd = this.workingDirectory instanceof RemoteFSFile ? (this.workingDirectory.getAbsolutePath().startsWith("/") ? FileUtility.unixPathToOpenVMSPath(this.workingDirectory.getAbsolutePath(), true) : this.workingDirectory.getAbsolutePath()) : RemoteFSUtils.__winPathToOpenVMSPath(this.workingDirectory.getAbsolutePath(), true);
            } else if (Utilities.isUnix() || Utilities.getOperatingSystem() == 16384) {
                cwd = RemoteFSUtils.__unixPathToOpenVMSPath(this.workingDirectory.getAbsolutePath(), true);
            }
        } else if (Utilities.isWindows()) {
            cwd = RemoteFSUtils._winPathToOpenVMSPath(file.getAbsolutePath(), true, obj.getPrimaryFile().getParent());
        } else if (Utilities.isUnix() || Utilities.getOperatingSystem() == 16384) {
            cwd = RemoteFSUtils.unixPathToOpenVMSPath(file.getAbsolutePath(), true, obj.getPrimaryFile().getParent());
        }
        return cwd;
    }
}

