/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.dclsupport.dcl;

import java.util.Map;
import java.util.ResourceBundle;
import org.netbeans.api.project.Project;
import org.netbeans.modules.distributed.common.util.Utils;
import org.netbeans.modules.distributed.remotefs.AbstractNetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.propertyeditor.RemoteFSFile;
import org.openide.compiler.ExternalCompiler;
import org.openide.compiler.ExternalCompilerType;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public abstract class BaseCompilerType
extends ExternalCompilerType {
    public static final String PROP_BUILD_DIRECTORY = "buildDirectory";
    public static final String PROP_EXTERNAL_COMPILER = "externalCompilerString";
    public static final String PROP_OUTPUT_SWITCH = "outputSwitch";
    public static final String PROP_ERROR_EXPRESSION = "errorExpression";
    private static ResourceBundle bundle;
    protected FileObject fobj;
    protected Map settingsMap;
    protected Project project;
    static final long serialVersionUID = 7207548436731777805L;

    public BaseCompilerType(FileObject fobj) {
        this.fobj = fobj;
    }

    public ExternalCompiler.ErrorExpression getErrorExpression() {
        String exp_opt = (String)this.settingsMap.get("error_exp_opt");
        String[] pos = exp_opt.split(" ");
        return new ExternalCompiler.ErrorExpression(NbBundle.getMessage(BaseCompilerType.class, (String)"ALPHA_VMS_ERROR_FILTER"), (String)this.settingsMap.get("error_exp"), Integer.parseInt(pos[0]), Integer.parseInt(pos[1]), Integer.parseInt(pos[2]), Integer.parseInt(pos[3]));
    }

    public void setErrorExpression(ExternalCompiler.ErrorExpression e) {
        this.settingsMap.put("error_exp", e.getErrorExpression());
        this.settingsMap.put("error_exp_opt", Integer.toString(e.getFilePos()) + " " + Integer.toString(e.getLinePos()) + " " + Integer.toString(e.getColumnPos()) + " " + Integer.toString(e.getDescriptionPos()));
    }

    public Boolean outputSwitch() {
        try {
            return ((AbstractNetworkFileSystem)this.fobj.getFileSystem()).getUseXtermCompile() ? Boolean.TRUE : Boolean.FALSE;
        }
        catch (Exception e) {
            return Boolean.FALSE;
        }
    }

    public RemoteFSFile getBuildDirectory() {
        try {
            String dir = (String)this.settingsMap.get("build_dir");
            RemoteFSFile rdir = (RemoteFSFile)Utils.deSerializeObj(dir);
            if (dir == null || dir.trim().length() == 0 || rdir.getAbsolutePath().length() == 0) {
                return null;
            }
            return rdir;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setBuildDirectory(RemoteFSFile buildDir) {
        try {
            if (buildDir != null && buildDir.getAbsolutePath().equals("")) {
                buildDir = null;
            }
            String dir = Utils.serializeObj(buildDir);
            this.settingsMap.put("build_dir", dir);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setExternalCompilerString(String comp) {
        this.settingsMap.put("compile_command", comp);
    }

    public String getExternalCompilerString() {
        return (String)this.settingsMap.get("compile_command");
    }

    public static String getString(String name) {
        if (bundle == null) {
            bundle = NbBundle.getBundle(BaseCompilerType.class);
        }
        return bundle.getString(name);
    }
}

