/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.cppsupport.prop;

import com.hp.openvms.netbeans.cppsupport.prop.PropertyDialogManager;
import com.hp.openvms.netbeans.cppsupport.prop.PropertySheet;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import org.openide.awt.ToolbarButton;
import org.openide.awt.ToolbarToggleButton;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

class PropertySheetToolbar
extends JPanel
implements ActionListener,
PropertyChangeListener {
    private PropertySheet mySheet;
    private ToolbarToggleButton bNoSort;
    private ToolbarToggleButton bAlphaSort;
    private ToolbarToggleButton bTypeSort;
    private ToolbarToggleButton bDisplayWritableOnly;
    private ToolbarButton customizer;
    private ToolbarButton help;
    private boolean ignorePropertyChange = false;

    public PropertySheetToolbar(PropertySheet p) {
        this.mySheet = p;
        this.mySheet.addPropertyChangeListener(this);
        this.setLayout(new FlowLayout(0, 0, 0));
        this.bNoSort = new ToolbarToggleButton((Icon)new ImageIcon(Utilities.loadImage((String)"org/openide/resources/propertysheet/unsorted.gif")));
        this.add((Component)this.bNoSort);
        this.bNoSort.getAccessibleContext().setAccessibleName(PropertySheetToolbar.getString("ACS_CTL_NoSort"));
        this.bNoSort.setToolTipText(PropertySheetToolbar.getString("CTL_NoSort"));
        this.bNoSort.setSelected(true);
        this.bNoSort.addActionListener((ActionListener)this);
        this.bAlphaSort = new ToolbarToggleButton((Icon)new ImageIcon(Utilities.loadImage((String)"org/openide/resources/propertysheet/sortedByNames.gif")));
        this.add((Component)this.bAlphaSort);
        this.bAlphaSort.getAccessibleContext().setAccessibleName(PropertySheetToolbar.getString("ACS_CTL_AlphaSort"));
        this.bAlphaSort.setToolTipText(PropertySheetToolbar.getString("CTL_AlphaSort"));
        this.bAlphaSort.addActionListener((ActionListener)this);
        this.bTypeSort = new ToolbarToggleButton((Icon)new ImageIcon(Utilities.loadImage((String)"org/openide/resources/propertysheet/sortedByTypes.gif")));
        this.add((Component)this.bTypeSort);
        this.bTypeSort.getAccessibleContext().setAccessibleName(PropertySheetToolbar.getString("ACS_CTL_TypeSort"));
        this.bTypeSort.setToolTipText(PropertySheetToolbar.getString("CTL_TypeSort"));
        this.bTypeSort.addActionListener((ActionListener)this);
        this.setSortingMode(this.mySheet.getSortingMode());
        JToolBar.Separator ts = new JToolBar.Separator();
        this.add(ts);
        ts.updateUI();
        this.bDisplayWritableOnly = new ToolbarToggleButton((Icon)new ImageIcon(Utilities.loadImage((String)"org/openide/resources/propertysheet/showWritableOnly.gif")), this.mySheet.getDisplayWritableOnly());
        this.bDisplayWritableOnly.getAccessibleContext().setAccessibleName(PropertySheetToolbar.getString("ACS_CTL_VisibleWritableOnly"));
        this.bDisplayWritableOnly.setToolTipText(PropertySheetToolbar.getString("CTL_VisibleWritableOnly"));
        this.bDisplayWritableOnly.addActionListener((ActionListener)this);
        this.add((Component)this.bDisplayWritableOnly);
        ts = new JToolBar.Separator();
        this.add(ts);
        ts.updateUI();
        this.customizer = new ToolbarButton((Icon)new ImageIcon(Utilities.loadImage((String)"org/openide/resources/propertysheet/customize.gif")));
        this.add((Component)this.customizer);
        this.customizer.getAccessibleContext().setAccessibleName(PropertySheetToolbar.getString("ACS_CTL_Customize"));
        this.customizer.setToolTipText(PropertySheetToolbar.getString("CTL_Customize"));
        this.customizer.setEnabled(false);
        this.customizer.addActionListener((ActionListener)this);
        ts = new JToolBar.Separator();
        this.add(ts);
        ts.updateUI();
        this.help = new ToolbarButton((Icon)new ImageIcon(Utilities.loadImage((String)"org/openide/resources/propertysheet/propertySheetHelp.gif")));
        this.add((Component)this.help);
        this.help.getAccessibleContext().setAccessibleName(PropertySheetToolbar.getString("ACS_CTL_Help"));
        this.help.setToolTipText(PropertySheetToolbar.getString("CTL_Help"));
        this.help.setEnabled(false);
        this.help.addActionListener((ActionListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source == this.bNoSort) {
            this.setSortingMode(0);
        } else if (source == this.bAlphaSort) {
            this.setSortingMode(1);
        } else if (source == this.bTypeSort) {
            this.setSortingMode(2);
        } else if (source == this.customizer) {
            this.mySheet.invokeCustomization();
        } else if (source == this.help) {
            this.mySheet.invokeHelp();
        } else if (source == this.bDisplayWritableOnly) {
            this.ignorePropertyChange = true;
            try {
                this.mySheet.setDisplayWritableOnly(this.bDisplayWritableOnly.isSelected());
            }
            finally {
                this.ignorePropertyChange = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSortingMode(int sortingMode) {
        this.ignorePropertyChange = true;
        try {
            this.mySheet.setSortingMode(sortingMode);
            this.ignorePropertyChange = false;
            this.bNoSort.setSelected(sortingMode == 0);
        }
        catch (PropertyVetoException pve) {
            try {
                PropertyDialogManager.notify(pve);
                this.ignorePropertyChange = false;
                this.bNoSort.setSelected(sortingMode == 0);
            }
            catch (Throwable throwable) {
                this.ignorePropertyChange = false;
                this.bNoSort.setSelected(sortingMode == 0);
                this.bAlphaSort.setSelected(sortingMode == 1);
                this.bTypeSort.setSelected(sortingMode == 2);
                throw throwable;
            }
            this.bAlphaSort.setSelected(sortingMode == 1);
            this.bTypeSort.setSelected(sortingMode == 2);
        }
        this.bAlphaSort.setSelected(sortingMode == 1);
        this.bTypeSort.setSelected(sortingMode == 2);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (this.ignorePropertyChange) {
            return;
        }
        if (evt.getPropertyName() == null) {
            return;
        }
        if (evt.getPropertyName().equals("sortingMode")) {
            this.setSortingMode((Integer)evt.getNewValue());
        }
        if (evt.getPropertyName().equals("displayWritableOnly")) {
            this.bDisplayWritableOnly.setSelected(((Boolean)evt.getNewValue()).booleanValue());
        }
        if (evt.getPropertyName().equals("hasCustomizer")) {
            this.customizer.setEnabled(((Boolean)evt.getNewValue()).booleanValue());
        }
        if (evt.getPropertyName().equals("pageHelpID")) {
            this.help.setEnabled(this.mySheet.getPageHelpID() != null);
        }
    }

    private static void toBufferedImage(ImageIcon icon) {
        BufferedImage img = PropertySheetToolbar.createImage();
        Graphics g = ((Image)img).getGraphics();
        g.drawImage(icon.getImage(), 0, 0, null);
        g.dispose();
        icon.setImage(img);
    }

    private static BufferedImage createImage() {
        ColorModel model = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getColorModel(2);
        BufferedImage buffImage = new BufferedImage(model, model.createCompatibleWritableRaster(16, 16), model.isAlphaPremultiplied(), null);
        return buffImage;
    }

    private static String getString(String key) {
        return NbBundle.getBundle(PropertySheetToolbar.class).getString(key);
    }
}

