/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.basicsupport.editor.basic;

import com.hp.openvms.netbeans.basicsupport.editor.basic.StringToken;
import org.netbeans.api.lexer.LexerInput;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;

public class StringLexerInput
implements LexerInput {
    private String text;
    private int inputIndex;
    private int tokenIndex;
    private int lookaheadIndex;
    private int eof;

    public StringLexerInput(String text) {
        this.text = text;
    }

    public int read() {
        if (this.inputIndex >= this.text.length()) {
            this.eof = 1;
            return -1;
        }
        return this.text.charAt(this.inputIndex++);
    }

    public int getReadLookahead() {
        return Math.max(this.lookaheadIndex, this.inputIndex + this.eof) - this.tokenIndex;
    }

    public int getReadLength() {
        return this.inputIndex - this.tokenIndex;
    }

    public void backup(int count) {
        this.lookaheadIndex = Math.max(this.lookaheadIndex, this.inputIndex + this.eof);
        this.inputIndex -= count;
        if (this.inputIndex < this.tokenIndex) {
            this.inputIndex += count;
            throw new IllegalArgumentException("count=" + count + " > " + (this.inputIndex - this.tokenIndex));
        }
    }

    public Token createToken(TokenId id, int tokenLength) {
        StringToken ret;
        if (tokenLength <= 0) {
            throw new IllegalArgumentException("tokenLength=" + tokenLength + " <= 0");
        }
        if (this.tokenIndex + tokenLength > this.inputIndex + 1) {
            throw new IllegalArgumentException("tokenLength=" + tokenLength + " > number-of-read-characters=" + (this.inputIndex - this.tokenIndex) + ";inputIndex=" + this.inputIndex + "; tokenIndex=" + this.tokenIndex);
        }
        if (this.tokenIndex + tokenLength == this.inputIndex + 1) {
            if (this.tokenIndex == 0) {
                if (tokenLength > this.text.length()) {
                    ret = new StringToken(id, this.text.substring(0, this.text.length()));
                    tokenLength = this.text.length();
                } else {
                    ret = new StringToken(id, this.text.substring(this.tokenIndex, this.tokenIndex + tokenLength));
                }
                this.tokenIndex += tokenLength;
            } else {
                ret = new StringToken(id, this.text.substring(this.tokenIndex - 1, this.tokenIndex - 1 + tokenLength));
                this.tokenIndex += tokenLength - 1;
            }
        } else {
            ret = new StringToken(id, this.text.substring(this.tokenIndex, this.tokenIndex + tokenLength));
            this.tokenIndex += tokenLength;
        }
        return ret;
    }

    public Token createToken(TokenId id) {
        return this.createToken(id, this.inputIndex - this.tokenIndex);
    }

    public CharSequence getReadText(int start, int end) {
        return this.getReadText(this.inputIndex, this.tokenIndex);
    }

    public boolean isEOFLookahead() {
        return this.getReadLookahead() <= 0;
    }
}

