/*
 * Decompiled with CFR 0.152.
 */
package org.openide.actions;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import org.openide.ErrorManager;
import org.openide.cookies.ExecCookie;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.CookieAction;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

public class ExecuteAction
extends CookieAction {
    private static String workspace = "None";
    private static boolean runCompilation = true;

    private static void changeWorkspace() {
        WindowManager windowManager = WindowManager.getDefault();
        Workspace workspace = windowManager.findWorkspace(ExecuteAction.workspace);
        if (workspace != null) {
            workspace.activate();
        }
    }

    public static String getWorkspace() {
        return workspace;
    }

    public static void setWorkspace(String string) {
        workspace = string;
    }

    public static void setRunCompilation(boolean bl) {
        runCompilation = bl;
    }

    public static boolean getRunCompilation() {
        return runCompilation;
    }

    protected Class[] cookieClasses() {
        return new Class[]{ExecCookie.class};
    }

    protected void performAction(final Node[] nodeArray) {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                ExecuteAction.execute(nodeArray, runCompilation, true);
            }
        });
    }

    protected boolean asynchronous() {
        return false;
    }

    protected int mode() {
        return 7;
    }

    public String getName() {
        return NbBundle.getMessage((Class)ExecuteAction.class, (String)"Execute");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ExecuteAction.class);
    }

    protected String iconResource() {
        return "org/openide/resources/actions/execute.gif";
    }

    public static void execute(Iterator iterator) {
        while (iterator.hasNext()) {
            ExecCookie execCookie = (ExecCookie)iterator.next();
            if (execCookie == null) continue;
            execCookie.start();
        }
    }

    public static boolean execute(DataObject[] dataObjectArray, boolean bl) {
        HashSet<ExecCookie> hashSet = new HashSet<ExecCookie>();
        for (int i = 0; i < dataObjectArray.length; ++i) {
            ExecCookie execCookie = (ExecCookie)dataObjectArray[i].getCookie(class$org$openide$cookies$ExecCookie == null ? ExecuteAction.class$("org.openide.cookies.ExecCookie") : class$org$openide$cookies$ExecCookie);
            if (execCookie == null) continue;
            hashSet.add(execCookie);
        }
        if (bl && !ExecuteAction.compile("compileDataObjects", dataObjectArray)) {
            return false;
        }
        ExecuteAction.execute(hashSet.iterator());
        return true;
    }

    public static boolean execute(Node[] nodeArray, boolean bl) {
        return ExecuteAction.execute(nodeArray, bl, false);
    }

    private static boolean execute(Node[] nodeArray, boolean bl, boolean bl2) {
        HashSet<ExecCookie> hashSet = new HashSet<ExecCookie>();
        for (int i = 0; i < nodeArray.length; ++i) {
            ExecCookie execCookie = (ExecCookie)nodeArray[i].getCookie(class$org$openide$cookies$ExecCookie == null ? ExecuteAction.class$("org.openide.cookies.ExecCookie") : class$org$openide$cookies$ExecCookie);
            if (execCookie == null) continue;
            hashSet.add(execCookie);
        }
        if (bl && !ExecuteAction.compile("compileNodes", nodeArray)) {
            return false;
        }
        if (bl2) {
            Mutex.EVENT.readAccess(new Mutex.Action(){

                public Object run() {
                    ExecuteAction.changeWorkspace();
                    return null;
                }
            });
        }
        ExecuteAction.execute(hashSet.iterator());
        return true;
    }

    private static boolean compile(String string, Object[] objectArray) {
        try {
            Class<?> clazz = ((ClassLoader)Lookup.getDefault().lookup(ClassLoader.class)).loadClass("org.openide.actions.AbstractCompileAction");
            Method method = clazz.getDeclaredMethod(string, objectArray.getClass());
            return (Boolean)method.invoke(null, new Object[]{objectArray});
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(1, (Throwable)exception);
            return false;
        }
    }
}

