/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remoteproject.panels;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableModel;
import org.netbeans.modules.distributed.ideserverclient.RemoteRuntimeType;
import org.netbeans.modules.distributed.ideserverclient.settings.DistributedSettings;
import org.openide.util.NbBundle;

public class RemoteRuntimeSelectPanel
extends JPanel {
    private RemoteRuntimeType rrt;
    private NoEditJTable jTable1;
    private JComboBox jComboBox1;

    public RemoteRuntimeSelectPanel() {
        this.initComponents();
        this.setName(NbBundle.getMessage((Class)RemoteRuntimeSelectPanel.class, (String)"TITLE_RemoteRuntimePanel"));
        this.setupComponents();
    }

    public RemoteRuntimeType getRemoteRuntimeType() {
        return this.rrt;
    }

    private void setupTable() {
        this.jTable1 = new NoEditJTable(new Object[][]{{null, null}, {null, null}, {null, null}, {null, null}, {null, null}}, new String[]{"Name", "Value"});
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        JScrollPane jScrollPane = new JScrollPane(this.jTable1);
        jScrollPane.setBorder(new TitledBorder("Remote IDE Server Properties"));
        this.add((Component)jScrollPane, gridBagConstraints);
    }

    private void fillupTable(RemoteRuntimeType remoteRuntimeType) {
        String string;
        String string2;
        try {
            string2 = remoteRuntimeType.getRemoteRuntime().getJDKVersion();
            string = remoteRuntimeType.getRemoteRuntime().getOperatingSystem();
        }
        catch (RemoteException remoteException) {
            string2 = "Unknown";
            string = "unknown";
        }
        TableModel tableModel = this.jTable1.getModel();
        tableModel.setValueAt("Host Name", 0, 0);
        tableModel.setValueAt(remoteRuntimeType.getHostName(), 0, 1);
        tableModel.setValueAt("User Name", 1, 0);
        tableModel.setValueAt(remoteRuntimeType.getUserName(), 1, 1);
        tableModel.setValueAt("Port Number", 2, 0);
        tableModel.setValueAt(new Integer(remoteRuntimeType.getPort()), 2, 1);
        tableModel.setValueAt("JDK version", 3, 0);
        tableModel.setValueAt(string2, 3, 1);
        tableModel.setValueAt("OS", 4, 0);
        tableModel.setValueAt(string, 4, 1);
    }

    private void setupComboBox() {
        Vector<Pair> vector = new Vector<Pair>();
        HashSet hashSet = DistributedSettings.getDefault().getRemoteRuntimes();
        Iterator iterator = hashSet.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            RemoteRuntimeType remoteRuntimeType = (RemoteRuntimeType)iterator.next();
            if (!remoteRuntimeType.isConnected()) continue;
            if (bl) {
                this.fillupTable(remoteRuntimeType);
                bl = false;
                this.rrt = remoteRuntimeType;
            }
            Pair pair = new Pair(remoteRuntimeType.getHostName() + ":" + remoteRuntimeType.getUserName(), remoteRuntimeType);
            vector.add(pair);
        }
        this.jComboBox1 = new JComboBox(vector);
        this.jComboBox1.setBorder(new TitledBorder("Remote IDE Servers"));
        this.jComboBox1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                Pair pair = (Pair)jComboBox.getSelectedItem();
                RemoteRuntimeSelectPanel.this.rrt = (RemoteRuntimeType)pair.getSecond();
                RemoteRuntimeSelectPanel.this.fillupTable(RemoteRuntimeSelectPanel.this.rrt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.jComboBox1, gridBagConstraints);
    }

    private void setupComponents() {
        this.setupTable();
        this.setupComboBox();
        JTextArea jTextArea = new JTextArea();
        jTextArea.setText("Select the Remote IDE Server to perform remote operations on this file system. If no Remote IDE Server is listed on the Combo box, go to the Runtime Tab, find \"Remote IDE Servers\", and add desired Remote IDE Server");
        jTextArea.setOpaque(false);
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)jTextArea, gridBagConstraints);
    }

    public Object getPropertyValue() throws IllegalStateException {
        return this.getRemoteRuntimeType();
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
    }

    private void jButton1ActionPerformed(ActionEvent actionEvent) {
    }

    class NoEditJTable
    extends JTable {
        public NoEditJTable(Object[][] objectArray, Object[] objectArray2) {
            super(objectArray, objectArray2);
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }

    class Pair
    implements Serializable {
        private Object p1;
        private transient Object p2;

        public Pair(Object object, Object object2) {
            this.p1 = object;
            this.p2 = object2;
        }

        public Object getFirst() {
            return this.p1;
        }

        public Object getSecond() {
            return this.p2;
        }

        public boolean equals(Object object) {
            return this.p1.equals(((Pair)object).getFirst());
        }

        public String toString() {
            return this.p1.toString();
        }
    }
}

