/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remoteproject;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Properties;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.distributed.remoteproject.RemoteProject;
import org.openide.util.NbBundle;

public class RemoteProjectPropertiesPanel
extends JPanel {
    private RemoteProject project = null;
    private Properties currSettings = null;
    private boolean changing = false;
    private String lastGoodResolution = "640x480";
    private JCheckBox antialias;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JCheckBox jitterBox;
    private JLabel prodRendLbl;
    private JLabel qualValue;
    private JSlider quality;
    private JLabel quallabel;
    private JComboBox renderAt;
    private JLabel renderAtLbl;
    private JLabel reslabel;
    private JComboBox resolution;

    RemoteProjectPropertiesPanel(RemoteProject remoteProject) {
        this.initComponents();
        this.initialize(remoteProject);
    }

    private void initialize(RemoteProject remoteProject) {
        this.project = remoteProject;
    }

    private void setControlsEnabled(boolean bl) {
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (componentArray[i] == this.renderAt || componentArray[i] == this.renderAtLbl) continue;
            componentArray[i].setEnabled(bl);
        }
        this.prodRendLbl.setEnabled(bl);
    }

    public boolean isChanged() {
        Properties properties = new Properties(this.currSettings);
        return properties.equals(this.currSettings);
    }

    private void initComponents() {
        this.reslabel = new JLabel();
        this.resolution = new JComboBox();
        this.quallabel = new JLabel();
        this.antialias = new JCheckBox();
        this.quality = new JSlider();
        this.qualValue = new JLabel();
        this.jPanel1 = new JPanel();
        this.prodRendLbl = new JLabel();
        this.jPanel2 = new JPanel();
        this.renderAtLbl = new JLabel();
        this.renderAt = new JComboBox();
        this.jitterBox = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.reslabel.setLabelFor(this.resolution);
        this.reslabel.setText(NbBundle.getMessage((Class)RemoteProjectPropertiesPanel.class, (String)"LBL_Resolution"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 12, 0, 5);
        this.add((Component)this.reslabel, gridBagConstraints);
        this.resolution.setEditable(true);
        this.resolution.setModel(new DefaultComboBoxModel<String>(new String[]{"1024x768", "640x480", "320x200", "160x100"}));
        this.resolution.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                RemoteProjectPropertiesPanel.this.checkResolutionValue(focusEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 30;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 12);
        this.add((Component)this.resolution, gridBagConstraints);
        this.quallabel.setLabelFor(this.quality);
        this.quallabel.setText(NbBundle.getMessage((Class)RemoteProjectPropertiesPanel.class, (String)"LBL_Quality"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 12, 0, 5);
        this.add((Component)this.quallabel, gridBagConstraints);
        this.antialias.setText(NbBundle.getMessage((Class)RemoteProjectPropertiesPanel.class, (String)"KEY_AntiAlias"));
        this.antialias.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RemoteProjectPropertiesPanel.this.change(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 12, 5);
        this.add((Component)this.antialias, gridBagConstraints);
        this.quality.setMaximum(9);
        this.quality.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                RemoteProjectPropertiesPanel.this.qualityStateChanged(changeEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.quality, gridBagConstraints);
        this.qualValue.setHorizontalAlignment(11);
        this.qualValue.setLabelFor(this.quality);
        this.qualValue.setText("0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.ipadx = 20;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 0, 0, 12);
        this.add((Component)this.qualValue, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.prodRendLbl.setText(NbBundle.getMessage((Class)RemoteProjectPropertiesPanel.class, (String)"LBL_Production"));
        this.prodRendLbl.setBorder(new EmptyBorder(new Insets(6, 0, 9, 5)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.prodRendLbl, gridBagConstraints);
        this.jPanel2.setBorder(new CompoundBorder(new CompoundBorder(new EmptyBorder(new Insets(7, 0, 0, 0)), new CompoundBorder(new MatteBorder(new Insets(1, 0, 0, 0), UIManager.getDefaults().getColor("controlShadow")), new MatteBorder(new Insets(1, 0, 0, 0), UIManager.getDefaults().getColor("controlHighlight")))), null));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 12, 0, 12);
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.renderAtLbl.setLabelFor(this.renderAt);
        this.renderAtLbl.setText(NbBundle.getMessage((Class)RemoteProjectPropertiesPanel.class, (String)"LBL_RenderWith"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 16, 5);
        this.add((Component)this.renderAtLbl, gridBagConstraints);
        this.renderAt.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RemoteProjectPropertiesPanel.this.renderAtActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(12, 0, 16, 12);
        this.add((Component)this.renderAt, gridBagConstraints);
        this.jitterBox.setText(NbBundle.getMessage((Class)RemoteProjectPropertiesPanel.class, (String)"KEY_Jitter"));
        this.jitterBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RemoteProjectPropertiesPanel.this.change(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 20;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 0, 12, 5);
        this.add((Component)this.jitterBox, gridBagConstraints);
    }

    private void renderAtActionPerformed(ActionEvent actionEvent) {
    }

    private void checkResolutionValue(FocusEvent focusEvent) {
        try {
            int n = this.getResolutionValue(true);
            int n2 = this.getResolutionValue(false);
            this.lastGoodResolution = (String)this.resolution.getSelectedItem();
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
            this.resolution.setSelectedItem(this.lastGoodResolution);
        }
    }

    private int getResolutionValue(boolean bl) throws NumberFormatException {
        String string = (String)this.resolution.getSelectedItem();
        int n = string.indexOf("x");
        if (n == -1) {
            n = string.indexOf("X");
        }
        if (n == -1 && n != string.length() - 1) {
            throw new NumberFormatException("No x");
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        if (bl) {
            return Integer.parseInt(string2);
        }
        return Integer.parseInt(string3);
    }

    private void qualityStateChanged(ChangeEvent changeEvent) {
        this.change(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void change(ActionEvent actionEvent) {
        if (this.changing) {
            return;
        }
        this.changing = true;
        try {
            int n = this.quality.getValue();
            this.qualValue.setText(Integer.toString(n));
            this.checkResolutionValue(null);
        }
        finally {
            this.changing = false;
        }
    }
}

