/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remoteproject;

import java.awt.Image;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.Action;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.distributed.remoteexecute.BuildProject;
import org.netbeans.modules.distributed.remoteexecute.OfflineProject;
import org.netbeans.modules.distributed.remoteexecute.OnlineProject;
import org.netbeans.modules.distributed.remotefs.ftpfs.FTPFileSystem;
import org.netbeans.modules.distributed.remoteproject.OpenVMSSources;
import org.netbeans.modules.distributed.remoteproject.RemoteProject;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

class RemoteProjectLogicalView
implements LogicalViewProvider {
    private RemoteProject project;
    static /* synthetic */ Class class$org$netbeans$api$project$ProjectInformation;
    static /* synthetic */ Class class$org$openide$actions$ToolsAction;

    public RemoteProjectLogicalView(RemoteProject remoteProject) {
        this.project = remoteProject;
    }

    public Node createLogicalView() {
        try {
            FileSystem fileSystem = this.project.getProjectDirectory().getFileSystem();
            List list = this.project.getRoots();
            for (int i = 0; i < list.size(); ++i) {
                FileOwnerQuery.markExternalOwner((FileObject)((FileSystem)list.get(i)).getRoot(), (Project)this.project, (int)0);
            }
            Node node = DataObject.find((FileObject)((FileSystem)list.get(OpenVMSSources.SRC_ROOT)).getRoot()).getNodeDelegate();
            return new ScenesNode(node, node, this.project);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            ErrorManager.getDefault().notify((Throwable)dataObjectNotFoundException);
            return new AbstractNode(Children.LEAF);
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
            return new AbstractNode(Children.LEAF);
        }
    }

    public Node findPath(Node node, Object object) {
        if (object instanceof DataObject) {
            return null;
        }
        return null;
    }

    private static final class ScenesNode
    extends FilterNode {
        final RemoteProject project;
        private static final int BADGE_ICON_SHIFT_X = 16;
        private static final int BADGE_ICON_SHIFT_Y = 1;

        public ScenesNode(Node node, Node node2, RemoteProject remoteProject) throws DataObjectNotFoundException {
            super(node, (Children)new LogicalViewChildren(remoteProject), (Lookup)new ProxyLookup(new Lookup[]{Lookups.singleton((Object)remoteProject), node.getLookup()}));
            this.project = remoteProject;
        }

        public ScenesNode(Node node, RemoteProject remoteProject) throws DataObjectNotFoundException {
            super(node, (Children)new FilterNode.Children(node), (Lookup)new ProxyLookup(new Lookup[]{Lookups.singleton((Object)remoteProject), node.getLookup()}));
            this.project = remoteProject;
        }

        public Image getIcon(int n) {
            Image image = Utilities.loadImage((String)"org/netbeans/core/resources/mime.gif");
            List list = this.project.getRoots();
            for (int i = 0; i < list.size(); ++i) {
                FileSystem fileSystem = (FileSystem)list.get(i);
                HashSet<FileObject> hashSet = new HashSet<FileObject>();
                hashSet.add(fileSystem.getRoot());
                image = fileSystem.getStatus().annotateIcon(image, n, hashSet);
            }
            return image;
        }

        public Image getOpenedIcon(int n) {
            return this.getIcon(n);
        }

        public Action[] getActions(boolean bl) {
            return this.getAdditionalActions();
        }

        public String getDisplayName() {
            try {
                ProjectInformation projectInformation = (ProjectInformation)this.project.getLookup().lookup(class$org$netbeans$api$project$ProjectInformation == null ? (class$org$netbeans$api$project$ProjectInformation = RemoteProjectLogicalView.class$("org.netbeans.api.project.ProjectInformation")) : class$org$netbeans$api$project$ProjectInformation);
                if (projectInformation != null) {
                    return projectInformation.getDisplayName();
                }
                return this.project.getProjectDirectory().getName();
            }
            catch (Exception exception) {
                return this.project.getProjectDirectory().getName();
            }
        }

        private Action[] getAdditionalActions() {
            ArrayList<Action> arrayList = new ArrayList<Action>();
            arrayList.add(CommonProjectActions.newFileAction());
            arrayList.add(CommonProjectActions.closeProjectAction());
            arrayList.add(CommonProjectActions.deleteProjectAction());
            arrayList.add((Action)new BuildProject());
            arrayList.add((Action)new OfflineProject());
            arrayList.add((Action)new OnlineProject());
            arrayList.add(null);
            arrayList.add(null);
            arrayList.add((Action)SystemAction.get((Class)(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = RemoteProjectLogicalView.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction)));
            arrayList.add(null);
            Action action = CommonProjectActions.customizeProjectAction();
            arrayList.add(action);
            return arrayList.toArray(new Action[arrayList.size()]);
        }
    }

    private static final class SourceNode
    extends FilterNode {
        final RemoteProject project;
        final FileObject fo;

        public SourceNode(Node node, Node node2, RemoteProject remoteProject, FileObject fileObject) throws DataObjectNotFoundException {
            super(node, (Children)new FilterNode.Children(node), (Lookup)new ProxyLookup(new Lookup[]{Lookups.singleton((Object)remoteProject), node.getLookup()}));
            this.project = remoteProject;
            this.fo = fileObject;
        }

        public SourceNode(Node node, RemoteProject remoteProject, FileObject fileObject) throws DataObjectNotFoundException {
            super(node, (Children)new FilterNode.Children(node), (Lookup)new ProxyLookup(new Lookup[]{Lookups.singleton((Object)remoteProject), node.getLookup()}));
            this.project = remoteProject;
            this.fo = fileObject;
        }

        public Image getIcon(int n) {
            return Utilities.loadImage((String)"org/netbeans/modules/java/j2seproject/ui/resources/packageRoot.gif");
        }

        public Image getOpenedIcon(int n) {
            return this.getIcon(n);
        }

        public String getDisplayName() {
            try {
                String string = "";
                if (this.fo.getFileSystem() instanceof FTPFileSystem) {
                    string = ((FTPFileSystem)this.fo.getFileSystem()).isConnected() ? "" : "<offline> ";
                }
                return string + FileUtil.toFile((FileObject)this.fo).getAbsolutePath();
            }
            catch (Exception exception) {
                return this.project.getProjectDirectory().getName();
            }
        }
    }

    private static final class LogicalViewChildren
    extends Children.Keys {
        private RemoteProject project;

        public LogicalViewChildren(RemoteProject remoteProject) {
            this.project = remoteProject;
        }

        private Sources getSources() {
            return ProjectUtils.getSources((Project)this.project);
        }

        protected void addNotify() {
            super.addNotify();
            this.setKeys(this.getKeys());
        }

        protected Node[] createNodes(Object object) {
            Node[] nodeArray = new Node[]{};
            if (object instanceof SourceGroupKey) {
                try {
                    Node node = DataObject.find((FileObject)((SourceGroupKey)object).fileObject).getNodeDelegate();
                    nodeArray = new Node[]{new SourceNode(node, node, this.project, ((SourceGroupKey)object).fileObject)};
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    // empty catch block
                }
            }
            return nodeArray;
        }

        private Collection getKeys() {
            if (this.project.getProjectDirectory() == null || !this.project.getProjectDirectory().isValid()) {
                return Collections.EMPTY_LIST;
            }
            Sources sources = this.getSources();
            SourceGroup[] sourceGroupArray = sources.getSourceGroups(null);
            ArrayList<SourceGroupKey> arrayList = new ArrayList<SourceGroupKey>(sourceGroupArray.length);
            for (int i = 0; i < sourceGroupArray.length; ++i) {
                arrayList.add(new SourceGroupKey(sourceGroupArray[i]));
            }
            return arrayList;
        }
    }

    private static class SourceGroupKey {
        public final SourceGroup group;
        public final FileObject fileObject;

        SourceGroupKey(SourceGroup sourceGroup) {
            this.group = sourceGroup;
            this.fileObject = sourceGroup.getRootFolder();
        }

        public int hashCode() {
            return this.fileObject.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof SourceGroupKey)) {
                return false;
            }
            SourceGroupKey sourceGroupKey = (SourceGroupKey)object;
            String string = this.group.getDisplayName();
            String string2 = sourceGroupKey.group.getDisplayName();
            return this.fileObject.equals(sourceGroupKey.fileObject) && string == null ? string2 == null : string.equals(string2);
        }
    }
}

