/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.awt.Component;
import java.awt.Dialog;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.ServiceType;
import org.openide.cookies.ArgumentsCookie;
import org.openide.cookies.ExecCookie;
import org.openide.execution.Executor;
import org.openide.loaders.DataObject;
import org.openide.loaders.Environment;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class ExecutionSupport
implements ExecCookie,
ArgumentsCookie {
    private static final String EA_EXECUTOR = "NetBeansAttrExecutor";
    private static final String EA_ARGUMENTS = "NetBeansAttrArguments";
    public static final String PROP_FILE_PARAMS = "params";
    public static final String PROP_EXECUTION = "execution";
    private MultiDataObject.Entry entry;
    protected static final String READONLY_ATTRIBUTES = "readOnlyAttrs";
    static /* synthetic */ Class class$org$openide$execution$Executor;
    static /* synthetic */ Class class$java$lang$String;

    public ExecutionSupport(MultiDataObject.Entry entry) {
        this.entry = entry;
    }

    protected MultiDataObject.Entry getEntry() {
        return this.entry;
    }

    public void start() {
        Executor executor = ExecutionSupport.getExecutor(this.entry);
        if (executor == null) {
            executor = this.defaultExecutor();
        }
        try {
            executor.execute((DataObject)this.entry.getDataObject());
        }
        catch (IOException iOException) {
            Mutex.EVENT.readAccess(new Runnable(){

                public void run() {
                    if (ExecutionSupport.this.startFailed(iOException)) {
                        ExecutionSupport.this.start();
                    }
                }
            });
        }
    }

    protected boolean startFailed(IOException iOException) {
        Executor executor;
        Executor executor2 = ExecutionSupport.getExecutor(this.entry);
        if (executor2 == null) {
            executor2 = this.defaultExecutor();
        }
        if ((executor = (Executor)ExecutionSupport.choose(executor2, class$org$openide$execution$Executor == null ? (class$org$openide$execution$Executor = ExecutionSupport.class$("org.openide.execution.Executor")) : class$org$openide$execution$Executor, iOException)) == null) {
            return false;
        }
        try {
            ExecutionSupport.setExecutor(this.entry, executor);
            return true;
        }
        catch (IOException iOException2) {
            return false;
        }
    }

    protected Executor defaultExecutor() {
        return Executor.getDefault();
    }

    public static void setExecutor(MultiDataObject.Entry entry, Executor executor) throws IOException {
        entry.getFile().setAttribute(EA_EXECUTOR, (Object)(executor == null ? null : new ServiceType.Handle((ServiceType)executor)));
    }

    public static Executor getExecutor(MultiDataObject.Entry entry) {
        Lookup lookup;
        Object object = entry.getFile().getAttribute(EA_EXECUTOR);
        if (object != null && object instanceof ServiceType.Handle && (lookup = ((ServiceType.Handle)object).getServiceType()) instanceof Executor) {
            return (Executor)lookup;
        }
        lookup = Environment.find((DataObject)entry.getDataObject());
        Executor executor = (Executor)((Object)lookup.lookup(class$org$openide$execution$Executor == null ? (class$org$openide$execution$Executor = ExecutionSupport.class$("org.openide.execution.Executor")) : class$org$openide$execution$Executor));
        if (executor != null) {
            return executor;
        }
        return null;
    }

    public void setArguments(String[] stringArray) throws IOException {
        this.entry.getFile().setAttribute(EA_ARGUMENTS, (Object)stringArray);
    }

    public static void setArguments(MultiDataObject.Entry entry, String[] stringArray) throws IOException {
        entry.getFile().setAttribute(EA_ARGUMENTS, (Object)stringArray);
    }

    public String[] getArguments() {
        return ExecutionSupport.getArguments(this.entry);
    }

    public static String[] getArguments(MultiDataObject.Entry entry) {
        Object object = entry.getFile().getAttribute(EA_ARGUMENTS);
        if (object != null && object instanceof String[]) {
            return (String[])object;
        }
        return new String[0];
    }

    public void addProperties(Sheet.Set set) {
        set.put((Node.Property)this.createParamsProperty());
        set.put((Node.Property)this.createExecutorProperty());
    }

    private PropertySupport createParamsProperty() {
        PropertySupport.ReadWrite readWrite = new PropertySupport.ReadWrite(PROP_FILE_PARAMS, class$java$lang$String == null ? (class$java$lang$String = ExecutionSupport.class$("java.lang.String")) : class$java$lang$String, ExecutionSupport.getString("PROP_fileParams"), ExecutionSupport.getString("HINT_fileParams")){

            public Object getValue() {
                String[] stringArray = ExecutionSupport.this.getArguments();
                return Utilities.escapeParameters((String[])stringArray);
            }

            public void setValue(Object object) throws InvocationTargetException {
                if (object instanceof String) {
                    try {
                        ExecutionSupport.this.setArguments(Utilities.parseParameters((String)((String)object)));
                    }
                    catch (IOException iOException) {
                        throw new InvocationTargetException(iOException);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }

            public boolean supportsDefaultValue() {
                return true;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                try {
                    ExecutionSupport.this.setArguments(null);
                }
                catch (IOException iOException) {
                    throw new InvocationTargetException(iOException);
                }
            }

            public boolean canWrite() {
                Boolean bl = (Boolean)ExecutionSupport.this.entry.getFile().getAttribute(ExecutionSupport.READONLY_ATTRIBUTES);
                return bl == null ? false : bl == false;
            }
        };
        readWrite.setValue("oneline", (Object)Boolean.TRUE);
        return readWrite;
    }

    private PropertySupport createExecutorProperty() {
        return new PropertySupport.ReadWrite(PROP_EXECUTION, class$org$openide$execution$Executor == null ? (class$org$openide$execution$Executor = ExecutionSupport.class$("org.openide.execution.Executor")) : class$org$openide$execution$Executor, ExecutionSupport.getString("PROP_execution"), ExecutionSupport.getString("HINT_execution")){

            public Object getValue() {
                Executor executor = ExecutionSupport.getExecutor(ExecutionSupport.this.entry);
                if (executor == null) {
                    return ExecutionSupport.this.defaultExecutor();
                }
                return executor;
            }

            public void setValue(Object object) throws InvocationTargetException {
                try {
                    ExecutionSupport.setExecutor(ExecutionSupport.this.entry, (Executor)((Object)object));
                }
                catch (IOException iOException) {
                    throw new InvocationTargetException(iOException);
                }
            }

            public boolean supportsDefaultValue() {
                return true;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                this.setValue(null);
            }

            public boolean canWrite() {
                Boolean bl = (Boolean)ExecutionSupport.this.entry.getFile().getAttribute(ExecutionSupport.READONLY_ATTRIBUTES);
                return bl == null ? false : bl == false;
            }
        };
    }

    static String getString(String string) {
        return NbBundle.getMessage((Class)(class$org$openide$execution$Executor == null ? (class$org$openide$execution$Executor = ExecutionSupport.class$("org.openide.execution.Executor")) : class$org$openide$execution$Executor), (String)string);
    }

    protected static ServiceType choose(ServiceType serviceType, Class clazz, Exception exception) {
        String string;
        String string2;
        ErrorManager errorManager = ErrorManager.getDefault();
        errorManager.notify(1, (Throwable)exception);
        PropertyEditor propertyEditor = PropertyEditorManager.findEditor(clazz);
        if (propertyEditor == null) {
            return null;
        }
        propertyEditor.setValue(serviceType);
        Component component = propertyEditor.getCustomEditor();
        if (component == null) {
            return null;
        }
        String string3 = ExecutionSupport.getString("CTL_ServiceConfigure");
        NotifyDescriptor.Message message = new NotifyDescriptor.Message(null, 0);
        message.setTitle(ExecutionSupport.getString("CTL_Service_Configuration_Title"));
        String string4 = null;
        ErrorManager.Annotation[] annotationArray = errorManager.findAnnotations((Throwable)exception);
        if (annotationArray != null) {
            for (int i = 0; i < annotationArray.length; ++i) {
                string2 = annotationArray[i].getLocalizedMessage();
                if (string2 == null) continue;
                string4 = string2;
                break;
            }
        }
        if (string4 == null && (string = exception.getLocalizedMessage()) != null && !string.equals(exception.getMessage())) {
            string4 = string;
        }
        if (string4 == null) {
            string4 = NbBundle.getMessage((Class)(class$org$openide$execution$Executor == null ? (class$org$openide$execution$Executor = ExecutionSupport.class$("org.openide.execution.Executor")) : class$org$openide$execution$Executor), (String)"LBL_unknown_service_misconfig", (Object)serviceType.getName());
        }
        message.setMessage(string4);
        message.setOptions(new Object[]{string3, NotifyDescriptor.CANCEL_OPTION});
        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
        if (!string3.equals(object)) {
            return null;
        }
        string2 = new DialogDescriptor((Object)component, ExecutionSupport.getString("MSG_ConfigureService"));
        string2.setOptions(new Object[]{DialogDescriptor.OK_OPTION, DialogDescriptor.CANCEL_OPTION});
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)string2);
        dialog.show();
        if (string2.getValue() == NotifyDescriptor.OK_OPTION) {
            return (ServiceType)propertyEditor.getValue();
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

