/*
 * Decompiled with CFR 0.152.
 */
package org.openide.execution;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.openide.ErrorManager;
import org.openide.cookies.ArgumentsCookie;
import org.openide.execution.ExecInfo;
import org.openide.execution.ExecutionEngine;
import org.openide.execution.Executor;
import org.openide.execution.ExecutorTask;
import org.openide.execution.NbClassPath;
import org.openide.execution.NbProcessDescriptor;
import org.openide.filesystems.FileSystemCapability;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.MapFormat;
import org.openide.util.NbBundle;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.Utilities;
import org.openide.util.WeakSet;
import org.openide.windows.InputOutput;

public class ProcessExecutor
extends Executor {
    static final long serialVersionUID = 1440216248312461457L;
    protected NbProcessDescriptor externalExecutor;
    private NbClassPath classPath;
    private NbClassPath bootClassPath;
    private String[] envp = null;
    private boolean addEnvs = false;
    private File cwd = null;
    private static final Set warnedClasses = new WeakSet();
    static /* synthetic */ Class class$org$openide$execution$ProcessExecutor;

    public synchronized void setExternalExecutor(NbProcessDescriptor desc) {
        NbProcessDescriptor old = this.externalExecutor;
        this.externalExecutor = desc;
        this.firePropertyChange("externalExecutor", old, desc);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$openide$execution$ProcessExecutor == null ? (class$org$openide$execution$ProcessExecutor = ProcessExecutor.class$("org.openide.execution.ProcessExecutor")) : class$org$openide$execution$ProcessExecutor);
    }

    public synchronized NbProcessDescriptor getExternalExecutor() {
        if (this.externalExecutor == null) {
            this.externalExecutor = new NbProcessDescriptor("{java.home}{/}bin{/}java", "-cp {filesystems}{:}{classpath}{:}{library} {classname} {arguments}", NbBundle.getBundle((Class)(class$org$openide$execution$ProcessExecutor == null ? (class$org$openide$execution$ProcessExecutor = ProcessExecutor.class$("org.openide.execution.ProcessExecutor")) : class$org$openide$execution$ProcessExecutor)).getString("MSG_ExecutorHint"));
        }
        return this.externalExecutor;
    }

    public NbClassPath getClassPath() {
        return this.classPath == null ? NbClassPath.createClassPath() : this.classPath;
    }

    public synchronized void setClassPath(NbClassPath path) {
        NbClassPath old = this.classPath;
        this.classPath = path;
        this.firePropertyChange("classPath", old, path);
    }

    public NbClassPath getBootClassPath() {
        return this.bootClassPath == null ? NbClassPath.createBootClassPath() : this.bootClassPath;
    }

    public synchronized void setBootClassPath(NbClassPath path) {
        NbClassPath old = this.bootClassPath;
        this.bootClassPath = path;
        this.firePropertyChange("bootClassPath", old, path);
    }

    public NbClassPath getRepositoryPath() {
        return NbClassPath.createRepositoryPath(FileSystemCapability.EXECUTE);
    }

    public NbClassPath getLibraryPath() {
        return NbClassPath.createLibraryPath();
    }

    public String[] getEnvironmentVariables() {
        return this.envp;
    }

    public synchronized void setEnvironmentVariables(String[] nue) {
        String[] old = this.envp;
        this.envp = nue;
        this.firePropertyChange("environmentVariables", old, nue);
    }

    public boolean getAppendEnvironmentVariables() {
        return this.addEnvs;
    }

    public synchronized void setAppendEnvironmentVariables(boolean nue) {
        boolean old = this.addEnvs;
        this.addEnvs = nue;
        this.firePropertyChange("appendEnvironmentVariables", old ? Boolean.TRUE : Boolean.FALSE, nue ? Boolean.TRUE : Boolean.FALSE);
    }

    public File getWorkingDirectory() {
        return this.cwd;
    }

    public synchronized void setWorkingDirectory(File nue) {
        File old = this.cwd;
        this.cwd = nue;
        this.firePropertyChange("workingDirectory", old, nue);
    }

    protected Process createProcess(ExecInfo info) throws IOException {
        return this.getExternalExecutor().exec((java.text.Format)((Object)new Format(info, this.getClassPath(), this.getBootClassPath(), this.getRepositoryPath(), this.getLibraryPath())), this.envp, this.addEnvs, this.cwd);
    }

    private final Class getKlass(String name) {
        try {
            return Class.forName(name, false, ((Object)((Object)this)).getClass().getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Process createProcess(DataObject obj) throws IOException {
        Class<?> c = ((Object)((Object)this)).getClass();
        Set set = warnedClasses;
        synchronized (set) {
            if (warnedClasses.add(c)) {
                ErrorManager.getDefault().log(16, "Warning - " + c.getName() + " should have overridden createProcess(DataObject); falling back on deprecated ExecInfo usage");
            }
        }
        ArgumentsCookie ac = (ArgumentsCookie)obj.getCookie(this.getKlass("org.openide.cookies.ArgumentsCookie"));
        String[] params = ac != null ? ac.getArguments() : new String[]{};
        return this.createProcess(new ExecInfo(obj.getPrimaryFile().getPackageName('.'), params));
    }

    public ExecutorTask execute(ExecInfo info) throws IOException {
        PERunnable run = new PERunnable(info);
        return this.handleExec(run, info.getClassName());
    }

    public ExecutorTask execute(DataObject obj) throws IOException {
        PERunnable run = new PERunnable(obj);
        return this.handleExec(run, obj.getName());
    }

    private ExecutorTask handleExec(PERunnable run, String name) throws IOException {
        PERunnable pERunnable = run;
        synchronized (pERunnable) {
            InputOutput inout = this.needsIO() ? null : InputOutput.NULL;
            ExecutorTask et = ExecutionEngine.getDefault().execute(name, run, inout);
            run.setExecutorTask(et);
            try {
                run.wait();
                Throwable t = run.getException();
                if (t != null) {
                    if (t instanceof RuntimeException) {
                        throw (RuntimeException)t;
                    }
                    if (t instanceof Error) {
                        throw (Error)t;
                    }
                    if (t instanceof IOException) {
                        throw (IOException)t;
                    }
                    IOException ex = new IOException(t.getMessage());
                    ErrorManager.getDefault().copyAnnotation((Throwable)ex, t);
                    throw ex;
                }
                return run.getExecutorTask();
            }
            catch (InterruptedException e) {
                IOException ex = new IOException(e.getMessage());
                ErrorManager.getDefault().copyAnnotation((Throwable)ex, (Throwable)e);
                throw ex;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class ExternalExecutorTask
    extends ExecutorTask {
        Process proc;
        Thread[] copyMakers;
        ExecutorTask foreign;

        ExternalExecutorTask(Runnable run, ExecutorTask etask, Process proc, Thread[] copyMakers) {
            super(run);
            this.proc = proc;
            this.copyMakers = copyMakers;
            this.foreign = etask;
            TaskListener tl = new TaskListener(this){
                private final /* synthetic */ ExternalExecutorTask this$0;
                {
                    this.this$0 = this$0;
                }

                public void taskFinished(Task t) {
                    this.this$0.stop();
                }
            };
            etask.addTaskListener(tl);
            new Thread(this){
                private final /* synthetic */ ExternalExecutorTask this$0;
                {
                    this.this$0 = this$0;
                }

                public void run() {
                    this.this$0.result();
                }
            }.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            try {
                this.copyMakers[0].interrupt();
                this.copyMakers[1].interrupt();
                this.copyMakers[2].interrupt();
            }
            finally {
                this.proc.destroy();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int result() {
            try {
                int ret = this.proc.waitFor();
                Thread.sleep(2000L);
                int n = ret;
                return n;
            }
            catch (InterruptedException e) {
                int n = 1;
                return n;
            }
            finally {
                this.stop();
                this.notifyFinished();
            }
        }

        public InputOutput getInputOutput() {
            return this.foreign.getInputOutput();
        }

        public void run() {
        }
    }

    private static class CopyMaker
    extends Thread {
        final Writer os;
        final Reader is;
        final boolean autoflush;
        final String permName;
        private boolean done = false;

        CopyMaker(Reader is, Writer os, boolean b, String className) {
            this.os = os;
            this.is = is;
            this.autoflush = b;
            this.permName = className;
        }

        public void run() {
            char[] buff = new char[256];
            try {
                int read;
                while ((read = this.read(this.is, buff, 0, 256)) > 0) {
                    this.os.write(buff, 0, read);
                    if (!this.autoflush) continue;
                    this.os.flush();
                }
            }
            catch (IOException ex) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void interrupt() {
            super.interrupt();
            this.done = true;
        }

        private int read(Reader is, char[] buff, int start, int count) throws InterruptedException, IOException {
            if (Utilities.getOperatingSystem() != 1024) {
                while (!is.ready() && !this.done) {
                    CopyMaker.sleep(100L);
                }
            }
            return is.read(buff, start, count);
        }
    }

    public static class Format
    extends MapFormat {
        public static final String TAG_CLASSPATH = "classpath";
        public static final String TAG_BOOTCLASSPATH = "bootclasspath";
        public static final String TAG_REPOSITORY = "filesystems";
        public static final String TAG_LIBRARY = "library";
        public static final String TAG_CLASSNAME = "classname";
        public static final String TAG_ARGUMENTS = "arguments";
        public static final String TAG_JAVAHOME = "java.home";
        public static final String TAG_JDKHOME = "jdk.home";
        public static final String TAG_SEPARATOR = "/";
        public static final String TAG_PATHSEPARATOR = ":";
        static final long serialVersionUID = 1105067849363827986L;

        public Format(ExecInfo info) {
            this(info, NbClassPath.createClassPath(), NbClassPath.createBootClassPath(), NbClassPath.createRepositoryPath(FileSystemCapability.EXECUTE), NbClassPath.createLibraryPath());
        }

        public Format(ExecInfo info, NbClassPath classPath, NbClassPath bootClassPath, NbClassPath repository, NbClassPath library) {
            super(new HashMap(7));
            Map map = this.getMap();
            map.put(TAG_CLASSPATH, classPath.getClassPath());
            map.put(TAG_BOOTCLASSPATH, bootClassPath.getClassPath());
            map.put(TAG_REPOSITORY, repository.getClassPath());
            map.put(TAG_LIBRARY, library.getClassPath());
            map.put(TAG_CLASSNAME, info.getClassName());
            map.put(TAG_JAVAHOME, System.getProperty(TAG_JAVAHOME));
            map.put(TAG_JDKHOME, System.getProperty(TAG_JDKHOME));
            map.put(TAG_SEPARATOR, File.separator);
            map.put(TAG_PATHSEPARATOR, File.pathSeparator);
            StringBuffer sb = new StringBuffer();
            String[] args = info.getArguments();
            for (int i = 0; i < args.length; ++i) {
                sb.append('\"');
                sb.append(args[i]);
                sb.append('\"');
                sb.append(' ');
            }
            map.put(TAG_ARGUMENTS, sb.toString());
        }
    }

    private class PERunnable
    implements Runnable,
    TaskListener {
        private DataObject obj;
        private ExecInfo info;
        private ExecutorTask fromEngine;
        ExecutorTask fromMe;
        private Throwable t;

        PERunnable(ExecInfo info) {
            this.info = info;
        }

        PERunnable(DataObject obj) {
            this.obj = obj;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void run() {
            try {
                Process process;
                String className;
                if (this.info != null) {
                    className = this.info.getClassName();
                    process = ProcessExecutor.this.createProcess(this.info);
                } else {
                    className = this.obj.getName();
                    process = ProcessExecutor.this.createProcess(this.obj);
                }
                Thread[] copyMakers = new Thread[3];
                copyMakers[0] = new CopyMaker(this.fromEngine.getInputOutput().getIn(), new OutputStreamWriter(process.getOutputStream()), true, className);
                copyMakers[0].start();
                copyMakers[1] = new CopyMaker(new InputStreamReader(process.getInputStream()), (Writer)this.fromEngine.getInputOutput().getOut(), false, className);
                copyMakers[1].start();
                copyMakers[2] = new CopyMaker(new InputStreamReader(process.getErrorStream()), (Writer)this.fromEngine.getInputOutput().getErr(), false, className);
                copyMakers[2].start();
                this.fromMe = new ExternalExecutorTask(this, this.fromEngine, process, copyMakers);
            }
            catch (Exception e) {
                this.t = e;
            }
            finally {
                this.notifyAll();
            }
        }

        public void setExecutorTask(ExecutorTask fromEngine) {
            this.fromEngine = fromEngine;
            fromEngine.addTaskListener(this);
        }

        public ExecutorTask getExecutorTask() {
            return this.fromMe;
        }

        public Throwable getException() {
            return this.t;
        }

        public void taskFinished(Task t) {
            if (this.fromMe != null) {
                this.fromMe.stop();
            }
        }
    }
}

