/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remoteexecute;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.distributed.remoteexecute.BasicAction;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.ErrorManager;
import org.openide.explorer.ExplorerManager;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class RemoteProjectOpen
extends BasicAction {
    static final long serialVersionUID = -7910677883191530621L;
    static final String REMOTE_OPERATIONS = "Open Remote Project...";

    public RemoteProjectOpen() {
        super(REMOTE_OPERATIONS, null);
    }

    private void openProject(final Project project) {
        Project[] projectArray = new Project[]{project};
        OpenProjects.getDefault().open(projectArray, true);
        ContextAwareAction contextAwareAction = (ContextAwareAction)CommonProjectActions.setAsMainProjectAction();
        Lookup lookup = Lookups.singleton((Object)project);
        Action action = contextAwareAction.createContextAwareInstance(lookup);
        action.actionPerformed(null);
        SwingUtilities.invokeLater(new Runnable(){
            ExplorerManager.Provider ptLogial = (ExplorerManager.Provider)WindowManager.getDefault().findTopComponent("projectTab_tc");

            public void run() {
                Node node = this.ptLogial.getExplorerManager().getRootContext();
                Node node2 = node.getChildren().findChild(ProjectUtils.getInformation((Project)project).getName());
                if (node2 != null) {
                    try {
                        this.ptLogial.getExplorerManager().setSelectedNodes(new Node[]{node2});
                        ((TopComponent)this.ptLogial).open();
                        ((TopComponent)this.ptLogial).requestActive();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = ProjectChooser.projectChooser();
        int n = jFileChooser.showOpenDialog(WindowManager.getDefault().getMainWindow());
        Project project = null;
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            try {
                project = ProjectManager.getDefault().findProject(FileUtil.toFileObject((File)file));
                this.openProject(project);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(16, (Throwable)iOException);
            }
        }
    }

    public String getName() {
        return REMOTE_OPERATIONS;
    }

    public boolean asynchronous() {
        return false;
    }
}

