/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remoteexecute;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.netbeans.modules.distributed.common.propertyeditors.ErrorExpressionEditor2;
import org.netbeans.modules.distributed.remoteexecute.RemoteOutputParser;
import org.openide.compiler.ExternalCompiler;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public abstract class RemoteOutputStreamParse
extends OutputStream {
    private StringBuffer buffer = new StringBuffer(1000);
    private boolean hadFirst = false;
    private ExternalCompiler.ErrorExpression errExp;
    private String prevMsg = "";
    private String prevFile = "";
    private FileObject prevFileObject;
    private RemoteOutputParser remoteOutputParser = RemoteOutputParser.getDefault();

    public RemoteOutputStreamParse(ExternalCompiler.ErrorExpression errorExpression) {
        this.errExp = errorExpression;
    }

    public final void close() throws IOException {
        this.flush();
        this.handleClose();
    }

    protected void handleClose() throws IOException {
    }

    public final void flush() throws IOException {
        this.flushLines(true);
    }

    public final void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public final void write(byte[] byArray, int n, int n2) throws IOException {
        this.buffer.append(new String(byArray, n, n2));
        this.flushLines(false);
    }

    public final void write(int n) throws IOException {
        this.buffer.append((char)n);
        if ((char)n == '\n') {
            this.flushLines(false);
        }
    }

    private void flushLines(boolean bl) throws IOException {
        block0: while (true) {
            int n = this.buffer.length();
            for (int i = 0; i < n; ++i) {
                if (this.buffer.charAt(i) != '\n') continue;
                int n2 = i;
                if (n2 > 0 && this.buffer.charAt(n2 - 1) == '\r') {
                    --n2;
                }
                this.flushLine(this.buffer.substring(0, n2));
                this.buffer.delete(0, i + 1);
                continue block0;
            }
            break;
        }
        if (bl) {
            this.flushLine(this.buffer.substring(0, this.buffer.length()));
            this.buffer.delete(0, this.buffer.length());
        }
    }

    private void flushLine(String string) throws IOException {
        if (!this.hadFirst) {
            this.hadFirst = true;
            if (string.trim().length() == 0) {
                return;
            }
        }
        boolean bl = false;
        RemoteOutputParser.Result result = null;
        if (this.errExp.getName().equals("OpenVMS Compiler Errors for Ant")) {
            ExternalCompiler.ErrorExpression errorExpression = this.errExp;
            ExternalCompiler.ErrorExpression errorExpression2 = ErrorExpressionEditor2.antErrorExpression;
            result = this.remoteOutputParser.parse(string, errorExpression, this.prevFile, this.prevFileObject);
            if (result == null) {
                result = this.remoteOutputParser.parse(string, errorExpression2, this.prevFile, this.prevFileObject);
            } else {
                bl = true;
            }
        } else {
            result = this.remoteOutputParser.parse(string, this.errExp, this.prevFile, this.prevFileObject);
        }
        if (!this.prevMsg.equals("") && !bl) {
            this.writeLine(this.prevMsg);
            this.prevMsg = "";
        }
        if (result == null) {
            this.prevMsg = string;
        } else {
            if (this.prevFileObject == null) {
                this.prevFileObject = result.getFileObject();
                this.prevFile = result.getFileName();
            } else if (!this.prevFileObject.equals(result.getFileObject())) {
                this.prevFileObject = result.getFileObject();
                this.prevFile = result.getFileName();
            }
            this.writeLine(string, result.getFileObject(), result.getLineStart(), result.getColumnStart(), result.getLineEnd(), result.getColumnEnd(), bl ? this.prevMsg : result.getMessage());
            if (bl) {
                this.prevMsg = "";
            }
        }
    }

    protected abstract void writeLine(String var1, FileObject var2, int var3, int var4, int var5, int var6, String var7) throws IOException;

    protected abstract void writeLine(String var1) throws IOException;

    protected String formatMessage(String string, String string2, int n, int n2, int n3, int n4) {
        String string3 = string2 != null ? string2 : NbBundle.getMessage((Class)RemoteOutputStreamParse.class, (String)"ERR_unknown");
        string = string.replace('\\', File.separatorChar);
        string = string.replace('/', File.separatorChar);
        if (n == -1) {
            return NbBundle.getMessage((Class)RemoteOutputStreamParse.class, (String)"MSG_err", (Object)string, (Object)string3);
        }
        if (n2 == -1) {
            return NbBundle.getMessage((Class)RemoteOutputStreamParse.class, (String)"MSG_err_line", (Object)string, (Object)string3, (Object)new Integer(n + 1));
        }
        if (n3 == -1 || n4 == -1 || n == n3 && n2 == n4) {
            return NbBundle.getMessage((Class)RemoteOutputStreamParse.class, (String)"MSG_err_line_col", (Object[])new Object[]{string, string3, new Integer(n + 1), new Integer(n2 + 1)});
        }
        if (n == n3) {
            return NbBundle.getMessage((Class)RemoteOutputStreamParse.class, (String)"MSG_err_line_col_col", (Object[])new Object[]{string, string3, new Integer(n + 1), new Integer(n2 + 1), new Integer(n4 + 1)});
        }
        return NbBundle.getMessage((Class)RemoteOutputStreamParse.class, (String)"MSG_err_line_col_line_col", (Object[])new Object[]{string, string3, new Integer(n + 1), new Integer(n2 + 1), new Integer(n3 + 1), new Integer(n4 + 1)});
    }
}

