/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.lexer.inc;

import java.util.NoSuchElementException;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenUpdater;

public abstract class AbstractTokenUpdater
extends TokenUpdater {
    private static final Token[] EMPTY_TOKEN_ARRAY = new Token[0];
    private Token[] tokenArray = EMPTY_TOKEN_ARRAY;
    private int gapStart;
    private int gapEnd;
    private int nextIndex;

    protected boolean hasNext() {
        return this.nextIndex < this.getTokenCount();
    }

    protected Token next() {
        try {
            Token token = this.tokenArray[this.getRawIndex(this.nextIndex)];
            ++this.nextIndex;
            this.nextUpdate(token);
            return token;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new NoSuchElementException();
        }
    }

    protected boolean hasPrevious() {
        return this.nextIndex > 0;
    }

    protected Token previous() {
        try {
            int n = this.nextIndex - 1;
            Token token = this.tokenArray[this.getRawIndex(n)];
            this.nextIndex = n;
            this.previousUpdate(token);
            return token;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new NoSuchElementException();
        }
    }

    protected void removeUpdate(Token token) {
    }

    protected void addUpdate(Token token) {
    }

    protected void nextUpdate(Token token) {
    }

    protected void previousUpdate(Token token) {
    }

    protected void remove() {
        if (this.nextIndex == 0) {
            throw new IllegalStateException();
        }
        if (this.gapStart != this.nextIndex - 1) {
            this.moveGap(this.nextIndex - 1);
        }
        Token token = this.tokenArray[this.gapEnd];
        this.tokenArray[this.gapEnd++] = null;
        this.removeUpdate(token);
        --this.nextIndex;
        this.previousUpdate(token);
    }

    protected void add(Token token) {
        if (this.gapStart != this.nextIndex) {
            this.moveGap(this.nextIndex);
        }
        if (this.gapEnd - this.gapStart == 0) {
            this.enlargeGap();
        }
        this.tokenArray[this.gapStart++] = token;
        this.addUpdate(token);
        ++this.nextIndex;
        this.nextUpdate(token);
    }

    public final int getTokenCount() {
        return this.tokenArray.length - (this.gapEnd - this.gapStart);
    }

    public final Token getToken(int n) {
        return this.tokenArray[this.getRawIndex(n)];
    }

    protected final void replaceToken(int n, Token token) {
        this.tokenArray[this.getRawIndex((int)n)] = token;
    }

    protected final int getNextIndex() {
        return this.nextIndex;
    }

    protected final int getValidPreviousIndex() {
        if (this.nextIndex <= 0) {
            throw new IllegalStateException();
        }
        return this.nextIndex - 1;
    }

    protected void setNextIndex(int n) {
        this.nextIndex = n;
    }

    private int getRawIndex(int n) {
        return n < this.gapStart ? n : n + (this.gapEnd - this.gapStart);
    }

    private void moveGap(int n) {
        if (n <= this.gapStart) {
            int n2 = this.gapStart - n;
            this.gapEnd -= n2;
            this.gapStart -= n2;
            System.arraycopy(this.tokenArray, n, this.tokenArray, this.gapEnd, n2);
            this.movedAboveGapUpdate(this.tokenArray, this.gapEnd, n2);
        } else {
            int n3 = n - this.gapStart;
            System.arraycopy(this.tokenArray, this.gapEnd, this.tokenArray, this.gapStart, n3);
            this.movedBelowGapUpdate(this.tokenArray, this.gapStart, n3);
            this.gapStart += n3;
            this.gapEnd += n3;
        }
    }

    protected void movedAboveGapUpdate(Token[] tokenArray, int n, int n2) {
    }

    protected void movedBelowGapUpdate(Token[] tokenArray, int n, int n2) {
    }

    private void enlargeGap() {
        int n = Math.max(4, this.tokenArray.length * 2);
        int n2 = this.tokenArray.length - this.gapEnd;
        int n3 = n - n2;
        Token[] tokenArray = new Token[n];
        System.arraycopy(this.tokenArray, 0, tokenArray, 0, this.gapStart);
        System.arraycopy(this.tokenArray, this.gapEnd, tokenArray, n3, n2);
        this.tokenArray = tokenArray;
        this.gapEnd = n3;
    }

    public String toString() {
        return "tokenCount=" + this.getTokenCount() + ", tokenArray.length=" + this.tokenArray.length + ", gapStart=" + this.gapStart + ", gapEnd=" + this.gapEnd;
    }
}

