/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.ideserverclient.actions;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.WindowEvent;
import java.rmi.RemoteException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import org.netbeans.modules.distributed.ideserverclient.RemoteRuntimeType;
import org.netbeans.modules.distributed.ideserverclient.actions.CaseIgnoreComparator;
import org.netbeans.modules.distributed.ideserverclient.actions.MyTimer;
import org.netbeans.modules.distributed.ideserverclient.actions.TimerListener;
import org.netbeans.modules.distributed.ideserverclient.settings.DistributedSettings;
import org.netbeans.modules.distributed.rmi.protocol.Admin;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

public class AdminPanel
extends JPanel
implements TimerListener {
    private DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
    private JTable jTable1;
    private JScrollPane scrollPane;
    private MyTimer t;
    private static final String[] columnNames = new String[]{" Server System", " User", " Number of Processes", " Number of Connections"};
    private String password;
    private JScrollPane jScrollPane1;

    public AdminPanel(String string) {
        this.password = string;
        this.setUpTable(this.getAdminInterfaces(string));
        this.t = new MyTimer(1000, this);
        this.t.start();
    }

    public void stopRefresh() {
        this.t.interrupt();
    }

    public void timeElapsed(MyTimer myTimer) {
        Map map = this.getAdminInterfaces(this.password);
        if (map != null) {
            this.jScrollPane1.remove(this.jTable1);
            this.jTable1 = new JTable(this.getData(map), columnNames);
            this.jScrollPane1.setViewportView(this.jTable1);
            this.jTable1.repaint();
        } else {
            this.stopRefresh();
        }
    }

    private Map getAdminInterfaces(String string) {
        TreeMap<String, Admin> treeMap = new TreeMap<String, Admin>(new CaseIgnoreComparator());
        HashSet hashSet = DistributedSettings.getDefault().getRemoteRuntimes();
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            RemoteRuntimeType remoteRuntimeType = (RemoteRuntimeType)iterator.next();
            if (!remoteRuntimeType.isConnected()) continue;
            treeMap.put(remoteRuntimeType.getHostName(), remoteRuntimeType.getAdminInterface(string));
        }
        return treeMap;
    }

    private Object[][] getData(Map map) {
        int n = 0;
        Object[][] objectArray = null;
        try {
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string = ((String)iterator.next()).toLowerCase();
                Admin admin = (Admin)map.get(string);
                if (admin == null) continue;
                n += admin.getUserCount();
            }
            objectArray = new Object[n][columnNames.length];
            iterator = map.keySet().iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                String[] stringArray;
                boolean bl = false;
                String string = ((String)iterator.next()).toLowerCase();
                Admin admin = (Admin)map.get(string);
                if (admin == null || (stringArray = admin.getListOfUsers()) == null) continue;
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!bl) {
                        objectArray[n2][0] = "  " + string;
                        bl = true;
                    }
                    objectArray[n2][1] = "  " + stringArray[i];
                    objectArray[n2][2] = "  " + admin.getNumberOfUserProcess(stringArray[i]);
                    objectArray[n2][3] = "  " + admin.getNumberOfUserConnections(stringArray[i]);
                    ++n2;
                }
            }
        }
        catch (RemoteException remoteException) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)remoteException.getMessage(), 0));
            return null;
        }
        return objectArray;
    }

    private void setTableCellAlignment(int n) {
        this.renderer.setHorizontalAlignment(n);
        for (int i = 0; i < this.jTable1.getColumnCount(); ++i) {
            this.jTable1.setDefaultRenderer(this.jTable1.getColumnClass(i), this.renderer);
        }
        this.jTable1.updateUI();
    }

    private void setUpTable(Map map) {
        Object object;
        this.initComponents();
        this.jTable1 = map != null ? ((object = this.getData(map)) != null ? new JTable(this.getData(map), columnNames) : new JTable(new Object[0][], columnNames)) : new JTable(new Object[0][], columnNames);
        object = this.jTable1.getTableHeader();
        ((JComponent)object).setFont(new Font("Arial", 1, 12));
        this.jScrollPane1.setViewportView(this.jTable1);
        this.setTableCellAlignment(2);
        this.setPreferredSize(new Dimension(700, 300));
    }

    private void fillupTable(RemoteRuntimeType remoteRuntimeType) {
        try {
            Thread.currentThread();
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.setLayout(new GridLayout(1, 0));
        this.add(this.jScrollPane1);
    }

    private void exitForm(WindowEvent windowEvent) {
        System.exit(0);
    }

    public void updateTable() {
        try {
            Thread.currentThread();
            Thread.sleep(3000L);
            class MyTableModel
            extends AbstractTableModel {
                final String[] columnNames = new String[]{"Name", "Value"};
                final Object[][] data = new Object[][]{{"a", "b"}, {"c", "d"}, {"e", "f"}};

                MyTableModel() {
                }

                public int getColumnCount() {
                    return this.columnNames.length;
                }

                public int getRowCount() {
                    return this.data.length;
                }

                public String getColumnName(int n) {
                    return this.columnNames[n];
                }

                public Object getValueAt(int n, int n2) {
                    return this.data[n][n2];
                }
            }
            this.jTable1.setModel(new MyTableModel());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void main(String[] stringArray) {
        AdminPanel adminPanel = new AdminPanel("VMSRULES");
        adminPanel.show();
    }

    class AdminTableModel
    extends AbstractTableModel {
        private String[] columnNames;
        private Object[][] data;
        private MyTimer t;

        public AdminTableModel(String[] stringArray, Object[][] objectArray) {
            this.columnNames = stringArray;
            this.data = objectArray;
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this.data.length;
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public Object getValueAt(int n, int n2) {
            return this.data[n][n2];
        }
    }
}

