/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.common.propertyeditors;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.FeatureDescriptor;
import java.beans.PropertyEditorSupport;
import java.util.Collection;
import java.util.HashSet;
import org.netbeans.modules.distributed.common.propertyeditors.ErrorExpressionPanelPlain;
import org.netbeans.modules.distributed.common.util.ErrorExpression;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.util.NbBundle;

public class ErrorExpressionEditor
extends PropertyEditorSupport
implements ExPropertyEditor {
    private static Collection sharedList;
    public static final String ALPHA_VMS_ERROR_EXPR = "[ \\t]*[A|a]t line number ([0-9]+) in file (.*)$";
    public static final String ANT_JAVA_ERROR_EXPR = "^(file\\:)?([^ ][^ ]+):([0-9]+): (.*)";
    public static final String SUN_ERROR_EXPR = "^([^ ][^\n]+):([0-9]+): (.*)";
    FeatureDescriptor fd;
    public static ErrorExpression errorExpression;
    public static ErrorExpression antErrorExpression;
    public static final ErrorExpression JAVAC;
    private Collection list;
    private ErrorExpression value;

    public ErrorExpressionEditor() {
        this.list = new HashSet(17);
        this.list.add(errorExpression);
        this.list.add(JAVAC);
        this.list.add(antErrorExpression);
    }

    public ErrorExpressionEditor(Collection collection) {
        this.list = collection;
    }

    public Object getValue() {
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(Object object) {
        ErrorExpressionEditor errorExpressionEditor = this;
        synchronized (errorExpressionEditor) {
            this.value = (ErrorExpression)object;
            this.list.add(object);
        }
        this.firePropertyChange();
    }

    public String getAsText() {
        return this.value.getName();
    }

    public void setAsText(String string) {
        ErrorExpression[] errorExpressionArray = this.getExpressions();
        for (int i = 0; i < errorExpressionArray.length; ++i) {
            if (!string.equals(errorExpressionArray[i].getName())) continue;
            this.setValue(errorExpressionArray[i]);
            break;
        }
    }

    public String getJavaInitializationString() {
        return "new ExternalCompiler.ErrorExpression (" + this.value.getName() + ", " + this.value.getErrorExpression() + ", " + this.value.getFilePos() + ", " + this.value.getLinePos() + ", " + this.value.getColumnPos() + ", " + this.value.getDescriptionPos() + ")";
    }

    public String[] getTags() {
        ErrorExpression[] errorExpressionArray = this.getExpressions();
        String[] stringArray = new String[errorExpressionArray.length];
        for (int i = 0; i < errorExpressionArray.length; ++i) {
            stringArray[i] = errorExpressionArray[i].getName();
        }
        return stringArray;
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        return new ErrorExpressionPanelPlain(this);
    }

    synchronized ErrorExpression[] getExpressions() {
        return this.list.toArray(new ErrorExpression[this.list.size()]);
    }

    Collection getExpressionsVector() {
        return this.list;
    }

    public void attachEnv(PropertyEnv propertyEnv) {
        this.fd = propertyEnv.getFeatureDescriptor();
    }

    public String getHelpID() {
        return (String)this.fd.getValue("helpID");
    }

    static {
        errorExpression = new ErrorExpression(NbBundle.getMessage((Class)ErrorExpressionEditor.class, (String)"ALPHA_VMS_ERROR_FILTER"), ALPHA_VMS_ERROR_EXPR, 2, 1, -1, -1);
        antErrorExpression = new ErrorExpression(NbBundle.getMessage((Class)ErrorExpressionEditor.class, (String)"ANT_JAVA_ERROR_EXPR"), ANT_JAVA_ERROR_EXPR, 2, 3, -1, 4);
        JAVAC = new ErrorExpression(NbBundle.getMessage((Class)ErrorExpressionEditor.class, (String)"CTL_Sun"), SUN_ERROR_EXPR, 1, 2, -1, 3, false);
    }
}

